/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.codec.ResponseEncoder;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.rts.configuration.monitor.MonitoringUtil;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiEventServlet
extends AbstractEventServlet {
    private static final Log log = LogFactory.getLog(MultiEventServlet.class);
    private static final byte[] responsePrefix = new byte[]{10, 27};
    private static final long serialVersionUID = 1731816573029992178L;
    private MonitoringMBean eventCounter;
    private static final byte[] eolPattern = new byte[]{10};

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.eventCounter = MonitoringUtil.getMBean((String)"MultiEvents");
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.error((Object)"doGet(): calling with compressed data not allowed via GET !");
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.config.isHttpMultiEventsDisabled()) {
            EventResponse eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
            this.sendResponse(eventResponse, new Properties(), response);
            return;
        }
        log.debug((Object)"doPost() POST mit komprimierten Daten verarbeiten...");
        this.eventCounter.increment();
        List<Properties> events = null;
        try {
            Object in = this.isRequestCompressed(request) ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            byte[] lineBreak = this.isPipeLineBreak(request) ? new byte[]{124} : eolPattern;
            events = this.readEvents((InputStream)in, lineBreak);
        }
        catch (IOException e) {
            log.warn((Object)"doPost() runs into java.io.IOException while reading input stream", (Throwable)e);
        }
        if (events != null) {
            ServletOutputStream out = response.getOutputStream();
            Iterator it = events.iterator();
            EventResponse eventResponse = null;
            while (it.hasNext() && (eventResponse == null || eventResponse.isEventResponse())) {
                Properties event = (Properties)it.next();
                eventResponse = this.processEvent(request.getRemoteAddr(), event);
                ResponseEncoder responseEncoder = this.encodeReturnMessage(eventResponse, event);
                out.write(responsePrefix);
                out.write(responseEncoder.encode());
                this.resetFlags(eventResponse, event);
            }
        }
        log.debug((Object)"doPost() end");
    }

    public int getBinaryPayloadStart(byte[] event) {
        int length = event.length;
        for (int index = 0; index < length; ++index) {
            if (event[index] != 10 || index + 2 >= length || event[index + 1] != 10) continue;
            return index + 2;
        }
        return -1;
    }

    public byte[] readContent(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            if ((n = in.read(buffer)) <= -1) continue;
            out.write(buffer, 0, n);
        } while (n > -1);
        return out.toByteArray();
    }

    public Properties readEvent(String eventStr) {
        StringTokenizer tokenizer = new StringTokenizer(eventStr, ";");
        return this.readProperties(tokenizer);
    }

    public Properties readProperties(StringTokenizer tokenizer) {
        Properties event = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int index = keyValue.indexOf(61);
            String key = keyValue.substring(0, index);
            String value = keyValue.substring(index + 1);
            event.put(key, value);
        }
        return event;
    }

    public static int indexOf(byte[] src, byte[] pattern, int from) {
        if (src == null || pattern == null) {
            throw new IllegalArgumentException("byte array and pattern can't be null");
        }
        if (from > src.length - 1 || from < 0) {
            throw new IllegalArgumentException("search index must be less than byte array size and greater than 0");
        }
        if (pattern.length == 0) {
            throw new IllegalArgumentException("pattern can't be empty");
        }
        int patternIndex = 0;
        for (int index = from; index < src.length; ++index) {
            if (src[index] == pattern[patternIndex]) {
                if (patternIndex < pattern.length - 1) {
                    ++patternIndex;
                    continue;
                }
                return index - patternIndex;
            }
            patternIndex = src[index] == pattern[0] ? 1 : 0;
        }
        return -1;
    }

    public List<Properties> readEvents(InputStream in, byte[] lineBreak) throws IOException {
        int index;
        byte[] content = this.readContent(in);
        if (log.isTraceEnabled()) {
            log.trace((Object)("content\n" + new String(content)));
        }
        ArrayList<Properties> events = new ArrayList<Properties>();
        int start = 0;
        do {
            String eventStr = (index = MultiEventServlet.indexOf(content, lineBreak, start)) == -1 ? new String(content, start, content.length - start) : new String(content, start, index - start);
            Properties event = this.readEvent(eventStr);
            if (index < content.length - 3 && content[index + 1] == 10 && content[index + 2] == 10) {
                int endOfHeaderIndex = MultiEventServlet.indexOf(content, lineBreak, index + 3);
                if (endOfHeaderIndex > -1) {
                    StringTokenizer headerTokenizer = new StringTokenizer(new String(content, index + 3, endOfHeaderIndex - (index + 3)));
                    Properties payloadHeaderProperties = this.readProperties(headerTokenizer);
                    int payloadLength = Integer.parseInt(payloadHeaderProperties.getProperty("length"));
                    byte[] payload = new byte[payloadLength];
                    System.arraycopy(content, endOfHeaderIndex + 1, payload, 0, payloadLength);
                    event.put("binary", payload);
                    index = endOfHeaderIndex + payloadLength;
                } else {
                    log.error((Object)"payload start found but no payload header line found");
                }
            }
            events.add(event);
            start = index + 1;
            if (start <= content.length - 1) continue;
            index = -1;
        } while (index > -1);
        return events;
    }
}

