/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventResponse;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.rts.configuration.monitor.MonitoringUtil;
import de.proveo.wwt.logic.servlet.dataIn.event.AbstractEventServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressedEventServlet
extends AbstractEventServlet {
    private static final Log log = LogFactory.getLog(CompressedEventServlet.class);
    private static final long serialVersionUID = 467528398303002495L;
    private MonitoringMBean eventCounter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.eventCounter = MonitoringUtil.getMBean((String)"CompressedEvents");
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.error((Object)"doGet(): calling with compressed data not allowed via GET !");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        Properties event;
        if (this.config.isHttpCompressedEventsDisabled()) {
            EventResponse eventResponse = new EventResponse();
            eventResponse.setEventResponse(false);
            this.sendResponse(eventResponse, new Properties(), response);
            return;
        }
        log.debug((Object)"doPost() POST mit komprimierten Daten verarbeiten...");
        this.eventCounter.increment();
        try {
            Object in = this.isRequestCompressed(request) ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            event = this.readEvent((InputStream)in);
        }
        catch (IOException e) {
            event = new Properties();
            log.warn((Object)"doPost() runs into java.io.IOException while reading input stream", (Throwable)e);
        }
        EventResponse eventResponse = this.processEvent(request.getRemoteAddr(), event);
        this.sendResponse(eventResponse, event, response);
        log.debug((Object)"doPost() end");
    }

    public int getBinaryPayloadStart(byte[] event) {
        int length = event.length;
        for (int index = 0; index < length; ++index) {
            if (event[index] != 10 || index + 2 >= length || event[index + 1] != 10) continue;
            return index + 2;
        }
        return -1;
    }

    public Properties readEvent(InputStream in) throws IOException {
        ByteArrayInputStream eventIn;
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            if ((n = in.read(buffer)) <= -1) continue;
            out.write(buffer, 0, n);
        } while (n > -1);
        int index = this.getBinaryPayloadStart(out.toByteArray());
        byte[] binaryPayload = null;
        if (index == -1) {
            eventIn = new ByteArrayInputStream(out.toByteArray());
        } else {
            byte[] eventContent = new byte[index - 2];
            System.arraycopy(out.toByteArray(), 0, eventContent, 0, eventContent.length);
            eventIn = new ByteArrayInputStream(eventContent);
            binaryPayload = new byte[out.toByteArray().length - index];
            System.arraycopy(out.toByteArray(), index, binaryPayload, 0, binaryPayload.length);
        }
        Properties event = new Properties();
        event.load(eventIn);
        if (binaryPayload != null) {
            event.put("binary", binaryPayload);
        }
        return event;
    }
}

