/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataIn.event;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.eventbase.EventUtil;
import de.proveo.eventbase.codec.ResponseEncoder;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceMBean;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceUtil;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacade;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.servlet.dataIn.event.forwarder.EventForwarder;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractEventServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(AbstractEventServlet.class);
    protected static EventForwarder eventForwarder = null;
    private EventFacade eventFacade;
    protected InfomanEventInterfaceMBean config;

    public void destroy() {
        eventForwarder.interrupt();
        eventForwarder.tearDownNotify();
        this.eventFacade = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.error((Object)"missing implementation of doGet() in extending class !");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.error((Object)"missing implementation of doPost() in extending class !");
    }

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"init()");
        super.init(config);
        eventForwarder = EventForwarder.getInstance();
        try {
            this.eventFacade = EventFacadeUtil.getHome().create();
            this.eventFacade = EventFacadeUtil.getHome().create();
            this.config = InfomanEventInterfaceUtil.getMBean();
        }
        catch (Exception ex) {
            throw new ServletException("lookup problem", (Throwable)ex);
        }
    }

    public EventResponse processEvent(String remoteAddr, Properties event) {
        if (event.size() > 0) {
            String ping;
            if (log.isDebugEnabled()) {
                log.debug((Object)("processEvent() " + event + " from " + remoteAddr));
            }
            if ((ping = event.getProperty("p")) != null && ping.equals("servlet")) {
                EventResponse eventResponse = new EventResponse();
                eventResponse.setEventResponse(true);
                return eventResponse;
            }
            try {
                return this.eventFacade.handleEvent(event);
            }
            catch (RemoteException e) {
                log.error((Object)"processEvent() EventFacade.handleEvent() runs into java.rmi.RemoteException", (Throwable)e);
                EventResponse eventResponse = new EventResponse();
                eventResponse.setEventResponse(false);
                return eventResponse;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processEvent() illegel request " + event + " from " + remoteAddr));
        }
        EventResponse eventResponse = new EventResponse();
        eventResponse.setEventResponse(false);
        return eventResponse;
    }

    protected ResponseEncoder encodeReturnMessage(EventResponse eventResponse, Properties event) {
        ResponseEncoder responseEncoder = ResponseEncoder.create((EventResponse)eventResponse);
        if (event.size() > 0 && eventResponse.isUserACLChanged()) {
            for (EventPayload payload : eventResponse.getPayloads()) {
                responseEncoder.addPayload(payload);
            }
        }
        if (log.isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("sendResponse() [u=");
            long[] unitIds = EventUtil.getUnitIds((Properties)event);
            for (int index = 0; index < unitIds.length; ++index) {
                msg.append(unitIds[index]);
                if (index + 1 >= unitIds.length) continue;
                msg.append(",");
            }
            msg.append(" t=");
            msg.append(event.getProperty("t"));
            msg.append("]: ");
            msg.append(responseEncoder);
            log.debug((Object)msg.toString());
        }
        return responseEncoder;
    }

    protected void sendResponse(EventResponse eventResponse, Properties event, HttpServletResponse response) {
        ResponseEncoder responseEncoder = this.encodeReturnMessage(eventResponse, event);
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(responseEncoder.encode());
            out.close();
        }
        catch (IOException ex) {
            log.error((Object)"sendResponse() sending response runs into", (Throwable)ex);
            return;
        }
        this.resetFlags(eventResponse, event);
        log.debug((Object)"sendResponse() leave");
    }

    public void resetFlags(EventResponse eventResponse, Properties event) {
        if (event.size() > 0 && eventResponse.isVPN()) {
            try {
                this.eventFacade.resetCallback(event);
            }
            catch (RemoteException ex) {
                log.error((Object)"sendResponse() EventFacade.resetCallback() runs into", (Throwable)ex);
            }
        }
    }

    protected boolean isRequestCompressed(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Content-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("uncompressed") <= -1) continue;
            return false;
        }
        return true;
    }

    protected boolean isPipeLineBreak(HttpServletRequest request) {
        Enumeration e = request.getHeaders("Content-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("pipeLineBreak") <= -1) continue;
            return true;
        }
        return false;
    }
}

