/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GroupNode;
import org.netbeans.modules.css.lib.api.properties.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.NodeVisitor2;
import org.netbeans.modules.css.lib.api.properties.ResolvedToken;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.css.lib.api.properties.TokenNode;

public interface Node {
    public String name();

    public Collection<Node> children();

    public void accept(NodeVisitor var1);

    public void accept(NodeVisitor2 var1);

    public CharSequence image();

    public static abstract class AbstractNode
    implements Node {
        @Override
        public void accept(NodeVisitor visitor) {
            if (visitor.visit(this)) {
                for (Node child : this.children()) {
                    child.accept(visitor);
                }
                visitor.unvisit(this);
            }
        }
    }

    public static class GroupNodeImpl
    extends AbstractNode
    implements GroupNode {
        private GrammarElement element;
        private Collection<Node> children = new ArrayList<Node>();

        public GroupNodeImpl(GrammarElement group) {
            this.element = group;
        }

        @Override
        public void accept(NodeVisitor2 visitor) {
            if (visitor.visitGroupNode(this)) {
                for (Node child : this.children()) {
                    child.accept(visitor);
                }
            }
        }

        @Override
        public GrammarElement getGrammarElement() {
            return this.element;
        }

        public <T extends AbstractNode> T addChild(T node) {
            this.children.add(node);
            return node;
        }

        public <T extends AbstractNode> boolean removeChild(T node) {
            return this.children.remove(node);
        }

        @Override
        public String name() {
            return this.element.getName();
        }

        @Override
        public Collection<Node> children() {
            return this.children;
        }

        public Collection<Node> modifiableChildren() {
            return this.children;
        }

        public String toString() {
            return this.element.toString();
        }

        @Override
        public CharSequence image() {
            StringBuilder sb = new StringBuilder();
            for (Node child : this.children()) {
                sb.append(child.image());
            }
            return sb.toString();
        }
    }

    public static class ResolvedTokenNode
    extends AbstractNode
    implements TokenNode {
        private ResolvedToken resolvedToken = null;

        @Override
        public void accept(NodeVisitor2 visitor) {
            visitor.visitTokenNode(this);
        }

        public void setResolvedToken(ResolvedToken resolvedToken) {
            this.resolvedToken = resolvedToken;
        }

        @Override
        public ResolvedToken getResolvedToken() {
            return this.resolvedToken;
        }

        @Override
        public Collection<Node> children() {
            return Collections.emptyList();
        }

        public Token getToken() {
            return this.resolvedToken.token();
        }

        @Override
        public CharSequence image() {
            return this.resolvedToken.token().image();
        }

        public String toString() {
            return this.resolvedToken.token().toString();
        }

        @Override
        public String name() {
            return this.resolvedToken.getGrammarElement().getValue();
        }
    }
}

