/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;

public class PageantConnector
implements Connector {
    private User32 libU = null;
    private Kernel32 libK = null;

    public PageantConnector() throws AgentProxyException {
        try {
            this.libU = User32.INSTANCE;
            this.libK = Kernel32.INSTANCE;
        }
        catch (UnsatisfiedLinkError e) {
            throw new AgentProxyException(e.toString());
        }
        catch (NoClassDefFoundError e) {
            throw new AgentProxyException(e.toString());
        }
    }

    public String getName() {
        return "pageant";
    }

    public static boolean isConnectorAvailable() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public boolean isAvailable() {
        return PageantConnector.isConnectorAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(Buffer buffer) throws AgentProxyException {
        WinNT.HANDLE sharedFile = null;
        Pointer sharedMemory = null;
        WinDef.HWND hwnd = this.libU.FindWindow("Pageant", "Pageant");
        if (hwnd == null) {
            throw new AgentProxyException("Pageant is not runnning.");
        }
        String mapname = String.format("PageantRequest%08x", this.libK.GetCurrentThreadId());
        WinBase.SECURITY_ATTRIBUTES psa = null;
        sharedFile = this.libK.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, psa, 4, 0, 8192, mapname);
        sharedMemory = Kernel32.INSTANCE.MapViewOfFile(sharedFile, 2, 0, 0, 0);
        byte[] data = null;
        long rcode = 0L;
        try {
            sharedMemory.write(0L, buffer.buffer, 0, buffer.getLength());
            if (Platform.is64Bit()) {
                COPYDATASTRUCT64 cds64 = new COPYDATASTRUCT64();
                data = this.install64(mapname, cds64);
                rcode = this.sendMessage(hwnd, data);
            } else {
                COPYDATASTRUCT32 cds32 = new COPYDATASTRUCT32();
                data = this.install32(mapname, cds32);
                rcode = this.sendMessage(hwnd, data);
            }
            buffer.rewind();
            if (rcode != 0L) {
                sharedMemory.read(0L, buffer.buffer, 0, 4);
                int i = buffer.getInt();
                buffer.rewind();
                buffer.checkFreeSize(i);
                sharedMemory.read(4L, buffer.buffer, 0, i);
            }
        }
        finally {
            if (sharedMemory != null) {
                this.libK.UnmapViewOfFile(sharedMemory);
            }
            if (sharedFile != null) {
                this.libK.CloseHandle(sharedFile);
            }
        }
    }

    private byte[] install32(String mapname, COPYDATASTRUCT32 cds) {
        cds.dwData = -2142351174;
        cds.cbData = mapname.length() + 1;
        cds.lpData = new Memory((long)(mapname.length() + 1));
        byte[] foo = mapname.getBytes();
        cds.lpData.write(0L, foo, 0, foo.length);
        cds.lpData.setByte((long)foo.length, (byte)0);
        cds.write();
        byte[] data = new byte[12];
        Pointer cdsp = cds.getPointer();
        cdsp.read(0L, data, 0, 12);
        return data;
    }

    private byte[] install64(String mapname, COPYDATASTRUCT64 cds) {
        cds.dwData = -2142351174;
        cds.cbData = mapname.length() + 1;
        cds.lpData = new Memory((long)(mapname.length() + 1));
        byte[] foo = mapname.getBytes();
        cds.lpData.write(0L, foo, 0, foo.length);
        cds.lpData.setByte((long)foo.length, (byte)0);
        cds.write();
        byte[] data = new byte[24];
        Pointer cdsp = cds.getPointer();
        cdsp.read(0L, data, 0, 24);
        return data;
    }

    long sendMessage(WinDef.HWND hwnd, byte[] data) {
        long rcode = this.libU.SendMessage(hwnd, 74, null, data);
        return rcode;
    }

    public class COPYDATASTRUCT32
    extends Structure {
        public int dwData;
        public int cbData;
        public Pointer lpData;
    }

    public class COPYDATASTRUCT64
    extends Structure {
        public int dwData;
        public long cbData;
        public Pointer lpData;
    }

    public static interface User32
    extends com.sun.jna.platform.win32.User32 {
        public static final User32 INSTANCE = (User32)Native.loadLibrary((String)"user32", User32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public long SendMessage(WinDef.HWND var1, int var2, WinDef.WPARAM var3, byte[] var4);
    }
}

