/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryValue;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.Transition;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.ReportFastLaneReader;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeLocal;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacadeUtil;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import de.proveo.wwt.logic.web.summarizedData.dto.SummarizedDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.SummarizedDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.PeriodType;
import org.joda.time.tz.FixedDateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SummarizedDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(SummarizedDataFacadeBean.class);
    private UnitModelLocalHome unitModelHome;
    private HistoryDataFacadeLocal historyDataFacadeLocal;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private ReportFastLaneReader reportFastLaneReader;

    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.historyDataFacadeLocal = HistoryDataFacadeUtil.getLocalHome().create();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
            this.reportFastLaneReader = new ReportFastLaneReader();
        }
        catch (Exception ex) {
            logger.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public StatusDurationsDTOList getDurationsSummarized(Long unitId, long stateModelId, long beginTime, long endTime, boolean useGroupHistory) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        stopwatch.start("overall");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getDurationsSummarized1 called with unitId=" + unitId + " statusModelId=" + stateModelId + " beginTime=" + beginTime + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        UnitModelLocal unitModel = null;
        if (unitId != null) {
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        long[] availableStates = SummarizedDataFacadeBean.getPossibleStates(stateModelId, 0L);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(unitModel, stateModelId, beginTime, endTime, availableStates);
        StateDTOList stateDtoList = this.historyDataFacadeLocal.getStateData(unitId, stateModelId, beginTime, endTime, true, useGroupHistory);
        this.sumToStatusDurationsDTOList(stateDtoList, list, null);
        stopwatch.stop("overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    public HashMap<Long, StatusDurationsDTOList> getDurationsSummarized(Long unitId, long beginTime, long endTime, long[] filterStateModelId, boolean useGroupHistory) {
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        stopwatch.start("overall");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getDurationsSummarized2 called with unitId=" + unitId + " statusModelId=" + " beginTime=" + beginTime + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        UnitModelLocal unitModel = null;
        if (unitId != null) {
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        long[] availableStates = SummarizedDataFacadeBean.getPossibleStates(filterStateModelId);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(unitModel, beginTime, endTime, null, availableStates);
        StateDTOList stateDtoList = this.historyDataFacadeLocal.getStateData(unitId, null, beginTime, endTime, true, useGroupHistory);
        HashMap<Long, StatusDurationsDTOList> map = this.sumToStatusDurationsDTOList(stateDtoList, list, filterStateModelId);
        stopwatch.stop("overall", true);
        list.setStopwatch(stopwatch);
        return map;
    }

    private HashMap<Long, StatusDurationsDTOList> sumToStatusDurationsDTOList(StateDTOList stateDtoList, StatusDurationsDTOList list, long[] filterStateModelId) {
        HashMap statesHashmap;
        HashMap<Long, StatusDurationsDTOList> map = new HashMap<Long, StatusDurationsDTOList>();
        Long stateModelId = stateDtoList.getStateModelId();
        Long beginTime = stateDtoList.getBeginDate();
        HashMap<SummaryDTOHelper2, HashMap> dtoHashmap = new HashMap<SummaryDTOHelper2, HashMap>();
        for (int k = 0; k < stateDtoList.size(); ++k) {
            StateDTO stateDTO = (StateDTO)stateDtoList.get(k);
            if (filterStateModelId != null && filterStateModelId.length != 0) {
                boolean passDTO = false;
                for (int i = 0; i < filterStateModelId.length; ++i) {
                    if (filterStateModelId == null || filterStateModelId[i] != stateDTO.getStateModelId()) continue;
                    passDTO = true;
                    break;
                }
                if (!passDTO) continue;
            }
            if (stateDTO == null) continue;
            statesHashmap = (HashMap)dtoHashmap.get(new SummaryDTOHelper2(stateDTO.getStateModelId(), stateDTO.getUnitId()));
            if (statesHashmap != null) {
                SummaryHelperDTO summaryHelperDTO = (SummaryHelperDTO)statesHashmap.get(stateDTO.getStateId());
                if (summaryHelperDTO == null) continue;
                summaryHelperDTO.sumDuration(stateDTO.getDuration());
                continue;
            }
            statesHashmap = new HashMap();
            for (long state : list.getStatusIds()) {
                if (state == stateDTO.getStateId()) {
                    statesHashmap.put(state, new SummaryHelperDTO(stateDTO.getStateModelId(), stateDTO.getDuration()));
                    continue;
                }
                statesHashmap.put(state, new SummaryHelperDTO(stateDTO.getStateModelId(), 0L));
            }
            dtoHashmap.put(new SummaryDTOHelper2(stateDTO.getStateModelId(), stateDTO.getUnitId()), statesHashmap);
        }
        UnitModelLocal unitModel = null;
        for (Map.Entry unitMapEntry : dtoHashmap.entrySet()) {
            long basicUnitId = ((SummaryDTOHelper2)unitMapEntry.getKey()).getUnitId();
            stateModelId = ((SummaryDTOHelper2)unitMapEntry.getKey()).getStateModelId();
            statesHashmap = (HashMap)unitMapEntry.getValue();
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(basicUnitId));
                StatusDurationsDTO dto = stateModelId != 2010L ? DTOFactory.buildStatusDurationsDTO(unitModel, stateModelId, beginTime) : DTOFactory.buildRunTimeDurationsDTO(unitModel, beginTime);
                for (Map.Entry state : statesHashmap.entrySet()) {
                    dto.setDuration((Long)state.getKey(), ((SummaryHelperDTO)state.getValue()).getSummarizedDuration());
                }
                list.add(dto);
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        for (int i = 0; i < list.size(); ++i) {
            StatusDurationsDTO dto = (StatusDurationsDTO)list.get(i);
            Long dtoStateModelId = dto.getStateModelId();
            StatusDurationsDTOList statusDurationsDTOList = map.get(dtoStateModelId);
            if (statusDurationsDTOList == null) {
                statusDurationsDTOList = DTOListFactory.buildStatusDurationsDTOList(unitModel, list.getBeginDate(), list.getEndDate(), dtoStateModelId, SummarizedDataFacadeBean.getPossibleStates(dtoStateModelId, 0L));
                map.put(dtoStateModelId, statusDurationsDTOList);
            }
            statusDurationsDTOList.add(dto);
        }
        return map;
    }

    public StatusDurationsDTOList getDurationsSummarizedfromStateSummary(Long unitId, long stateModelId, long beginTime, long endTime, boolean includeDeletedUnits, boolean useGroupHistory, boolean includeStateHistory) {
        HashMap statesHashmap;
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "durationsSummarized");
        UnitModelValue unitModelValue = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getDurationsSummarizedfromStateSummary called with unitId=" + unitId + " statusModelId=" + stateModelId + " beginTime=" + beginTime + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        UnitModelLocal unitModel = null;
        if (unitId != null) {
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            unitModelValue = unitModel.getUnitModelValue();
        }
        Collection<Object> collSummaries = new ArrayList();
        logger.debug((Object)"stateSummary databaseAccess...");
        stopwatch.start("dataBase access");
        collSummaries = unitId == null ? this.reportFastLaneReader.getStateSummary(unitId, false, stateModelId, beginTime, endTime, 0, useGroupHistory) : (!unitModelValue.getBasic() ? this.reportFastLaneReader.getStateSummary(unitId, false, stateModelId, beginTime, endTime, 0, useGroupHistory) : this.reportFastLaneReader.getStateSummary(unitId, true, stateModelId, beginTime, endTime, 0, useGroupHistory));
        stopwatch.stop("dataBase access", true, collSummaries.size());
        stopwatch.start("building DTO");
        long[] availableStates = SummarizedDataFacadeBean.getPossibleStates(stateModelId, 0L);
        StatusDurationsDTOList list = DTOListFactory.buildStatusDurationsDTOList(unitModel, stateModelId, beginTime, endTime, availableStates);
        endTime = Math.min(System.currentTimeMillis(), endTime);
        HashMap dtoHashmap = new HashMap();
        HashMap<Long, Long> maxSummaryDateMap = new HashMap<Long, Long>();
        StateSummaryValue[] arrSummary = collSummaries.toArray(new StateSummaryValue[0]);
        long actUnitId = 0L;
        long prevUnitId = 0L;
        long maxSummaryDate = 0L;
        for (int i = 0; i != arrSummary.length; ++i) {
            StateSummaryValue value = arrSummary[i];
            actUnitId = value.getUnitId();
            if (prevUnitId != actUnitId) {
                maxSummaryDate = 0L;
            }
            UnitModelLocal unitLocal = null;
            try {
                unitLocal = this.unitModelHome.findByPrimaryKey(new UnitModelPK(actUnitId));
            }
            catch (FinderException e) {
                logger.debug((Object)"runs into", (Throwable)e);
            }
            if (!includeDeletedUnits && unitLocal != null && unitLocal.getUnitModelValue().getDeleted()) continue;
            statesHashmap = (HashMap)dtoHashmap.get(actUnitId);
            if (statesHashmap != null) {
                Long duration = (Long)statesHashmap.get(value.getStateId());
                if (duration != null) {
                    statesHashmap.put(value.getStateId(), duration + value.getDuration());
                }
                maxSummaryDate = Math.max(value.getBeginTime(), maxSummaryDate);
            } else {
                statesHashmap = new HashMap();
                for (int j = 0; j < availableStates.length; ++j) {
                    long state = availableStates[j];
                    if (state == value.getStateId()) {
                        statesHashmap.put(state, value.getDuration());
                        continue;
                    }
                    statesHashmap.put(state, 0L);
                }
                dtoHashmap.put(value.getUnitId(), statesHashmap);
                maxSummaryDate = Math.max(value.getBeginTime(), maxSummaryDate);
            }
            maxSummaryDateMap.put(value.getUnitId(), maxSummaryDate);
            prevUnitId = actUnitId;
        }
        if (includeStateHistory) {
            long minSummaryDate = 0L;
            boolean start = true;
            int plusDays = 1;
            if (maxSummaryDateMap.size() == 0) {
                plusDays = 0;
                minSummaryDate = beginTime;
            } else {
                for (Map.Entry e : maxSummaryDateMap.entrySet()) {
                    if (start) {
                        minSummaryDate = (Long)e.getValue();
                        start = false;
                    }
                    minSummaryDate = Math.min((Long)e.getValue(), minSummaryDate);
                }
            }
            minSummaryDate = new DateMidnight(minSummaryDate).plusDays(plusDays).getMillis();
            StatusDurationsDTOList listHistory = this.getDurationsSummarized(unitId, stateModelId, minSummaryDate, endTime, useGroupHistory);
            for (int i = 0; i < listHistory.size(); ++i) {
                StatusDurationsDTO listHistoryDto = (StatusDurationsDTO)listHistory.get(i);
                if (!includeDeletedUnits && listHistoryDto != null && listHistoryDto.getUnitDTO().getUnitModelValue().getDeleted()) continue;
                long unitHistory = listHistoryDto.getUnitId();
                long correctBegin = beginTime;
                Long maxSummaryDateTime = (Long)maxSummaryDateMap.get(unitHistory);
                if (maxSummaryDateTime != null) {
                    correctBegin = new DateMidnight((Object)maxSummaryDateTime).plusDays(1).getMillis();
                }
                listHistoryDto.correctTimes(correctBegin, endTime);
                statesHashmap = (HashMap)dtoHashmap.get(unitHistory);
                if (statesHashmap == null) {
                    statesHashmap = new HashMap();
                    for (int j = 0; j < availableStates.length; ++j) {
                        long state = availableStates[j];
                        statesHashmap.put(state, 0L);
                    }
                    dtoHashmap.put(unitHistory, statesHashmap);
                }
                for (Map.Entry<Long, Long> e : listHistoryDto.getStateDurations().entrySet()) {
                    long duration = listHistoryDto.getDuration(e.getKey());
                    if (statesHashmap == null || duration <= 0L) continue;
                    statesHashmap.put(e.getKey(), duration + (Long)statesHashmap.get(e.getKey()));
                }
            }
        }
        unitModel = null;
        for (Map.Entry unitMapEntry : dtoHashmap.entrySet()) {
            long basicUnitId = (Long)unitMapEntry.getKey();
            statesHashmap = (HashMap)unitMapEntry.getValue();
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(basicUnitId));
                StatusDurationsDTO dto = stateModelId == 2010L ? DTOFactory.buildRunTimeDurationsDTO(unitModel, beginTime) : DTOFactory.buildStatusDurationsDTO(unitModel, stateModelId, beginTime);
                for (Map.Entry state : statesHashmap.entrySet()) {
                    dto.setDuration((Long)state.getKey(), (Long)state.getValue());
                }
                list.add(dto);
            }
            catch (FinderException e) {
                logger.debug((Object)"unit not found (deleted) for summarized data (clean database))");
            }
        }
        stopwatch.stop("building DTO", true);
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        list.setStopwatch(stopwatch);
        return list;
    }

    public DTOListBase getGroupDetailData(Long unitId, long stateModelId, long beginTime, long endTime) {
        DTOListBase dataLists = new DTOListBase();
        Stopwatch stopwatch = new Stopwatch(SummarizedDataFacadeBean.class, "getDurationsSummarizedPerUnitAndDay");
        stopwatch.start("overall");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getGroupDetailData called with unitId=" + unitId + " statusModelId=" + stateModelId + " beginTime=" + beginTime + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        UnitModelLocal unitModel = null;
        if (unitId != null) {
            try {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        stopwatch.start("dataBase access");
        StateDTOList stateDtoList = this.historyDataFacadeLocal.getStateData(unitId, stateModelId, beginTime, endTime, true, true);
        stopwatch.stop("dataBase access", true);
        stopwatch.start("building DTO");
        SummarizedDTOList summarizedDTOList = DTOListFactory.buildSummarizedDTOList(unitModel, beginTime, endTime, stateModelId);
        this.summarizeToDayPerUnit(DTOFactory.buildUnitDTO(unitModel), stateDtoList, summarizedDTOList);
        long[] availableStates = SummarizedDataFacadeBean.getPossibleStates(stateModelId, 0L);
        StatusDurationsDTOList statusDurationsDTOList = DTOListFactory.buildStatusDurationsDTOList(unitModel, stateModelId, beginTime, endTime, availableStates);
        this.sumToStatusDurationsDTOList(stateDtoList, statusDurationsDTOList, null);
        stopwatch.stop("building DTO", true);
        dataLists.add(summarizedDTOList);
        dataLists.add(statusDurationsDTOList);
        stopwatch.stop("overall", true);
        dataLists.setStopwatch(stopwatch);
        return dataLists;
    }

    private SummarizedDTOList summarizeToDayPerUnit(UnitDTO unitDTO, StateDTOList list, SummarizedDTOList summarizedDTOList) {
        Interval interval = new Interval(new DateMidnight(list.getBeginDate()).getMillis(), new DateMidnight(list.getEndDate()).plusDays(1).getMillis());
        int iterationPeriod = 0;
        long timePortionMillis = 86400000L;
        iterationPeriod = interval.toPeriod(PeriodType.days()).getDays();
        if (list != null || list.size() != 0) {
            HashMap<Long, SummarizedDTO> summarizedDTOMap = new HashMap<Long, SummarizedDTO>();
            long timePeriodBegin = interval.getStart().getMillis();
            for (int i = 0; i < iterationPeriod; ++i) {
                if (timePeriodBegin >= list.getEndDate()) continue;
                timePortionMillis = 86400000L;
                long timePeriodEnd = timePeriodBegin + timePortionMillis;
                long duration = 0L;
                StateDTO value = null;
                for (int j = 0; j < list.size(); ++j) {
                    StatusDurationsDTO statusDurationsDTO;
                    value = (StateDTO)list.get(j);
                    long stateBegin = value.getBeginTime();
                    long stateEndTime = value.getEndTime();
                    if (stateEndTime < timePeriodBegin || stateBegin >= timePeriodEnd) continue;
                    long unitId = value.getUnitId();
                    duration = value.getDuration();
                    long statusId = value.getStateId();
                    if (stateEndTime > timePeriodEnd) {
                        duration = timePeriodEnd - stateBegin;
                    } else if (stateBegin < timePeriodBegin) {
                        duration = stateEndTime - timePeriodBegin;
                    }
                    if (stateBegin < timePeriodBegin && stateEndTime > timePeriodEnd) {
                        duration = timePortionMillis;
                    }
                    UnitDTO currentUnitDTO = value.getUnitDTO();
                    SummarizedDTO summarizedDTO = (SummarizedDTO)summarizedDTOMap.get(unitId);
                    if (summarizedDTO == null) {
                        summarizedDTO = new SummarizedDTO(value.getUnitDTO(), new HashMap<Long, StatusDurationsDTO>());
                        summarizedDTOMap.put(unitId, summarizedDTO);
                    }
                    if ((statusDurationsDTO = summarizedDTO.getDurations().get(timePeriodBegin)) == null) {
                        statusDurationsDTO = new StatusDurationsDTO(currentUnitDTO, summarizedDTOList.getStateModelId(), timePeriodBegin);
                        statusDurationsDTO.setDuration(statusId, duration);
                        summarizedDTO.addStatusDurationsDTO(timePeriodBegin, statusDurationsDTO);
                        continue;
                    }
                    long totalDuration = statusDurationsDTO.getDuration(statusId);
                    statusDurationsDTO.setDuration(statusId, totalDuration + duration);
                }
                timePeriodBegin += timePortionMillis;
            }
            for (Map.Entry entry : summarizedDTOMap.entrySet()) {
                summarizedDTOList.add(entry.getValue());
            }
        }
        return summarizedDTOList;
    }

    private static long[] getPossibleStates(long stateModelId, Long unitId) {
        long[] states = null;
        try {
            StateModelFactory factory = new StateModelFactory();
            if (unitId == null) {
                unitId = 0L;
            }
            StateModel model = factory.getStateModel(stateModelId, unitId);
            states = model.getPossibleStates();
        }
        catch (StateModelNotFoundException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return states;
    }

    private static long[] getPossibleStates(long[] stateModelId) {
        long[] states = null;
        try {
            int i;
            StateModelFactory factory = new StateModelFactory();
            ArrayList<Long> list = new ArrayList<Long>();
            for (i = 0; i != stateModelId.length; ++i) {
                StateModel model = factory.getStateModel(stateModelId[i], 0L);
                long[] tempArr = model.getPossibleStates();
                for (int j = 0; j < tempArr.length; ++j) {
                    list.add(tempArr[j]);
                }
            }
            states = new long[list.size()];
            for (i = 0; i != list.size(); ++i) {
                states[i] = (Long)list.get(i);
            }
        }
        catch (StateModelNotFoundException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return states;
    }

    private static Transition[] getTransitions(long begin, long end) {
        ArrayList<Transition> daylightSavings = new ArrayList<Transition>();
        DateTimeZone dtz = FixedDateTimeZone.getDefault();
        long oldTransition = 0L;
        long nextTransition = begin;
        while (nextTransition <= end && nextTransition != oldTransition) {
            oldTransition = nextTransition;
            if ((nextTransition = dtz.nextTransition(oldTransition)) == oldTransition || nextTransition > end) continue;
            DateMidnight dm = new DateMidnight(nextTransition);
            long transitionDay = dm.getMillis();
            daylightSavings.add(new Transition(nextTransition, transitionDay));
        }
        return daylightSavings.toArray(new Transition[0]);
    }

    public static void main(String[] args) {
        String timeFormat = "dd.MM.yyyy hh:mm";
        long begin = 1204315200000L;
        long end = 1260561600000L;
        Transition[] t = SummarizedDataFacadeBean.getTransitions(begin, end);
        System.out.println("Anzahl der Zeitumstellungen\n\tvom " + new DateTime(begin).toString(timeFormat) + "\n\tbis " + new DateTime(end).toString(timeFormat) + "\n-> " + t.length + "\n");
        for (Transition l : t) {
            System.out.println(new DateTime(l.getTransitionDay()).toString(timeFormat) + "    -    " + l);
        }
    }

    public class SummaryHelperDTO {
        long stateModelId;
        long summarizedDuration;

        public SummaryHelperDTO(long stateModelId, long summarizedDuration) {
            this.stateModelId = stateModelId;
            this.summarizedDuration = summarizedDuration;
        }

        public long getStateModelId() {
            return this.stateModelId;
        }

        public void setStateModelId(long stateModelId) {
            this.stateModelId = stateModelId;
        }

        public long getSummarizedDuration() {
            return this.summarizedDuration;
        }

        public void setSummarizedDuration(long summarizedDuration) {
            this.summarizedDuration = summarizedDuration;
        }

        public void sumDuration(long duration) {
            this.summarizedDuration += duration;
        }
    }

    public class SummaryDTOHelper2 {
        private long stateModelId;
        private long unitId;

        public SummaryDTOHelper2(long stateModelId, long unitId) {
            this.stateModelId = stateModelId;
            this.unitId = unitId;
        }

        public long getStateModelId() {
            return this.stateModelId;
        }

        public long getUnitId() {
            return this.unitId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SummaryDTOHelper2)) {
                return false;
            }
            SummaryDTOHelper2 obj2 = (SummaryDTOHelper2)obj;
            return this.stateModelId == obj2.stateModelId && this.unitId == obj2.unitId;
        }

        public int hashCode() {
            long result = 7L;
            result = 37L * result + this.unitId + this.stateModelId;
            return (int)result;
        }
    }
}

