/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.FastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelemetryFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(TelemetryFastLaneReader.class);

    public List<PositionDTO> getGdataHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getGdataHistoryForBasicDataInterface called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getGdataHistoryForBasicDataInterface");
        stopwatch.start("overall");
        ArrayList<PositionDTO> list = new ArrayList<PositionDTO>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateGdataHistorySql(historyIdBegin, historyIdEnd);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                ResultSet resultSet = statement.executeQuery(sql);
                int size = TelemetryFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                log.debug((Object)"building DTOs...");
                stopwatch.start("building DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long gdataUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(gdataUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(gdataUnitId, unitDTO);
                    }
                    PositionDTO positionDto = TelemetryFastLaneReader.getPositionDTO(unitDTO, resultSet);
                    list.add(positionDto);
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, size);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    private static final PositionDTO getPositionDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        String area = resultSet.getString("AREA");
        String areaDescr = resultSet.getString("AREA_DESCRIPTION");
        long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
        long bdataEndTime = resultSet.getLong("END_TIME");
        boolean trusted = resultSet.getBoolean("TRUSTED");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
        long pkGdataPrevious = resultSet.getLong("PK_GDATA_PREVIOUS");
        String ggaRec = resultSet.getString("GGA_REC");
        String rmcRec = resultSet.getString("RMC_REC");
        String reason = null;
        int latMSEC = 0;
        int longMSEC = 0;
        PositionDTO positionDTO = new PositionDTO(unitDto, gdataBeginTime, bdataEndTime, beginReceiveTime, endReceiveTime, trusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, area, areaDescr);
        positionDTO.setPkGdataPrevious(pkGdataPrevious);
        return positionDTO;
    }

    private static final String generateGdataHistorySql(long historyIdBegin, long historyIdEnd) {
        String sql = TelemetryFastLaneReader.appendStrings("SELECT ", " g.GDATA_HISTORY_ID, g.UNIT_ID, g.BEGIN_TIME, g.BEGIN_RECEIVE_TIME, g.END_TIME, g.END_RECEIVE_TIME, ", " g.PK_GDATA_PREVIOUS, g.RMC_REC, g.GGA_REC, g.TRUSTED, ", " ui.NAME, ui.IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.CUSTOMER_UNIT_ID, um.BRAND, um.MODEL_TYPE, um.DELETED, a.AREA, a.DESCRIPTION as AREA_DESCRIPTION ", " FROM gdata_history g ", " LEFT JOIN unit_model um ON g.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON g.UNIT_ID = ui.UNIT_ID", " LEFT JOIN area a ON g.AREA_ID = a.AREA_ID ", " WHERE PK_GDATA_PREVIOUS BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd));
        return sql.toLowerCase();
    }

    public List<NotificationDTO> getNotifyHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getNotifyHistoryForBasicDataInterface called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getNotifyHistoryForBasicDataInterface");
        stopwatch.start("overall");
        ArrayList<NotificationDTO> list = new ArrayList<NotificationDTO>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateNotifyHistorySql(historyIdBegin, historyIdEnd);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long notificationUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(notificationUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(notificationUnitId, unitDTO);
                    }
                    NotificationDTO notificationDTO = TelemetryFastLaneReader.getNotificationDTO(unitDTO, resultSet);
                    list.add(notificationDTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    private static final NotificationDTO getNotificationDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong("ID");
        long messageId = resultSet.getLong("MESSAGE_ID");
        long createTime = resultSet.getLong("CREATE_TIME");
        long receiveTime = resultSet.getLong("RECEIVE_TIME");
        String remark = resultSet.getString("REMARK");
        NotificationDTO notificationDTO = new NotificationDTO(unitDto, messageId, createTime, receiveTime, remark, null, null);
        notificationDTO.setId(id);
        return notificationDTO;
    }

    private static final String generateNotifyHistorySql(long historyIdBegin, long historyIdEnd) {
        String sql = TelemetryFastLaneReader.appendStrings("SELECT nh.ID, nh.UNIT_ID, nh.MESSAGE_ID, nh.CREATE_TIME, nh.ENTRY, nh.RECEIVE_TIME, nh.REMARK, ", " um.CUSTOMER_UNIT_ID, ui.NAME, um.DELETED", " FROM notify_history nh ", " LEFT JOIN unit_model um ON nh.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON nh.UNIT_ID = ui.UNIT_ID ", " WHERE ID BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd));
        return sql.toLowerCase();
    }

    public List<StateDTO> getStateHistory(long historyIdBegin, long historyIdEnd) {
        log.debug((Object)"getStateHistoryForBasicDataInterface called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getStateHistoryForBasicDataInterface");
        stopwatch.start("overall");
        ArrayList<StateDTO> list = new ArrayList<StateDTO>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = TelemetryFastLaneReader.generateStateHistorySql(historyIdBegin, historyIdEnd);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    UnitDTO unitDTO = (UnitDTO)unitModelMap.get(stateUnitId);
                    if (unitDTO == null) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    StateDTO stateDTO = TelemetryFastLaneReader.getStateDTO(unitDTO, resultSet);
                    list.add(stateDTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    private static final StateDTO getStateDTO(UnitDTO unitDto, ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong("STATE_HISTORY_ID");
        long stateId = resultSet.getLong("STATE_ID");
        long stateIdAfter = resultSet.getLong("STATE_ID_AFTER");
        long stateModelId = resultSet.getLong("STATE_MODEL_ID");
        long shBeginTime = resultSet.getLong("BEGIN_TIME");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        long shEndTime = resultSet.getLong("END_TIME");
        long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
        long duration = resultSet.getLong("DURATION");
        String remark = resultSet.getString("REMARK");
        StateDTO stateDTO = new StateDTO(unitDto, id, duration, stateId, stateModelId, remark, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime);
        stateDTO.setStateIdAfter(stateIdAfter);
        return stateDTO;
    }

    private static final String generateStateHistorySql(long historyIdBegin, long historyIdEnd) {
        String sql = TelemetryFastLaneReader.appendStrings("SELECT sh.STATE_HISTORY_ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.STATE_ID_AFTER, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, ", "sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, um.CUSTOMER_UNIT_ID, ", "ui.NAME, um.DELETED", " from state_history sh ", " LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID ", " LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID ", " WHERE STATE_HISTORY_ID BETWEEN ", String.valueOf(historyIdBegin), " AND ", String.valueOf(historyIdEnd));
        return sql.toLowerCase();
    }

    @Override
    protected UnitDTO buildUnitDTO(ResultSet resultSet) {
        UnitDTO unitDTO = null;
        try {
            long unitId = resultSet.getLong("UNIT_ID");
            String unitName = resultSet.getString("NAME");
            String customerUnitId = resultSet.getString("CUSTOMER_UNIT_ID");
            boolean deleted = resultSet.getBoolean("DELETED");
            UnitModelValue unitModelValue = new UnitModelValue();
            unitModelValue.setUnitId(unitId);
            unitModelValue.setCustomerUnitID(customerUnitId);
            unitModelValue.setBasic(true);
            unitModelValue.setDeleted(deleted);
            UnitIdentityValue unitIdentityValue = new UnitIdentityValue();
            unitIdentityValue.setName(unitName);
            UnitTypeIdentityValue unitTypeIdentity = new UnitTypeIdentityValue();
            unitDTO = new UnitDTO(unitModelValue, unitIdentityValue, unitTypeIdentity);
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitDTO;
    }
}

