/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.data.FastLaneBase;
import de.proveo.wwt.logic.web.data.FastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.GseUsageDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTOList;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(ReportFastLaneReader.class);

    public void getStateHistory(List list, Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, boolean correctedTimes, boolean isGSEUsageQuery, boolean useGroupHistory) {
        log.debug((Object)"stateHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "stateHistoryFastLaneRead");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateStateHistorySql(unitId, isBasicUnit, stateModelID, beginTime, endTime, useGroupHistory);
                log.debug((Object)"database access fast lane...");
                log.debug((Object)("executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                UnitDTO unitDTO = null;
                UseUserValue useUserValue = null;
                AreaValue areaValue = null;
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    StateDTO stateDTO;
                    long id = resultSet.getLong("STATE_HISTORY_ID");
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    long stateId = resultSet.getLong("STATE_ID");
                    long stateModelId = resultSet.getLong("STATE_MODEL_ID");
                    long shBeginTime = resultSet.getLong("BEGIN_TIME");
                    long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                    long shEndTime = resultSet.getLong("END_TIME");
                    long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
                    long duration = resultSet.getLong("DURATION");
                    String remark = resultSet.getString("REMARK");
                    if (!(unitDTO != null && isBasicUnit || (unitDTO = (UnitDTO)unitModelMap.get(stateUnitId)) != null)) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    if (isGSEUsageQuery) {
                        boolean areaTrusted = resultSet.getBoolean("AREA_TRUSTED");
                        areaValue = new AreaValue();
                        areaValue.setArea(resultSet.getString("AREA"));
                        areaValue.setDescription(resultSet.getString("AREA_DESC"));
                        useUserValue = new UseUserValue();
                        useUserValue.setId(resultSet.getLong("USEUSER_ID"));
                        useUserValue.setPersonalNumber(resultSet.getString("PERSONAL_NUMBER"));
                        useUserValue.setName(resultSet.getString("USEUSER_NAME"));
                        useUserValue.setKey(resultSet.getString("KEY_ID"));
                        stateDTO = new GseUsageDTO(unitDTO, id, duration, stateId, stateModelId, remark, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime, areaTrusted, areaValue, useUserValue);
                    } else {
                        stateDTO = new StateDTO(unitDTO, id, duration, stateId, stateModelId, remark, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime);
                    }
                    if (correctedTimes) {
                        stateDTO.correctTimes(beginTime, endTime);
                    }
                    list.add(stateDTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
    }

    private String generateStateHistorySql(Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, boolean useGroupHistory) {
        String sql_opt1 = "";
        String sql_opt2 = "";
        switch (this.databaseType) {
            case Oracle: {
                sql_opt1 = isBasicUnit ? "/*+ index(sh sh_uid_bstamp_estamp) */ " : "/*+ index(sh sh_bstamp_estamp) */ ";
                break;
            }
            case MySQL: {
                sql_opt2 = isBasicUnit ? "use index (state_history_idx_unitid_beginstamp_endstamp) " : "use index (state_history_idx_beginstamp_endstamp) ";
                break;
            }
            case MSSQL: {
                sql_opt2 = isBasicUnit ? "with (Index (state_history_idx_unitid_beginstamp_endstamp)) " : "with (Index (state_history_idx_beginstamp_endstamp)) ";
            }
        }
        String sql = ReportFastLaneReader.appendStrings("SELECT DISTINCT ", "sh.STATE_HISTORY_ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, ", "sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, sh.AREA_TRUSTED, a.AREA, a.DESCRIPTION as AREA_DESC, ", "ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED, ", " uu.ID as USEUSER_ID, uu.NAME as USEUSER_NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", " FROM state_history_helper hsh ", "LEFT JOIN state_history sh ON hsh.STATE_HISTORY_ID = sh.STATE_HISTORY_ID ", "LEFT JOIN unit_model um ON hsh.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON hsh.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID ", "LEFT JOIN area a ON sh.AREA_ID = a.AREA_ID ", "LEFT JOIN use_user uu ON sh.USE_USER_ID = uu.ID ");
        String groupSQL = ReportFastLaneReader.appendStrings(" LEFT JOIN groupHistory gh ON hsh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID ", " LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ");
        String sqlWhereClause = ReportFastLaneReader.appendStrings(" WHERE hsh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(endTime / 86400000L))), " AND hsh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(beginTime / 86400000L))), " AND sh.BEGIN_TIME < ", String.valueOf(endTime), " AND sh.END_TIME > ", String.valueOf(beginTime));
        String sqlStateModelId = ReportFastLaneReader.appendStrings(" AND sh.STATE_MODEL_ID = ", String.valueOf(stateModelID));
        String groupSQLWhereClause = ReportFastLaneReader.appendStrings(" AND ghu.UNITGROUP_ID = ", String.valueOf(unitId));
        String basicUnitSQL = ReportFastLaneReader.appendStrings(" AND hsh.UNIT_ID = ", String.valueOf(unitId));
        String orderByBeginTime = " ORDER BY sh.BEGIN_TIME ASC ";
        String orderByUnitIdAndBeginTime = " ORDER BY sh.UNIT_ID ASC, sh.BEGIN_TIME ASC";
        String sqlUnitIdIn = ReportFastLaneReader.appendStrings(" AND sh.", ReportFastLaneReader.sqlUnitIdInForUnitModelList(unitId));
        if (stateModelID != null) {
            sqlWhereClause = ReportFastLaneReader.appendStrings(sqlWhereClause, sqlStateModelId);
        }
        sql = unitId == null ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause) : (isBasicUnit ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause, basicUnitSQL) : (useGroupHistory ? ReportFastLaneReader.appendStrings(sql, groupSQL, sqlWhereClause, groupSQLWhereClause) : ReportFastLaneReader.appendStrings(sql, sqlWhereClause, sqlUnitIdIn)));
        sql = ReportFastLaneReader.appendStrings(sql, isBasicUnit ? orderByBeginTime : orderByUnitIdAndBeginTime);
        return sql.toLowerCase();
    }

    public void getGdataHistory(PositionDTOList list, Long unitId, boolean isBasicUnit, long beginTime, long endTime, boolean correctedTimes, boolean fetchExtendedData) {
        log.debug((Object)"gdataHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "gdataHistoryFastLaneRead");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateGdataHistorySql(unitId, isBasicUnit, beginTime, endTime, maxRowsLimit);
                log.debug((Object)"database access fast lane...");
                log.debug((Object)("executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (FastLaneBase.DatabaseType.Oracle == this.databaseType) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReportFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building DTOs...");
                    stopwatch.start("building DTO");
                    UnitDTO unitDTO = null;
                    HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                    while (resultSet.next()) {
                        long gdataUnitId = resultSet.getLong("UNIT_ID");
                        if (!(isBasicUnit && unitDTO != null || (unitDTO = (UnitDTO)unitModelMap.get(gdataUnitId)) != null)) {
                            unitDTO = this.buildUnitDTO(resultSet);
                            unitModelMap.put(gdataUnitId, unitDTO);
                        }
                        PositionDTO positionDTO = ReportFastLaneReader.getPositionDTO(unitDTO, resultSet, fetchExtendedData);
                        if (correctedTimes) {
                            positionDTO.correctTimes(beginTime, endTime);
                        }
                        list.add(positionDTO);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, size);
                } else {
                    list.setMaxRowsLimit(maxRowsLimit);
                    log.debug((Object)("Row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
    }

    private static PositionDTO getPositionDTO(UnitDTO unitDTO, ResultSet resultSet, boolean fetchExtendedData) throws SQLException {
        String ggaRec = null;
        String rmcRmcRec = null;
        String reason = null;
        int latMSEC = 0;
        int longMSEC = 0;
        if (fetchExtendedData) {
            ggaRec = resultSet.getString("GGA_REC");
            rmcRmcRec = resultSet.getString("RMC_REC");
            reason = resultSet.getString("REASON");
            latMSEC = resultSet.getInt("LAT_MSEC");
            longMSEC = resultSet.getInt("LONG_MSEC");
        }
        String area = resultSet.getString("AREA");
        String areaDescr = resultSet.getString("AREA_DESCRIPTION");
        long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
        long bdataEndTime = resultSet.getLong("END_TIME");
        boolean trusted = resultSet.getBoolean("TRUSTED");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        long endReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
        return new PositionDTO(unitDTO, gdataBeginTime, bdataEndTime, beginReceiveTime, endReceiveTime, trusted, ggaRec, latMSEC, longMSEC, rmcRmcRec, reason, area, areaDescr);
    }

    private String generateGdataHistorySql(Long unitId, boolean isBasicUnit, long beginTime, long endTime, int maxRowsLimit) {
        String sql_opt1 = "";
        String sql_opt2 = "";
        String limitRowsSQL = "";
        switch (this.databaseType) {
            case Oracle: {
                sql_opt1 = isBasicUnit ? "/*+ index(g gh_uid_bstamp_estamp) */ " : "/*+ index(g gh_bstamp_estamp) */ ";
                limitRowsSQL = " AND ROWNUM <=" + maxRowsLimit;
                break;
            }
            case MySQL: {
                sql_opt2 = "";
                limitRowsSQL = " LIMIT " + maxRowsLimit;
                break;
            }
            case MSSQL: {
                sql_opt2 = isBasicUnit ? "with (Index (gdata_history_idx_unitid_beginstamp_endstamp)) " : "with (Index (gdata_history_idx_beginstamp_endstamp)) ";
            }
        }
        String sql = ReportFastLaneReader.appendStrings("SELECT DISTINCT ", "g.UNIT_ID, g.BEGIN_TIME, g.BEGIN_RECEIVE_TIME, g.END_TIME, g.END_RECEIVE_TIME, ", "g.PK_GDATA_PREVIOUS, g.RMC_REC, g.GGA_REC, g.AREA_ID, g.TRUSTED, g.REASON, g.LONG_MSEC, g.LAT_MSEC, a.AREA, a.DESCRIPTION as AREA_DESCRIPTION, ", "ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED ", "FROM gdata_history_helper hg ", "LEFT JOIN gdata_history g ON hg.GDATA_HISTORY_ID = g.GDATA_HISTORY_ID ", "LEFT JOIN unit_model um ON hg.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON hg.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID ", "LEFT JOIN area a ON g.AREA_ID = a.AREA_ID ");
        String groupSQL = ReportFastLaneReader.appendStrings(" LEFT JOIN groupHistory gh ON hg.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID ", " LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ");
        String sqlWhereClause = ReportFastLaneReader.appendStrings(" WHERE hg.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(endTime / 86400000L))), " AND hg.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(beginTime / 86400000L))), " AND g.BEGIN_TIME < ", String.valueOf(endTime), " AND g.END_TIME > ", String.valueOf(beginTime));
        String groupSQLWhereClause = ReportFastLaneReader.appendStrings(" AND ghu.UNITGROUP_ID = ", String.valueOf(unitId));
        String basicUnitSQL = ReportFastLaneReader.appendStrings(" AND hg.UNIT_ID = ", String.valueOf(unitId));
        sql = unitId == null ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause) : (isBasicUnit ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause, basicUnitSQL) : ReportFastLaneReader.appendStrings(sql, groupSQL, sqlWhereClause, groupSQLWhereClause));
        if (maxRowsLimit != 0) {
            sql = ReportFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public void getNotificationHistory(List list, Long unitId, boolean isBasicUnit, Long messageId, long beginTime, long endTime) {
        log.debug((Object)"notificationHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "notificationHistoryFastLaneRead");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = ReportFastLaneReader.generateNotificaionHistorySql(unitId, isBasicUnit, beginTime, endTime);
                log.debug((Object)"database access fast lane...");
                log.debug((Object)("executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                UnitDTO unitDTO = null;
                UseUserValue useUserValue = null;
                AreaValue areaValue = null;
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (resultSet.next()) {
                    long nhUnitId = resultSet.getLong("UNIT_ID");
                    long nhMessageId = resultSet.getLong("MESSAGE_ID");
                    long nhCreateTime = resultSet.getLong("CREATE_TIME");
                    long nhReceiveTime = resultSet.getLong("RECEIVE_TIME");
                    String remark = resultSet.getString("REMARK");
                    if (!(unitDTO != null && isBasicUnit || (unitDTO = (UnitDTO)unitModelMap.get(nhUnitId)) != null)) {
                        unitDTO = this.buildUnitDTO(resultSet);
                        unitModelMap.put(nhUnitId, unitDTO);
                    }
                    areaValue = new AreaValue();
                    areaValue.setArea(resultSet.getString("AREA"));
                    areaValue.setDescription(resultSet.getString("AREA_DESC"));
                    useUserValue = new UseUserValue();
                    useUserValue.setId(resultSet.getLong("USEUSER_ID"));
                    useUserValue.setPersonalNumber(resultSet.getString("PERSONAL_NUMBER"));
                    useUserValue.setName(resultSet.getString("USEUSER_NAME"));
                    useUserValue.setKey(resultSet.getString("KEY_ID"));
                    if (messageId != null && messageId != nhMessageId) continue;
                    NotificationDTO notificationDTO = new NotificationDTO(unitDTO, nhMessageId, nhCreateTime, nhReceiveTime, remark, useUserValue, areaValue);
                    list.add(notificationDTO);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
    }

    private static String generateNotificaionHistorySql(Long unitId, boolean isBasicUnit, long beginTime, long endTime) {
        String sql = ReportFastLaneReader.appendStrings("SELECT nh.ID, nh.UNIT_ID, nh.MESSAGE_ID, nh.CREATE_TIME, nh.RECEIVE_TIME,", "nh.REMARK, a.AREA, a.DESCRIPTION as AREA_DESC, ", "ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED, ", " uu.ID as USEUSER_ID, uu.NAME as USEUSER_NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", "from notify_history nh ", "LEFT JOIN unit_model um ON nh.UNIT_ID = um.UNIT_ID ", "LEFT JOIN unit_identity ui ON nh.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID ", "LEFT JOIN area  a ON nh.AREA_ID = a.AREA_ID ", "LEFT JOIN use_user uu ON nh.USE_USER_ID = uu.ID ");
        String groupSQL = ReportFastLaneReader.appendStrings(" LEFT JOIN groupHistory gh ON nh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID ", " LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ");
        String sqlWhereClause = ReportFastLaneReader.appendStrings(" WHERE nh.CREATE_TIME < ", String.valueOf(endTime), " AND nh.CREATE_TIME > ", String.valueOf(beginTime));
        String groupSQLWhereClause = ReportFastLaneReader.appendStrings(" AND ghu.UNITGROUP_ID = ", String.valueOf(unitId));
        String basicUnitSQL = ReportFastLaneReader.appendStrings(" AND nh.UNIT_ID = ", String.valueOf(unitId));
        String orderByBeginTime = " ORDER BY nh.CREATE_TIME ASC ";
        sql = unitId == null ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause, orderByBeginTime) : (isBasicUnit ? ReportFastLaneReader.appendStrings(sql, sqlWhereClause, basicUnitSQL) : ReportFastLaneReader.appendStrings(sql, groupSQL, sqlWhereClause, groupSQLWhereClause, orderByBeginTime));
        return sql.toLowerCase();
    }

    public Collection<StateSummaryValue> getStateSummary(Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, int periodType, boolean useGroupHistory) {
        ArrayList<StateSummaryValue> collSummaries = new ArrayList<StateSummaryValue>();
        log.debug((Object)"notificationHistoryFastLaneRead1 called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "notificationHistoryFastLaneRead1");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = ReportFastLaneReader.generateStateSummarySql(unitId, isBasicUnit, stateModelID, beginTime, endTime, periodType, useGroupHistory);
                log.debug((Object)"database access fast lane...");
                log.debug((Object)("executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                while (resultSet.next()) {
                    collSummaries.add(ReportFastLaneReader.getStateSummaryValue(resultSet));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, collSummaries.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return collSummaries;
    }

    private static StateSummaryValue getStateSummaryValue(ResultSet resultSet) throws SQLException {
        StateSummaryValue stateSummaryValue = new StateSummaryValue();
        stateSummaryValue.setBeginTime(resultSet.getLong("BEGIN_TIME"));
        stateSummaryValue.setStateId(resultSet.getLong("STATE_ID"));
        stateSummaryValue.setStateModelId(resultSet.getLong("STATE_MODEL_ID"));
        stateSummaryValue.setDuration(resultSet.getLong("DURATION"));
        stateSummaryValue.setPeriodType(resultSet.getInt("PERIOD_TYPE"));
        stateSummaryValue.setUnitId(resultSet.getLong("UNIT_ID"));
        return stateSummaryValue;
    }

    private static String generateStateSummarySql(Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, int periodType, boolean useGroupHistory) {
        String sql = ReportFastLaneReader.appendStrings("SELECT sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, sh.PERIOD_TYPE, sh.DURATION ", " from state_summary sh ");
        String sqlTimeframe = ReportFastLaneReader.appendStrings(" sh.BEGIN_TIME < ", String.valueOf(endTime), " AND sh.BEGIN_TIME >= ", String.valueOf(beginTime));
        String sqlUnitIdIn = ReportFastLaneReader.appendStrings("sh.", ReportFastLaneReader.sqlUnitIdInForUnitModelList(unitId));
        String basicUnitSQL = ReportFastLaneReader.appendStrings(" sh.UNIT_ID = ", String.valueOf(unitId));
        String sqlStateModelId = "";
        if (stateModelID != null) {
            sqlStateModelId = ReportFastLaneReader.appendStrings(" AND sh.STATE_MODEL_ID = ", String.valueOf(stateModelID));
        }
        String sqlPeriod = ReportFastLaneReader.appendStrings(" sh.PERIOD_TYPE = ", String.valueOf(periodType));
        String orderByBeginTime = " ORDER BY sh.BEGIN_TIME ASC ";
        String orderByUnitId = " ORDER BY sh.UNIT_ID ASC";
        String groupHistorySQL = ReportFastLaneReader.appendStrings(" LEFT JOIN groupHistory gh ON sh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID ", " LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ");
        String groupHistorySQLWhereClause = ReportFastLaneReader.appendStrings(" ghu.UNITGROUP_ID = ", String.valueOf(unitId));
        sql = unitId == null ? ReportFastLaneReader.appendStrings(sql, " WHERE ", sqlUnitIdIn, sqlStateModelId, " AND ", sqlPeriod, " AND ", sqlTimeframe, orderByUnitId) : (isBasicUnit ? ReportFastLaneReader.appendStrings(sql, " WHERE ", basicUnitSQL, sqlStateModelId, " AND ", sqlPeriod, " AND ", sqlTimeframe, orderByBeginTime) : (useGroupHistory ? ReportFastLaneReader.appendStrings(sql, groupHistorySQL, " WHERE ", groupHistorySQLWhereClause, sqlStateModelId, " AND ", sqlPeriod, " AND ", sqlTimeframe, orderByUnitId) : ReportFastLaneReader.appendStrings(sql, " WHERE ", sqlUnitIdIn, sqlStateModelId, " AND ", sqlPeriod, " AND ", sqlTimeframe, orderByUnitId)));
        sql = sql.toLowerCase();
        return sql;
    }

    private static String sqlUnitIdInForUnitModelList(Long unitId) {
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        StringBuilder sb = new StringBuilder("UNIT_ID IN (");
        for (int i = 0; i < unitBasicModels.size(); ++i) {
            sb.append("'");
            sb.append(String.valueOf(((UnitModelLocal)unitBasicModels.get(i)).getUnitId()));
            sb.append("'");
            sb.append(i == unitBasicModels.size() - 1 ? ") " : ",");
        }
        return sb.toString();
    }
}

