/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.FastLaneBase;
import de.proveo.wwt.logic.web.data.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplayFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(ReplayFastLaneReader.class);

    protected static String getUnitIdString(HashSet<Long> unitIds) {
        StringBuffer unitIdString = new StringBuffer();
        Iterator<Long> iterator = unitIds.iterator();
        while (iterator.hasNext()) {
            unitIdString.append(iterator.next());
            if (!iterator.hasNext()) continue;
            unitIdString.append(",");
        }
        return unitIdString.toString();
    }

    protected static String getFlightIdString(Set<String> flightIds) {
        StringBuffer flightIdString = new StringBuffer();
        Iterator<String> iterator = flightIds.iterator();
        while (iterator.hasNext()) {
            flightIdString.append(iterator.next());
            if (!iterator.hasNext()) continue;
            flightIdString.append(",");
        }
        return flightIdString.toString();
    }

    private HashMap generateGeoMap(long gdataCreateTime, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> valueMap;
        String ggaRec = resultSet.getString("GGA_REC");
        String rmcRec = resultSet.getString("RMC_REC");
        if (ggaRec == null || ggaRec.length() < 50 || rmcRec == null || rmcRec.length() < 40) {
            valueMap = null;
        } else {
            long gdataUnitId = resultSet.getLong("UNIT_ID");
            int areaId = resultSet.getInt("AREA_ID");
            long gdataBeginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
            boolean trusted = resultSet.getBoolean("TRUSTED");
            int latMSEC = resultSet.getInt("LAT_MSEC");
            int longMSEC = resultSet.getInt("LONG_MSEC");
            valueMap = new HashMap<String, Object>();
            valueMap.put("EventType", "GeoStruct");
            valueMap.put("UnitId", gdataUnitId);
            valueMap.put("GpsGga", ggaRec);
            valueMap.put("GpsRmc", rmcRec);
            valueMap.put("GpsTrusted", trusted);
            valueMap.put("GeoBegin", gdataBeginReceiveTime);
            valueMap.put("AreaId", areaId);
            valueMap.put("GpsLatMsec", latMSEC);
            valueMap.put("GpsLongMsec", longMSEC);
            valueMap.put("ServerTime", gdataCreateTime);
        }
        return valueMap;
    }

    public HashMap<Long, HashMap> getInitialGeoCache(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialGeoCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialGeoCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getInitialGeoCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialGeoCacheSql(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (FastLaneBase.DatabaseType.Oracle == this.databaseType) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long gdataCreateTime = resultSet.getLong("CREATE_TIME");
                        HashMap valueMap = this.generateGeoMap(gdataCreateTime, resultSet);
                        if (valueMap == null) continue;
                        retMap.put(resultSet.getLong("UNIT_ID"), valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialGeoCacheSql(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT g.UNIT_ID, g.CREATE_TIME, g.BEGIN_RECEIVE_TIME, ", "g.RMC_REC, g.GGA_REC, g.AREA_ID, g.TRUSTED, g.LONG_MSEC, g.LAT_MSEC ", "FROM current_gdata_cache g ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE g.CREATE_TIME <= ", String.valueOf(since));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND g.UNIT_ID IN (", unitPermissionsAsString, ")");
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getGeoCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getGeoCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getGeoCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getGeoCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateGeoCacheSql(since, until, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long gdataCreateTime = resultSet.getLong("CREATE_TIME");
                        while (completeReplayDataMap.containsKey(gdataCreateTime)) {
                            ++gdataCreateTime;
                        }
                        HashMap valueMap = this.generateGeoMap(gdataCreateTime, resultSet);
                        if (valueMap == null) continue;
                        completeReplayDataMap.put(gdataCreateTime, valueMap);
                        retMap.put(gdataCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateGeoCacheSql(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT g.UNIT_ID, g.CREATE_TIME, g.BEGIN_RECEIVE_TIME, ", "g.RMC_REC, g.GGA_REC, g.AREA_ID, g.TRUSTED, g.LONG_MSEC, g.LAT_MSEC ", "FROM current_gdata_cache g ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE g.CREATE_TIME > ", String.valueOf(since), " AND g.CREATE_TIME <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND g.UNIT_ID IN (", unitPermissionsAsString, ")");
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getGeoHistory(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getGeoHistoryForReplayFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getGeoHistoryForReplayFastLaneRead");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateGeoHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
                        while (completeReplayDataMap.containsKey(gdataBeginTime)) {
                            ++gdataBeginTime;
                        }
                        HashMap valueMap = this.generateGeoMap(gdataBeginTime, resultSet);
                        if (valueMap == null) continue;
                        completeReplayDataMap.put(gdataBeginTime, valueMap);
                        retMap.put(gdataBeginTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateGeoHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT gh.UNIT_ID, gh.BEGIN_RECEIVE_TIME, gh.BEGIN_TIME, gh.RMC_REC, ", "gh.GGA_REC, gh.AREA_ID, gh.TRUSTED, gh.LONG_MSEC, gh.LAT_MSEC ", "FROM gdata_history_helper ghh ");
        String leftJoin = "LEFT JOIN gdata_history gh ON ghh.GDATA_HISTORY_ID = gh.GDATA_HISTORY_ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE ghh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(until / 86400000L))), " AND ghh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND gh.BEGIN_TIME < ", String.valueOf(until), " AND gh.END_TIME > ", String.valueOf(since));
        String orderByBeginTime = " ORDER BY gh.BEGIN_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderByBeginTime);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            if (FastLaneBase.DatabaseType.Oracle == this.databaseType) {
                limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", String.valueOf(maxRowsLimit));
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialKeepAliveCache(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialKeepAliveCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialKeepAliveCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getInitialKeepAliveCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialKeepAliveCacheSql(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long kaUnitId = resultSet.getLong("UNIT_ID");
                        long kaTimeStamp = resultSet.getLong("CREATE_TIME_STAMP");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "KeepAliveEvent");
                        valueMap.put("UnitId", kaUnitId);
                        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
                        valueMap.put("KeepaliveTimeout", Boolean.FALSE);
                        valueMap.put("ServerTime", kaTimeStamp);
                        retMap.put(kaUnitId, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialKeepAliveCacheSql(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT k.UNIT_ID, k.CREATE_TIME_STAMP ", "FROM keepalive_cache k ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE k.CREATE_TIME_STAMP <= ", String.valueOf(since));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND k.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY k.CREATE_TIME_STAMP DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, TreeMap> getInitialNotifyCache(HashSet<Long> unitPermissions, long since, int maximumNotifiesPerDay) {
        log.debug((Object)"getInitialNotifyCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialNotifyCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, TreeMap> retMap = new HashMap<Long, TreeMap>();
        if (unitPermissions == null || unitPermissions.size() <= 0) {
            log.warn((Object)"getInitialNotifyCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialNotifyCacheSql(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long nUnitId = resultSet.getLong("UNIT_ID");
                        long nTimeStamp = resultSet.getLong("CREATE_TIME");
                        long nReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        long nMessageId = resultSet.getLong("MESSAGE_ID");
                        String nMessageName = resultSet.getString("DEFAULT_NAME");
                        boolean nEntry = resultSet.getBoolean("ENTRY");
                        TreeMap unitValueMap = new TreeMap();
                        if (retMap.containsKey(nUnitId)) {
                            unitValueMap = retMap.get(nUnitId);
                            if (maximumNotifiesPerDay > 0 && unitValueMap.size() >= maximumNotifiesPerDay) continue;
                            while (unitValueMap.containsKey(nTimeStamp + "_" + nMessageId)) {
                                ++nTimeStamp;
                            }
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_notification_event");
                        valueMap.put("UnitId", nUnitId);
                        valueMap.put("NotifyMessageID", nMessageId);
                        valueMap.put("NotifyMessage", nMessageName);
                        valueMap.put("NotifyEntry", nEntry);
                        valueMap.put("NotifyTimestamp", nTimeStamp);
                        valueMap.put("NotifyReceiveTime", nReceiveTime);
                        valueMap.put("ServerTime", nTimeStamp);
                        unitValueMap.put(nTimeStamp + "_" + nMessageId, valueMap);
                        retMap.put(nUnitId, unitValueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialNotifyCacheSql(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT n.UNIT_ID, n.CREATE_TIME, n.RECEIVE_TIME, n.MESSAGE_ID, n.ENTRY, nf.DEFAULT_NAME ", "FROM current_notify_cache n");
        String leftJoin = ReplayFastLaneReader.appendStrings(" LEFT JOIN notification nf on nf.ID=n.MESSAGE_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE n.CREATE_TIME <= ", String.valueOf(since), " AND n.CREATE_TIME >= ", String.valueOf(since - 864000000L));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND n.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY n.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, TreeMap> getInitialNotifyHistory(HashSet<Long> unitPermissions, long since, HashMap<Long, TreeMap> notifyCacheMap, int maximumNotifiesPerDay) {
        log.debug((Object)"getInitialNotifyHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialNotifyHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        if (notifyCacheMap == null) {
            notifyCacheMap = new HashMap();
        }
        HashMap tmpMap = new HashMap();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialNotifyHistorySql(since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long nUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(nUnitId)) continue;
                        long nTimeStamp = resultSet.getLong("CREATE_TIME");
                        long nReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        long nMessageId = resultSet.getLong("MESSAGE_ID");
                        String nMessageName = resultSet.getString("DEFAULT_NAME");
                        boolean nEntry = resultSet.getBoolean("ENTRY");
                        TreeMap unitValueMap = new TreeMap();
                        if (notifyCacheMap.containsKey(nUnitId)) {
                            unitValueMap = notifyCacheMap.get(nUnitId);
                            if (maximumNotifiesPerDay > 0 && unitValueMap.size() >= maximumNotifiesPerDay) continue;
                            while (unitValueMap.containsKey(nTimeStamp + "_" + nMessageId)) {
                                ++nTimeStamp;
                            }
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_notification_event");
                        valueMap.put("UnitId", nUnitId);
                        valueMap.put("NotifyMessageID", nMessageId);
                        valueMap.put("NotifyMessage", nMessageName);
                        valueMap.put("NotifyEntry", nEntry);
                        valueMap.put("NotifyTimestamp", nTimeStamp);
                        valueMap.put("NotifyReceiveTime", nReceiveTime);
                        valueMap.put("ServerTime", nTimeStamp);
                        unitValueMap.put(nTimeStamp + "_" + nMessageId, valueMap);
                        notifyCacheMap.put(nUnitId, unitValueMap);
                        tmpMap.put(nUnitId, unitValueMap);
                    }
                    stopwatch.stop("building DTO", true, tmpMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return notifyCacheMap;
    }

    private String generateInitialNotifyHistorySql(long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT nh.UNIT_ID, nh.CREATE_TIME, nh.RECEIVE_TIME, nh.MESSAGE_ID, nh.ENTRY, nf.DEFAULT_NAME ", "FROM notify_history_helper nhh ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN notify_history nh ON nhh.ID = nh.ID ", "LEFT JOIN notification nf ON nf.ID = nh.MESSAGE_ID ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE nhh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(since / 86400000L))), " AND nhh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND nh.CREATE_TIME <= ", String.valueOf(since), " AND nh.CREATE_TIME >= ", String.valueOf(since - 864000000L));
        String orderBySql = " ORDER BY nh.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialUseCache(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialUseCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialUseCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getInitialUseCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialUseCacheSql(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long useUnitId = resultSet.getLong("UNIT_ID");
                        long useBeginTime = resultSet.getLong("BEGIN_TIME");
                        String useUserKey = resultSet.getString("KEY_ID");
                        String usePersonalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String useUserName = resultSet.getString("NAME");
                        long useUserGroupId = resultSet.getLong("GROUP_ID");
                        long useReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "UseEvent");
                        valueMap.put("UnitId", useUnitId);
                        valueMap.put("UseEventUserKey", useUserKey);
                        valueMap.put("UseEventDriverName", useUserName);
                        valueMap.put("UseEventPersonalNumber", usePersonalNumber);
                        valueMap.put("UseEventTimestamp", useBeginTime);
                        valueMap.put("UseEventUserGroupId", useUserGroupId);
                        valueMap.put("UseEventReceiveTime", useReceiveTime);
                        valueMap.put("UseEventLogin", Boolean.TRUE);
                        valueMap.put("ServerTime", useBeginTime);
                        retMap.put(useUnitId, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialUseCacheSql(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT u.UNIT_ID, u.USER_ID, u.GROUP_ID, u.BEGIN_TIME, u.RECEIVE_TIME, uu.NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", "FROM use_cache u ");
        String leftJoin = ReplayFastLaneReader.appendStrings(" LEFT JOIN use_user uu on uu.ID=u.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE u.BEGIN_TIME <= ", String.valueOf(since));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND u.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY u.BEGIN_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialUseHistory(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialUseHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialUseHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialUseHistorySql(since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long useUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(useUnitId)) continue;
                        long useBeginTime = resultSet.getLong("BEGIN_TIME");
                        long useEndTime = resultSet.getLong("END_TIME");
                        String useUserKey = resultSet.getString("KEY_ID");
                        String usePersonalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String useUserName = resultSet.getString("NAME");
                        long useUserGroupId = resultSet.getLong("GROUP_ID");
                        long useBeginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                        long useEndReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        Boolean login = Boolean.FALSE;
                        long timestamp = useEndTime;
                        long receiveTime = useEndReceiveTime;
                        if (useEndTime > since) {
                            login = Boolean.TRUE;
                            timestamp = useBeginTime;
                            receiveTime = useBeginReceiveTime;
                        }
                        valueMap.put("EventType", "UseEvent");
                        valueMap.put("UnitId", useUnitId);
                        valueMap.put("UseEventUserKey", useUserKey);
                        valueMap.put("UseEventDriverName", useUserName);
                        valueMap.put("UseEventPersonalNumber", usePersonalNumber);
                        valueMap.put("UseEventTimestamp", timestamp);
                        valueMap.put("UseEventUserGroupId", useUserGroupId);
                        valueMap.put("UseEventReceiveTime", receiveTime);
                        valueMap.put("UseEventLogin", login);
                        valueMap.put("ServerTime", timestamp);
                        retMap.put(useUnitId, valueMap);
                    }
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialUseHistorySql(long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT uh.UNIT_ID, uh.USER_ID, uh.GROUP_ID, uh.BEGIN_RECEIVE_TIME, uh.BEGIN_TIME, uh.END_RECEIVE_TIME, uh.END_TIME, uu.NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", "FROM use_history_helper uhh ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN use_history uh ON uhh.ID = uh.ID ", "LEFT JOIN use_user uu ON uu.ID = uh.USER_ID ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE uhh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(since / 86400000L))), " AND uhh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND uh.BEGIN_TIME <= ", String.valueOf(since), " AND uh.END_TIME >= ", String.valueOf(since));
        String orderBySql = " ORDER BY uh.BEGIN_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getUseCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getUseCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getUseCache");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() <= 0) {
            log.warn((Object)"getUseCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateUseCacheSql(since, until, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long useBeginTime = resultSet.getLong("BEGIN_TIME");
                        while (completeReplayDataMap.containsKey(useBeginTime)) {
                            ++useBeginTime;
                        }
                        long useUnitId = resultSet.getLong("UNIT_ID");
                        String useUserKey = resultSet.getString("KEY_ID");
                        String usePersonalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String useUserName = resultSet.getString("NAME");
                        long useUserGroupId = resultSet.getLong("GROUP_ID");
                        long useReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "UseEvent");
                        valueMap.put("UnitId", useUnitId);
                        valueMap.put("UseEventUserKey", useUserKey);
                        valueMap.put("UseEventDriverName", useUserName);
                        valueMap.put("UseEventPersonalNumber", usePersonalNumber);
                        valueMap.put("UseEventTimestamp", useBeginTime);
                        valueMap.put("UseEventUserGroupId", useUserGroupId);
                        valueMap.put("UseEventReceiveTime", useReceiveTime);
                        valueMap.put("UseEventLogin", Boolean.TRUE);
                        valueMap.put("ServerTime", useBeginTime);
                        completeReplayDataMap.put(useBeginTime, valueMap);
                        retMap.put(useBeginTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateUseCacheSql(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT u.UNIT_ID, u.USER_ID, u.GROUP_ID, u.BEGIN_TIME, u.RECEIVE_TIME, uu.NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", "FROM use_cache u ");
        String leftJoin = ReplayFastLaneReader.appendStrings(" LEFT JOIN use_user uu on uu.ID=u.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE u.BEGIN_TIME > ", String.valueOf(since), " AND u.BEGIN_TIME <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND u.UNIT_ID IN (", unitPermissionsAsString, ")");
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, unitPermissionsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getUseHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getUseHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getUseHistory");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateUseHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long useUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(useUnitId)) continue;
                        long useBeginTime = resultSet.getLong("BEGIN_TIME");
                        long useEndTime = resultSet.getLong("END_TIME");
                        String useUserKey = resultSet.getString("KEY_ID");
                        String usePersonalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String useUserName = resultSet.getString("NAME");
                        long useUserGroupId = resultSet.getLong("GROUP_ID");
                        long useBeginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
                        long useEndReceiveTime = resultSet.getLong("END_RECEIVE_TIME");
                        if (useBeginTime > since) {
                            while (completeReplayDataMap.containsKey(useBeginTime)) {
                                ++useBeginTime;
                            }
                            HashMap<String, Object> valueMapLogin = new HashMap<String, Object>();
                            valueMapLogin.put("EventType", "UseEvent");
                            valueMapLogin.put("UnitId", useUnitId);
                            valueMapLogin.put("UseEventUserKey", useUserKey);
                            valueMapLogin.put("UseEventDriverName", useUserName);
                            valueMapLogin.put("UseEventPersonalNumber", usePersonalNumber);
                            valueMapLogin.put("UseEventTimestamp", useBeginTime);
                            valueMapLogin.put("UseEventUserGroupId", useUserGroupId);
                            valueMapLogin.put("UseEventReceiveTime", useBeginReceiveTime);
                            valueMapLogin.put("UseEventLogin", Boolean.TRUE);
                            valueMapLogin.put("ServerTime", useBeginTime);
                            completeReplayDataMap.put(useBeginTime, valueMapLogin);
                            retMap.put(useBeginTime, valueMapLogin);
                        }
                        if (useEndTime > until) continue;
                        while (completeReplayDataMap.containsKey(useEndTime)) {
                            ++useEndTime;
                        }
                        HashMap<String, Object> valueMapLogout = new HashMap<String, Object>();
                        valueMapLogout.put("EventType", "UseEvent");
                        valueMapLogout.put("UnitId", useUnitId);
                        valueMapLogout.put("UseEventUserKey", useUserKey);
                        valueMapLogout.put("UseEventDriverName", useUserName);
                        valueMapLogout.put("UseEventPersonalNumber", usePersonalNumber);
                        valueMapLogout.put("UseEventTimestamp", useEndTime);
                        valueMapLogout.put("UseEventUserGroupId", useUserGroupId);
                        valueMapLogout.put("UseEventReceiveTime", useEndReceiveTime);
                        valueMapLogout.put("UseEventLogin", Boolean.FALSE);
                        valueMapLogout.put("ServerTime", useEndTime);
                        completeReplayDataMap.put(useEndTime, valueMapLogout);
                        retMap.put(useEndTime, valueMapLogout);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateUseHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT uh.UNIT_ID, uh.USER_ID, uh.GROUP_ID, uh.BEGIN_RECEIVE_TIME, uh.BEGIN_TIME, uh.END_RECEIVE_TIME, uh.END_TIME, uu.NAME, uu.PERSONAL_NUMBER, uu.KEY_ID ", "FROM use_history_helper uhh ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN use_history uh ON uhh.ID = uh.ID ", "LEFT JOIN use_user uu ON uu.ID = uh.USER_ID ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE uhh.DAY_STAMP <= ", String.valueOf(until / 86400000L), " AND uhh.DAY_STAMP >= ", String.valueOf(since / 86400000L), " AND uh.BEGIN_TIME < ", String.valueOf(until), " AND uh.END_TIME >= ", String.valueOf(since));
        String orderBySql = " ORDER BY uh.BEGIN_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialInfomanMsgCache(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialInfomanMsgCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialInfomanMsgCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getInitialInfomanMsgCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialInfomanMsgCacheSql(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        int iType = resultSet.getInt("TYPE");
                        if (iType != 9 && iType != 25 && iType != 10) continue;
                        long iUnitId = resultSet.getLong("UNIT_ID");
                        long iCreateTime = resultSet.getLong("CREATE_TIME");
                        String iMessage = resultSet.getString("MESSAGE");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        if (iType == 9) {
                            valueMap.put("SmErrorTimestamp", iCreateTime);
                            valueMap.put("SmErrorMessage", iMessage);
                        } else if (iType == 25) {
                            valueMap.put("SmBootTimestamp", iCreateTime);
                            valueMap.put("SmBootMessage", iMessage);
                        } else if (iType == 10) {
                            valueMap.put("SmIpTimestamp", iCreateTime);
                            valueMap.put("SmIpMessage", iMessage);
                        }
                        valueMap.put("ServerTime", iCreateTime);
                        retMap.put(iUnitId, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialInfomanMsgCacheSql(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT i.UNIT_ID, i.CREATE_TIME, i.TYPE, i.MESSAGE ", "FROM scanman_msg_cache i ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE i.CREATE_TIME <= ", String.valueOf(since));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND i.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY i.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialInfomanMsgHistory(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialInfomanMsgHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialInfomanMsgHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialInfomanMsgHistorySql(since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        int iType;
                        long iUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(iUnitId) || (iType = resultSet.getInt("TYPE")) != 9 && iType != 25 && iType != 10) continue;
                        long iCreateTime = resultSet.getLong("CREATE_TIME");
                        String iMessage = resultSet.getString("MSG_TO_STRING");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        if (iType == 9) {
                            valueMap.put("SmErrorTimestamp", iCreateTime);
                            valueMap.put("SmErrorMessage", iMessage);
                        } else if (iType == 25) {
                            valueMap.put("SmBootTimestamp", iCreateTime);
                            valueMap.put("SmBootMessage", iMessage);
                        } else if (iType == 10) {
                            valueMap.put("SmIpTimestamp", iCreateTime);
                            valueMap.put("SmIpMessage", iMessage);
                        }
                        valueMap.put("ServerTime", iCreateTime);
                        retMap.put(iUnitId, valueMap);
                    }
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialInfomanMsgHistorySql(long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT smh.UNIT_ID, MAX(smh.CREATE_TIME) as CREATE_TIME, smh.TYPE, smh.MSG_TO_STRING ", "FROM scanman_msg_history_helper smhh ");
        String leftJoin = "LEFT JOIN scanman_msg_history smh ON smhh.SCANMAN_MSG_HISTORY_ID = smh.SCANMAN_MSG_HISTORY_ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE smhh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(since / 86400000L))), " AND smhh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND smh.CREATE_TIME <= ", String.valueOf(since));
        String groupBySql = " GROUP BY smh.UNIT_ID";
        String orderByBeginTime = " ORDER BY smh.CREATE_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, groupBySql, orderByBeginTime);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getInfomanMsgCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getInfomanMsgCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInfomanMsgCache");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() <= 0) {
            log.warn((Object)"getInfomanMsgCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInfomanMsgCacheSql(since, until, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        int iType = resultSet.getInt("TYPE");
                        if (iType != 9 && iType != 25 && iType != 10) continue;
                        long iCreateTime = resultSet.getLong("CREATE_TIME");
                        long iUnitId = resultSet.getLong("UNIT_ID");
                        String iMessage = resultSet.getString("MESSAGE");
                        while (completeReplayDataMap.containsKey(iCreateTime)) {
                            ++iCreateTime;
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        if (iType == 9) {
                            valueMap.put("SmErrorTimestamp", iCreateTime);
                            valueMap.put("SmErrorMessage", iMessage);
                        } else if (iType == 25) {
                            valueMap.put("SmBootTimestamp", iCreateTime);
                            valueMap.put("SmBootMessage", iMessage);
                        } else if (iType == 10) {
                            valueMap.put("SmIpTimestamp", iCreateTime);
                            valueMap.put("SmIpMessage", iMessage);
                        }
                        valueMap.put("ServerTime", iCreateTime);
                        completeReplayDataMap.put(iCreateTime, valueMap);
                        retMap.put(iCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInfomanMsgCacheSql(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT i.UNIT_ID, i.CREATE_TIME, i.TYPE, i.MESSAGE ", "FROM scanman_msg_cache i ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE i.CREATE_TIME > ", String.valueOf(since), " AND i.CREATE_TIME <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND i.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY i.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getInfomanMsgHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getInfomanMsgHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInfomanMsgHistory");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInfomanMsgHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        int iType;
                        long iUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(iUnitId) || (iType = resultSet.getInt("TYPE")) != 9 && iType != 25 && iType != 10) continue;
                        String iMessage = resultSet.getString("MSG_TO_STRING");
                        long iCreateTime = resultSet.getLong("CREATE_TIME");
                        while (completeReplayDataMap.containsKey(iCreateTime)) {
                            ++iCreateTime;
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "data_type_infoman_event");
                        valueMap.put("UnitId", iUnitId);
                        if (iType == 9) {
                            valueMap.put("SmErrorTimestamp", iCreateTime);
                            valueMap.put("SmErrorMessage", iMessage);
                        } else if (iType == 25) {
                            valueMap.put("SmBootTimestamp", iCreateTime);
                            valueMap.put("SmBootMessage", iMessage);
                        } else if (iType == 10) {
                            valueMap.put("SmIpTimestamp", iCreateTime);
                            valueMap.put("SmIpMessage", iMessage);
                        }
                        valueMap.put("ServerTime", iCreateTime);
                        completeReplayDataMap.put(iCreateTime, valueMap);
                        retMap.put(iCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInfomanMsgHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT smh.UNIT_ID, smh.CREATE_TIME, smh.TYPE, smh.MSG_TO_STRING ", "FROM scanman_msg_history_helper smhh ");
        String leftJoin = "LEFT JOIN scanman_msg_history smh ON smhh.SCANMAN_MSG_HISTORY_ID = smh.SCANMAN_MSG_HISTORY_ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE smhh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(until / 86400000L))), " AND smhh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND smh.CREATE_TIME > ", String.valueOf(since), " AND smh.CREATE_TIME <= ", String.valueOf(until));
        String orderByBeginTime = " ORDER BY smh.CREATE_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderByBeginTime);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getKeepAliveCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getKeepAliveCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getKeepAliveCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getKeepAliveCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateKeepAliveCacheSql(since, until, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long kaUnitId = resultSet.getLong("UNIT_ID");
                        long kaTimeStamp = resultSet.getLong("CREATE_TIME_STAMP");
                        while (completeReplayDataMap.containsKey(kaTimeStamp)) {
                            ++kaTimeStamp;
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "KeepAliveEvent");
                        valueMap.put("UnitId", kaUnitId);
                        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
                        valueMap.put("ServerTime", kaTimeStamp);
                        completeReplayDataMap.put(kaTimeStamp, valueMap);
                        retMap.put(kaTimeStamp, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateKeepAliveCacheSql(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT k.UNIT_ID, k.CREATE_TIME_STAMP ", "FROM keepalive_cache k ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE k.CREATE_TIME_STAMP > ", String.valueOf(since), " AND k.CREATE_TIME_STAMP <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND k.UNIT_ID IN (", unitPermissionsAsString, ")");
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public HashMap<Long, HashMap> getInitialKeepAliveHistory(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialKeepAliveHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialKeepAliveHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialKeepAliveHistorySql(since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long kaUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(kaUnitId)) continue;
                        long kaTimeStamp = resultSet.getLong("CREATE_TIME_STAMP");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "KeepAliveEvent");
                        valueMap.put("UnitId", kaUnitId);
                        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
                        valueMap.put("KeepaliveTimeout", Boolean.FALSE);
                        valueMap.put("ServerTime", kaTimeStamp);
                        retMap.put(kaUnitId, valueMap);
                    }
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialKeepAliveHistorySql(long since, int maxRowsLimit) {
        String sql_opt1 = "";
        String sql_opt2 = "";
        switch (this.databaseType) {
            case Oracle: {
                sql_opt1 = "/*+ index(k ka_uid_time) */ ";
                break;
            }
            case MSSQL: {
                sql_opt2 = "with (Index (keepalive_history_idx_unitid_timestamp)) ";
            }
        }
        String sql = ReplayFastLaneReader.appendStrings("SELECT", sql_opt1, " kh.UNIT_ID, MAX(kh.CREATE_TIME_STAMP) AS CREATE_TIME_STAMP ", "FROM keepalive_history_helper khh ", sql_opt2);
        String leftJoin = "LEFT JOIN keepalive_history kh ON khh.ID = kh.ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE khh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(since / 86400000L))), " AND khh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND kh.CREATE_TIME_STAMP <= ", String.valueOf(since));
        String groupBySql = " GROUP BY kh.UNIT_ID";
        String orderByBeginTime = " ORDER BY kh.CREATE_TIME_STAMP ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, groupBySql, orderByBeginTime);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getKeepAliveHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getKeepAliveHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getKeepAliveHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateKeepAliveHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long kaUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(kaUnitId)) continue;
                        long kaTimeStamp = resultSet.getLong("CREATE_TIME_STAMP");
                        while (completeReplayDataMap.containsKey(kaTimeStamp)) {
                            ++kaTimeStamp;
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "KeepAliveEvent");
                        valueMap.put("UnitId", kaUnitId);
                        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
                        valueMap.put("ServerTime", kaTimeStamp);
                        completeReplayDataMap.put(kaTimeStamp, valueMap);
                        retMap.put(kaTimeStamp, valueMap);
                    }
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateKeepAliveHistorySql(long since, long until, int maxRowsLimit) {
        String sql_opt1 = "";
        String sql_opt2 = "";
        switch (this.databaseType) {
            case Oracle: {
                sql_opt1 = "/*+ index(k ka_uid_time) */ ";
                break;
            }
            case MSSQL: {
                sql_opt2 = "with (Index (keepalive_history_idx_unitid_timestamp)) ";
            }
        }
        String sql = ReplayFastLaneReader.appendStrings("SELECT ", sql_opt1, "kh.UNIT_ID, kh.CREATE_TIME_STAMP ", "FROM keepalive_history_helper khh ", sql_opt2);
        String leftJoin = "LEFT JOIN keepalive_history kh ON khh.ID = kh.ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE khh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(until / 86400000L))), " AND khh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND kh.CREATE_TIME_STAMP > ", String.valueOf(since), " AND kh.CREATE_TIME_STAMP <= ", String.valueOf(until));
        String orderByBeginTime = " ORDER BY kh.CREATE_TIME_STAMP ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderByBeginTime);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getNotifyCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getNotifyCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getNotifyCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() <= 0) {
            log.warn((Object)"getNotifyCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateNotifyCacheSql(since, until, maxRowsLimit, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long nUnitId = resultSet.getLong("UNIT_ID");
                        long nMessageId = resultSet.getLong("MESSAGE_ID");
                        String nMessageName = resultSet.getString("DEFAULT_NAME");
                        boolean nEntry = resultSet.getBoolean("ENTRY");
                        long nTimeStamp = resultSet.getLong("CREATE_TIME");
                        long nReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        if (completeReplayDataMap.containsKey(nTimeStamp)) {
                            ++nTimeStamp;
                        }
                        valueMap.put("EventType", "data_type_notification_event");
                        valueMap.put("UnitId", nUnitId);
                        valueMap.put("NotifyMessageID", nMessageId);
                        valueMap.put("NotifyMessage", nMessageName);
                        valueMap.put("NotifyEntry", nEntry);
                        valueMap.put("NotifyTimestamp", nTimeStamp);
                        valueMap.put("NotifyReceiveTime", nReceiveTime);
                        valueMap.put("ServerTime", nTimeStamp);
                        completeReplayDataMap.put(nTimeStamp, valueMap);
                        retMap.put(nTimeStamp, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateNotifyCacheSql(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT n.UNIT_ID, n.CREATE_TIME, n.RECEIVE_TIME, n.MESSAGE_ID, n.ENTRY, nf.DEFAULT_NAME ", "FROM current_notify_cache n");
        String leftJoin = ReplayFastLaneReader.appendStrings(" LEFT JOIN notification nf on nf.ID=n.MESSAGE_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE n.CREATE_TIME > ", String.valueOf(since), " AND n.CREATE_TIME <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND n.UNIT_ID IN (", unitPermissionsAsString, ")");
        String orderBySql = " ORDER BY n.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, unitPermissionsSql, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getNotifyHistory(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getNotifyHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getNotifyHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateNotifyHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long nUnitId = resultSet.getLong("UNIT_ID");
                        if (!unitPermissions.contains(nUnitId)) continue;
                        long nMessageId = resultSet.getLong("MESSAGE_ID");
                        String nMessageName = resultSet.getString("DEFAULT_NAME");
                        boolean nEntry = resultSet.getBoolean("ENTRY");
                        long nTimeStamp = resultSet.getLong("CREATE_TIME");
                        long nReceiveTime = resultSet.getLong("RECEIVE_TIME");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        if (completeReplayDataMap.containsKey(nTimeStamp)) {
                            ++nTimeStamp;
                        }
                        valueMap.put("EventType", "data_type_notification_event");
                        valueMap.put("UnitId", nUnitId);
                        valueMap.put("NotifyMessageID", nMessageId);
                        valueMap.put("NotifyMessage", nMessageName);
                        valueMap.put("NotifyEntry", nEntry);
                        valueMap.put("NotifyTimestamp", nTimeStamp);
                        valueMap.put("NotifyReceiveTime", nReceiveTime);
                        valueMap.put("ServerTime", nTimeStamp);
                        completeReplayDataMap.put(nTimeStamp, valueMap);
                        retMap.put(nTimeStamp, valueMap);
                    }
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateNotifyHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT nh.UNIT_ID, nh.CREATE_TIME, nh.RECEIVE_TIME, nh.MESSAGE_ID, nh.ENTRY, nf.DEFAULT_NAME ", "FROM notify_history_helper nhh ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN notify_history nh ON nhh.ID = nh.ID ", "LEFT JOIN notification nf ON nf.ID = nh.MESSAGE_ID ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE nhh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(since / 86400000L))), " AND nhh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND nh.CREATE_TIME > ", String.valueOf(since), " AND nh.CREATE_TIME <= ", String.valueOf(until));
        String orderBySql = " ORDER BY nh.CREATE_TIME DESC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderBySql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    private HashMap generateStateMap(long beginTime, ResultSet resultSet) throws SQLException {
        long stateId = resultSet.getLong("STATE_ID");
        long stateUnitId = resultSet.getLong("UNIT_ID");
        long stateModelId = resultSet.getLong("STATE_MODEL_ID");
        long beginReceiveTime = resultSet.getLong("BEGIN_RECEIVE_TIME");
        String remark = resultSet.getString("REMARK");
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("EventType", "StateEvent");
        valueMap.put("UnitId", stateUnitId);
        valueMap.put("StateModelID", stateModelId);
        if (stateModelId == 2010L) {
            valueMap.put("MotorState", stateId);
            valueMap.put("MotorStateBegin", beginReceiveTime);
        } else if (stateModelId == 2050L) {
            valueMap.put("OperationState", stateId);
            valueMap.put("OperationStateBegin", beginReceiveTime);
        } else if (stateModelId == 2090L) {
            valueMap.put("ServiceState", stateId);
            valueMap.put("ServiceStateBegin", beginReceiveTime);
            valueMap.put("ServiceStateRemark", remark);
        } else if (stateModelId == 2100L) {
            valueMap.put("AssignedState", stateId);
            valueMap.put("AssignedStateBegin", beginReceiveTime);
            valueMap.put("AssignedStateRemark", remark);
        } else if (stateModelId == 2030L) {
            valueMap.put("FuelState", stateId);
            valueMap.put("FuelStateBegin", beginReceiveTime);
        } else if (stateModelId == 2020L) {
            valueMap.put("ConnectorState", stateId);
            valueMap.put("ConnectorStateBegin", beginReceiveTime);
        } else if (stateModelId == 2910L) {
            valueMap.put("Flag1State", stateId);
            valueMap.put("Flag1StateBegin", beginTime);
        } else if (stateModelId == 2920L) {
            valueMap.put("Flag2State", stateId);
            valueMap.put("Flag2StateBegin", beginTime);
        } else if (stateModelId == 2930L) {
            valueMap.put("Flag3State", stateId);
            valueMap.put("Flag3StateBegin", beginTime);
        } else if (stateModelId == 2110L) {
            valueMap.put("InfomanOnlineState", stateId);
            valueMap.put("InfomanOnlineStateBegin", beginTime);
        } else if (stateModelId == 2120L) {
            valueMap.put("GseAssignmentState", stateId);
            valueMap.put("GseAssignmentStateBegin", beginTime);
        } else {
            log.error((Object)("Unknown state model id: " + stateModelId));
            valueMap = null;
        }
        return valueMap;
    }

    public HashMap<Long, HashMap<Long, HashMap>> getInitialStateCache(HashSet<Long> unitPermissions, long since) {
        log.debug((Object)"getInitialStateCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialStateCache");
        stopwatch.start("overall");
        HashMap<Long, HashMap<Long, HashMap>> retMap = new HashMap<Long, HashMap<Long, HashMap>>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getInitialStateCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialStateCacheSql(since, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                stopwatch.start("building DTO");
                while (resultSet.next()) {
                    HashMap<Object, Object> stateMap;
                    long beginTime = resultSet.getLong("BEGIN_TIME");
                    HashMap valueMap = this.generateStateMap(beginTime, resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    long stateUnitId = resultSet.getLong("UNIT_ID");
                    long stateModelId = resultSet.getLong("STATE_MODEL_ID");
                    if (!retMap.containsKey(stateUnitId)) {
                        stateMap = new HashMap<Long, HashMap>();
                        stateMap.put(stateModelId, valueMap);
                        retMap.put(stateUnitId, stateMap);
                    } else {
                        stateMap = retMap.get(stateUnitId);
                        if (!stateMap.containsKey(stateModelId)) {
                            stateMap.put(stateModelId, valueMap);
                            retMap.put(stateUnitId, stateMap);
                        }
                    }
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateInitialStateCacheSql(long since, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME,", " sh.BEGIN_RECEIVE_TIME, sh.REMARK ", "FROM current_state_cache sh ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE sh.BEGIN_TIME <= ", String.valueOf(since));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND sh.UNIT_ID IN (", unitPermissionsAsString, ")");
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql);
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getStateCache(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getStateCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getStateCache");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.size() == 0) {
            log.warn((Object)"getStateCache(): No permissions, break.");
            stopwatch.stop("overall", true);
            return retMap;
        }
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateStateCacheSql(since, until, unitPermissions);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                stopwatch.start("building DTO");
                while (resultSet.next()) {
                    long beginTime = resultSet.getLong("BEGIN_TIME");
                    while (completeReplayDataMap.containsKey(beginTime)) {
                        ++beginTime;
                    }
                    HashMap valueMap = this.generateStateMap(beginTime, resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    completeReplayDataMap.put(beginTime, valueMap);
                    retMap.put(beginTime, valueMap);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateStateCacheSql(long since, long until, HashSet<Long> unitPermissions) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, ", "sh.BEGIN_RECEIVE_TIME, sh.REMARK ", "FROM current_state_cache sh ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE sh.BEGIN_TIME > ", String.valueOf(since), " AND sh.BEGIN_TIME <= ", String.valueOf(until));
        String unitPermissionsAsString = ReplayFastLaneReader.getUnitIdString(unitPermissions);
        String unitPermissionsSql = ReplayFastLaneReader.appendStrings(" AND sh.UNIT_ID IN (", String.valueOf(unitPermissionsAsString), ")");
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, unitPermissionsSql);
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getStateHistory(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getStateHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getStateHistory");
        stopwatch.start("overall");
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateStateHistorySql(since, until);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                int dataSize = 0;
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                stopwatch.start("building DTO");
                while (resultSet.next()) {
                    long beginTime = resultSet.getLong("BEGIN_TIME");
                    while (completeReplayDataMap.containsKey(beginTime)) {
                        ++beginTime;
                    }
                    HashMap valueMap = this.generateStateMap(beginTime, resultSet);
                    if (valueMap == null) continue;
                    valueMap.put("ServerTime", beginTime);
                    completeReplayDataMap.put(beginTime, valueMap);
                    retMap.put(beginTime, valueMap);
                    ++dataSize;
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateStateHistorySql(long since, long until) {
        String sql_opt1 = "";
        String sql_opt2 = "";
        switch (this.databaseType) {
            case Oracle: {
                sql_opt1 = "/*+ index(sh sh_bstamp_estamp) */ ";
                break;
            }
            case MSSQL: {
                sql_opt2 = "with (Index (state_history_idx_beginstamp_endstamp)) ";
            }
        }
        String sql = ReplayFastLaneReader.appendStrings("SELECT " + sql_opt1, "sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, sh.REMARK ", "FROM state_history_helper shh ", sql_opt2);
        String leftJoin = "LEFT JOIN state_history sh ON shh.STATE_HISTORY_ID = sh.STATE_HISTORY_ID ";
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE shh.DAY_STAMP <= ", String.valueOf(Math.round(Math.ceil(until / 86400000L))), " AND shh.DAY_STAMP >= ", String.valueOf(Math.round(Math.floor(since / 86400000L))), " AND sh.BEGIN_TIME < ", String.valueOf(until), " AND sh.END_TIME > ", String.valueOf(since));
        String orderByBeginTime = " ORDER BY sh.BEGIN_TIME ASC";
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, orderByBeginTime);
        return sql.toLowerCase();
    }

    private void generateAndAddFisFlightMap(long time, String timeType, ResultSet resultSet, TreeMap<Long, HashMap> retMap, TreeMap<Long, HashMap> completeReplayDataMap) throws SQLException {
        if (time == 0L) {
            return;
        }
        while (completeReplayDataMap.containsKey(time)) {
            ++time;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        long std = resultSet.getLong("STD");
        long etd = resultSet.getLong("ETD");
        long sta = resultSet.getLong("STA");
        long eta = resultSet.getLong("ETA");
        String flightNumberSemantics = resultSet.getString("FLIGHT_NUMBER_SEMANTICS");
        String flightStatus = resultSet.getString("FLIGHT_STATUS");
        String parkingStand = resultSet.getString("PARKING_STAND");
        String flightNature = resultSet.getString("FLIGHT_NATURE");
        String origin = resultSet.getString("ORIGIN_3_LETTER_CODE");
        String registration = resultSet.getString("REGISTRATION");
        String destination = resultSet.getString("DESTINATION_3_LETTER_CODE");
        String aircraftModelType = resultSet.getString("AIRCRAFT_TYPE_5_LETTER_CODE");
        if (aircraftModelType == null || aircraftModelType.trim().length() == 0) {
            aircraftModelType = resultSet.getString("AIRCRAFT_TYPE_3_LETTER_CODE");
        }
        if (parkingStand != null && parkingStand.trim().length() != 0) {
            valueMap.put("fstd", "Stand_" + parkingStand);
        } else {
            valueMap.put("fstd", "");
        }
        String arrivalDeparture = "D";
        if (timeType.equals("st") || timeType.equals("onbl") || timeType.equals("sta") || timeType.equals("eta")) {
            arrivalDeparture = "A";
        }
        valueMap.put("FlightEventType", "FlightUpdate");
        valueMap.put("adflag", arrivalDeparture);
        valueMap.put("sta", sta);
        valueMap.put("eta", eta);
        valueMap.put("AircraftType", aircraftModelType);
        valueMap.put("category", flightNature);
        valueMap.put("origin", origin);
        valueMap.put("FlightTypeArrival", flightStatus);
        valueMap.put("reg", registration);
        valueMap.put("std", std);
        valueMap.put("etd", etd);
        valueMap.put("destination", destination);
        valueMap.put("FlightTypeDeparture", flightStatus);
        valueMap.put("ServerTime", time);
        if (etd != 0L) {
            valueMap.put("et", etd);
        } else if (std != 0L) {
            valueMap.put("et", std);
        }
        if (eta != 0L) {
            valueMap.put("st", eta);
        } else if (sta != 0L) {
            valueMap.put("st", sta);
        }
        if (arrivalDeparture.equals("A")) {
            String arrivalUAFT = resultSet.getString("ARRIVAL_UAFT");
            valueMap.put("oid", arrivalUAFT);
            valueMap.put("arrivalUAFT", arrivalUAFT);
            valueMap.put("afid", flightNumberSemantics);
        } else if (arrivalDeparture.equals("D")) {
            String departureUAFT = resultSet.getString("DEPARTURE_UAFT");
            String rotationKey = resultSet.getString("ROTATION_KEY");
            valueMap.put("oid", departureUAFT);
            valueMap.put("departureUAFT", departureUAFT);
            valueMap.put("dfid", flightNumberSemantics);
            valueMap.put("departureRKEY", rotationKey);
        }
        if (timeType.equals("st")) {
            valueMap.put("StandAllocationStatus", "Empty");
        } else if (timeType.equals("et")) {
            valueMap.put("StandAllocationStatus", "Empty");
        } else if (timeType.equals("onbl")) {
            valueMap.put("onbl", time);
            valueMap.put("st", time);
            valueMap.put("DataType", "data_type_SingleStandEvent");
            valueMap.put("StandAllocationStatus", "Taken");
        } else if (timeType.equals("ofbl")) {
            valueMap.put("ofbl", time);
            valueMap.put("et", time);
            valueMap.put("DataType", "data_type_SingleStandEvent");
            valueMap.put("StandAllocationStatus", "Empty");
        } else {
            valueMap.put("DataType", "data_type_SingleStandEvent");
        }
        completeReplayDataMap.put(time, valueMap);
        retMap.put(time, valueMap);
    }

    public TreeMap<Long, HashMap> getFisFlightCache(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisFlightCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisFlightCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisFlightCacheSql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long startTime = resultSet.getLong("START_TIME");
                        long onBlock = resultSet.getLong("ONBL");
                        long endTime = resultSet.getLong("END_TIME");
                        long offBlock = resultSet.getLong("OFBL");
                        this.generateAndAddFisFlightMap(startTime, "st", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(onBlock, "onbl", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(endTime, "et", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(offBlock, "ofbl", resultSet, retMap, completeReplayDataMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisFlightCacheSql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT ARRIVAL_UAFT, DEPARTURE_UAFT, f.FLIGHT_NUMBER_SEMANTICS, ", "f.ROTATION_KEY, f.REGISTRATION, f.DESTINATION_3_LETTER_CODE, f.ORIGIN_3_LETTER_CODE, ", "f.FLIGHT_STATUS, f.FLIGHT_NATURE, f.AIRCRAFT_TYPE_3_LETTER_CODE, f.AIRCRAFT_TYPE_5_LETTER_CODE, ", "f.PARKING_STAND, f.STA, f.STD, f.ETA, f.ETD, f.ONBL, f.OFBL, f.START_TIME, f.END_TIME ", "FROM ffcvv_view f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE (f.START_TIME != 0 AND f.END_TIME != 0) AND ", "f.START_TIME < ", String.valueOf(until), " AND f.END_TIME > ", String.valueOf(since));
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getFisFlightHistory(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisFlightHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisFlightHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisFlightHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long startTime = resultSet.getLong("START_TIME");
                        long onBlock = resultSet.getLong("ONBL");
                        long endTime = resultSet.getLong("END_TIME");
                        long offBlock = resultSet.getLong("OFBL");
                        this.generateAndAddFisFlightMap(startTime, "st", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(onBlock, "onbl", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(endTime, "et", resultSet, retMap, completeReplayDataMap);
                        this.generateAndAddFisFlightMap(offBlock, "ofbl", resultSet, retMap, completeReplayDataMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisFlightHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT ARRIVAL_UAFT, DEPARTURE_UAFT, f.FLIGHT_NUMBER_SEMANTICS, ", "f.ROTATION_KEY, f.REGISTRATION, f.DESTINATION_3_LETTER_CODE, f.ORIGIN_3_LETTER_CODE, ", "f.FLIGHT_STATUS, f.FLIGHT_NATURE, f.AIRCRAFT_TYPE_3_LETTER_CODE, f.AIRCRAFT_TYPE_5_LETTER_CODE, ", "f.PARKING_STAND, f.STA, f.STD, f.ETA, f.ETD, f.ONBL, f.OFBL, f.START_TIME, f.END_TIME ", "FROM ffhvv_view f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings("WHERE (f.START_TIME != 0 AND f.END_TIME != 0) AND ", "f.START_TIME < ", String.valueOf(until), " AND f.END_TIME > ", String.valueOf(since));
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getFisGseCache(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisGseCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisGseCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisGseCacheSql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        while (completeReplayDataMap.containsKey(costumerCreateTime)) {
                            ++costumerCreateTime;
                        }
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String costumerGseCode = resultSet.getString("CUSTOMER_GSE_CODE");
                        String gseModelType = resultSet.getString("MODEL_TYPE");
                        String registrationNumber = resultSet.getString("REGISTRATION_NUMBER");
                        String userNameCache = resultSet.getString("USERNAME_CACHE");
                        String userNameHistory = resultSet.getString("USERNAME_HISTORY");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglGSEAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        valueMap.put("GSEAllocationGSEID", costumerGseCode);
                        if (gseModelType != null && gseModelType.length() != 0) {
                            valueMap.put("GSEAllocationGSEType", gseModelType);
                        }
                        if (registrationNumber != null && registrationNumber.length() != 0) {
                            valueMap.put("GSEAllocationRegistrationNumber", registrationNumber);
                        }
                        if (userNameCache != null && userNameCache.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameCache);
                        } else if (userNameHistory != null && userNameHistory.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameHistory);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        completeReplayDataMap.put(costumerCreateTime, valueMap);
                        retMap.put(costumerCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisGseCacheSql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.CUSTOMER_GSE_CODE, ", "f.CUSTOMER_CREATE_TIME, um.MODEL_TYPE, um.REGISTRATION_NUMBER, ", "us.NAME AS USERNAME_CACHE, uss.NAME AS USERNAME_HISTORY ", "FROM fis_gse_cache f ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN unit_identity ui ON f.CUSTOMER_GSE_CODE = ui.NAME ", "LEFT JOIN unit_model um ON um.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN use_cache uc ON uc.UNIT_ID = ui.UNIT_ID AND uc.BEGIN_TIME <= f.CUSTOMER_CREATE_TIME ", "LEFT JOIN use_history uh ON uh.UNIT_ID = ui.UNIT_ID AND f.CUSTOMER_CREATE_TIME BETWEEN uh.BEGIN_TIME AND uh.END_TIME ", "LEFT JOIN use_user us ON us.ID = uc.USER_ID ", "LEFT JOIN use_user uss ON uss.ID = uh.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME > ", String.valueOf(since), " AND f.CUSTOMER_CREATE_TIME <= ", String.valueOf(until));
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getFisGseHistory(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisGseHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisGseHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisGseHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        while (completeReplayDataMap.containsKey(costumerCreateTime)) {
                            ++costumerCreateTime;
                        }
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String costumerGseCode = resultSet.getString("CUSTOMER_GSE_CODE");
                        String gseModelType = resultSet.getString("MODEL_TYPE");
                        String registrationNumber = resultSet.getString("REGISTRATION_NUMBER");
                        String userNameCache = resultSet.getString("USERNAME_CACHE");
                        String userNameHistory = resultSet.getString("USERNAME_HISTORY");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglGSEAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        valueMap.put("GSEAllocationGSEID", costumerGseCode);
                        if (gseModelType != null && gseModelType.length() != 0) {
                            valueMap.put("GSEAllocationGSEType", gseModelType);
                        }
                        if (registrationNumber != null && registrationNumber.length() != 0) {
                            valueMap.put("GSEAllocationRegistrationNumber", registrationNumber);
                        }
                        if (userNameCache != null && userNameCache.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameCache);
                        } else if (userNameHistory != null && userNameHistory.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameHistory);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        completeReplayDataMap.put(costumerCreateTime, valueMap);
                        retMap.put(costumerCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisGseHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.CUSTOMER_GSE_CODE, ", "f.CUSTOMER_CREATE_TIME, um.MODEL_TYPE, um.REGISTRATION_NUMBER, ", "us.NAME AS USERNAME_CACHE, uss.NAME AS USERNAME_HISTORY ", "FROM fis_gse_history f ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN unit_identity ui ON f.CUSTOMER_GSE_CODE = ui.NAME ", "LEFT JOIN unit_model um ON um.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN use_cache uc ON uc.UNIT_ID = ui.UNIT_ID AND uc.BEGIN_TIME <= f.CUSTOMER_CREATE_TIME ", "LEFT JOIN use_history uh ON uh.UNIT_ID = ui.UNIT_ID AND f.CUSTOMER_CREATE_TIME BETWEEN uh.BEGIN_TIME AND uh.END_TIME ", "LEFT JOIN use_user us ON us.ID = uc.USER_ID ", "LEFT JOIN use_user uss ON uss.ID = uh.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME > ", String.valueOf(since), " AND f.CUSTOMER_CREATE_TIME <= ", String.valueOf(until));
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getFisStaffCache(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisStaffCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisStaffCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisStaffCacheSql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        while (completeReplayDataMap.containsKey(costumerCreateTime)) {
                            ++costumerCreateTime;
                        }
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String personalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String firstName = resultSet.getString("FIRST_NAME");
                        String lastName = resultSet.getString("LAST_NAME");
                        String shortName = resultSet.getString("SHORT_NAME");
                        String teamId = resultSet.getString("TEAM_ID");
                        String staffFunctionCode = resultSet.getString("STAFF_FUNCTION_CODE");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglStaffAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        if (personalNumber != null) {
                            valueMap.put("StaffAllocationPersonalNumber", personalNumber);
                        }
                        if (firstName != null && firstName.length() != 0 && lastName != null && lastName.length() != 0) {
                            valueMap.put("StaffAllocationName", firstName + " " + lastName);
                        } else if (shortName != null) {
                            valueMap.put("StaffAllocationName", shortName);
                        }
                        if (teamId != null) {
                            valueMap.put("StaffAllocationTeamID", teamId);
                        }
                        if (staffFunctionCode != null) {
                            valueMap.put("StaffAllocationFuntionCode", staffFunctionCode);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        completeReplayDataMap.put(costumerCreateTime, valueMap);
                        retMap.put(costumerCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisStaffCacheSql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.PERSONAL_NUMBER, ", "f.CUSTOMER_CREATE_TIME, f.FIRST_NAME, f.LAST_NAME, ", "f.SHORT_NAME, f.TEAM_ID, f.STAFF_FUNCTION_CODE ", "FROM fis_staff_cache f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME > ", String.valueOf(since), " AND f.CUSTOMER_CREATE_TIME <= ", String.valueOf(until));
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public TreeMap<Long, HashMap> getFisStaffHistory(TreeMap<Long, HashMap> completeReplayDataMap, long since, long until) {
        log.debug((Object)"getFisStaffHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisStaffHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateFisStaffHistorySql(since, until, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        while (completeReplayDataMap.containsKey(costumerCreateTime)) {
                            ++costumerCreateTime;
                        }
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String personalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String firstName = resultSet.getString("FIRST_NAME");
                        String lastName = resultSet.getString("LAST_NAME");
                        String shortName = resultSet.getString("SHORT_NAME");
                        String teamId = resultSet.getString("TEAM_ID");
                        String staffFunctionCode = resultSet.getString("STAFF_FUNCTION_CODE");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglStaffAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        if (personalNumber != null) {
                            valueMap.put("StaffAllocationPersonalNumber", personalNumber);
                        }
                        if (firstName != null && firstName.length() != 0 && lastName != null && lastName.length() != 0) {
                            valueMap.put("StaffAllocationName", firstName + " " + lastName);
                        } else if (shortName != null) {
                            valueMap.put("StaffAllocationName", shortName);
                        }
                        if (teamId != null) {
                            valueMap.put("StaffAllocationTeamID", teamId);
                        }
                        if (staffFunctionCode != null) {
                            valueMap.put("StaffAllocationFuntionCode", staffFunctionCode);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        completeReplayDataMap.put(costumerCreateTime, valueMap);
                        retMap.put(costumerCreateTime, valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, retMap.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return retMap;
    }

    private String generateFisStaffHistorySql(long since, long until, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.PERSONAL_NUMBER, ", "f.CUSTOMER_CREATE_TIME, f.FIRST_NAME, f.LAST_NAME, ", "f.SHORT_NAME, f.TEAM_ID, f.STAFF_FUNCTION_CODE ", "FROM fis_staff_history f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME > ", String.valueOf(since), " AND f.CUSTOMER_CREATE_TIME <= ", String.valueOf(until));
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public List<HashMap> getInitialFisGseCache(Set<String> flightIds, long since) {
        log.debug((Object)"getInitialFisGseCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialFisGseCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        if (flightIds == null || flightIds.size() == 0) {
            return ret;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialFisGseCacheSql(flightIds, since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String costumerGseCode = resultSet.getString("CUSTOMER_GSE_CODE");
                        String gseModelType = resultSet.getString("MODEL_TYPE");
                        String registrationNumber = resultSet.getString("REGISTRATION_NUMBER");
                        String userNameCache = resultSet.getString("USERNAME_CACHE");
                        String userNameHistory = resultSet.getString("USERNAME_HISTORY");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglGSEAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        valueMap.put("GSEAllocationGSEID", costumerGseCode);
                        if (gseModelType != null && gseModelType.length() != 0) {
                            valueMap.put("GSEAllocationGSEType", gseModelType);
                        }
                        if (registrationNumber != null && registrationNumber.length() != 0) {
                            valueMap.put("GSEAllocationRegistrationNumber", registrationNumber);
                        }
                        if (userNameCache != null && userNameCache.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameCache);
                        } else if (userNameHistory != null && userNameHistory.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameHistory);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        ret.add(valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, ret.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return ret;
    }

    private String generateInitialFisGseCacheSql(Set<String> flightIds, long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.CUSTOMER_GSE_CODE, ", "f.CUSTOMER_CREATE_TIME, um.MODEL_TYPE, um.REGISTRATION_NUMBER, ", "us.NAME AS USERNAME_CACHE, uss.NAME AS USERNAME_HISTORY ", "FROM fis_gse_cache f ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN unit_identity ui ON f.CUSTOMER_GSE_CODE = ui.NAME ", "LEFT JOIN unit_model um ON um.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN use_cache uc ON uc.UNIT_ID = ui.UNIT_ID AND uc.BEGIN_TIME <= f.CUSTOMER_CREATE_TIME ", "LEFT JOIN use_history uh ON uh.UNIT_ID = ui.UNIT_ID AND f.CUSTOMER_CREATE_TIME BETWEEN uh.BEGIN_TIME AND uh.END_TIME ", "LEFT JOIN use_user us ON us.ID = uc.USER_ID ", "LEFT JOIN use_user uss ON uss.ID = uh.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME <= ", String.valueOf(since));
        String flightsSql = "";
        String flightsAsString = ReplayFastLaneReader.getFlightIdString(flightIds);
        if (flightsAsString != null && flightsAsString.trim().length() != 0) {
            flightsSql = ReplayFastLaneReader.appendStrings(" AND f.UNIQUE_FLIGHT_NUMBER IN (", flightsAsString, ")");
        }
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, flightsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public List<HashMap> getInitialFisGseHistory(Set<String> flightIds, long since) {
        log.debug((Object)"getInitialFisGseHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialFisGseHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        if (flightIds == null || flightIds.size() == 0) {
            return ret;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialFisGseHistorySql(flightIds, since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String costumerGseCode = resultSet.getString("CUSTOMER_GSE_CODE");
                        String gseModelType = resultSet.getString("MODEL_TYPE");
                        String registrationNumber = resultSet.getString("REGISTRATION_NUMBER");
                        String userNameCache = resultSet.getString("USERNAME_CACHE");
                        String userNameHistory = resultSet.getString("USERNAME_HISTORY");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglGSEAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        valueMap.put("GSEAllocationGSEID", costumerGseCode);
                        if (gseModelType != null && gseModelType.length() != 0) {
                            valueMap.put("GSEAllocationGSEType", gseModelType);
                        }
                        if (registrationNumber != null && registrationNumber.length() != 0) {
                            valueMap.put("GSEAllocationRegistrationNumber", registrationNumber);
                        }
                        if (userNameCache != null && userNameCache.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameCache);
                        } else if (userNameHistory != null && userNameHistory.length() != 0) {
                            valueMap.put("GSEAllocationDriverName", userNameHistory);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        ret.add(valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, ret.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return ret;
    }

    private String generateInitialFisGseHistorySql(Set<String> flightIds, long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.CUSTOMER_GSE_CODE, ", "f.CUSTOMER_CREATE_TIME, um.MODEL_TYPE, um.REGISTRATION_NUMBER, ", "us.NAME AS USERNAME_CACHE, uss.NAME AS USERNAME_HISTORY ", "FROM fis_gse_history f ");
        String leftJoin = ReplayFastLaneReader.appendStrings("LEFT JOIN unit_identity ui ON f.CUSTOMER_GSE_CODE = ui.NAME ", "LEFT JOIN unit_model um ON um.UNIT_ID = ui.UNIT_ID ", "LEFT JOIN use_cache uc ON uc.UNIT_ID = ui.UNIT_ID AND uc.BEGIN_TIME <= f.CUSTOMER_CREATE_TIME ", "LEFT JOIN use_history uh ON uh.UNIT_ID = ui.UNIT_ID AND f.CUSTOMER_CREATE_TIME BETWEEN uh.BEGIN_TIME AND uh.END_TIME ", "LEFT JOIN use_user us ON us.ID = uc.USER_ID ", "LEFT JOIN use_user uss ON uss.ID = uh.USER_ID");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME <= ", String.valueOf(since));
        String flightsSql = "";
        String flightsAsString = ReplayFastLaneReader.getFlightIdString(flightIds);
        if (flightsAsString != null && flightsAsString.trim().length() != 0) {
            flightsSql = ReplayFastLaneReader.appendStrings(" AND f.UNIQUE_FLIGHT_NUMBER IN (", flightsAsString, ")");
        }
        sql = ReplayFastLaneReader.appendStrings(sql, leftJoin, sqlWhereClause, flightsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public List<HashMap> getInitialFisStaffCache(Set<String> flightIds, long since) {
        log.debug((Object)"getFisStaffCache called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getFisStaffCache");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        if (flightIds == null || flightIds.size() == 0) {
            return ret;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialFisStaffCacheSql(flightIds, since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String personalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String firstName = resultSet.getString("FIRST_NAME");
                        String lastName = resultSet.getString("LAST_NAME");
                        String shortName = resultSet.getString("SHORT_NAME");
                        String teamId = resultSet.getString("TEAM_ID");
                        String staffFunctionCode = resultSet.getString("STAFF_FUNCTION_CODE");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglStaffAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        if (personalNumber != null) {
                            valueMap.put("StaffAllocationPersonalNumber", personalNumber);
                        }
                        if (firstName != null && firstName.length() != 0 && lastName != null && lastName.length() != 0) {
                            valueMap.put("StaffAllocationName", firstName + " " + lastName);
                        } else if (shortName != null) {
                            valueMap.put("StaffAllocationName", shortName);
                        }
                        if (teamId != null) {
                            valueMap.put("StaffAllocationTeamID", teamId);
                        }
                        if (staffFunctionCode != null) {
                            valueMap.put("StaffAllocationFuntionCode", staffFunctionCode);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        ret.add(valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, ret.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return ret;
    }

    private String generateInitialFisStaffCacheSql(Set<String> flightIds, long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.PERSONAL_NUMBER, ", "f.CUSTOMER_CREATE_TIME, f.FIRST_NAME, f.LAST_NAME, ", "f.SHORT_NAME, f.TEAM_ID, f.STAFF_FUNCTION_CODE ", "FROM fis_staff_cache f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME <= ", String.valueOf(since));
        String flightsSql = "";
        String flightsAsString = ReplayFastLaneReader.getFlightIdString(flightIds);
        if (flightsAsString != null && flightsAsString.trim().length() != 0) {
            flightsSql = ReplayFastLaneReader.appendStrings(" AND f.UNIQUE_FLIGHT_NUMBER IN (", flightsAsString, ")");
        }
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, flightsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }

    public List<HashMap> getInitialFisStaffHistory(Set<String> flightIds, long since) {
        log.debug((Object)"getInitialFisStaffHistory called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getInitialFisStaffHistory");
        stopwatch.start("overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        ArrayList<HashMap> ret = new ArrayList<HashMap>();
        if (flightIds == null || flightIds.size() == 0) {
            return ret;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = this.generateInitialFisStaffHistorySql(flightIds, since, maxRowsLimit);
                log.debug((Object)("Executed SQL: " + sql));
                stopwatch.start("dataBase access");
                Statement statement = connection.createStatement(1005, 1007);
                if (this.databaseType.equals((Object)FastLaneBase.DatabaseType.Oracle)) {
                    statement.setFetchSize(maxRowsLimit);
                }
                ResultSet resultSet = statement.executeQuery(sql);
                int size = ReplayFastLaneReader.rowCount(resultSet);
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    log.debug((Object)"building Maps...");
                    stopwatch.start("building DTO");
                    while (resultSet.next()) {
                        long costumerCreateTime = resultSet.getLong("CUSTOMER_CREATE_TIME");
                        String uniqueFlightNumber = resultSet.getString("UNIQUE_FLIGHT_NUMBER");
                        String personalNumber = resultSet.getString("PERSONAL_NUMBER");
                        String firstName = resultSet.getString("FIRST_NAME");
                        String lastName = resultSet.getString("LAST_NAME");
                        String shortName = resultSet.getString("SHORT_NAME");
                        String teamId = resultSet.getString("TEAM_ID");
                        String staffFunctionCode = resultSet.getString("STAFF_FUNCTION_CODE");
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("DataType", "data_type_SinglStaffAllocationEventUPDATE");
                        valueMap.put("oid", uniqueFlightNumber);
                        if (personalNumber != null) {
                            valueMap.put("StaffAllocationPersonalNumber", personalNumber);
                        }
                        if (firstName != null && firstName.length() != 0 && lastName != null && lastName.length() != 0) {
                            valueMap.put("StaffAllocationName", firstName + " " + lastName);
                        } else if (shortName != null) {
                            valueMap.put("StaffAllocationName", shortName);
                        }
                        if (teamId != null) {
                            valueMap.put("StaffAllocationTeamID", teamId);
                        }
                        if (staffFunctionCode != null) {
                            valueMap.put("StaffAllocationFuntionCode", staffFunctionCode);
                        }
                        valueMap.put("ServerTime", costumerCreateTime);
                        ret.add(valueMap);
                    }
                    statement.close();
                    resultSet.close();
                    connection.close();
                    resultSet = null;
                    stopwatch.stop("building DTO", true, ret.size());
                } else {
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return ret;
    }

    private String generateInitialFisStaffHistorySql(Set<String> flightIds, long since, int maxRowsLimit) {
        String sql = ReplayFastLaneReader.appendStrings("SELECT f.UNIQUE_FLIGHT_NUMBER, f.PERSONAL_NUMBER, ", "f.CUSTOMER_CREATE_TIME, f.FIRST_NAME, f.LAST_NAME, ", "f.SHORT_NAME, f.TEAM_ID, f.STAFF_FUNCTION_CODE ", "FROM fis_staff_history f ");
        String sqlWhereClause = ReplayFastLaneReader.appendStrings(" WHERE f.CUSTOMER_CREATE_TIME <= ", String.valueOf(since));
        String flightsSql = "";
        String flightsAsString = ReplayFastLaneReader.getFlightIdString(flightIds);
        if (flightsAsString != null && flightsAsString.trim().length() != 0) {
            flightsSql = ReplayFastLaneReader.appendStrings(" AND f.UNIQUE_FLIGHT_NUMBER IN (", flightsAsString, ")");
        }
        sql = ReplayFastLaneReader.appendStrings(sql, sqlWhereClause, flightsSql);
        if (maxRowsLimit != 0) {
            String limitRowsSQL = "";
            String maxRowsLimitStr = String.valueOf(maxRowsLimit);
            switch (this.databaseType) {
                case MySQL: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" LIMIT ", maxRowsLimitStr);
                    break;
                }
                case Oracle: {
                    limitRowsSQL = ReplayFastLaneReader.appendStrings(" AND ROWNUM <= ", maxRowsLimitStr);
                }
            }
            sql = ReplayFastLaneReader.appendStrings(sql, limitRowsSQL);
        }
        return sql.toLowerCase();
    }
}

