/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.web.data.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDataFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(MasterDataFastLaneReader.class);

    public List<RoleValue> getAllRolesForUser(String userName) {
        log.debug((Object)"getAllRolesForUserFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getAllRolesForUserFastLaneRead");
        stopwatch.start("overall");
        ArrayList<RoleValue> roleSummary = new ArrayList<RoleValue>();
        try {
            String sqlUsername = MasterDataFastLaneReader.appendStrings("'", userName, "'");
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                String sql = MasterDataFastLaneReader.generateAllRolesForUserSql(sqlUsername);
                log.debug((Object)("Executed SQL: " + sql));
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(sql);
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                while (resultSet.next()) {
                    RoleValue value = new RoleValue();
                    value.setRolename(resultSet.getString("ROLE_NAME"));
                    roleSummary.add(value);
                }
                statement.close();
                resultSet.close();
                connection.close();
                resultSet = null;
                stopwatch.stop("building DTO", true, roleSummary.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return roleSummary;
    }

    private static String generateAllRolesForUserSql(String username) {
        String sql = MasterDataFastLaneReader.appendStrings("SELECT r.ROLE_NAME FROM role r WHERE r.id IN (SELECT id_role FROM account_x_role WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")) OR r.id IN (SELECT id_role FROM groupident_x_role WHERE id_groupident IN (SELECT id_groupident FROM account_x_groupident WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, "))) OR r.id IN (SELECT id_sectionrole FROM role_x_role WHERE id_role IN (SELECT id_role FROM groupident_x_role WHERE id_groupident IN (SELECT id_groupident FROM account_x_groupident WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")))) OR r.id IN (SELECT id_sectionrole FROM role_x_role WHERE id_role IN (SELECT id_role FROM account_x_role WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")))");
        sql = sql.toLowerCase();
        return sql;
    }
}

