/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastLaneBase {
    private static final Log log = LogFactory.getLog(FastLaneBase.class);
    protected DataSource dataSource;
    protected DatabaseType databaseType;

    public FastLaneBase() {
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup("java:/wwt");
            DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
            String dataBaseProductName = metaData.getDatabaseProductName();
            log.debug((Object)("DatabaseProductName: " + dataBaseProductName));
            dataBaseProductName = dataBaseProductName.toLowerCase();
            this.databaseType = dataBaseProductName.contains("mysql") ? DatabaseType.MySQL : (dataBaseProductName.contains("oracle") ? DatabaseType.Oracle : (dataBaseProductName.contains("microsoft sql server") ? DatabaseType.MSSQL : DatabaseType.Unknown));
            log.debug((Object)("Database SQL Dialect: " + this.databaseType.name()));
        }
        catch (NamingException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    protected static final String appendStrings(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != strings.length; ++i) {
            if (strings[i] == null) continue;
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DatabaseType {
        MySQL,
        Oracle,
        MSSQL,
        Unknown;

    }
}

