/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTOList;
import de.proveo.wwt.logic.web.currentData.dto.GseAvailabilityDTO;
import de.proveo.wwt.logic.web.currentData.dto.GseAvailabilityDTOList;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTOList;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTOList;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTOList;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.historyData.dto.UseDTOList;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CurrentDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(CurrentDataFacadeBean.class);
    private static final String CONFIG_PARAM_NAME_TIMEOUT = "infoman.keepalive.timeout";
    private static final int DEFAULT_KEEPALIVE_TIMEOUT = 10800000;
    private UnitModelLocalHome unitModelHome;
    private ConfigurationLocalHome configurationHome;
    private CurrentStateCacheLocalHome currentStateCacheHome;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private UseCacheLocalHome useCacheLocalHome;
    private KeepAliveCacheLocalHome keepAliveCacheLocalHome;
    private CurrentGdataCacheLocalHome currentGdataCacheLocalHome;
    private CurrentNotifyCacheLocalHome currentNotifyCacheLocalHome;
    private FisFlightCacheLocalHome fisFlightCacheLocalHome;
    private FisGseCacheLocalHome fisGseCacheLocalHome;
    private AreaLocalHome areaHome;
    private long timeout;

    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.configurationHome = ConfigurationUtil.getLocalHome();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
            this.useCacheLocalHome = UseCacheUtil.getLocalHome();
            this.keepAliveCacheLocalHome = KeepAliveCacheUtil.getLocalHome();
            this.currentGdataCacheLocalHome = CurrentGdataCacheUtil.getLocalHome();
            this.currentNotifyCacheLocalHome = CurrentNotifyCacheUtil.getLocalHome();
            this.fisFlightCacheLocalHome = FisFlightCacheUtil.getLocalHome();
            this.fisGseCacheLocalHome = FisGseCacheUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            ConfigurationLocal configuration = this.configurationHome.create();
            String timeOutStr = configuration.getParameter(CONFIG_PARAM_NAME_TIMEOUT);
            this.timeout = Long.parseLong(timeOutStr);
            this.timeout *= 60000L;
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"configuration parameter 'infoman.keepalive.timeout' not found. User default.", (Throwable)e);
            this.timeout = 10800000L;
        }
        catch (NumberFormatException e) {
            log.error((Object)"wrong value for 'infoman.keepalive.timeout'. Runs into", (Throwable)e);
            this.timeout = 10800000L;
        }
        catch (CreateException e) {
            log.error((Object)"creating failed", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"naming exception", (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    public StateDTOList getCurrentStateData(Long unitID, long stateModelId, Long stateFilterId, boolean useGroupHistory) {
        Stopwatch stopwatch = new Stopwatch(CurrentDataFacadeBean.class, "getCurrentStateData");
        stopwatch.start("overallDuration");
        StateDTOList list = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentStateData called with unitId=" + unitID + " stateModelId=" + stateModelId + " stateFilterId=" + stateFilterId));
        }
        try {
            UnitModelLocal unitModel = null;
            UnitModelValue unitModelValue = null;
            CurrentStateCacheLocal cacheLocal2 = null;
            Collection<CurrentStateCacheLocal> coll = new ArrayList();
            stopwatch.start("dataBase access");
            if (unitID == null) {
                coll = this.currentStateCacheHome.findAllByStateModelId(stateModelId);
            } else {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitID));
                unitModelValue = unitModel.getUnitModelValue();
                if (!unitModelValue.getBasic()) {
                    if (useGroupHistory) {
                        coll = this.currentStateCacheHome.findByUnitGroupIdStateModelId(unitID, stateModelId);
                    } else {
                        UnitDTOListBase<UnitModelLocal> basicUnits = UnitListFactory.generateUnitModelList(unitID);
                        for (UnitModelLocal model : basicUnits) {
                            Collection cacheValues = this.currentStateCacheHome.findByUnitModelIdStateModelId(model.getUnitId(), stateModelId);
                            for (CurrentStateCacheLocal cacheLocal2 : cacheValues) {
                                if (cacheLocal2 == null) continue;
                                coll.add(cacheLocal2);
                            }
                        }
                    }
                } else {
                    coll = this.currentStateCacheHome.findByUnitModelIdStateModelId(unitID, stateModelId);
                }
            }
            stopwatch.stop("dataBase access", false, coll.size());
            stopwatch.start("buildDTOList");
            list = DTOListFactory.buildStateDTOList(unitModel, stateModelId, null, null);
            for (CurrentStateCacheLocal cacheLocal2 : coll) {
                UnitModelLocal unitModelLocal;
                CurrentStateCacheValue value = cacheLocal2.getCurrentStateCacheValue();
                if (value.getStateModelId() != stateModelId || stateFilterId != null && value.getState() != stateFilterId.longValue() || (unitModelLocal = cacheLocal2.getUnitModel()) == null || unitModelLocal.getUnitModelValue().getDeleted()) continue;
                list.add(DTOFactory.buildStateDTO(unitModelLocal, value));
            }
            stopwatch.stop("buildDTOList", false);
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding UnitModels failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        stopwatch.stop("overallDuration", false);
        stopwatch.logAll();
        return list;
    }

    public PositionDTOList getCurrentPositionData(Long unitID, boolean useGroupHistory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentPositionData with unitModelId=" + unitID));
        }
        PositionDTOList list = null;
        try {
            UnitModelLocal unitModel = null;
            UnitModelValue unitModelValue = null;
            if (unitID != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitID));
                unitModelValue = unitModel.getUnitModelValue();
            }
            Collection<CurrentGdataCacheLocal> coll = new ArrayList();
            if (unitID == null) {
                coll = this.currentGdataCacheLocalHome.findAll();
            } else if (!unitModelValue.getBasic()) {
                if (useGroupHistory) {
                    coll = this.currentGdataCacheLocalHome.findByUnitGroupId(unitID);
                } else {
                    UnitDTOListBase<UnitModelLocal> basicUnits = UnitListFactory.generateUnitModelList(unitID);
                    for (UnitModelLocal model : basicUnits) {
                        CurrentGdataCacheLocal gdataCache = model.getCurrentGDataCache();
                        if (gdataCache == null) continue;
                        coll.add(gdataCache);
                    }
                }
            } else {
                coll = this.currentGdataCacheLocalHome.findByUnitId(unitID);
            }
            list = DTOListFactory.buildPostionDTOList(unitModel, null, null);
            for (CurrentGdataCacheLocal cacheLocal : coll) {
                UnitModelLocal unitModelLocal;
                if (cacheLocal == null || (unitModelLocal = cacheLocal.getUnitModel()) == null || unitModelLocal.getUnitModelValue().getDeleted()) continue;
                list.add(DTOFactory.buildPositionDTO(unitModelLocal, cacheLocal, 0L, 0L, false));
            }
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public KeepAliveDTOList getCurrentKeepAliveData(Long unitId, boolean useGroupHistory) {
        KeepAliveDTOList list = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCurrentKeepAliveData with unitId: " + unitId));
        }
        UnitModelLocal unitModel = null;
        UnitModelValue unitModelValue = null;
        try {
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                unitModelValue = unitModel.getUnitModelValue();
            }
            Collection<KeepAliveCacheLocal> coll = new ArrayList();
            if (unitId == null) {
                coll = this.keepAliveCacheLocalHome.findAll();
            } else if (!unitModelValue.getBasic()) {
                if (useGroupHistory) {
                    coll = this.keepAliveCacheLocalHome.findByUnitGroupId(unitId);
                } else {
                    UnitDTOListBase<UnitModelLocal> basicUnits = UnitListFactory.generateUnitModelList(unitId);
                    for (UnitModelLocal model : basicUnits) {
                        if (model.getKeepAliveCache() == null) continue;
                        coll.add(model.getKeepAliveCache());
                    }
                }
            } else {
                coll = this.keepAliveCacheLocalHome.findByUnitId(unitId);
            }
            list = DTOListFactory.buildKeepAliveDTOList(unitModel, null, null);
            for (KeepAliveCacheLocal keepAliveCacheLocal : coll) {
                KeepAliveCacheValue keepAliveCacheValue = keepAliveCacheLocal.getKeepAliveCacheValue();
                UnitModelLocal unitModelLocal = keepAliveCacheLocal.getUnitModel();
                if (unitModelLocal == null || unitModelLocal.getUnitModelValue().getDeleted()) continue;
                list.add(DTOFactory.buildKeepAliveDTO(unitModelLocal, keepAliveCacheValue.getCreateTimeStamp(), keepAliveCacheValue.getReceiveTimeStamp(), this.getKeepAliveTimedOut(keepAliveCacheValue)));
            }
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public NotificationDTOList getCurrentNotifications(Long unitId, Long messageIdFilter, boolean useGroupHistory) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getByPosition with unitId: " + unitId));
        }
        NotificationDTOList list = null;
        try {
            UnitModelLocal unitModel = null;
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildNotificationList(unitModel, System.currentTimeMillis(), System.currentTimeMillis());
            Collection coll = new ArrayList();
            if (unitId == null) {
                coll = messageIdFilter == null ? this.currentNotifyCacheLocalHome.findAll() : this.currentNotifyCacheLocalHome.findByMessageId(messageIdFilter);
            } else if (!unitModel.getUnitModelValue().getBasic()) {
                if (useGroupHistory) {
                    coll = messageIdFilter == null ? this.currentNotifyCacheLocalHome.findByUnitGroupId(unitId) : this.currentNotifyCacheLocalHome.findByUnitGroupIdAndMessageId(unitId, messageIdFilter);
                } else {
                    UnitDTOListBase<UnitModelLocal> basicUnits = UnitListFactory.generateUnitModelList(unitId);
                    for (UnitModelLocal model : basicUnits) {
                        Collection cacheValues = messageIdFilter == null ? this.currentNotifyCacheLocalHome.findByUnitId(unitId) : this.currentNotifyCacheLocalHome.findByUnitIdAndMessageId(unitId, messageIdFilter);
                        Iterator it = cacheValues.iterator();
                        while (it.hasNext()) {
                            coll.add(it.next());
                        }
                    }
                }
            } else {
                coll = messageIdFilter == null ? this.currentNotifyCacheLocalHome.findByUnitId(unitId) : this.currentNotifyCacheLocalHome.findByUnitIdAndMessageId(unitId, messageIdFilter);
            }
            if (coll != null) {
                for (CurrentNotifyCacheLocal notifyCacheLocal : coll) {
                    UnitModelLocal unitModelLocal = notifyCacheLocal.getUnitModel();
                    if (unitModelLocal == null || unitModelLocal.getUnitModelValue().getDeleted()) continue;
                    NotificationDTO dto = DTOFactory.buildNotificationDTO(notifyCacheLocal);
                    list.add(dto);
                }
            }
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public UseDTOList getCurrentUse(Long unitId, Long useUserId, boolean useGroupHistory) {
        UseDTOList list = null;
        try {
            UnitModelLocal unitModel = null;
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildUseDTOList(unitModel, System.currentTimeMillis(), System.currentTimeMillis());
            Collection coll = new ArrayList();
            if (unitId == null) {
                coll = useUserId == null ? this.useCacheLocalHome.findAll() : this.useCacheLocalHome.findByUserId(useUserId);
            } else if (!unitModel.getUnitModelValue().getBasic()) {
                if (useGroupHistory) {
                    coll = useUserId == null ? this.useCacheLocalHome.findByUnitGroupId(unitId) : this.useCacheLocalHome.findByUnitGroupIdAndUseUserId(unitId, useUserId);
                } else {
                    UnitDTOListBase<UnitModelLocal> basicUnits = UnitListFactory.generateUnitModelList(unitId);
                    for (UnitModelLocal model : basicUnits) {
                        Collection cacheValues = useUserId == null ? this.useCacheLocalHome.findByUnitId(model.getUnitId()) : this.useCacheLocalHome.findByUnitIdAndUseUserId(model.getUnitId(), useUserId);
                        Iterator it = cacheValues.iterator();
                        while (it.hasNext()) {
                            coll.add(it.next());
                        }
                    }
                }
            } else {
                coll = useUserId == null ? this.useCacheLocalHome.findByUnitId(unitId) : this.useCacheLocalHome.findByUnitIdAndUseUserId(unitId, useUserId);
            }
            if (coll != null) {
                for (UseCacheLocal useCacheLocal : coll) {
                    UnitModelLocal unitModelLocal = useCacheLocal.getUnitModel();
                    if (unitModelLocal == null || unitModelLocal.getUnitModelValue().getDeleted()) continue;
                    UseDTO dto = DTOFactory.buildUseDTO(useCacheLocal);
                    list.add(dto);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)("Unit id (" + unitId + ") or use user id (" + useUserId + ") not found!"));
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public CurrentAllDTOList getAllCurrentData(Long unitID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAllCurrentData with unitModelId=" + unitID));
        }
        CurrentAllDTOList list = null;
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitID);
        UnitTypeIdentityValue unitTypeIdentityValue = null;
        if (unitBasicModels.getUnitModel().getBasic()) {
            unitTypeIdentityValue = unitBasicModels.getUnitTypeIdentityValue();
        }
        CurrentAllDTOList allDTOList = new CurrentAllDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitTypeIdentityValue);
        list = this.createCurrentAllDTOList(allDTOList, unitBasicModels);
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private CurrentAllDTOList createCurrentAllDTOList(CurrentAllDTOList list, Collection<UnitModelLocal> coll) {
        CurrentAllDTO dto = null;
        Map areas = this.getAllAreas();
        if (coll.size() > 0) {
            for (UnitModelLocal unitModel : coll) {
                CurrentGdataCacheLocal gdataCache;
                if (unitModel != null && unitModel.getUnitModelValue().getDeleted()) continue;
                UnitIdentityLocal unitIdentity = unitModel.getUnitIdentity();
                UnitTypeIdentityValue unitTypeIdentityValue = null;
                if (unitModel.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
                dto = new CurrentAllDTO(unitModel.getUnitModelValue(), unitIdentity.getUnitIdentityValue(), unitTypeIdentityValue);
                KeepAliveCacheLocal keepAliveCacheLocal = unitModel.getKeepAliveCache();
                if (unitModel.getKeepAliveCache() != null) {
                    KeepAliveCacheValue kaCacheValue = keepAliveCacheLocal.getKeepAliveCacheValue();
                    dto.setKeepAliveCacheValue(kaCacheValue);
                    dto.setTimedOut(this.getKeepAliveTimedOut(kaCacheValue));
                }
                if ((gdataCache = unitModel.getCurrentGDataCache()) != null) {
                    AreaValue currentArea = (AreaValue)areas.get(gdataCache.getCurrentGdataCacheValue().getAreaId());
                    String areaName = "";
                    if (currentArea != null) {
                        areaName = currentArea.getArea();
                    }
                    dto.setPosition(gdataCache.getCurrentGdataCacheValue(), areaName);
                }
                Collection stateCaches = unitModel.getCurrentStateCaches();
                for (CurrentStateCacheLocal stateCache : stateCaches) {
                    CurrentStateCacheValue stateCacheValue = stateCache.getCurrentStateCacheValue();
                    dto.setState(stateCacheValue);
                }
                list.add(dto);
            }
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private Map getAllAreas() {
        String method = "getAllAreas(): ";
        Collection col = new HashSet();
        try {
            col = this.areaHome.findOrderedByPriority();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Integer, AreaValue> areas = new HashMap<Integer, AreaValue>();
        for (AreaLocal remote : col) {
            AreaValue value = remote.getAreaValue();
            areas.put(value.getAreaId(), value);
        }
        return areas;
    }

    private boolean getKeepAliveTimedOut(KeepAliveCacheValue kaCacheValue) {
        Long currentTime = new Date().getTime();
        Long keepAliveTime = kaCacheValue.getReceiveTimeStamp();
        return currentTime >= keepAliveTime + this.timeout;
    }

    private boolean buildFisGseMaps(Collection<FisGseCacheLocal> gseValues, HashMap<String, ArrayList<String>> flightToGses, HashMap<String, ArrayList<String>> gseToFlights) {
        for (FisGseCacheLocal gse : gseValues) {
            String key = gse.getUniqueFlightNumber();
            ArrayList<Object> value = null;
            value = flightToGses.containsKey(key) ? flightToGses.get(key) : new ArrayList();
            value.add(gse.getCustomerGseCode());
            flightToGses.put(key, value);
            key = gse.getCustomerGseCode();
            value = null;
            value = gseToFlights.containsKey(key) ? gseToFlights.get(key) : new ArrayList();
            value.add(gse.getUniqueFlightNumber());
            gseToFlights.put(key, value);
        }
        return true;
    }

    private Long actualTimeForGseAvailability(FisFlightCacheValue flight, long beginTime, long endTime) {
        if (flight == null) {
            return null;
        }
        long tif = 0L;
        if (flight.getArrivalDeparture().equals("A")) {
            if (flight.getScheduledTimeOfArrival() > 0L) {
                tif = flight.getScheduledTimeOfArrival();
            }
            if (flight.getEstimatedTimeOfArrival() > 0L) {
                tif = flight.getEstimatedTimeOfArrival();
            }
            if (flight.getLandingTime() > 0L) {
                tif = flight.getLandingTime();
            }
            if (flight.getOnBlockTime() > 0L) {
                tif = flight.getOnBlockTime();
            }
            if (flight.getOnBlockTime() > 0L) {
                // empty if block
            }
        }
        if (flight.getArrivalDeparture().equals("D") && flight.getOffBlockTime() == 0L && flight.getTakeOffTime() == 0L) {
            if (flight.getScheduledTimeOfDeparture() > 0L) {
                tif = flight.getScheduledTimeOfDeparture();
            }
            if (flight.getEstimatedTimeOfDeparture() > 0L) {
                tif = flight.getEstimatedTimeOfDeparture();
            }
        }
        if (tif >= beginTime && tif <= endTime) {
            return tif;
        }
        return null;
    }

    private HashMap<String, FisFlightCacheValue> uniqueFlightNumbers(long beginTime, long endTime) {
        Collection flightValues = new ArrayList();
        HashMap<String, FisFlightCacheValue> flightNumbersToValue = new HashMap<String, FisFlightCacheValue>();
        try {
            flightValues = this.fisFlightCacheLocalHome.findFlightsInPeriod(beginTime, endTime);
            for (FisFlightCacheLocal fis : flightValues) {
                if (this.actualTimeForGseAvailability(fis.getFisFlightCacheValue(), beginTime, endTime) == null) continue;
                flightNumbersToValue.put(fis.getUniqueFlightNumber(), fis.getFisFlightCacheValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"Finding flightValues failed", (Throwable)e);
        }
        return flightNumbersToValue;
    }

    public GseAvailabilityDTOList getGseAvailability(Long unitId, long beginTime, long endTime, int searchPeriod) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGseAvailability called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        boolean useUnitName = true;
        GseAvailabilityDTOList list = null;
        try {
            UnitModelLocal unitModelLocal = null;
            if (unitId != null) {
                unitModelLocal = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildGseAvailabilityDTOList(unitModelLocal, beginTime, endTime);
            if (endTime < beginTime) {
                return list;
            }
            UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
            HashMap<String, UnitModelLocal> customCodesToUnitModel = new HashMap<String, UnitModelLocal>();
            HashSet<String> customerCodes = new HashSet<String>();
            for (UnitModelLocal m : unitBasicModels) {
                String unitKey = "";
                unitKey = useUnitName ? m.getUnitIdentity().getUnitIdentityValue().getName() : String.valueOf(m.getUnitId());
                customerCodes.add(unitKey);
                customCodesToUnitModel.put(unitKey, m);
            }
            HashMap<String, FisFlightCacheValue> flightSet = this.uniqueFlightNumbers(beginTime, endTime);
            ArrayList<FisGseCacheLocal> gseValues = new ArrayList();
            gseValues = this.fisGseCacheLocalHome.findAll();
            HashMap<String, ArrayList<String>> flightToGses = new HashMap<String, ArrayList<String>>();
            HashMap<String, ArrayList<String>> gseToFlights = new HashMap<String, ArrayList<String>>();
            this.buildFisGseMaps(gseValues, flightToGses, gseToFlights);
            for (Map.Entry<String, FisFlightCacheValue> e : flightSet.entrySet()) {
                String flight = e.getKey();
                ArrayList<String> gses = flightToGses.get(flight);
                if (gses == null) continue;
                customerCodes.removeAll(gses);
            }
            long endTimeForFlightSearch = endTime + (long)(3600000 * searchPeriod);
            flightSet = this.uniqueFlightNumbers(endTime, endTimeForFlightSearch);
            PositionDTOList posList = this.getCurrentPositionData(unitId, false);
            HashMap<String, PositionDTO> customCodesToPosDTO = new HashMap<String, PositionDTO>();
            for (int i = 0; i < posList.size(); ++i) {
                PositionDTO posDTO = (PositionDTO)posList.get(i);
                String unitKey = useUnitName ? posDTO.getUnitName() : String.valueOf(posDTO.getUnitModelValue().getUnitId());
                customCodesToPosDTO.put(unitKey, posDTO);
            }
            for (String customerCode : customerCodes) {
                ArrayList<String> flights = gseToFlights.get(customerCode);
                Long nextTime = endTimeForFlightSearch + 1000L;
                FisFlightCacheValue nextFlight = null;
                if (flights != null) {
                    for (int i = 0; i < flights.size(); ++i) {
                        String flightNr = flights.get(i);
                        FisFlightCacheValue f = flightSet.get(flightNr);
                        Long flightTime = this.actualTimeForGseAvailability(f, endTime, endTimeForFlightSearch);
                        if (flightTime == null || flightTime <= 0L || flightTime >= nextTime) continue;
                        nextTime = flightTime;
                        nextFlight = f;
                    }
                }
                if (nextTime > endTimeForFlightSearch) {
                    nextTime = null;
                }
                UnitModelLocal uLocal = (UnitModelLocal)customCodesToUnitModel.get(customerCode);
                PositionDTO posDTO = (PositionDTO)customCodesToPosDTO.get(customerCode);
                if (uLocal == null || uLocal.getUnitModelValue().getDeleted()) continue;
                GseAvailabilityDTO dto = DTOFactory.buildGseAvailabilityDTO(uLocal, nextFlight, posDTO, nextTime);
                list.add(dto);
            }
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding flightValues failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }
}

