/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitDTOListBase<T>
extends DTOListBase<T> {
    private static final long serialVersionUID = -1390710469127960588L;
    private ArrayList<UnitDTO> removedUnitsList;
    private long stateModelId;
    public HashMap<Long, String> involvedUnitMap = new HashMap();
    public HashMap<Long, String> involvedDeletedUnitMap = new HashMap();

    public UnitDTOListBase() {
    }

    public UnitDTOListBase(UnitDTO unitDTO, Long beginTime, Long endTime) {
        this(unitDTO.getUnitModelValue(), unitDTO.getUnitIdentityValue(), unitDTO.getUnitTypeIdentityValue(), beginTime, endTime);
    }

    public UnitDTOListBase(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue) {
        if (unitModelValue == null) {
            unitModelValue = new UnitModelValue();
            unitModelValue.setUnitId(0L);
        }
        if (unitIdentityValue == null) {
            unitIdentityValue = new UnitIdentityValue();
            unitIdentityValue.setImageName("all");
            unitIdentityValue.setName("all");
        }
        if (unitTypeIdentityValue == null) {
            unitTypeIdentityValue = new UnitTypeIdentityValue();
        }
        this.unitTypeIdentityValue = unitTypeIdentityValue;
        this.unitModelValue = unitModelValue;
        this.unitIdentityValue = unitIdentityValue;
    }

    public UnitDTOListBase(UnitModelValue unitModel, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue, Long beginTime, Long endTime) {
        this(unitModel, unitIdentityValue, unitTypeIdentityValue);
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    @Override
    public boolean add(T e) {
        UnitDTO unitDTO;
        if (e instanceof UnitDTO && (unitDTO = (UnitDTO)e) != null) {
            this.addUnitToInvolvedMap(unitDTO);
        }
        return super.add(e);
    }

    public boolean removeUnAuthorizedData(UnitDTO dto) {
        if (super.remove(dto)) {
            if (this.removedUnitsList == null) {
                this.removedUnitsList = new ArrayList();
            }
            UnitDTO unitDTO = new UnitDTO(dto.getUnitModelValue(), dto.getUnitIdentityValue(), dto.getUnitTypeIdentityValue());
            this.removedUnitsList.add(unitDTO);
            return true;
        }
        return false;
    }

    public boolean isInsufficientPermissions() {
        return this.removedUnitsList != null;
    }

    public int getRemovedDataCount() {
        if (this.removedUnitsList == null) {
            return 0;
        }
        return this.removedUnitsList.size();
    }

    public boolean isAllDataRemoved() {
        if (this.removedUnitsList == null) {
            return false;
        }
        return this.removedUnitsList != null && this.size() == 0;
    }

    public HashMap<Long, String> getInvolvedUnitMap() {
        return this.involvedUnitMap;
    }

    public HashMap<Long, String> getInvolvedDeletedUnitMap() {
        return this.involvedDeletedUnitMap;
    }

    private void addUnitToInvolvedMap(UnitDTO unitDTO) {
        if (unitDTO == null) {
            return;
        }
        if (unitDTO.getUnitModelValue().getDeleted()) {
            this.involvedDeletedUnitMap.put(unitDTO.getUnitId(), unitDTO.getUnitName());
        } else {
            this.involvedUnitMap.put(unitDTO.getUnitId(), unitDTO.getUnitName());
        }
    }

    public void clearInvolvedUnitMaps() {
        this.involvedUnitMap.clear();
        this.involvedDeletedUnitMap.clear();
    }
}

