/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownErrorException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;

public class XMLDocument {
    private static final Log log = LogFactory.getLog(XMLDocument.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    protected Document doc;

    public XMLDocument() {
        this.doc = new Document();
        this.setDocType();
    }

    public XMLDocument(Document doc) {
        this.doc = doc;
        this.setDocType();
    }

    public XMLDocument(Element element) {
        this.doc = new Document();
        this.setDocType();
        this.doc.setRootElement(element);
    }

    public XMLDocument(String xmlText) throws JDOMException, UnknownErrorException {
        this.doc = this.parseByJDom(xmlText);
        this.setDocType();
    }

    public Document parseByJDom(String xmlText) throws JDOMException, UnknownErrorException {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        log.debug((Object)("parseByJDom: " + xmlText));
        Document doc = new Document();
        if (xmlText.length() > 0) {
            StringReader reader = new StringReader(xmlText);
            try {
                doc = builder.build((Reader)reader);
                return doc;
            }
            catch (JDOMException e) {
                log.error((Object)"runs into", (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new UnknownErrorException(e.getMessage());
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                throw new UnknownErrorException(e.getMessage());
            }
        }
        return doc;
    }

    private InputSource createInputSource(String xmlText) {
        StringReader reader = new StringReader(xmlText);
        return new InputSource(reader);
    }

    protected void setDocType() {
    }

    public String toString() {
        XMLOutputter xmlOut = new XMLOutputter();
        Format format = this.config.getBoolean("xml.formatted") ? Format.getPrettyFormat() : Format.getCompactFormat();
        format.setEncoding("ISO-8859-1");
        xmlOut.setFormat(format);
        String xmlData = xmlOut.outputString(this.doc);
        return xmlData;
    }

    protected String getTimeString(long timestamp) {
        Timestamp ts = new Timestamp(timestamp);
        return ts.getTimeString();
    }

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }
}

