/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.util.geo.GPSPosition;
import de.proveo.util.math.Point;
import de.proveo.util.math.PointImpl;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownNotifyException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateModelException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.XMLDocument;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class TelemetryDataMessage
extends XMLDocument {
    private static final Log log = LogFactory.getLog(TelemetryDataMessage.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private Enums.EventType eventType = Enums.EventType.UNKNOWN;

    public TelemetryDataMessage() {
    }

    public TelemetryDataMessage(Document doc) {
        super(doc);
    }

    public TelemetryDataMessage(Element element) {
        super(element);
    }

    public TelemetryDataMessage(StateHistoryValue history) throws UnknownStateModelException, UnknownStateException {
        this.eventType = Enums.EventType.STATE;
        long stateModelID = history.getStateModelId();
        long currentStateID = history.getStateIdAfter();
        long oldStateID = history.getStateId();
        String beginTime = this.getTimeString(history.getBeginTime());
        String endTime = this.getTimeString(history.getEndTime());
        long previousID = history.getPrimaryKey().stateHistoryId;
        String stateModel = this.getStateModelById(stateModelID);
        String currentState = this.getStateById(currentStateID);
        String oldState = "";
        try {
            oldState = this.getStateById(oldStateID);
        }
        catch (UnknownStateException e) {
            oldState = this.config.containsKey("stateId.9999") ? this.config.getString("stateId.9999") : "unknown";
        }
        long unitId = history.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(previousID)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.state"));
        Element statusField = new Element(this.config.getString("xml.telemetryDataMessage.stateField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.stateModelName.active")) {
            if (stateModel == null) {
                stateModel = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.stateModelName.xmlName"), stateModel));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.oldState.active")) {
            if (oldState == null) {
                oldState = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.oldState.xmlName"), oldState));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.beginTime.active")) {
            if (beginTime == null) {
                beginTime = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.beginTime.xmlName"), beginTime));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.endTime.active")) {
            if (endTime == null) {
                endTime = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.endTime.xmlName"), endTime));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.currState.active")) {
            if (currentState == null) {
                currentState = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.currState.xmlName"), currentState));
        }
        telemetryDataMessage.addContent((Content)statusField);
        this.doc = new Document();
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(StateDTO history) throws UnknownStateModelException, UnknownStateException {
        this.eventType = Enums.EventType.STATE;
        long stateModelID = history.getStateModelId();
        long currentStateID = history.getStateIdAfter();
        long oldStateID = history.getStateId();
        String beginTime = this.getTimeString(history.getBeginTime());
        String endTime = this.getTimeString(history.getEndTime());
        long historyID = history.getId();
        String stateModel = this.getStateModelById(stateModelID);
        String currentState = this.getStateById(currentStateID);
        String oldState = "";
        try {
            oldState = this.getStateById(oldStateID);
        }
        catch (UnknownStateException e) {
            oldState = this.config.containsKey("stateId.9999") ? this.config.getString("stateId.9999") : "unknown";
        }
        long unitId = history.getUnitId();
        String customerUnitId = history.getUnitModelValue().getCustomerUnitID();
        String unitName = history.getUnitName();
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyID)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.state"));
        Element statusField = new Element(this.config.getString("xml.telemetryDataMessage.stateField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.stateModelName.active")) {
            if (stateModel == null) {
                stateModel = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.stateModelName.xmlName"), stateModel));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.oldState.active")) {
            if (oldState == null) {
                oldState = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.oldState.xmlName"), oldState));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.beginTime.active")) {
            if (beginTime == null) {
                beginTime = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.beginTime.xmlName"), beginTime));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.endTime.active")) {
            if (endTime == null) {
                endTime = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.endTime.xmlName"), endTime));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.currState.active")) {
            if (currentState == null) {
                currentState = "";
            }
            statusField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.currState.xmlName"), currentState));
        }
        telemetryDataMessage.addContent((Content)statusField);
        this.doc = new Document();
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(GeoStruct geo) {
        this.eventType = Enums.EventType.GEO;
        String area = geo.getArea();
        long previousID = geo.getPkGdataPrevious();
        GPSPosition gps = new GPSPosition(geo.getRmcRec(), geo.getGgaRec(), geo.isTrusted());
        double latitude = (double)gps.getLatitudeArcDegree() + (double)gps.getLatitudeArcMinute() / 60.0 + (double)gps.getLatitudeArcSecond() / 3600.0;
        double longitude = (double)gps.getLongitudeArcDegree() + (double)gps.getLongitudeArcMinute() / 60.0 + (double)gps.getLongitudeArcSecond() / 3600.0;
        latitude = this.round(latitude, 6);
        longitude = this.round(longitude, 6);
        String timestamp = this.getTimeString(geo.getBeginTime());
        long unitId = geo.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        PointImpl gk = new PointImpl();
        double x = 0.0;
        double y = 0.0;
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            gk = this.calculateGaussKrueger(latitude, longitude);
            x = this.round(gk.getX(), 3);
            y = this.round(gk.getY(), 3);
        }
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(previousID)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.geo"));
        Element geoField = new Element(this.config.getString("xml.telemetryDataMessage.geoField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.gpsCoords.active")) {
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gpsCoords.longitude.xmlName"), Double.toString(longitude)));
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gpsCoords.latitude.xmlName"), Double.toString(latitude)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gkCoords.x.xmlName"), Double.toString(x)));
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gkCoords.y.xmlName"), Double.toString(y)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.rmc.active")) {
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.rmc.xmlName"), geo.getRmcRec()));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.area.active")) {
            if (area == null) {
                area = "";
            }
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.area.xmlName"), area));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.receiveTimestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.receiveTimestamp.xmlName"), this.getTimeString(geo.getBeginReceiveTime())));
        }
        telemetryDataMessage.addContent((Content)geoField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(PositionDTO position) {
        this.eventType = Enums.EventType.GEO;
        String area = position.getArea();
        long previousID = position.getPkGdataPrevious();
        GPSPosition gps = new GPSPosition(position.getRmcRmcRec(), position.getGgaRec(), position.isTrusted());
        double latitude = (double)gps.getLatitudeArcDegree() + (double)gps.getLatitudeArcMinute() / 60.0 + (double)gps.getLatitudeArcSecond() / 3600.0;
        double longitude = (double)gps.getLongitudeArcDegree() + (double)gps.getLongitudeArcMinute() / 60.0 + (double)gps.getLongitudeArcSecond() / 3600.0;
        latitude = this.round(latitude, 6);
        longitude = this.round(longitude, 6);
        String timestamp = this.getTimeString(position.getBeginTime());
        long unitId = position.getUnitId();
        String customerUnitId = position.getUnitModelValue().getCustomerUnitID();
        String unitName = position.getUnitName();
        PointImpl gk = new PointImpl();
        double x = 0.0;
        double y = 0.0;
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            gk = this.calculateGaussKrueger(latitude, longitude);
            x = this.round(gk.getX(), 3);
            y = this.round(gk.getY(), 3);
        }
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(previousID)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.geo"));
        Element geoField = new Element(this.config.getString("xml.telemetryDataMessage.geoField.xmlName"));
        if (this.config.getBoolean("xml.telemetryDataMessage.gpsCoords.active")) {
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gpsCoords.longitude.xmlName"), Double.toString(longitude)));
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gpsCoords.latitude.xmlName"), Double.toString(latitude)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.gkCoords.active")) {
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gkCoords.x.xmlName"), Double.toString(x)));
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.gkCoords.y.xmlName"), Double.toString(y)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.area.active")) {
            if (area == null) {
                area = "";
            }
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.area.xmlName"), area));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            if (timestamp == null) {
                timestamp = "";
            }
            geoField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp));
        }
        telemetryDataMessage.addContent((Content)geoField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(NotifyHistoryValue notifyHistoryValue) throws UnknownNotifyException {
        this.eventType = Enums.EventType.NOTIFY;
        NotifyFacadeLocal notifyFacade = null;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("NotifyFacadeLocal");
            NotifyFacadeLocalHome notifyFacadeHome = (NotifyFacadeLocalHome)PortableRemoteObject.narrow((Object)obj, NotifyFacadeLocalHome.class);
            notifyFacade = notifyFacadeHome.create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        long historyId = notifyHistoryValue.getId();
        long notifyTypeId = notifyHistoryValue.getMessageId();
        Timestamp timestamp = new Timestamp(notifyHistoryValue.getReceiveTime());
        String remark = notifyHistoryValue.getRemark();
        long unitId = notifyHistoryValue.getUnitId();
        String customerUnitId = UnitHelper.getCustomerUnitId(unitId);
        String unitName = UnitHelper.getUnitName(unitId);
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.notify"));
        Element notifyField = new Element(this.config.getString("xml.telemetryDataMessage.notifyField.xmlName"));
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), notificationText));
                } else {
                    notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), this.config.getString("notify.unknown.text") + " " + notifyTypeId));
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp.getTimeString()));
        }
        if (remark != null && this.config.getBoolean("xml.telemetryDataMessage.remark.active")) {
            notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.remark.xmlName"), remark));
        }
        telemetryDataMessage.addContent((Content)notifyField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    public TelemetryDataMessage(NotificationDTO notificationDTO) throws UnknownNotifyException {
        this.eventType = Enums.EventType.NOTIFY;
        NotifyFacadeLocal notifyFacade = null;
        try {
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup("NotifyFacadeLocal");
            NotifyFacadeLocalHome notifyFacadeHome = (NotifyFacadeLocalHome)PortableRemoteObject.narrow((Object)obj, NotifyFacadeLocalHome.class);
            notifyFacade = notifyFacadeHome.create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        long historyId = notificationDTO.getId();
        long notifyTypeId = notificationDTO.getMessageId();
        Timestamp timestamp = new Timestamp(notificationDTO.getBeginReceiveTime());
        String remark = notificationDTO.getRemark();
        long unitId = notificationDTO.getUnitId();
        String customerUnitId = notificationDTO.getUnitModelValue().getCustomerUnitID();
        String unitName = notificationDTO.getUnitName();
        Element telemetryDataMessage = new Element(this.config.getString("xml.telemetryDataMessage.xmlName"));
        telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.messageId.xmlName"), Long.toString(historyId)));
        if (this.config.getBoolean("xml.telemetryDataMessage.customerUnitId.active")) {
            if (customerUnitId != null) {
                telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.customerUnitId.xmlName"), customerUnitId));
            } else {
                log.warn((Object)("unit " + unitId + " has no customer unit id"));
            }
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.proveoUnitID.active")) {
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.proveoUnitID.xmlName"), Long.toString(unitId)));
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.unitName.active")) {
            if (unitName == null) {
                unitName = "";
            }
            telemetryDataMessage.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.unitName.xmlName"), unitName));
        }
        telemetryDataMessage.setAttribute(this.config.getString("xml.telemetryDataMessages.eventType.xmlName"), this.config.getString("xml.telemetryDataMessages.eventTypes.notify"));
        Element notifyField = new Element(this.config.getString("xml.telemetryDataMessage.notifyField.xmlName"));
        if (this.sendNotifyWithId(notifyTypeId)) {
            if (notifyFacade != null) {
                String notificationText = notifyFacade.getNotificationTextById(notifyTypeId);
                if (notificationText != null) {
                    notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), notificationText));
                } else {
                    notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.notificationText.xmlName"), this.config.getString("notify.unknown.text") + " " + notifyTypeId));
                }
            }
        } else {
            throw new UnknownNotifyException(notifyTypeId);
        }
        if (this.config.getBoolean("xml.telemetryDataMessage.timestamp.active")) {
            notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.timestamp.xmlName"), timestamp.getTimeString()));
        }
        if (remark != null && this.config.getBoolean("xml.telemetryDataMessage.remark.active")) {
            notifyField.setAttribute(new Attribute(this.config.getString("xml.telemetryDataMessage.remark.xmlName"), remark));
        }
        telemetryDataMessage.addContent((Content)notifyField);
        this.setDocType();
        this.doc.setRootElement(telemetryDataMessage);
    }

    private boolean sendNotifyWithId(long id) {
        long[] ids = this.config.getLongArray("notify.messageIdList");
        if (ids.length == 1) {
            if (ids[0] == -1L) {
                return false;
            }
            if (ids[0] == 0L) {
                return true;
            }
        }
        for (long l : ids) {
            if (l != id) continue;
            return true;
        }
        return false;
    }

    private Point calculateGaussKrueger(double b, double l) {
        double metersPerDegreeX = this.config.getDouble("plugins.fmg.client.gausskrueger.metersPerDegreeX");
        double metersPerDegreeY = this.config.getDouble("plugins.fmg.client.gausskrueger.metersPerDegreeY");
        double b0 = this.config.getDouble("plugins.fmg.client.gausskrueger.b0");
        double l0 = this.config.getDouble("plugins.fmg.client.gausskrueger.l0");
        double x0 = this.config.getDouble("plugins.fmg.client.gausskrueger.x0");
        double y0 = this.config.getDouble("plugins.fmg.client.gausskrueger.y0");
        double x = metersPerDegreeX * (b - b0) + x0;
        double y = metersPerDegreeY * (l - l0) + y0;
        return new PointImpl(x, y);
    }

    private double round(double number, int decimals) {
        return (double)Math.round(number * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public void add(Element element) {
        this.doc.getRootElement().getChildren().add(element);
    }

    public void add(Document doc) {
        doc.getRootElement().getChildren().add(doc.getRootElement());
    }

    private String getStateModelById(long stateModelID) throws UnknownStateModelException {
        if (this.config.isConfigured("stateModel." + stateModelID)) {
            String stateModel = this.config.getString("stateModel." + stateModelID);
            return stateModel;
        }
        throw new UnknownStateModelException("state model " + stateModelID + " is unknown");
    }

    private String getStateById(long stateID) throws UnknownStateException {
        if (this.config.isConfigured("stateId." + stateID)) {
            String state = this.config.getString("stateId." + stateID);
            return state;
        }
        throw new UnknownStateException("state " + stateID + " is unknown");
    }

    public static void main(String[] args) {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        double b = 0.0;
        double l = 0.0;
        TelemetryDataMessage msg = new TelemetryDataMessage();
        do {
            try {
                System.out.println("l: ");
                String input_l = br.readLine();
                if (input_l != null && input_l.trim().length() > 0) {
                    l = Double.parseDouble(input_l);
                }
                System.out.println("b: ");
                String input_b = br.readLine();
                if (input_b != null && input_b.trim().length() > 0) {
                    b = Double.parseDouble(input_b);
                }
                Point gk = msg.calculateGaussKrueger(b, l);
                System.out.println("x = " + gk.getX());
                System.out.println("y = " + gk.getY());
                System.out.println();
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } while (b != 0.0 && l != 0.0);
    }

    public Enums.EventType getEventType() {
        return this.eventType;
    }
}

