/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml;

import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.AbstractTelegramHandler;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXDocument {
    private static final Log log = LogFactory.getLog(SAXDocument.class);
    protected String xmlText;

    public SAXDocument(String xmlText) {
        this.xmlText = xmlText;
    }

    public HashMap<String, Object> parse(ContentHandler handler) throws SAXException, IOException {
        log.debug((Object)("parse " + this.xmlText));
        HashMap<String, Object> result = new HashMap<String, Object>();
        SAXParser parser = new SAXParser();
        parser.setContentHandler(handler);
        parser.parse(this.createInputSource(this.xmlText));
        log.debug((Object)("handler class: " + handler.getClass()));
        if (handler instanceof AbstractTelegramHandler) {
            AbstractTelegramHandler telegramHandler = (AbstractTelegramHandler)handler;
            result = telegramHandler.getResult();
            log.debug((Object)("result.size=" + result.size()));
        }
        return result;
    }

    private InputSource createInputSource(String xmlText) {
        StringReader reader = new StringReader(xmlText);
        return new InputSource(reader);
    }

    public String getXmlText() {
        return this.xmlText;
    }

    public void setXmlText(String xmlText) {
        this.xmlText = xmlText;
    }

    public String toString() {
        return this.xmlText;
    }
}

