/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.util;

import de.proveo.rts.configuration.interfaces.telemetryData.TelemetryDataConfigurationServiceMBean;
import de.proveo.rts.configuration.interfaces.telemetryData.TelemetryDataConfigurationServiceUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.rmi.RemoteException;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientConfiguration {
    private static final Log log = LogFactory.getLog(ClientConfiguration.class);
    private static final ClientConfiguration INSTANCE = new ClientConfiguration();
    private static ConfigurationClient configuration;
    private static TelemetryDataConfigurationServiceMBean telemetryDataConfigurationServiceMBean;
    private final String PREFIX_NAME = "telemetryDataPrefix";
    private String prefix = null;

    private ClientConfiguration() {
        this.init();
    }

    public static ClientConfiguration getInstance() {
        return INSTANCE;
    }

    public String getString(String key) {
        try {
            return configuration.getParameter(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return "";
    }

    public int getInt(String key) {
        try {
            return configuration.getInteger(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return 0;
    }

    public double getDouble(String key) {
        try {
            return Double.parseDouble(configuration.getParameter(this.getPrefix() + key));
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return 0.0;
    }

    public String[] getStringArray(String key) {
        try {
            return configuration.getParameterArray(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return new String[0];
    }

    public long[] getLongArray(String key) {
        try {
            return configuration.getLongArray(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return new long[0];
    }

    public boolean getBoolean(String key) {
        if (key.equals(this.getPrefix() + "active")) {
            return this.isTelemetryDataActive();
        }
        try {
            return configuration.getBoolean(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)("Cannot find parameter " + this.getPrefix() + key), (Throwable)e);
        }
        return false;
    }

    public boolean isConfigured(String key) {
        try {
            return configuration.isConfigured(this.getPrefix() + key);
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    public boolean containsKey(String key) {
        return this.isConfigured(this.getPrefix() + key);
    }

    public boolean isTelemetryDataActive() {
        return telemetryDataConfigurationServiceMBean.isTelemetryDataActive();
    }

    public boolean isClientRegistered() {
        return telemetryDataConfigurationServiceMBean.isClientRegistered();
    }

    public void setClientRegistered(boolean registered) {
        telemetryDataConfigurationServiceMBean.setClientRegistered(registered);
    }

    private String getPrefix() {
        if (this.prefix == null) {
            try {
                this.prefix = configuration.getParameter("telemetryDataPrefix");
            }
            catch (RemoteException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.prefix = "de.proveo.telemetry.";
            }
            catch (ConfigurationParameterNotFoundException e) {
                log.error((Object)"runs into", (Throwable)e);
                this.prefix = "de.proveo.telemetry.";
            }
        }
        return this.prefix;
    }

    private void init() {
        configuration = new ConfigurationClient();
        try {
            telemetryDataConfigurationServiceMBean = TelemetryDataConfigurationServiceUtil.getMBean();
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }
}

