/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.UnknownStateModelException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.ejb.state.StateOutFacade;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeUtil;
import de.proveo.wwt.logic.web.data.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(StateHandler.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private static StateHandler stateHandler = null;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private StateHistoryLocalHome stateHistoryHome;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();

    private StateHandler() {
        try {
            this.stateHistoryHome = StateHistoryUtil.getLocalHome();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static StateHandler getInstance() {
        if (stateHandler == null) {
            stateHandler = new StateHandler();
        }
        return stateHandler;
    }

    /*
     * Unable to fully structure code
     */
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        StateHandler.log.debug((Object)"handle event");
        startTime = System.currentTimeMillis();
        stateHistory = (StateHistoryValue)wrapper.get_historyValue();
        stateCache = (CurrentStateCacheValue)wrapper.get_cacheValue();
        if (stateHistory != null) {
            if (stateCache != null) {
                sendData = UnitHelper.isSendData(stateCache.getUnitId());
                try {
                    xmlMsg = new TelemetryDataMessage(stateHistory);
                    messageID = stateCache.getPkStatePrevious();
                    if (StateHandler.log.isDebugEnabled()) {
                        StateHandler.log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + stateCache.getUnitId()));
                    }
                    if (sendData) {
                        StateHandler.log.debug((Object)("pushStatus: " + xmlMsg.toString()));
                        this.sendTextMessage(xmlMsg.toString());
                    }
                    if (!StateHandler.log.isTraceEnabled()) ** GOTO lbl32
                    StateHandler.log.trace((Object)("status event " + messageID + " not sent: " + xmlMsg.toString()));
                }
                catch (UnknownStateModelException e) {
                    StateHandler.log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (UnknownStateException e) {
                    StateHandler.log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (Exception e) {
                    StateHandler.log.error((Object)"runs into", (Throwable)e);
                    throw new MessageNotSentException();
                }
            } else {
                StateHandler.log.error((Object)"stateCacheValue is null");
            }
        } else {
            StateHandler.log.error((Object)"stateHistoryValue is null");
        }
lbl32:
        // 7 sources

        duration = System.currentTimeMillis() - startTime;
        StateHandler.log.trace((Object)("handle event finished after " + duration + " ms"));
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        block18: {
            try {
                StateOutFacade facade = StateOutFacadeUtil.getHome().create();
                ArrayList col = facade.getAllUnitEventsFromCacheSortedByPreviousPk();
                Iterator it = col.iterator();
                long maxId = 0L;
                while (it.hasNext()) {
                    boolean sendData;
                    CurrentStateCacheValue stateCacheValue = (CurrentStateCacheValue)it.next();
                    long pk = stateCacheValue.getPkStatePrevious();
                    if (pk <= 0L || !(sendData = UnitHelper.isSendData(stateCacheValue.getUnitId()))) continue;
                    if (pk < minId) {
                        minId = pk;
                    }
                    if (pk <= maxId) continue;
                    maxId = pk;
                }
                Range includedData = new Range(minId, maxId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"beginStateStock");
                }
                BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.STATE);
                this.sendTextMessage(beginStockPart.toString());
                it = col.iterator();
                int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
                while (it.hasNext()) {
                    TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
                    int count = 0;
                    while (count < maxMessageCount && it.hasNext()) {
                        boolean sendData;
                        StateHistoryValue stateHistoryValue;
                        CurrentStateCacheValue stateCacheValue = (CurrentStateCacheValue)it.next();
                        long pk = stateCacheValue.getPkStatePrevious();
                        if (pk <= 0L || (stateHistoryValue = facade.getStateHistoryValue(new StateHistoryPK(pk))) == null || !(sendData = UnitHelper.isSendData(stateHistoryValue.getUnitId()))) continue;
                        try {
                            xmlMsgs.add(new TelemetryDataMessage(stateHistoryValue));
                            ++count;
                            this.lastSentMessageId = pk;
                        }
                        catch (UnknownStateModelException e) {
                            log.debug((Object)("runs into " + e.getMessage()));
                        }
                        catch (UnknownStateException e) {
                            log.debug((Object)("runs into " + e.getMessage()));
                        }
                    }
                    if (xmlMsgs.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushStateStockPart: " + xmlMsgs.toString()));
                    }
                    this.sendTextMessage(xmlMsgs.toString());
                }
                this.setSynchronizing(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("endStateStock: " + includedData));
                }
                EndStockPart endStockPart = new EndStockPart(Enums.EventType.STATE, includedData.getFrom(), includedData.getUntil());
                this.sendTextMessage(endStockPart.toString());
            }
            catch (RemoteException e) {
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                }
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
                }
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (!this.isTimeoutException(e)) break block18;
                throw new TOWhileSyncException("Transaction timed out while synchronization. Synchronization aborted.");
            }
        }
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.stateHistoryHome.getMaxHistoryId();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public StateHistoryLocal getStateHistory(long id) throws TOWhileSyncException {
        try {
            return this.stateHistoryHome.findByPrimaryKey(new StateHistoryPK(id));
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (FinderException e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getStateHistory runs into", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getStateHistory runs into", (Throwable)e);
            return null;
        }
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStateStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount) {
            until = from + (long)maxMessageCount;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<StateDTO> list = this.fastLaneTelemetry.getStateHistory(from, until);
        for (StateDTO stateDTO : list) {
            if (stateDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(stateDTO.getUnitId());
                if (!sendData) continue;
                xmlMsgs.add(new TelemetryDataMessage(stateDTO));
            }
            catch (UnknownStateModelException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (UnknownStateException e) {
                log.debug((Object)(e.getMessage() + " - message is not sent"));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (xmlMsgs.isEmpty()) {
            xmlMsgs.setIncludedData("-1");
            return xmlMsgs;
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getStatesForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStatesForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.STATE);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            Collection stateHistoryCol = this.stateHistoryHome.findByUnitPeriod(unitId, startTime.getTimestamp(), endTime.getTimestamp());
            int size = stateHistoryCol.size();
            log.debug((Object)("stateHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (StateHistoryLocal stateHistory : stateHistoryCol) {
                if (stateHistory == null) continue;
                try {
                    boolean sendData;
                    StateHistoryValue stateEvent = stateHistory.getStateHistoryValue();
                    if (stateEvent == null || !(sendData = UnitHelper.isSendData(stateEvent.getUnitId()))) continue;
                    xmlMsgs.add(new TelemetryDataMessage(stateEvent));
                }
                catch (UnknownStateModelException e) {
                    log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (UnknownStateException e) {
                    log.debug((Object)(e.getMessage() + " - message is not sent"));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (stateHandler != null) {
            stateHandler.shutDownQueue();
            stateHandler = null;
        }
    }
}

