/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.geo.GeoOutFacade;
import de.proveo.wwt.logic.ejb.geo.GeoOutFacadeUtil;
import de.proveo.wwt.logic.ejb.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistory;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryLocal;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.geo.history.GdataHistoryValue;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler.AbstractHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.UnitHelper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.BeginStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.EndStockPart;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.TelemetryDataMessages;
import de.proveo.wwt.logic.web.data.TelemetryFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeoHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(GeoHandler.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private static GeoHandler geoHandler = null;
    private static long lastPkGdataHistory = 0L;
    private boolean discardOldMessages = false;
    private boolean synchronizing = false;
    private long lastSentMessageId = -1L;
    private GdataHistoryLocalHome gdataHistoryLocalHome;
    private TelemetryFastLaneReader fastLaneTelemetry = new TelemetryFastLaneReader();

    private GeoHandler() {
        try {
            this.gdataHistoryLocalHome = GdataHistoryUtil.getLocalHome();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public static GeoHandler getInstance() {
        if (geoHandler == null) {
            geoHandler = new GeoHandler();
        }
        return geoHandler;
    }

    /*
     * Unable to fully structure code
     */
    public void handleEvent(SerializableEventWrapper wrapper) throws MessageNotSentException {
        GeoHandler.log.debug((Object)"handle event");
        startTime = System.currentTimeMillis();
        if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
            pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
            if (pkGdataHistoryPre < GeoHandler.lastPkGdataHistory) {
                GeoHandler.log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + GeoHandler.lastPkGdataHistory + ")"));
            }
            GeoHandler.lastPkGdataHistory = pkGdataHistoryPre;
        }
        if ((geo = (GeoStruct)wrapper.get_cacheValue()) != null) {
            sendData = UnitHelper.isSendData(geo.getUnitId());
            try {
                xmlMsg = new TelemetryDataMessage(geo);
                messageID = geo.getPkGdataPrevious();
                if (GeoHandler.log.isDebugEnabled()) {
                    GeoHandler.log.debug((Object)("handleEvent() - messageId: " + messageID + " unitId: " + geo.getUnitId()));
                }
                if (sendData) {
                    GeoHandler.log.debug((Object)("pushGeo: " + xmlMsg.toString()));
                    this.sendTextMessage(xmlMsg.toString());
                }
                if (!GeoHandler.log.isTraceEnabled()) ** GOTO lbl26
                GeoHandler.log.trace((Object)("geo event " + messageID + " not sent: " + xmlMsg.toString()));
            }
            catch (Exception e) {
                GeoHandler.log.error((Object)"runs into", (Throwable)e);
                throw new MessageNotSentException();
            }
        } else {
            GeoHandler.log.error((Object)"geoStruct is null");
        }
lbl26:
        // 4 sources

        duration = System.currentTimeMillis() - startTime;
        GeoHandler.log.trace((Object)("handle event finished after " + duration + " ms"));
    }

    public void pushCache(long minId) throws TOWhileSyncException {
        block15: {
            try {
                GeoOutFacade facade = GeoOutFacadeUtil.getHome().create();
                ArrayList col = facade.getAllUnitEventsFromCacheSortedByPreviousPk();
                Iterator it = col.iterator();
                long maxId = 0L;
                while (it.hasNext()) {
                    boolean sendData;
                    GeoStruct geoStruct = (GeoStruct)it.next();
                    long pk = geoStruct.getPkGdataPrevious();
                    if (pk <= 0L || !(sendData = UnitHelper.isSendData(geoStruct.getUnitId()))) continue;
                    if (pk < minId) {
                        minId = pk;
                    }
                    if (pk <= maxId) continue;
                    maxId = pk;
                }
                Range includedData = new Range(minId, maxId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"beginBestandGeo ");
                }
                BeginStockPart beginStockPart = new BeginStockPart(Enums.EventType.GEO);
                this.sendTextMessage(beginStockPart.toString());
                it = col.iterator();
                int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
                while (it.hasNext()) {
                    TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
                    int count = 0;
                    while (count < maxMessageCount && it.hasNext()) {
                        boolean sendData;
                        long pk;
                        GeoStruct geoStruct = (GeoStruct)it.next();
                        if (geoStruct == null || (pk = geoStruct.getPkGdataPrevious()) <= 0L || !(sendData = UnitHelper.isSendData(geoStruct.getUnitId()))) continue;
                        xmlMsgs.add(new TelemetryDataMessage(geoStruct));
                        ++count;
                        this.setLastSentMessageId(pk);
                    }
                    if (xmlMsgs.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pushTeilBestandGeo: " + xmlMsgs.toString()));
                    }
                    this.sendTextMessage(xmlMsgs.toString());
                }
                this.setSynchronizing(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("endBestandGeo: " + includedData));
                }
                EndStockPart endStockPart = new EndStockPart(Enums.EventType.GEO, includedData.getFrom(), includedData.getUntil());
                this.sendTextMessage(endStockPart.toString());
            }
            catch (RemoteException e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (!this.isTimeoutException(e)) break block15;
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
        }
    }

    public long getMaxHistoryId() throws TOWhileSyncException {
        try {
            log.debug((Object)"try getMaxHistoryId...");
            return this.gdataHistoryLocalHome.getMaxPkPrevious();
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
            }
            log.error((Object)"getMaxHistoryId runs into", (Throwable)e);
            return -1L;
        }
    }

    public GdataHistory getGDataHistory(long id) throws TOWhileSyncException {
        try {
            Collection col = this.gdataHistoryLocalHome.findByPkPrevious(id);
            Iterator it = col.iterator();
            if (it.hasNext()) {
                return (GdataHistory)it.next();
            }
            return null;
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)("object with id " + id + " not found in Gdata history"));
        }
        catch (FinderException e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborted.");
            }
            log.error((Object)"getGDataHistory runs into", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (this.isTimeoutException(e)) {
                throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborted.");
            }
            log.error((Object)"runs into", (Throwable)e);
            return null;
        }
        return null;
    }

    public TelemetryDataMessages getStockPart(long from, long until) throws TOWhileSyncException {
        long requestedUntil = until;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGeoStockPart from " + from + " until " + until));
        }
        long maxHistoryId = this.getMaxHistoryId();
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
        until = requestedUntil;
        int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
        if (until > from + (long)maxMessageCount) {
            until = from + (long)maxMessageCount;
        }
        if (until > maxHistoryId) {
            until = maxHistoryId;
        }
        List<PositionDTO> list = this.fastLaneTelemetry.getGdataHistory(from, until);
        for (PositionDTO positionDTO : list) {
            if (positionDTO == null) continue;
            try {
                boolean sendData = UnitHelper.isSendData(positionDTO.getUnitId());
                if (!sendData) continue;
                xmlMsgs.add(new TelemetryDataMessage(positionDTO));
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                if (this.isTimeoutException(e)) {
                    throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                }
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (xmlMsgs.isEmpty()) {
            xmlMsgs.setIncludedData("-1");
            return xmlMsgs;
        }
        xmlMsgs.setFrom(from);
        xmlMsgs.setUntil(until);
        return xmlMsgs;
    }

    public TelemetryDataMessages getGeosForUnit(String unitName, Timestamp startTime, Timestamp endTime) throws TOWhileSyncException, TooMuchDataException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGeosForUnit for unit " + unitName + " from " + startTime.getTimestamp() + " until " + endTime.getTimestamp()));
        }
        TelemetryDataMessages xmlMsgs = new TelemetryDataMessages(Enums.EventType.GEO);
        try {
            long unitId = UnitHelper.getUnitId(unitName);
            log.debug((Object)("unitId: " + unitId));
            Collection gdataHistoryCol = this.gdataHistoryLocalHome.findByUnitBeginEnd(unitId, startTime.getTimestamp(), endTime.getTimestamp());
            int size = gdataHistoryCol.size();
            log.debug((Object)("gdataHistoryCol.size: " + size));
            int maxMessageCount = this.config.getInt("telemetryDataMessage.maxMessageCount");
            if (size > maxMessageCount) {
                throw new TooMuchDataException();
            }
            for (GdataHistoryLocal gdataHistory : gdataHistoryCol) {
                if (gdataHistory == null) continue;
                try {
                    boolean sendData;
                    GdataHistoryValue geoEvent = gdataHistory.getGdataHistoryValue();
                    GeoStruct geoStruct = gdataHistory.getStruct();
                    if (geoEvent == null || !(sendData = UnitHelper.isSendData(geoEvent.getUnitId()))) continue;
                    xmlMsgs.add(new TelemetryDataMessage(geoStruct));
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                    if (this.isTimeoutException(e)) {
                        throw new TOWhileSyncException("Transaction timed out while syncronize.Syncronize aborded.");
                    }
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return xmlMsgs;
    }

    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    public void setDiscardOldMessages(boolean discardOldMessages) {
        this.discardOldMessages = discardOldMessages;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    public void setLastSentMessageId(long lastSentMessageId) {
        this.lastSentMessageId = lastSentMessageId;
    }

    public static void undeploy() {
        if (geoHandler != null) {
            geoHandler.shutDownQueue();
            geoHandler = null;
        }
    }
}

