/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData.handler;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.MessageNotSentException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.transaction.TransactionRolledbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHandler {
    private static final Log log = LogFactory.getLog(AbstractHandler.class);
    public static final String QUEUE_NAME = "queue/telemetryDataOutQueue";
    private transient QueueConnectionFactory queueConnectionFactory;
    private transient QueueConnection queueConnection;
    protected transient QueueSender queueSender;
    protected transient QueueSession queueSession;
    protected boolean discardOldMessages = false;
    private long lastSentMessageId = 0L;

    public AbstractHandler() {
        this.initializeQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initializeQueue() {
        try {
            Queue queue;
            InitialContext ctx = new InitialContext();
            this.queueConnectionFactory = (QueueConnectionFactory)ctx.lookup("ConnectionFactory");
            this.queueConnection = this.queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            try {
                queue = (Queue)ctx.lookup(QUEUE_NAME);
            }
            catch (NameNotFoundException ex) {
                log.debug((Object)"queue not found, create new");
                queue = this.queueSession.createQueue(QUEUE_NAME);
                ctx.bind(QUEUE_NAME, (Object)queue);
            }
            try {
                this.queueConnection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
                this.queueSender = this.queueSession.createSender(queue);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
                try {
                    this.queueConnection.close();
                }
                catch (JMSException ignored) {
                }
                finally {
                    ctx.close();
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public void shutDownQueue() {
        try {
            this.queueSender.close();
            this.queueConnection.setExceptionListener(null);
            this.queueConnection.close();
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void sendTextMessage(String text) {
        try {
            TextMessage msg = this.queueSession.createTextMessage(text);
            log.debug((Object)("send message to out queue: " + text));
            this.queueSender.send((Message)msg);
        }
        catch (JMSException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public abstract void handleEvent(SerializableEventWrapper var1) throws MessageNotSentException;

    protected boolean isTimeoutException(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null) {
            return false;
        }
        if (cause instanceof ResourceException || cause instanceof RuntimeException || cause instanceof TransactionRolledbackException) {
            log.debug((Object)("cause: " + cause.getMessage()));
            return cause.getMessage().contains("Transaction is not active") || cause.getMessage().contains("timeout");
        }
        return this.isTimeoutException(cause);
    }

    public void setDiscardOldMessages(boolean discard) {
        log.debug((Object)("discard old messages: " + discard));
        this.discardOldMessages = discard;
    }

    public boolean isDiscardOldMessages() {
        return this.discardOldMessages;
    }

    public long getLastSentMessageId() {
        return this.lastSentMessageId;
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                try {
                    AbstractHandler.this.queueConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                boolean setupOK = AbstractHandler.this.initializeQueue();
                if (setupOK) {
                    log.info((Object)"Connection re-established");
                    return;
                }
                log.warn((Object)"Re-creating connection failed, retrying ...");
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

