/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.Ping;
import java.io.Serializable;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryPingTimerBean
extends BaseSessionBean
implements SessionBean,
TimedObject {
    private static final Log log = LogFactory.getLog(TelemetryPingTimerBean.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private static final String INFO = "PingTimer TelemetryData";
    private Timer timer = null;
    private TimerService timerService;
    private TelemetryDataMessageSenderLocal messageSender;
    private boolean pingReceived = false;
    private int errorCount = 0;
    private final int MAX_ERROR_COUNT = 3;

    public void ejbCreate() throws CreateException {
        try {
            this.timerService = this.sessionContext.getTimerService();
            this.messageSender = TelemetryDataMessageSenderUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void ejbRemove() {
        log.info((Object)"ejbReomve() invoked in BasicDataPingTimerBean");
    }

    public void createTimer(int interval) {
        log.debug((Object)"createTimer() in BasicDataPingTimerBean");
        try {
            this.timer = this.timerService.createTimer(1000L * (long)interval, 1000L * (long)interval, (Serializable)((Object)INFO));
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    public void cancelOldTimers() {
        log.debug((Object)"cancelOldTimers()s in BasicDataPingTimerBean");
        Collection timers = this.timerService.getTimers();
        for (Timer tempTimer : timers) {
            if (!INFO.equals(tempTimer.getInfo())) continue;
            tempTimer.cancel();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            log.debug((Object)"pingTimer of TelemetryData stopped");
        }
    }

    public void ejbTimeout(Timer timer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTimeout() in BasicData. " + (Object)((Object)this)));
            if (this.timer != timer) {
                log.debug((Object)("timer:      " + timer));
                log.debug((Object)("Client.getTimer(): " + timer));
            }
        }
        this.sendPingMessage();
    }

    protected void sendPingMessage() {
        Ping ping = new Ping();
        this.messageSender.sendTextMessage(ping.toString());
        log.debug((Object)"ping message sent");
        log.debug((Object)"check if telemetryData has received ping");
        if (!this.pingReceived) {
            ++this.errorCount;
            log.debug((Object)("sendPingMessage() - errorCount: " + this.errorCount));
        } else {
            this.errorCount = 0;
        }
        if (this.errorCount >= 3) {
            log.debug((Object)"errorCount >= MAX_ERROR_COUNT -> reconnect");
            this.unregisterClient();
        }
        this.pingReceived = false;
    }

    public void ping() {
        log.debug((Object)"received ping");
        this.pingReceived = true;
    }

    public void unregisterClient() {
        log.info((Object)"unregisterClient()");
        MessageDistributor.getInstance().setIgnoreMessages(true);
        this.stop();
        this.errorCount = 0;
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }
}

