/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.MessageDistributor;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.Registered;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelemetryDataRegistrationBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TelemetryDataRegistrationBean.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private TelemetryDataStockLocal stockBean;
    private TelemetryDataMessageSenderLocal messageSender;
    private static boolean registrationRunning = false;
    private TelemetryPingTimerLocal pingTimer;

    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate");
        try {
            this.stockBean = TelemetryDataStockUtil.getLocalHome().create();
            this.pingTimer = TelemetryPingTimerUtil.getLocalHome().create();
            this.messageSender = TelemetryDataMessageSenderUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void register(long lastGeo, long lastState, long lastNotify) throws TOWhileSyncException {
        if (!registrationRunning) {
            registrationRunning = true;
            if (this.config.isTelemetryDataActive()) {
                if (this.config.isClientRegistered()) {
                    log.debug((Object)"Already a client registered! call unregister()!!!");
                    this.unregister();
                }
                if (!MessageDistributor.getInstance().isStopped()) {
                    log.debug((Object)"MessageDistributor is started! Stop it before synchronizing!");
                    MessageDistributor.getInstance().stop();
                }
                this.messageSender.sendTextMessage(new Registered().toString());
                log.info((Object)("register() - lastGeo=" + lastGeo + " lastState=" + lastState + " lastNotify=" + lastNotify));
                if (this.config.getBoolean("geo.active") && lastGeo != -2L) {
                    this.stockBean.synchronizeGeo(lastGeo);
                }
                if (this.config.getBoolean("state.active") && lastState != -2L) {
                    this.stockBean.synchronizeState(lastState);
                }
                if (this.config.getBoolean("notify.active") && lastNotify != -2L) {
                    this.stockBean.synchronizeNotify(lastNotify);
                }
                MessageDistributor.getInstance().setIgnoreMessages(false);
                MessageDistributor.getInstance().start();
                log.debug((Object)"start ping timer");
                this.pingTimer.createTimer(this.config.getInt("ping.interval"));
                this.config.setClientRegistered(true);
                log.debug((Object)"Client is registered.");
            } else {
                log.warn((Object)"Client tried to register, but telemetry data interface is not active!");
            }
            registrationRunning = false;
        } else {
            log.debug((Object)"registration is already running");
        }
    }

    public void unregister() {
        log.info((Object)"unregister()");
        MessageDistributor.getInstance().setIgnoreMessages(true);
        this.pingTimer.stop();
        this.messageSender.removeAllMessages();
        this.config.setClientRegistered(false);
        log.debug((Object)"Client is un-registered.");
    }

    public boolean isRegistered() {
        return this.config.isClientRegistered();
    }
}

