/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataErrorUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataRegistrationLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataRegistrationUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataStockUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryPingTimerUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.ClientNotRegisteredException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TOWhileSyncException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.exceptions.TooMuchDataException;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Enums;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Range;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.ErrorMessage;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.SAXDocument;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RegisterTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestGeoStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestGeosForUnitTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestNotifiesForUnitTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestNotifyStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestStateStockTelegramHandler;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.telegrams.RequestStatesForUnitTelegramHandler;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class TelemetryDataInSessionBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TelemetryDataInSessionBean.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private TelemetryDataErrorLocal errorLocalBean;
    private TelemetryDataRegistrationLocal registrationLocalBean;
    private TelemetryDataStockLocal stockLocalBean;
    private TelemetryPingTimerLocal pingTimer;

    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
        try {
            this.errorLocalBean = TelemetryDataErrorUtil.getLocalHome().create();
            this.registrationLocalBean = TelemetryDataRegistrationUtil.getLocalHome().create();
            this.stockLocalBean = TelemetryDataStockUtil.getLocalHome().create();
            this.pingTimer = TelemetryPingTimerUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void parse(String xml) {
        log.debug((Object)("parse XML " + xml));
        SAXDocument document = new SAXDocument(xml);
        try {
            if (xml.contains(this.config.getString("xml.ping.xmlName"))) {
                this.ping();
            } else if (xml.contains(this.config.getString("xml.unregister.xmlName"))) {
                this.unregister();
            } else if (xml.contains(this.config.getString("xml.register.xmlName"))) {
                this.register(document);
            } else if (xml.contains(this.config.getString("xml.requestStateStock.xmlName"))) {
                this.requestStateStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestStatesForUnit.xmlName"))) {
                this.requestStatesForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.requestGeoStock.xmlName"))) {
                this.requestGeoStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestGeosForUnit.xmlName"))) {
                this.requestGeosForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.requestNotifyStock.xmlName"))) {
                this.requestNotifyStock(document, false);
            } else if (xml.contains(this.config.getString("xml.requestNotifiesForUnit.xmlName"))) {
                this.requestNotifiesForUnit(document, false);
            } else if (xml.contains(this.config.getString("xml.errStateStock.xmlName"))) {
                this.requestStateStock(document, true);
            } else if (xml.contains(this.config.getString("xml.errGeoStock.xmlName"))) {
                this.requestGeoStock(document, true);
            } else if (xml.contains(this.config.getString("xml.errNotifyStock.xmlName"))) {
                this.requestNotifyStock(document, true);
            } else {
                log.warn((Object)"Telegram doesn't contain a valid method name.");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.UNKNOWN_METHOD, "%1s", document);
                this.errorLocalBean.sendErrorMessage(errMsg);
            }
        }
        catch (ClientNotRegisteredException e) {
            log.debug((Object)"client not registered");
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NOT_REGISTERED, "%1s", document);
            this.errorLocalBean.sendErrorMessage(errMsg);
        }
    }

    public void ping() {
        this.pingTimer.ping();
    }

    public void register(long lastGeo, long lastState, long lastNotify) throws TOWhileSyncException {
        log.debug((Object)("register() - lastGeo=" + lastGeo + " lastState=" + lastState + " lastNotify=" + lastNotify));
        this.registrationLocalBean.register(lastGeo, lastState, lastNotify);
    }

    public void register(SAXDocument saxDoc) {
        RegisterTelegramHandler handler = new RegisterTelegramHandler();
        try {
            ErrorMessage errMsg;
            ErrorMessage errMsg2;
            HashMap<String, Object> result = saxDoc.parse(handler);
            long lastGeo = -1L;
            long lastState = -1L;
            long lastNotify = -1L;
            if (this.config.getBoolean("geo.active")) {
                try {
                    if (result.containsKey("lastGeo")) {
                        String lastGeoString = (String)result.get("lastGeo");
                        lastGeo = Long.parseLong(lastGeoString);
                    } else {
                        log.debug((Object)"missing parameter lastGeo");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastGeo", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastGeo.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastGeo:" + result.get("lastGeo")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastGeo:" + result.get("lastGeo"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastGeo.xmlName"), (String)result.get("lastGeo"));
                    this.sendErrorMessage(errMsg);
                }
            }
            if (this.config.getBoolean("state.active")) {
                try {
                    if (result.containsKey("lastState")) {
                        String lastStateString = (String)result.get("lastState");
                        lastState = Long.parseLong(lastStateString);
                    } else {
                        log.debug((Object)"missing parameter lastState");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastState", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastState.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastState:" + result.get("lastState")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastState:" + result.get("lastState"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastState.xmlName"), (String)result.get("lastState"));
                    this.sendErrorMessage(errMsg);
                }
            }
            if (this.config.getBoolean("notify.active")) {
                try {
                    if (result.containsKey("lastNotify")) {
                        String lastNotifyString = (String)result.get("lastNotify");
                        lastNotify = Long.parseLong(lastNotifyString);
                    } else {
                        log.debug((Object)"missing parameter lastNotify");
                        errMsg2 = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s: lastNotify", saxDoc);
                        errMsg2.addParameter(this.config.getString("xml.register.lastNotify.xmlName"), null);
                        this.sendErrorMessage(errMsg2);
                    }
                }
                catch (NumberFormatException e) {
                    log.debug((Object)("incorrect number format of parameter lastNotify:" + result.get("lastNotify")));
                    errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s lastNotify:" + result.get("lastNotify"), saxDoc);
                    errMsg.addParameter(this.config.getString("xml.register.lastNotify.xmlName"), (String)result.get("lastNotify"));
                    this.sendErrorMessage(errMsg);
                }
            }
            try {
                this.register(lastGeo, lastState, lastNotify);
            }
            catch (TOWhileSyncException e) {
                log.error((Object)"register runs into", (Throwable)e);
                errMsg = new ErrorMessage(Enums.ErrorCode.TIMEOUT, "%1s", saxDoc);
                this.sendErrorMessage(errMsg);
            }
        }
        catch (SAXException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
            errMsg.setExceptionMessage(e.getMessage());
            this.sendErrorMessage(errMsg);
        }
        catch (IOException e) {
            log.error((Object)"runs into", (Throwable)e);
            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
            errMsg.setExceptionMessage(e.getMessage());
            this.sendErrorMessage(errMsg);
        }
    }

    private void sendErrorMessage(ErrorMessage errorMessage) {
        this.errorLocalBean.sendErrorMessage(errorMessage);
    }

    public void unregister() throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.registrationLocalBean.unregister();
    }

    public void requestStateStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block16: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestStateStockTelegramHandler handler = new RequestStateStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    String whichData = (String)result.get("whichData");
                    if (error) {
                        String errorText = (String)result.get("errorText");
                        this.errStateStock(whichData, errorText);
                    } else {
                        this.requestStateStock(whichData);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errStateStock(whichData.toString(), errorText);
                            } else {
                                this.requestStateStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestStateStock.until.xmlName"), (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter(this.config.getString("xml.requestStateStock.from.xmlName"), (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter(this.config.getString("xml.requestStateStock.from.xmlName"), null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter(this.config.getString("xml.requestStateStock.until.xmlName"), null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestStateStock(String whichData) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Range range = new Range(whichData);
        this.requestStateStock(range.getFrom(), range.getUntil());
    }

    public void requestStateStock(long from, long until) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestStateStock(from, until);
    }

    public void requestStatesForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block15: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestStatesForUnitTelegramHandler handler = new RequestStatesForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            Timestamp startTimestamp = new Timestamp((String)result.get("startTime"));
                            try {
                                Timestamp endTimestamp = new Timestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errStatesForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block15;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block15;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.STATE, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block15;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block15;
                }
                log.debug((Object)"requestStatesForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestStatesForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestStatesForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Timestamp startTimestamp = new Timestamp(startTime);
        Timestamp endTimestamp = new Timestamp(endTime);
        this.stockLocalBean.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void requestStatesForUnit(String unitName, Timestamp startTimestamp, Timestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestStatesForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void requestGeoStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block16: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestGeoStockTelegramHandler handler = new RequestGeoStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    String whichData = (String)result.get("whichData");
                    if (error) {
                        String errorText = (String)result.get("errorText");
                        this.errGeoStock(whichData, errorText);
                    } else {
                        this.requestGeoStock(whichData);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errGeoStock(whichData.toString(), errorText);
                            } else {
                                this.requestGeoStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestGeoStock.until.xmlName"), (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter(this.config.getString("xml.requestGeoStock.from.xmlName"), (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestGeoStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter(this.config.getString("xml.requestGeoStock.from.xmlName"), null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter(this.config.getString("xml.requestGeoStock.until.xmlName"), null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestGeoStock(String whichData) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Range range = new Range(whichData);
        this.requestGeoStock(range.getFrom(), range.getUntil());
    }

    public void requestGeoStock(long from, long until) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestGeoStock(from, until);
    }

    public void requestGeosForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block15: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestGeosForUnitTelegramHandler handler = new RequestGeosForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            Timestamp startTimestamp = new Timestamp((String)result.get("startTime"));
                            try {
                                Timestamp endTimestamp = new Timestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errGeosForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block15;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block15;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.GEO, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block15;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block15;
                }
                log.debug((Object)"requestGeosForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestGeosForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestGeosForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Timestamp startTimestamp = new Timestamp(startTime);
        Timestamp endTimestamp = new Timestamp(endTime);
        this.stockLocalBean.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void requestGeosForUnit(String unitName, Timestamp startTimestamp, Timestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestGeosForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void requestNotifyStock(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block16: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestNotifyStockTelegramHandler handler = new RequestNotifyStockTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("whichData")) {
                    String whichData = (String)result.get("whichData");
                    if (error) {
                        String errorText = (String)result.get("errorText");
                        this.errNotifyStock(whichData, errorText);
                    } else {
                        this.requestNotifyStock(whichData);
                    }
                    break block16;
                }
                if (result.containsKey("from") && result.containsKey("until")) {
                    try {
                        long from = Long.parseLong((String)result.get("from"));
                        try {
                            long until = Long.parseLong((String)result.get("until"));
                            if (error) {
                                Range whichData = new Range(from, until);
                                String errorText = (String)result.get("errorText");
                                this.errNotifyStock(whichData.toString(), errorText);
                            } else {
                                this.requestNotifyStock(from, until);
                            }
                            break block16;
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)("incorrect number format of parameter until:" + result.get("until")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s until:" + result.get("until"), saxDoc);
                            errMsg.addParameter("until", (String)result.get("until"));
                            this.sendErrorMessage(errMsg);
                        }
                    }
                    catch (NumberFormatException e) {
                        log.debug((Object)("incorrect number format of parameter from:" + result.get("from")));
                        ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s from:" + result.get("from"), saxDoc);
                        errMsg.addParameter("from", (String)result.get("from"));
                        this.sendErrorMessage(errMsg);
                    }
                    break block16;
                }
                log.debug((Object)"requestNotifyStock doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                if (!result.containsKey("from")) {
                    errMsg.addParameter("from", null);
                }
                if (!result.containsKey("until")) {
                    errMsg.addParameter("until", null);
                }
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestNotifyStock(String whichData) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Range range = new Range(whichData);
        this.requestNotifyStock(range.getFrom(), range.getUntil());
    }

    public void requestNotifyStock(long from, long until) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestNotifyStock(from, until);
    }

    public void requestNotifiesForUnit(SAXDocument saxDoc, boolean error) throws ClientNotRegisteredException {
        block15: {
            if (!this.registrationLocalBean.isRegistered()) {
                throw new ClientNotRegisteredException();
            }
            RequestNotifiesForUnitTelegramHandler handler = new RequestNotifiesForUnitTelegramHandler();
            try {
                HashMap<String, Object> result = saxDoc.parse(handler);
                if (result.containsKey("unitName")) {
                    String unitName = (String)result.get("unitName");
                    if (result.containsKey("startTime") && result.containsKey("endTime")) {
                        try {
                            Timestamp startTimestamp = new Timestamp((String)result.get("startTime"));
                            try {
                                Timestamp endTimestamp = new Timestamp((String)result.get("endTime"));
                                if (error) {
                                    String errorText = (String)result.get("errorText");
                                    this.errNotifiesForUnit(unitName, startTimestamp, endTimestamp, errorText);
                                } else {
                                    this.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
                                }
                                break block15;
                            }
                            catch (ParseException e) {
                                log.debug((Object)("incorrect number format of parameter endTime:" + result.get("endTime")));
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s endTime:" + result.get("endTime"), saxDoc);
                                errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.endTime.xmlName"), (String)result.get("endTime"));
                                this.sendErrorMessage(errMsg);
                                break block15;
                            }
                            catch (TooMuchDataException e) {
                                log.warn((Object)"too much data");
                                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.TOO_MUCH_DATA, "%1s", saxDoc);
                                errMsg.setSynchronizationDetails(Enums.EventType.NOTIFY, unitName, startTimestamp, startTimestamp);
                                this.sendErrorMessage(errMsg);
                            }
                        }
                        catch (ParseException e) {
                            log.debug((Object)("incorrect number format of parameter startTime:" + result.get("startTime")));
                            ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.NUMBER_FORMAT, "%1s startTime:" + result.get("startTime"), saxDoc);
                            errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.startTime.xmlName"), (String)result.get("startTime"));
                            this.sendErrorMessage(errMsg);
                        }
                        break block15;
                    }
                    log.debug((Object)"requestStateStock doesn't contain the necessary parameters");
                    ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                    if (!result.containsKey("startTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.startTime.xmlName"), null);
                    }
                    if (!result.containsKey("endTime")) {
                        errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.endTime.xmlName"), null);
                    }
                    this.sendErrorMessage(errMsg);
                    break block15;
                }
                log.debug((Object)"requestNotifiesForUnit doesn't contain the necessary parameters");
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.MISSING_PARAMETER, "%1s", saxDoc);
                errMsg.addParameter(this.config.getString("xml.requestNotifiesForUnit.unitName.xmlName"), null);
                this.sendErrorMessage(errMsg);
            }
            catch (SAXException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.XML_PARSE_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
            catch (IOException e) {
                log.error((Object)"runs into", (Throwable)e);
                ErrorMessage errMsg = new ErrorMessage(Enums.ErrorCode.IO_EXCEPTION, "%1s" + e.getMessage(), saxDoc);
                errMsg.setExceptionMessage(e.getMessage());
                this.sendErrorMessage(errMsg);
            }
        }
    }

    public void requestNotifiesForUnit(String unitName, String startTime, String endTime) throws ClientNotRegisteredException, ParseException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        Timestamp startTimestamp = new Timestamp(startTime);
        Timestamp endTimestamp = new Timestamp(endTime);
        this.stockLocalBean.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void requestNotifiesForUnit(String unitName, Timestamp startTimestamp, Timestamp endTimestamp) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        this.stockLocalBean.requestNotifiesForUnit(unitName, startTimestamp, endTimestamp);
    }

    public void errStateStock(String whichData, String errorText) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errStateStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestStateStock(whichData);
        } else {
            log.error((Object)"could not get state stock (max. re-tries exceeded)");
        }
    }

    public void errGeoStock(String whichData, String errorText) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errGeoStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestGeoStock(whichData);
        } else {
            log.error((Object)"could not get geo stock (max. re-tries exceeded)");
        }
    }

    public void errNotifyStock(String whichData, String errorText) throws ClientNotRegisteredException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errNotifyStock(whichData, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestNotifyStock(whichData);
        } else {
            log.error((Object)"could not get notify stock (max. re-tries exceeded)");
        }
    }

    public void errStatesForUnit(String unitName, Timestamp startTime, Timestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errStatesForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestStatesForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get state events for unit (max. re-tries exceeded)");
        }
    }

    public void errGeosForUnit(String unitName, Timestamp startTime, Timestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errGeosForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestGeosForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get geo events for unit (max. re-tries exceeded)");
        }
    }

    public void errNotifiesForUnit(String unitName, Timestamp startTime, Timestamp endTime, String errorText) throws ClientNotRegisteredException, TooMuchDataException {
        if (!this.registrationLocalBean.isRegistered()) {
            throw new ClientNotRegisteredException();
        }
        int errorCount = this.errorLocalBean.errNotifiesForUnit(unitName, startTime, endTime, errorText);
        if (errorCount < this.config.getInt("xml.errStock.maxErrorCount")) {
            this.requestNotifiesForUnit(unitName, startTime, endTime);
        } else {
            log.error((Object)"could not get geo events for unit (max. re-tries exceeded)");
        }
    }

    public boolean isTelemetryDataActive() {
        return this.config.isTelemetryDataActive();
    }

    public void init() {
        if (this.config.getBoolean("active")) {
            log.debug((Object)"init()");
        }
    }
}

