/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.telemetryData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderLocal;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.TelemetryDataMessageSenderUtil;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.ClientConfiguration;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.util.Timestamp;
import de.proveo.wwt.logic.ejb.interfaces.telemetryData.xml.ErrorMessage;
import java.util.HashMap;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelemetryDataErrorBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(TelemetryDataErrorBean.class);
    private ClientConfiguration config = ClientConfiguration.getInstance();
    private TelemetryDataMessageSenderLocal messageSender;
    private HashMap<String, Integer> stateErrors = new HashMap();
    private HashMap<String, Integer> geoErrors = new HashMap();
    private HashMap<String, Integer> notifyErrors = new HashMap();

    public void ejbCreate() throws CreateException {
        try {
            this.messageSender = TelemetryDataMessageSenderUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void sendErrorMessage(ErrorMessage errMsg) {
        log.debug((Object)("sendErrorMessage: " + errMsg.toString()));
        this.messageSender.sendTextMessage(errMsg.toString());
    }

    public int errStateStock(String whichData, String errorText) {
        log.debug((Object)("errStateStock - whichData: " + whichData + " errorText: " + errorText));
        this.stateErrors = this.incValue(this.stateErrors, whichData);
        int count = this.stateErrors.get(whichData);
        return count;
    }

    public int errGeoStock(String whichData, String errorText) {
        log.debug((Object)("errGeoStock - whichData: " + whichData + " errorText: " + errorText));
        this.geoErrors = this.incValue(this.geoErrors, whichData);
        int count = this.geoErrors.get(whichData);
        return count;
    }

    public int errNotifyStock(String whichData, String errorText) {
        log.debug((Object)("errNotifyStock - whichData: " + whichData + " errorText: " + errorText));
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    public int errStatesForUnit(String unitId, Timestamp startTime, Timestamp endTime, String errorText) {
        log.debug((Object)("errStatesForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.stateErrors = this.incValue(this.stateErrors, whichData);
        int count = this.stateErrors.get(whichData);
        return count;
    }

    public int errGeosForUnit(String unitId, Timestamp startTime, Timestamp endTime, String errorText) {
        log.debug((Object)("errGeosForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.geoErrors = this.incValue(this.geoErrors, whichData);
        int count = this.geoErrors.get(whichData);
        return count;
    }

    public int errNotifiesForUnit(String unitId, Timestamp startTime, Timestamp endTime, String errorText) {
        log.debug((Object)("errNotifiesForUnit - unitId: " + unitId + " startTime: " + startTime + " endTime: " + endTime + " errorText: " + errorText));
        String whichData = unitId + "/" + startTime + "-" + endTime;
        this.notifyErrors = this.incValue(this.notifyErrors, whichData);
        int count = this.notifyErrors.get(whichData);
        return count;
    }

    private HashMap<String, Integer> incValue(HashMap<String, Integer> hashMap, String whichData) {
        if (!hashMap.containsKey(whichData)) {
            hashMap.put(whichData, 0);
        }
        hashMap.put(whichData, new Integer(hashMap.get(whichData) + 1));
        return hashMap;
    }
}

