/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.interfaces.maintenance;

import de.proveo.wwt.logic.ejb.interfaces.maintenance.ClientConfiguration;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Timestamp
implements Serializable {
    private static final Log log = LogFactory.getLog(Timestamp.class);
    private static ClientConfiguration config = ClientConfiguration.getInstance();
    public static Timestamp empty = new Timestamp(0L);
    private long timestamp;

    public Timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Timestamp(String timeString) throws ParseException {
        this.timestamp = Timestamp.parseDate(timeString);
    }

    public static long parseDate(String dateString) throws ParseException {
        if (dateString == null || dateString.length() == 0) {
            return 0L;
        }
        String formatString = config.getString("timestamp.format");
        SimpleDateFormat formatter = new SimpleDateFormat(formatString, Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone(config.getString("timestamp.timezone")));
        Date date = formatter.parse(dateString);
        long timestamp = date.getTime();
        return timestamp;
    }

    public static String formatDate(long timestamp) {
        if (timestamp == 0L || timestamp == -1L) {
            return "";
        }
        if (config.getBoolean("timestamp.format.active")) {
            String formatString = config.getString("timestamp.format");
            SimpleDateFormat formatter = new SimpleDateFormat(formatString, Locale.ENGLISH);
            formatter.setTimeZone(TimeZone.getTimeZone(config.getString("timestamp.timezone")));
            String dateString = formatter.format(timestamp);
            return dateString;
        }
        return Long.toString(timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimeString() {
        return Timestamp.formatDate(this.timestamp);
    }

    public String toString() {
        return Timestamp.formatDate(this.timestamp);
    }
}

