/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.scheduledReports;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportLocalHome;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportPK;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportUtil;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportLocalHome;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportPK;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportUtil;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.GeneratedReportDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ReportBaseDTO;
import de.proveo.wwt.logic.ejb.general.scheduledReports.dto.ReportDTOList;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledReportFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(ScheduledReportFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private AccountLocalHome accountHome;
    private ScheduledReportLocalHome scheduledReportLocalHome;
    private GeneratedReportLocalHome generatedReportLocalHome;

    public void ejbCreate() throws CreateException {
        try {
            this.scheduledReportLocalHome = ScheduledReportUtil.getLocalHome();
            this.accountHome = AccountUtil.getLocalHome();
            this.generatedReportLocalHome = GeneratedReportUtil.getLocalHome();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public ReportDTOList getAllScheduledReports() {
        ReportDTOList list = new ReportDTOList();
        try {
            Collection coll = this.scheduledReportLocalHome.findAll();
            for (ScheduledReportLocal report : coll) {
                list.add(DTOFactory.buildScheduledReportDTO(report));
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ReportDTOList getScheduledReports() {
        ReportDTOList list = new ReportDTOList();
        try {
            Collection coll = this.scheduledReportLocalHome.findNotDeleted();
            for (ScheduledReportLocal report : coll) {
                list.add(DTOFactory.buildScheduledReportDTO(report));
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long saveReport(ReportBaseDTO reportDTO) {
        Long id = null;
        ScheduledReportValue value = new ScheduledReportValue();
        value.setEmails(reportDTO.getEmails());
        value.setLocale(reportDTO.getLocale().toString());
        value.setOutputFormat(reportDTO.getOutputFormat().name());
        if (reportDTO.getPageFormat() != null) {
            value.setPageFormat(reportDTO.getPageFormat().name());
        }
        value.setReportDesign(reportDTO.getReportDesign());
        value.setReportName(reportDTO.getReportName());
        value.setCreateTime(reportDTO.getCreateTime());
        value.setReportType(reportDTO.getReportType());
        String parameterString = "";
        for (Map.Entry<String, String> e : reportDTO.getReportParameters().entrySet()) {
            if (!parameterString.equals("")) {
                parameterString = parameterString + ";";
            }
            String paramKey = e.getKey();
            String paramValue = e.getValue();
            parameterString = parameterString + paramKey + "=" + paramValue;
        }
        value.setReportParameters(parameterString);
        value.setTimeInterval(reportDTO.getInterval().name());
        try {
            ScheduledReportLocal reportLocal;
            if (reportDTO.getId() != null) {
                value.setId(reportDTO.getId());
                reportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(reportDTO.getId()));
                reportLocal.setScheduledReportValue(value);
                id = reportLocal.getId();
            } else {
                reportLocal = this.scheduledReportLocalHome.create(value);
                id = reportLocal.getId();
            }
            ArrayList<AccountLocal> coll = new ArrayList<AccountLocal>();
            if (reportDTO.getAccounts() != null) {
                for (AccountValue accountValue : reportDTO.getAccounts()) {
                    AccountLocal accountLocal = this.accountHome.findByPrimaryKey(new AccountPK(accountValue.getId()));
                    coll.add(accountLocal);
                }
                reportLocal.setAccounts(coll);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return id;
    }

    public void deleteReport(ReportBaseDTO reportDTO) {
        try {
            ScheduledReportLocal reportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(reportDTO.getId()));
            reportLocal.setDeleted(true);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void deleteReportPhysically(ReportBaseDTO reportDTO) {
        List<GeneratedReportDTO> dtoList = this.getGeneratedReports(reportDTO.getId());
        for (GeneratedReportDTO dto : dtoList) {
            this.deleteGeneratedReport(dto);
        }
        try {
            ScheduledReportLocal reportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(reportDTO.getId()));
            reportLocal.remove();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void saveGeneratedReport(ReportBaseDTO reportDTO, byte[] reportFile, long createTime, int dataSize, long processDuration, Short errorCode) {
        logger.debug((Object)("generated Report saved" + reportDTO.getReportName()));
        GeneratedReportValue generatedReportValue = new GeneratedReportValue();
        generatedReportValue.setScheduledReportId(reportDTO.getId());
        generatedReportValue.setReport(reportFile);
        generatedReportValue.setCreateTime(createTime);
        generatedReportValue.setDataSize(dataSize);
        generatedReportValue.setProcessDuration(processDuration);
        generatedReportValue.setErrorCode(errorCode);
        try {
            this.generatedReportLocalHome.create(generatedReportValue);
        }
        catch (CreateException e) {
            logger.debug((Object)"runs inot", (Throwable)e);
        }
    }

    public List<GeneratedReportDTO> getGeneratedReports(Long scheduledReportId) {
        ArrayList<GeneratedReportDTO> list = new ArrayList<GeneratedReportDTO>();
        try {
            Collection coll = this.generatedReportLocalHome.findAll();
            for (GeneratedReportLocal report : coll) {
                GeneratedReportValue generatedReportValue = report.getGeneratedReportValue();
                ScheduledReportLocal scheduledReportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(generatedReportValue.getScheduledReportId()));
                ScheduledReportValue scheduledReportValue = scheduledReportLocal.getScheduledReportValue();
                if (scheduledReportId != null && scheduledReportValue.getId() != scheduledReportId.longValue()) continue;
                list.add(new GeneratedReportDTO(generatedReportValue, scheduledReportValue));
            }
        }
        catch (FinderException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void deleteGeneratedReport(GeneratedReportDTO reportDTO) {
        try {
            this.generatedReportLocalHome.remove(new GeneratedReportPK(reportDTO.getGeneratedReportValue().getId()));
        }
        catch (EJBException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }
}

