/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.reportaudit;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.reportaudit.ReportAuditLocal;
import de.proveo.wwt.logic.ejb.general.reportaudit.ReportAuditLocalHome;
import de.proveo.wwt.logic.ejb.general.reportaudit.ReportAuditUtil;
import de.proveo.wwt.logic.ejb.general.reportaudit.ReportAuditValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAuditFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(ReportAuditFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private ReportAuditLocalHome reportAuditLocalHome;

    public void ejbCreate() throws CreateException {
        try {
            this.reportAuditLocalHome = ReportAuditUtil.getLocalHome();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<ReportAuditValue> getReportAudits() {
        ArrayList<ReportAuditValue> list = new ArrayList<ReportAuditValue>();
        try {
            Collection coll = this.reportAuditLocalHome.findAll();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                ReportAuditValue value = ((ReportAuditLocal)it.next()).getReportAuditValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<ReportAuditValue> getReportAudits(long beginTime, long endTime) {
        ArrayList<ReportAuditValue> list = new ArrayList<ReportAuditValue>();
        try {
            Collection coll = this.reportAuditLocalHome.findByTimeframe(beginTime, endTime);
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                ReportAuditValue value = ((ReportAuditLocal)it.next()).getReportAuditValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void createReportAudit(ReportAuditValue value) {
        try {
            this.reportAuditLocalHome.create(value);
        }
        catch (CreateException e) {
            e.printStackTrace();
        }
    }
}

