/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.geofencing;

import de.proveo.eventbase.EventPayload;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofGroupLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofGroupUtil;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelPK;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofUnitModelUtil;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofZoneLocal;
import de.proveo.wwt.logic.ejb.general.geofencing.GeofZoneValue;
import de.proveo.wwt.logic.ejb.general.geofencing.exception.GeofUnitGroupNotFoundException;
import de.proveo.wwt.logic.ejb.general.geofencing.exception.GeofUnitNotFoundException;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GeofencingUpdateFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(GeofencingUpdateFacadeBean.class);
    private GeofGroupLocalHome geofGroupHome;
    private GeofUnitModelLocalHome geofUnitModelHome;
    private UnitModelLocalHome unitModelHome;
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout;

    public void ejbCreate() throws CreateException {
        try {
            this.geofGroupHome = GeofGroupUtil.getLocalHome();
            this.geofUnitModelHome = GeofUnitModelUtil.getLocalHome();
            this.unitModelHome = UnitModelUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejb lookup into", (Throwable)ex);
            throw new CreateException("runs during ejb lookup into " + ex.getMessage());
        }
        this.configure();
    }

    protected void configure() {
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.aclupdate.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    public void updateGeofAreasSuccessful(long unitId) throws UnitNotFoundException {
        try {
            this.updateGeofUnitModel(unitId, false);
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)("updateGeofAreasSuccessful: can't find unit (id:" + unitId + ")"), (Throwable)ex);
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
        catch (Exception ex) {
            log.error((Object)"updateGeofAreasSuccessful runs into", (Throwable)ex);
            throw new EJBException("updateGeofAreasSuccessful runs into" + ex.getMessage());
        }
    }

    public void updateGeofUnitModel(long unitId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() untiId: " + unitId + " refresh: " + refresh));
        }
        GeofUnitModelLocal geofUnitModel = this.geofUnitModelHome.findByPrimaryKey(new GeofUnitModelPK(unitId));
        geofUnitModel.setUnitGeofAreasRefresh(refresh);
        if (refresh) {
            geofUnitModel.setUnitGeofAreasSyncStartTime(0L);
        }
    }

    public void updateGeofUnitModelByGroupId(long groupId, boolean refresh) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updateUnitModel() groupId: " + groupId + " refresh: " + refresh));
        }
        Collection colGeofGroup = this.geofGroupHome.findByGeofGroupId(groupId);
        for (GeofGroupLocal geofGroupLocal : colGeofGroup) {
            Collection colGeofUnitModel = geofGroupLocal.getGeofUnitModels();
            for (GeofUnitModelLocal geofUnitModel : colGeofUnitModel) {
                geofUnitModel.setUnitGeofAreasRefresh(refresh);
                if (!refresh) continue;
                geofUnitModel.setUnitGeofAreasSyncStartTime(0L);
            }
        }
    }

    public boolean isGeofAreasUpdateNecessary(GeofUnitModelLocal geofUnitModel) {
        if (!geofUnitModel.getUnitGeofAreasRefresh()) {
            return false;
        }
        long delta = System.currentTimeMillis() - geofUnitModel.getUnitGeofAreasSyncStartTime();
        if (delta <= this.infomanRequestTimeout) {
            return false;
        }
        log.debug((Object)"geofUpdateIsnecessary");
        return true;
    }

    public EventPayload startGeofAreasUpdate(GeofUnitModelLocal geofUnitModel) {
        log.debug((Object)("startGeofAreasUpdate for" + geofUnitModel.getUnitId()));
        geofUnitModel.setUnitGeofAreasSyncStartTime(System.currentTimeMillis());
        geofUnitModel.setUnitGeofAreasSyncDone(false);
        EventPayload payload = new EventPayload();
        payload.setName("GeofUpdate");
        payload.setPayload(Long.toString(geofUnitModel.getUnitGeofAreasSyncStartTime()).getBytes());
        return payload;
    }

    public void updateGeofReport(long unitId, long eventTime, String updateReport) {
        long activeToken;
        GeofUnitModelLocal geofUnitModel;
        boolean succesful;
        log.trace((Object)("updateGeofReport for " + unitId));
        log.trace((Object)("updateReport " + updateReport));
        Long token = null;
        String errorMessage = null;
        if (updateReport.startsWith("error")) {
            StringTokenizer tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            succesful = false;
            log.trace((Object)"not successfull");
            try {
                token = Long.valueOf(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    errorMessage = tokenizer.nextToken();
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for geof update not available");
            }
        } else {
            succesful = true;
            try {
                token = Long.valueOf(updateReport);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)"token for geof update not available");
            }
        }
        try {
            geofUnitModel = this.geofUnitModelHome.findByPrimaryKey(new GeofUnitModelPK(unitId));
        }
        catch (ObjectNotFoundException ex) {
            throw new EJBException("geof update report for unkown unit", (Exception)((Object)ex));
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        log.debug((Object)"GeofAreaUpdateDone");
        if (!geofUnitModel.getUnitGeofAreasRefresh() || geofUnitModel.getUnitGeofAreasSyncDone()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no open geof update found for unitId " + unitId + " and token " + updateReport + " found. unitGeofAreasRefresh: " + geofUnitModel.getUnitGeofAreasRefresh() + " unitGeofAreasSyncDone: " + geofUnitModel.getUnitGeofAreasSyncDone()));
            }
            return;
        }
        if (token != null && (activeToken = geofUnitModel.getUnitGeofAreasSyncStartTime()) != token) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("geof token no longer active, wait. unitId " + unitId + " infomanToken: " + token + " expectedToken: " + activeToken));
            }
            geofUnitModel.setUnitGeofAreasSyncSuccessful(false);
            geofUnitModel.setUnitGeofAreasSyncError("invalid token");
            geofUnitModel.setUnitGeofAreasSyncEndTime(eventTime);
            return;
        }
        log.trace((Object)"token is not given from infoman or token is still active close geof areas update");
        geofUnitModel.setUnitGeofAreasRefresh(false);
        geofUnitModel.setUnitGeofAreasSyncDone(true);
        geofUnitModel.setUnitGeofAreasSyncSuccessful(succesful);
        geofUnitModel.setUnitGeofAreasSyncError(errorMessage);
        geofUnitModel.setUnitGeofAreasSyncEndTime(eventTime);
    }

    public String getUnitGeofAreasCsvV2(long unitId) throws Exception {
        StringBuffer areaBuffer = new StringBuffer();
        StringBuffer zoneBuffer = new StringBuffer();
        StringBuffer areaPointsBuffer = new StringBuffer();
        UnitModelLocal unitModel = null;
        try {
            unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
        }
        catch (FinderException ex) {
            throw new UnitNotFoundException(unitId);
        }
        GeofUnitModelLocal geofUnitModelLocal = unitModel.getGeofUnitModel();
        if (geofUnitModelLocal == null) {
            throw new GeofUnitNotFoundException(unitId, "no geof unit found");
        }
        GeofGroupLocal geofGroupLocal = geofUnitModelLocal.getGeofGroupLocal();
        if (geofGroupLocal == null) {
            throw new GeofUnitGroupNotFoundException(unitId, "no geof Group found");
        }
        Collection colGeofZone = geofGroupLocal.getGeofZones();
        Iterator itGeofZone = colGeofZone.iterator();
        GeofZoneLocal geofZone = null;
        while (itGeofZone.hasNext()) {
            geofZone = (GeofZoneLocal)itGeofZone.next();
            GeofZoneValue geofZoneValue = geofZone.getGeofZoneValue();
            Collection colAreas = geofZone.getAreas();
            zoneBuffer.append(geofZoneValue.getZoneId() + ",");
            zoneBuffer.append(geofZoneValue.getZone() + ",");
            zoneBuffer.append(geofZoneValue.getZoneEntryNotificationId() + ",");
            zoneBuffer.append(geofZoneValue.getZoneExitNotificationId() + ",");
            zoneBuffer.append(geofZoneValue.getZoneEntry() ? 1 : 0);
            zoneBuffer.append(",");
            zoneBuffer.append(geofZoneValue.getZoneExit() ? 1 : 0);
            zoneBuffer.append(",");
            zoneBuffer.append(geofZoneValue.getBlackBoardItem() + ",");
            zoneBuffer.append("\n");
            Iterator itAreas = colAreas.iterator();
            AreaLocal area = null;
            while (itAreas.hasNext()) {
                area = (AreaLocal)itAreas.next();
                areaBuffer.append(area.getAreaValue().getAreaId() + ",");
                areaBuffer.append(geofZoneValue.getZoneId());
                areaBuffer.append(area.getAreaValue().getPriority() + ",");
                areaBuffer.append("\n");
                ArrayList areaPoints = area.getPoints();
                Iterator itAreaPoints = areaPoints.iterator();
                while (itAreaPoints.hasNext()) {
                    int nextPoint = 0;
                    AreaPointsValue areaPointsValue = (AreaPointsValue)itAreaPoints.next();
                    areaPointsBuffer.append(areaPointsValue.getAreaId() + ",");
                    areaPointsBuffer.append(areaPointsValue.getPoint() + ",");
                    nextPoint = itAreaPoints.hasNext() ? areaPointsValue.getPoint() + 1 : 1;
                    areaPointsBuffer.append(nextPoint + ",");
                    areaPointsBuffer.append(areaPointsValue.getLongMsec());
                    areaPointsBuffer.append(areaPointsValue.getLatMsec() + ",");
                    areaPointsBuffer.append("\n");
                }
            }
        }
        areaBuffer.append(zoneBuffer);
        areaBuffer.append(areaPointsBuffer);
        return areaBuffer.toString();
    }

    public String getUnitGeofAreasCsvV1(long unitId) throws Exception {
        StringBuffer areaBuffer = new StringBuffer();
        StringBuffer areaPointsBuffer = new StringBuffer();
        UnitModelLocal unitModel = null;
        try {
            unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
        }
        catch (FinderException ex) {
            throw new UnitNotFoundException(unitId);
        }
        GeofUnitModelLocal geofUnitModelLocal = unitModel.getGeofUnitModel();
        if (geofUnitModelLocal == null) {
            throw new GeofUnitNotFoundException(unitId, "no geof unit found");
        }
        GeofGroupLocal geofGroupLocal = geofUnitModelLocal.getGeofGroupLocal();
        if (geofGroupLocal == null) {
            throw new GeofUnitGroupNotFoundException(unitId, "no geof Group found");
        }
        Collection colGeofZone = geofGroupLocal.getGeofZones();
        Iterator itGeofZone = colGeofZone.iterator();
        GeofZoneLocal geofZone = null;
        while (itGeofZone.hasNext()) {
            geofZone = (GeofZoneLocal)itGeofZone.next();
            GeofZoneValue geofZoneValue = geofZone.getGeofZoneValue();
            if ("outside".equals(geofZoneValue.getZone())) {
                areaBuffer.append(geofZoneValue.getZone());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneId());
                areaBuffer.append(",");
                areaBuffer.append(-1);
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneEntryNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneExitNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneEntry() ? 1 : 0);
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneExit() ? 1 : 0);
                if (StringUtils.trimToNull((String)geofZoneValue.getBlackBoardItem()) != null) {
                    areaBuffer.append(",");
                    areaBuffer.append(geofZoneValue.getBlackBoardItem());
                }
                areaBuffer.append("\n");
            }
            Collection colAreas = geofZone.getAreas();
            Iterator itAreas = colAreas.iterator();
            AreaLocal area = null;
            while (itAreas.hasNext()) {
                area = (AreaLocal)itAreas.next();
                areaBuffer.append(area.getAreaValue().getAreaId());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneId());
                areaBuffer.append(",");
                areaBuffer.append(area.getAreaValue().getPriority());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneEntryNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneExitNotificationId());
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneEntry() ? 1 : 0);
                areaBuffer.append(",");
                areaBuffer.append(geofZoneValue.getZoneExit() ? 1 : 0);
                if (StringUtils.trimToNull((String)geofZoneValue.getBlackBoardItem()) != null) {
                    areaBuffer.append(",");
                    areaBuffer.append(geofZoneValue.getBlackBoardItem());
                }
                areaBuffer.append("\n");
                ArrayList areaPoints = area.getPoints();
                Iterator itAreaPoints = areaPoints.iterator();
                while (itAreaPoints.hasNext()) {
                    int nextPoint = 0;
                    AreaPointsValue areaPointsValue = (AreaPointsValue)itAreaPoints.next();
                    areaPointsBuffer.append(areaPointsValue.getAreaId() + ",");
                    areaPointsBuffer.append(areaPointsValue.getPoint() + ",");
                    nextPoint = itAreaPoints.hasNext() ? areaPointsValue.getPoint() + 1 : 1;
                    areaPointsBuffer.append(nextPoint + ",");
                    areaPointsBuffer.append(areaPointsValue.getLongMsec() + ",");
                    areaPointsBuffer.append(areaPointsValue.getLatMsec());
                    areaPointsBuffer.append("\n");
                }
            }
        }
        areaBuffer.append(areaPointsBuffer);
        return areaBuffer.toString();
    }
}

