/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.fileStorage;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageLocal;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageLocalHome;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStoragePK;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageUtil;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStorageFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(FileStorageFacadeBean.class);
    private FileStorageLocalHome fileStorageLocalHome;

    public void ejbCreate() throws CreateException {
        try {
            this.fileStorageLocalHome = FileStorageUtil.getLocalHome();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public boolean saveFileStorage(FileStorageValue fileStorageValue) {
        try {
            fileStorageValue.setCreateTime(System.currentTimeMillis());
            fileStorageValue.setUploadedBy(super.getCallerName());
            FileStoragePK pk = fileStorageValue.getPrimaryKey();
            if (pk != null) {
                try {
                    FileStorageLocal fsl = this.fileStorageLocalHome.findByPrimaryKey(pk);
                    fsl.setFileStorageValue(fileStorageValue);
                }
                catch (FinderException e) {
                    this.fileStorageLocalHome.create(fileStorageValue);
                }
            } else {
                this.fileStorageLocalHome.create(fileStorageValue);
            }
            return true;
        }
        catch (CreateException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
            return false;
        }
    }

    public boolean deleteFileStorage(long fileStorageId) {
        try {
            this.fileStorageLocalHome.remove(new FileStoragePK(fileStorageId));
            return true;
        }
        catch (RemoveException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
            return false;
        }
    }

    public List<FileStorageValue> getAllStoredFiles(String category) {
        ArrayList<FileStorageValue> list = new ArrayList<FileStorageValue>();
        try {
            Collection coll = category == null ? this.fileStorageLocalHome.findAll() : this.fileStorageLocalHome.findByCategory(category);
            FileStorageLocal[] arr = coll.toArray(new FileStorageLocal[coll.size()]);
            for (int i = 0; i < arr.length; ++i) {
                list.add(arr[i].getFileStorageValue());
            }
        }
        catch (FinderException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
        }
        return list;
    }
}

