/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.config;

import de.proveo.rts.configuration.RTSConfiguration;
import de.proveo.rts.configuration.infoman.InfomanConfigurationServiceUtil;
import de.proveo.rts.configuration.infoman.InfomanEventInterfaceUtil;
import de.proveo.rts.configuration.infoman.InfomanEventServiceUtil;
import de.proveo.rts.configuration.interfaces.telemetryData.TelemetryDataConfigurationServiceUtil;
import de.proveo.rts.configuration.map.AirportMapGeneratorUtil;
import de.proveo.rts.configuration.map.AirportMapUtil;
import de.proveo.rts.configuration.web.WebUIUtil;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterLocal;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterLocalHome;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterPK;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterUtil;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.management.MalformedObjectNameException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(ConfigurationBean.class);
    private ConfigurationParameterLocalHome configurationParameterHome;
    protected static final String DEFAULT_PROPERTIES = "/config/default-application.properties";
    private Properties defaultProperties;
    private final Collection<RTSConfiguration> configurationMBeans = new ArrayList<RTSConfiguration>();

    public void ejbCreate() throws CreateException {
        try {
            this.configurationParameterHome = ConfigurationParameterUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"Can not find ConfigurationParameter Entity Bean", (Throwable)ex);
            throw new EJBException("Can not find ConfigurationParameter Entity Bean: " + ex.getMessage());
        }
        this.defaultProperties = new Properties();
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_PROPERTIES);
            if (in != null) {
                this.defaultProperties.load(in);
            } else {
                log.warn((Object)"no default properties found");
            }
        }
        catch (IOException ex) {
            throw new EJBException("runs during load default values into", (Exception)ex);
        }
        try {
            this.configurationMBeans.add((RTSConfiguration)InfomanEventInterfaceUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)InfomanEventServiceUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)InfomanConfigurationServiceUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)AirportMapGeneratorUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)AirportMapUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)WebUIUtil.getMBean());
            this.configurationMBeans.add((RTSConfiguration)TelemetryDataConfigurationServiceUtil.getMBean());
        }
        catch (MalformedObjectNameException ex) {
            log.error((Object)"runs during get configuraiton MBeans into", (Throwable)ex);
            throw new EJBException((Exception)ex);
        }
    }

    public void initMBeans() {
        Properties properties = this.getProperties();
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configurationInit(properties);
        }
    }

    protected void updateMBeans(String key, String value) {
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configuraitonUpdate(key, value);
        }
    }

    protected void updateMBeansKeyRemoved(String key) {
        Iterator<RTSConfiguration> it = this.configurationMBeans.iterator();
        while (it.hasNext()) {
            it.next().configurationRemove(key);
        }
    }

    public String getParameter(String key) throws ConfigurationParameterNotFoundException {
        String value;
        ConfigurationParameterPK pk = new ConfigurationParameterPK(key);
        try {
            ConfigurationParameterLocal configParam = this.configurationParameterHome.findByPrimaryKey(pk);
            value = configParam.getValue();
        }
        catch (FinderException ex) {
            value = this.defaultProperties.getProperty(key);
            if (value != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getParameter(): key '" + key + "' not found, use default value '" + value + "'."));
                }
            }
            if (log.isErrorEnabled()) {
                log.error((Object)("getParameter(): key '" + key + "' not found and no default value defined!"));
            }
            throw new ConfigurationParameterNotFoundException(key);
        }
        return value;
    }

    public String getParameter(String key, String defaultValue) {
        ConfigurationParameterPK pk = new ConfigurationParameterPK(key);
        try {
            ConfigurationParameterLocal configParam = this.configurationParameterHome.findByPrimaryKey(pk);
            return configParam.getValue();
        }
        catch (FinderException ex) {
            String value = this.defaultProperties.getProperty(key);
            if (value != null && !value.equals(defaultValue) && log.isWarnEnabled()) {
                log.warn((Object)("given parameter overrides default value defined in /config/default-application.properties [" + key + "]"));
            }
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) throws ConfigurationParameterNotFoundException {
        return Boolean.parseBoolean(this.getParameter(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getParameter(key, new Boolean(defaultValue).toString()));
    }

    public int getInteger(String key) throws ConfigurationParameterNotFoundException {
        return Integer.parseInt(this.getParameter(key));
    }

    public long[] getLongArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        long[] elementArray = new long[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = Long.parseLong(tokenizer.nextToken());
        }
        return elementArray;
    }

    public String[] getParameterArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        String[] elementArray = new String[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = tokenizer.nextToken();
        }
        return elementArray;
    }

    public boolean isConfigured(String key) {
        try {
            String value = this.getParameter(key);
            return value != null && !value.trim().equals("");
        }
        catch (ConfigurationParameterNotFoundException ex) {
            return false;
        }
    }

    public void setParameter(String key, String value) {
        try {
            ConfigurationParameterLocal parameter = this.configurationParameterHome.findByPrimaryKey(new ConfigurationParameterPK(key));
            parameter.setValue(value);
        }
        catch (ObjectNotFoundException ex) {
            try {
                this.configurationParameterHome.create(key, value);
            }
            catch (CreateException cEx) {
                log.error((Object)"setParameter() runs into", (Throwable)cEx);
                throw new EJBException((Exception)((Object)cEx));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"setParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        this.updateMBeans(key, value);
    }

    public void removeParameter(String key) {
        try {
            ConfigurationParameterLocal parameter = this.configurationParameterHome.findByPrimaryKey(new ConfigurationParameterPK(key));
            parameter.remove();
        }
        catch (ObjectNotFoundException ex) {
        }
        catch (FinderException ex) {
            log.error((Object)"removeParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        catch (RemoveException ex) {
            log.error((Object)"removeParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        if (this.isConfigured(key)) {
            try {
                this.updateMBeans(key, this.getParameter(key));
            }
            catch (ConfigurationParameterNotFoundException ex) {
                log.error((Object)"removeParameter() runs during notify MBeans into", (Throwable)ex);
                this.updateMBeansKeyRemoved(key);
            }
        } else {
            this.updateMBeansKeyRemoved(key);
        }
    }

    public boolean deleteConfigurationParameter(ConfigurationParameterValue value) {
        try {
            this.configurationParameterHome.remove(new ConfigurationParameterPK(value.getKey()));
            return true;
        }
        catch (EJBException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultProperties);
        try {
            Object[] configParameters = this.configurationParameterHome.findAll().toArray();
            for (int i = 0; i != configParameters.length; ++i) {
                ConfigurationParameterLocal parameter = (ConfigurationParameterLocal)configParameters[i];
                String key = parameter.getKey();
                String val = parameter.getValue();
                if (key != null && val != null) {
                    properties.put(key, val);
                    continue;
                }
                log.error((Object)("getProperties() found NULL value: key='" + key + "', value='" + val + "'. Check content of table CONFIGURATION_PARAMETER!"));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"getProperties() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        return properties;
    }

    public List<ConfigurationParameterValue> getAllConfigurationParameters() {
        ArrayList<ConfigurationParameterValue> list = new ArrayList<ConfigurationParameterValue>();
        Properties props = this.getProperties();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = (String)props.get(string);
            ConfigurationParameterValue configValue = new ConfigurationParameterValue(string, value);
            list.add(configValue);
        }
        return list;
    }
}

