/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area;

import de.proveo.util.ejb.BaseEntityBean;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AreaPointsBean
extends BaseEntityBean
implements EntityBean {
    private static final Log log = LogFactory.getLog(AreaPointsBean.class);
    private AreaLocalHome areaHome;

    public abstract void setAreaPointsValue(AreaPointsValue var1);

    public abstract AreaPointsValue getAreaPointsValue();

    public AreaPointsPK ejbCreate(AreaPointsValue value) throws CreateException {
        this.setAreaId(value.getAreaId());
        this.setPoint(value.getPoint());
        this.setAreaPointsValue(value);
        return null;
    }

    public void ejbPostCreate(AreaPointsValue value) throws CreateException {
    }

    public void ejbStore() {
        this.updateAreaExtremalValues();
    }

    private AreaLocal getAreaLocalInterface() throws RemoteException {
        try {
            if (this.areaHome == null) {
                this.areaHome = AreaUtil.getLocalHome();
            }
            return this.areaHome.findByPrimaryKey(new AreaPK(this.getAreaId()));
        }
        catch (NamingException ex) {
            log.error((Object)"getAreaLocalInterface() runs into NamingException", (Throwable)ex);
            throw new RemoteException("break after previous error.");
        }
        catch (FinderException ex) {
            log.error((Object)"getAreaLocalInterface() runs into FinderException", (Throwable)ex);
            throw new RemoteException("break after previous error.");
        }
    }

    private void updateAreaExtremalValues() {
        String sMethodName = "updateAreaExtremalValues()";
        boolean doUpdate = false;
        try {
            AreaLocal remote = this.getAreaLocalInterface();
            AreaValue struct = remote.getAreaValue();
            int val = struct.getMinLongMsec();
            if (this.getLongMsec() < val || val == 0) {
                struct.setMinLongMsec(this.getLongMsec());
                doUpdate = true;
            }
            val = struct.getMaxLongMsec();
            if (this.getLongMsec() > val || val == 0) {
                struct.setMaxLongMsec(this.getLongMsec());
                doUpdate = true;
            }
            val = struct.getMinLatMsec();
            if (this.getLatMsec() < val || val == 0) {
                struct.setMinLatMsec(this.getLatMsec());
                doUpdate = true;
            }
            val = struct.getMaxLatMsec();
            if (this.getLatMsec() > val || val == 0) {
                struct.setMaxLatMsec(this.getLatMsec());
                doUpdate = true;
            }
            if (doUpdate) {
                log.debug((Object)(sMethodName + ": new extremal values for AREA found. Update AREA now. "));
                remote.setAreaValue(struct);
            }
        }
        catch (RemoteException re) {
            log.error((Object)(sMethodName + " runs into RemoteException"));
            return;
        }
    }

    public abstract int getAreaId();

    public abstract void setAreaId(int var1);

    public abstract int getLatMsec();

    public abstract void setLatMsec(int var1);

    public abstract int getLongMsec();

    public abstract void setLongMsec(int var1);

    public abstract int getPoint();

    public abstract void setPoint(int var1);
}

