/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.dto;

import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.ejb.general.tree.TreeNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectionRoleNode
extends TreeNode<SectionRoleNode, RoleValue> {
    private static final long serialVersionUID = -7545926216613699355L;
    private static final Log log = LogFactory.getLog(SectionRoleNode.class);
    private String displayName;
    private boolean selectedByRole = false;
    private boolean selectedByGroup = false;
    private boolean selectedByUser = false;

    public SectionRoleNode(RoleValue role) {
        this.setData(role);
    }

    public void setAllGroupSelections(boolean includeRoot, boolean selectionValue) {
        this.setSelections(null, !includeRoot, SelectionType.Group, null, selectionValue);
    }

    public void setAllRoleSelections(boolean includeRoot, boolean selectionValue) {
        this.setSelections(null, !includeRoot, SelectionType.Role, null, selectionValue);
    }

    public void setAllUserSelections(boolean includeRoot, boolean selectionValue) {
        this.setSelections(null, !includeRoot, SelectionType.User, null, selectionValue);
    }

    public void setGroupSelections(boolean childrenOnly, boolean selectionValue) {
        this.setSelections(this, childrenOnly, SelectionType.Group, null, selectionValue);
    }

    public void setRoleSelections(boolean childrenOnly, boolean selectionValue) {
        this.setSelections(this, childrenOnly, SelectionType.Role, null, selectionValue);
    }

    public void setUserSelections(boolean childrenOnly, boolean selectionValue) {
        this.setSelections(this, childrenOnly, SelectionType.User, null, selectionValue);
    }

    public void setGroupSelectionsByRole(List<RoleValue> roles, boolean includeRoot, boolean selectionValue) {
        this.setSelectionsByRole(SelectionType.Group, roles, includeRoot, selectionValue);
    }

    public void setRoleSelectionsByRole(List<RoleValue> roles, boolean includeRoot, boolean selectionValue) {
        this.setSelectionsByRole(SelectionType.Role, roles, includeRoot, selectionValue);
    }

    public void setUserSelectionsByRole(List<RoleValue> roles, boolean includeRoot, boolean selectionValue) {
        this.setSelectionsByRole(SelectionType.User, roles, includeRoot, selectionValue);
    }

    private void setSelectionsByRole(SelectionType selectionType, List<RoleValue> roles, boolean includeRoot, boolean selectionValue) {
        this.setSelections(null, !includeRoot, selectionType, roles, selectionValue);
    }

    private void setSelections(SectionRoleNode startNode, boolean childrenOnly, SelectionType selectionType, List<RoleValue> roles, boolean selectionValue) {
        List nodes = null;
        nodes = startNode == null ? this.getAllNodes(!childrenOnly) : startNode.getNodes(childrenOnly);
        if (nodes == null) {
            return;
        }
        for (int i = 0; i != nodes.size(); ++i) {
            SectionRoleNode currentNode = (SectionRoleNode)nodes.get(i);
            if (currentNode == null) continue;
            if (roles != null) {
                for (int j = 0; j != roles.size(); ++j) {
                    RoleValue currentRole = roles.get(j);
                    if (currentRole == null || currentRole.getId() != currentNode.getRole().getId()) continue;
                    this.setNodeSelection(currentNode, selectionType, selectionValue);
                }
                continue;
            }
            this.setNodeSelection(currentNode, selectionType, selectionValue);
        }
    }

    private void setNodeSelection(SectionRoleNode node, SelectionType selectionType, boolean selectionValue) {
        switch (selectionType) {
            case Group: {
                node.setSelectedByGroup(selectionValue);
                break;
            }
            case Role: {
                node.setSelectedByRole(selectionValue);
                break;
            }
            case User: {
                node.setSelectedByUser(selectionValue);
            }
        }
    }

    public SectionRoleNode addRoleNode(RoleValue role) {
        SectionRoleNode node = null;
        if (role != null) {
            node = new SectionRoleNode(role);
            this.addChild(node);
        }
        return node;
    }

    public RoleValue getRole() {
        return (RoleValue)this.getData();
    }

    public String getRoleName() {
        return ((RoleValue)this.getData()).getRolename();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isSelectedByUser() {
        return this.selectedByUser;
    }

    public void setSelectedByUser(boolean selectedByUser) {
        this.selectedByUser = selectedByUser;
    }

    public boolean isSelectedByRole() {
        return this.selectedByRole;
    }

    public void setSelectedByRole(boolean selectedByRole) {
        this.selectedByRole = selectedByRole;
    }

    public boolean isSelectedByGroup() {
        return this.selectedByGroup;
    }

    public void setSelectedByGroup(boolean selectedByGroup) {
        this.selectedByGroup = selectedByGroup;
    }

    public boolean isSelected() {
        return this.selectedByGroup || this.selectedByRole || this.selectedByUser;
    }

    public boolean isReadOnly() {
        return this.selectedByGroup || this.selectedByRole;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionType {
        Group,
        Role,
        User;

    }
}

