/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.exception.AccessDeniedException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RolePK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountDataWithPermissions;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyUtil;
import de.proveo.wwt.security.LoginUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UserAdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private AccountLocalHome accountHome;
    private GroupIdentLocalHome groupIdentHome;
    private RoleLocalHome roleLocalHome;
    private LoginLoggerLocalHome loginLoggerHome;
    private AuditFacadeLocal auditFacadeLocal;
    private ConfigurationLocal configuration;
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal;

    public void ejbCreate() throws CreateException {
        try {
            this.accountHome = AccountUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.roleLocalHome = RoleUtil.getLocalHome();
            this.loginLoggerHome = LoginLoggerUtil.getLocalHome();
            this.auditFacadeLocal = AuditFacadeUtil.getLocalHome().create();
            this.configuration = ConfigurationUtil.getLocalHome().create();
            this.permissionUpdateNotifyLocal = PermissionUpdateNotifyUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            log.error((Object)"lookupOtherBeans() runs into", (Throwable)ex);
            throw new CreateException("lookupOtherBeans() runs into " + ex.getMessage());
        }
    }

    public AccountDataWithPermissions checkUser(String username, String passwordHash) throws AccessDeniedException {
        LoginLoggerValue logData = new LoginLoggerValue();
        logData.setUsername(username);
        try {
            AccountLocal account = null;
            Iterator it = this.accountHome.findByUsername(username).iterator();
            if (!it.hasNext()) {
                throw new FinderException();
            }
            account = (AccountLocal)it.next();
            if (account.getPassword().equals(passwordHash)) {
                AccountValue value = account.getAccountValue();
                AccountDataWithPermissions data = new AccountDataWithPermissions(value);
                logData.setSuccessful(true);
                this.loginLogger(logData);
                return data;
            }
            logData.setErrorMessage("wrong password");
            logData.setSuccessful(false);
            this.loginLogger(logData);
            throw new AccessDeniedException(username);
        }
        catch (FinderException ex) {
            log.debug((Object)"checkUser(): User not found in DB!");
            logData.setSuccessful(false);
            this.loginLogger(logData, (Exception)((Object)ex));
            throw new AccessDeniedException(username);
        }
    }

    public AccountDataWithPermissions checkUser(String username, char[] password) throws AccessDeniedException {
        String passwordHash = LoginUtil.createMessageDigest(password);
        return this.checkUser(username, passwordHash);
    }

    public List<AccountValue> getAllUsers() {
        ArrayList<AccountValue> list = null;
        try {
            Collection collection = this.accountHome.findAll();
            list = new ArrayList<AccountValue>();
            for (AccountLocal account : collection) {
                AccountValue value = account.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public AccountValue getAccount(String username) {
        AccountValue accountValue = null;
        try {
            AccountLocal account = null;
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                accountValue = account.getAccountValue();
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return accountValue;
    }

    public AccountValue getAccount(long accountId) {
        AccountValue accountValue = null;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            accountValue = account.getAccountValue();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return accountValue;
    }

    public boolean deleteUser(long accountId) {
        return this.deleteUser(accountId, false);
    }

    private boolean deleteUser(long accountId, boolean markAsDeleted) {
        boolean success = false;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            try {
                StringBuilder sb = new StringBuilder(account.getPrimaryKey().toString());
                sb.append(" ");
                sb.append(account.getAccountValue().getUsername());
                this.auditFacadeLocal.createAuditData(auditAppl, sb.toString(), "", account.getAccountValue(), null);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            ArrayList<AccountValue> accounts = new ArrayList<AccountValue>();
            accounts.add(account.getAccountValue());
            this.permissionUpdateNotifyLocal.sendUserDeletedJMSMessage(accounts);
            if (markAsDeleted) {
                account.setDeleted(true);
            } else {
                account.remove();
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean markAsDeleted(long accountId) {
        return this.deleteUser(accountId, true);
    }

    public Long insertUser(AccountValue value) throws DuplicateKeyException {
        Long id = null;
        String validation = this.validateUser(value, -1L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        AccountLocal accountLocal = null;
        try {
            boolean changePWDAfterFirstLogin = this.configuration.getBoolean("login.passwordChangeAfterFirstLogin");
            if (changePWDAfterFirstLogin) {
                value.setPasswordReset(true);
            } else {
                value.setPasswordReset(false);
            }
            accountLocal = this.accountHome.create(value);
            value.setPrimaryKey((AccountPK)accountLocal.getPrimaryKey());
            id = accountLocal.getAccountValue().getId();
        }
        catch (CreateException ex) {
            this.accountHome.reorganizeSequence();
            try {
                accountLocal = this.accountHome.create(value);
            }
            catch (CreateException e) {
                String msg = "createAccount runs into error leave old ";
                log.error((Object)msg, (Throwable)e);
                throw new ImplicitRollbackException(msg);
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"ConfigurationParameter not found: ", (Throwable)e);
        }
        try {
            if (accountLocal != null) {
                String pk = accountLocal.getPrimaryKey().toString() + " " + accountLocal.getAccountValue().getUsername();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", null, accountLocal.getAccountValue());
            }
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return id;
    }

    public boolean updateUser(AccountValue value) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUser(value, value.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(value.getId()));
            AccountValue oldAccountValue = account.getAccountValue();
            String userName = value.getUsername();
            if (super.getCallerName().equals(userName)) {
                value.setPasswordReset(false);
            }
            if (oldAccountValue.equals(value)) {
                return true;
            }
            if (value.getPassword() != oldAccountValue.getPassword()) {
                value.setLastPasswordChange(System.currentTimeMillis());
            }
            if (!value.getBlockOut() && oldAccountValue.getBlockOut()) {
                value.setFailedLogins(0);
            }
            account.setAccountValue(value);
            if (value.getPassword() != oldAccountValue.getPassword()) {
                this.permissionUpdateNotifyLocal.sendUserPwChangedJMSMessage(value);
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", oldAccountValue, value);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean duplicatedUsername(String userName, long accountId) {
        boolean duplicated = false;
        List<AccountValue> collection = this.getAllUsers();
        for (AccountValue account : collection) {
            if (account.getId() == accountId || !account.getUsername().equals(userName)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public boolean duplicatedUserPersonalNumber(String personalNumber, long id) {
        boolean duplicated = false;
        if (personalNumber == null) {
            return duplicated;
        }
        List<AccountValue> collection = this.getAllUsers();
        for (AccountValue value : collection) {
            String valuePersonalNumber;
            if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || personalNumber.equals("") || !valuePersonalNumber.equals(personalNumber)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public String validateUser(AccountValue value, long id) {
        if (this.duplicatedUserPersonalNumber(value.getPersonalNumber(), id)) {
            return "personalNumber";
        }
        if (this.duplicatedUsername(value.getUsername(), id)) {
            return "username";
        }
        if (this.internalUsername(value.getUsername())) {
            return "internalUsername";
        }
        return null;
    }

    public List<AccountValue> getAccountsByUsername(long groupId) {
        return this.getAccountsByGroupId(groupId);
    }

    public List<AccountValue> getAccountsByGroupId(long groupId) {
        ArrayList<AccountValue> list = null;
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            Collection accounts = groupIdent.getUser();
            list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean internalUsername(String userName) {
        boolean internal = false;
        if (userName.equals("proveoadmin") || userName.equals("nobody")) {
            internal = true;
        }
        return internal;
    }

    public List<AccountValue> getUsernamesByRoleId(long roleId) {
        ArrayList<AccountValue> list = null;
        try {
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            Collection accounts = role.getUser();
            list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public int incrementFailedLogins(String username) {
        int failedLogins = 0;
        long overallFailedLogins = 0L;
        try {
            Collection coll = this.accountHome.findByUsername(username);
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                AccountLocal accountLocal = (AccountLocal)iter.next();
                AccountValue accountValue = accountLocal.getAccountValue();
                failedLogins = accountValue.getFailedLogins() == null ? 0 : accountValue.getFailedLogins();
                overallFailedLogins = accountValue.getOverallFailedLogins() == null ? 0L : accountValue.getOverallFailedLogins();
                accountValue.setOverallFailedLogins(++overallFailedLogins);
                accountValue.setFailedLogins(++failedLogins);
                accountValue.setLastFailedLogin(System.currentTimeMillis());
                int failedLoginLimit = Integer.parseInt(this.configuration.getParameter("login.failedLoginLimit"));
                if (failedLoginLimit != 0 && failedLogins >= failedLoginLimit) {
                    accountValue.setBlockOut(true);
                }
                accountLocal.setAccountValue(accountValue);
            }
        }
        catch (FinderException e) {
            log.debug((Object)("no username found: " + username));
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return failedLogins;
    }

    public void setLoginSuccessful(String username) {
        try {
            Collection coll = this.accountHome.findByUsername(username);
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                AccountLocal accountLocal = (AccountLocal)iter.next();
                AccountValue accountValue = accountLocal.getAccountValue();
                Integer logins = accountValue.getLogins();
                if (logins == null) {
                    logins = 0;
                }
                accountValue.setLogins(logins + 1);
                accountValue.setFailedLogins(0);
                accountLocal.setAccountValue(accountValue);
            }
        }
        catch (FinderException e) {
            log.error((Object)("no username found: " + username));
        }
    }

    public boolean isPasswordChangeRequired(String username) {
        try {
            Long lastPwdChange;
            AccountValue account = this.getAccount(username);
            if (account != null && account.getPasswordReset()) {
                return true;
            }
            int days = this.configuration.getInteger("login.passwordChangeDays");
            if (account != null && days > 0 && (lastPwdChange = account.getLastPasswordChange()) != null) {
                long millis = days * 86400000;
                millis = lastPwdChange + millis;
                long current = System.currentTimeMillis();
                if (current < millis) {
                    return true;
                }
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    private void loginLogger(LoginLoggerValue value) {
        value.setDatetime(System.currentTimeMillis());
        try {
            try {
                this.loginLoggerHome.create(value);
            }
            catch (DuplicateKeyException ex) {
                this.loginLoggerHome.reorganizeSequence();
                this.loginLoggerHome.create(value);
            }
        }
        catch (Exception ex) {
            log.error((Object)"loginLogger() runs into", (Throwable)ex);
        }
    }

    private void loginLogger(LoginLoggerValue value, Exception e) {
        value.setErrorMessage(e.getMessage());
        this.loginLogger(value);
    }
}

