/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UseUserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UseUserAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseUserGroupAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(UseUserGroupAdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private UseUserLocalHome useUserHome;
    private UseGroupLocalHome userGroupLocalHome;
    private AuditFacadeLocal auditFacadeLocal;
    private UseUserAdminFacadeLocal useUserAdministrationFacade;

    public void ejbCreate() throws CreateException {
        try {
            this.useUserHome = UseUserUtil.getLocalHome();
            this.userGroupLocalHome = UseGroupUtil.getLocalHome();
            this.auditFacadeLocal = AuditFacadeUtil.getLocalHome().create();
            this.useUserAdministrationFacade = UseUserAdminFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<UseGroupValue> getAllUseGroups() {
        ArrayList<UseGroupValue> list = null;
        try {
            Collection collection = this.userGroupLocalHome.findAll();
            list = new ArrayList<UseGroupValue>();
            for (UseGroupLocal useGroupLocal : collection) {
                UseGroupValue value = useGroupLocal.getUseGroupValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long insertUseGroup(UseGroupValue value) throws CreateException, DuplicateKeyException {
        UseGroupLocal local = null;
        Long id = null;
        String validation = this.validateUseGroup(value, -99L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            local = this.userGroupLocalHome.create(value);
            id = local.getUseGroupValue().getId();
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getUseGroupValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", null, local.getUseGroupValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, Usergroup already exists");
        }
        return id;
    }

    public boolean updateUseGroup(UseGroupValue value) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUseGroup(value, value.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            UseGroupLocal useGroupLocal = this.userGroupLocalHome.findByPrimaryKey(new UseGroupPK(value.getId()));
            UseGroupValue oldValue = useGroupLocal.getUseGroupValue();
            if (oldValue.equals(value)) {
                return true;
            }
            useGroupLocal.setUseGroupValue(value);
            try {
                String pk = useGroupLocal.getPrimaryKey().toString() + " " + useGroupLocal.getUseGroupValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", oldValue, value);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public String duplicatedUseGroupName(String name, long id) {
        boolean duplicated = false;
        List<UseGroupValue> collection = this.getAllUseGroupsIncludeDeleted();
        for (UseGroupValue value : collection) {
            String valueName;
            if (value.getId() == id || (valueName = value.getName()) == null || name.equals("") || !valueName.equals(name)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "nameDeleted";
            }
            return "name";
        }
        return null;
    }

    public String validateUseGroup(UseGroupValue value, long id) {
        String validation = "";
        validation = this.duplicatedUseGroupName(value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    public boolean deleteUseGroup(long id) {
        boolean success = false;
        try {
            UnitFacadeLocal adminUnitFacade = null;
            adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
            adminUnitFacade.updateUnitUserRefreshForUseGroup(id);
            this.removeUseGroupToUseUser(id);
            UseGroupLocal useGroupLocal = this.userGroupLocalHome.findByPrimaryKey(new UseGroupPK(id));
            try {
                String pk = useGroupLocal.getPrimaryKey().toString() + " " + useGroupLocal.getUseGroupValue().getName();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", useGroupLocal.getUseGroupValue(), "Marked as deleted");
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            UseGroupValue value = useGroupLocal.getUseGroupValue();
            value.setDeleted(true);
            useGroupLocal.setUseGroupValue(value);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setUseUsersByUseGroupId(long groupId, long[] useUserIds) {
        boolean success = false;
        UseGroupLocal useGroup = null;
        try {
            useGroup = this.userGroupLocalHome.findByPrimaryKey(new UseGroupPK(groupId));
        }
        catch (FinderException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        List<UseUserValue> oldUseUsers = this.useUserAdministrationFacade.getUseUsersByUseGroupId(groupId);
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (int i = 0; i != oldUseUsers.size(); ++i) {
            oldAssignment.add(oldUseUsers.get(i).getName());
        }
        this.removeUseGroupToUseUser(groupId);
        HashSet<Long> permOfUseGroups = new HashSet<Long>();
        permOfUseGroups.add(groupId);
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long useUserId : useUserIds) {
            try {
                UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
                UseUserValue value = useUserLocal.getUseUserValue();
                long oldGroupId = value.getGroupId();
                if (oldGroupId != -1L) {
                    permOfUseGroups.add(oldGroupId);
                }
                value.setGroupId(groupId);
                useUserLocal.setUseUserValue(value);
                newAssignment.add(value.getName());
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return true;
        }
        UnitFacadeLocal adminUnitFacade = null;
        try {
            adminUnitFacade = UnitFacadeUtil.getLocalHome().create();
            for (Long permOfUseGroup : permOfUseGroups) {
                adminUnitFacade.updateUnitUserRefreshForUseGroup(permOfUseGroup);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + permOfUseGroup));
            }
        }
        catch (CreateException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        catch (NamingException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        try {
            String pk = useGroup.getPrimaryKey().toString() + " " + useGroup.getUseGroupValue().getName();
            this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUseGroupToUseUser", oldAssignment, newAssignment);
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    private void removeUseGroupToUseUser(long groupId) {
        List<UseUserValue> list = this.useUserAdministrationFacade.getUseUsersByUseGroupId(groupId);
        long[] useUsers = new long[list.size()];
        int i = 0;
        for (UseUserValue value : list) {
            useUsers[i] = value.getId();
            ++i;
        }
        for (long userId : useUsers) {
            try {
                UseUserLocal useUserLocal = this.useUserHome.findByPrimaryKey(new UseUserPK(userId));
                UseUserValue value = useUserLocal.getUseUserValue();
                value.setGroupId(-1L);
                useUserLocal.setUseUserValue(value);
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public List<UseGroupValue> getAllUseGroupsIncludeDeleted() {
        ArrayList<UseGroupValue> list = null;
        try {
            Collection collection = this.userGroupLocalHome.findAllIncludeDeleted();
            list = new ArrayList<UseGroupValue>();
            for (UseGroupLocal useGroupLocal : collection) {
                UseGroupValue value = useGroupLocal.getUseGroupValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }
}

