/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserGroupAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.dto.SectionRoleDTO;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.dto.SectionRoleNode;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RolePK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyUtil;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateToolsUtil;
import de.proveo.wwt.logic.web.data.MasterDataFastLaneReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -5466790817769050409L;
    private static final Log log = LogFactory.getLog(RoleAdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private static final String RESOURCE_ENTRY_FOR_SECTIONROLES = "section.";
    private UserGroupAdminFacadeLocal userGroupAdminFacade;
    private AuditFacadeLocal auditFacadeLocal;
    private RoleLocalHome roleLocalHome;
    private AccountLocalHome accountLocalHome;
    private GroupIdentLocalHome groupIdentHome;
    private PermissionUpdateNotifyLocal permissionUpdateNotifyLocal;
    private PermissionUpdateToolsLocal permissionUpdateToolsLocal;
    private UserAdminFacadeLocal userAdminFacadeLocal;
    private UnitFacadeLocal unitFacadeLocal;

    public void ejbCreate() throws CreateException {
        try {
            this.userGroupAdminFacade = UserGroupAdminFacadeUtil.getLocalHome().create();
            this.auditFacadeLocal = AuditFacadeUtil.getLocalHome().create();
            this.roleLocalHome = RoleUtil.getLocalHome();
            this.accountLocalHome = AccountUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.permissionUpdateNotifyLocal = PermissionUpdateNotifyUtil.getLocalHome().create();
            this.permissionUpdateToolsLocal = PermissionUpdateToolsUtil.getLocalHome().create();
            this.userAdminFacadeLocal = UserAdminFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<RoleValue> getAllRoles() {
        ArrayList<RoleValue> list = null;
        try {
            Collection collection = this.roleLocalHome.findAll();
            list = new ArrayList<RoleValue>();
            for (RoleLocal account : collection) {
                RoleValue value = account.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long insertRole(RoleValue value) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedRolename(value.getRolename(), -1L)) {
                throw new CreateException("No creation possible, rolename already exists");
            }
            RoleLocal local = null;
            try {
                local = this.roleLocalHome.create(value);
                value.setPrimaryKey((RolePK)local.getPrimaryKey());
                id = local.getRoleValue().getId();
            }
            catch (CreateException ex) {
                this.roleLocalHome.reorganizeSequence();
                try {
                    local = this.roleLocalHome.create(value);
                }
                catch (CreateException e) {
                    String msg = "createRole() ran into error. No changes were made.";
                    log.error((Object)msg, (Throwable)e);
                    throw new ImplicitRollbackException(msg);
                }
            }
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getRoleValue().getRolename();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", null, local.getRoleValue());
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, role already exists");
        }
        return id;
    }

    public boolean duplicatedRolename(String roleName, long roleId) {
        boolean duplicated = false;
        List<RoleValue> collection = this.getAllRoles();
        for (RoleValue role : collection) {
            if (role.getId() == roleId || !role.getRolename().equals(roleName)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public boolean deleteRole(long roleId) {
        boolean success = false;
        try {
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "", role.getRoleValue(), null);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            this.sendRoleChangedJMSMessageDueToRoleDeleted(role);
            role.remove();
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public RoleValue getRoleById(long roleId) {
        RoleValue roleValue = null;
        try {
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            roleValue = role.getRoleValue();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return roleValue;
    }

    public Map<String, String[]> getAllSectionRolesForUsers(String[] usernames) {
        HashMap<String, String[]> userRoles = new HashMap<String, String[]>();
        for (int i = 0; i < usernames.length; ++i) {
            userRoles.put(usernames[i], this.getAllSectionRolesForUser(usernames[i]));
        }
        return userRoles;
    }

    public String[] getAllSectionRolesForUser(String username) {
        AccountValue account;
        try {
            Collection accountCollection = this.accountLocalHome.findByUsername(username);
            AccountLocal accountLocal = (AccountLocal)accountCollection.iterator().next();
            account = accountLocal.getAccountValue();
        }
        catch (FinderException e) {
            log.warn((Object)("Cannot find user '" + username + "'"));
            return new String[0];
        }
        List<GroupIdentValue> userGroups = this.userGroupAdminFacade.getGroupsByUserId(account.getId());
        ArrayList readOnlyRoles = new ArrayList();
        List<RoleValue> userRoles = this.getRolesByUserId(account.getId());
        ArrayList<RoleValue> tempRoles = new ArrayList<RoleValue>();
        ArrayList<RoleValue> temp = new ArrayList<RoleValue>();
        if (userGroups != null) {
            for (GroupIdentValue group : userGroups) {
                tempRoles.addAll(this.getRolesByGroupId(group.getID()));
            }
        }
        for (RoleValue value : tempRoles) {
            temp.addAll(this.getRolesByRoleId(value.getId()));
        }
        tempRoles.addAll(temp);
        readOnlyRoles.addAll(tempRoles);
        tempRoles.clear();
        for (RoleValue role : userRoles) {
            readOnlyRoles.add(role);
            tempRoles.addAll(this.getRolesByRoleId(role.getId()));
        }
        readOnlyRoles.addAll(tempRoles);
        String[] list = new String[readOnlyRoles.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = ((RoleValue)readOnlyRoles.get(i)).getRolename();
        }
        return list;
    }

    public boolean updateRole(RoleValue value) {
        boolean success;
        block6: {
            success = false;
            try {
                if (this.duplicatedRolename(value.getRolename(), value.getId())) {
                    success = false;
                    break block6;
                }
                RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(value.getId()));
                RoleValue oldRoleValue = role.getRoleValue();
                if (oldRoleValue.equals(value)) {
                    return true;
                }
                role.setRoleValue(value);
                try {
                    String pk = role.getPrimaryKey().toString() + " " + oldRoleValue.getRolename();
                    this.auditFacadeLocal.createAuditData(auditAppl, pk, "", oldRoleValue, value);
                }
                catch (CreateException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                success = true;
            }
            catch (FinderException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return success;
    }

    public ArrayList<RoleValue> getAllRolesStartsWith(String rolenameContains) {
        ArrayList list = null;
        try {
            Collection collection = this.roleLocalHome.findByStartsWith(rolenameContains);
            list = new ArrayList();
            list.addAll(collection);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public RoleValue getRoleByName(String rolename) {
        RoleValue roleValue = null;
        try {
            RoleLocal role = null;
            Collection records = this.roleLocalHome.findByRolename(rolename);
            Iterator it = records.iterator();
            if (it.hasNext()) {
                role = (RoleLocal)it.next();
                roleValue = role.getRoleValue();
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return roleValue;
    }

    public List<RoleValue> getRolesByUserId(long accountId) {
        ArrayList<RoleValue> list = null;
        try {
            AccountLocal account = this.accountLocalHome.findByPrimaryKey(new AccountPK(accountId));
            Collection roles = account.getRoles();
            list = new ArrayList<RoleValue>();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByTypes(Object customer, boolean removeSections, boolean removeNotSections) {
        List<RoleValue> list = null;
        Collection roles = null;
        try {
            if (customer instanceof AccountValue) {
                AccountValue value = (AccountValue)customer;
                long customerId = value.getId();
                AccountLocal local = this.accountLocalHome.findByPrimaryKey(new AccountPK(customerId));
                roles = local.getRoles();
            } else if (customer instanceof GroupIdentValue) {
                GroupIdentValue value = (GroupIdentValue)customer;
                long customerId = value.getID();
                GroupIdentLocal local = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(customerId));
                roles = local.getRoles();
            } else if (customer instanceof RoleValue) {
                RoleValue value = (RoleValue)customer;
                long customerId = value.getId();
                RoleLocal local = this.roleLocalHome.findByPrimaryKey(new RolePK(customerId));
                roles = local.getSectionRoles();
            } else {
                return null;
            }
            list = this.removeRoles(roles, removeSections, removeNotSections);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private List<RoleValue> removeRoles(Collection list, boolean removeSections, boolean removeNotSections) {
        ArrayList<RoleValue> roles = new ArrayList<RoleValue>();
        for (Object obj : list) {
            RoleLocal local = (RoleLocal)obj;
            RoleValue role = local.getRoleValue();
            if (removeSections && role.getRolename().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES) || removeNotSections && !role.getRolename().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
            roles.add(role);
        }
        return roles;
    }

    public SectionRoleNode getSectionRoleNodeTree(String sectionIdentifier) {
        SectionRoleDTO dto = this.getSectionRoleData(sectionIdentifier);
        SectionRoleNode rootNode = dto.getRoot();
        return rootNode;
    }

    public SectionRoleDTO getSectionRoleData(String sectionIdentifier) {
        RoleValue sectionRole = new RoleValue();
        sectionRole.setRolename(sectionIdentifier);
        SectionRoleDTO dto = new SectionRoleDTO(sectionRole);
        SectionRoleNode rootNode = dto.getRoot();
        this.iterateSectionNodes(sectionRole, rootNode, true);
        return dto;
    }

    private void iterateSectionNodes(RoleValue role, SectionRoleNode node, boolean test) {
        List<RoleValue> roles = this.getAllRoles();
        ArrayList<RoleValue> childs = new ArrayList<RoleValue>();
        String rolePrefix = role.getRolename();
        if (!rolePrefix.endsWith(".")) {
            rolePrefix = rolePrefix + ".";
        }
        for (RoleValue value : roles) {
            if (!value.getRolename().startsWith(rolePrefix) || value.getRolename().split("[.]").length != role.getRolename().split("[.]").length + 1) continue;
            childs.add(value);
        }
        for (RoleValue roleValue : childs) {
            try {
                SectionRoleNode roleNode = node.addRoleNode(roleValue);
                if (!test) continue;
                this.iterateSectionNodes(roleValue, roleNode, true);
            }
            catch (Exception e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public List<RoleValue> getAllRoleTypes(boolean removeSections, boolean removeNotSections) {
        List<RoleValue> list = null;
        try {
            Collection collection = this.roleLocalHome.findAll();
            list = this.removeRoles(collection, removeSections, removeNotSections);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setRoleIdsByUserId(long accountId, long[] roleIds, boolean sendJMSMessage) {
        boolean success = false;
        try {
            RoleLocal roleLocal = null;
            AccountLocal account = this.accountLocalHome.findByPrimaryKey(new AccountPK(accountId));
            String userName = account.getAccountValue().getUsername();
            ArrayList<String> currentRolesList = new ArrayList<String>(Arrays.asList(this.getAllSectionRolesForUser(userName)));
            HashSet<Long> currentUnitIDs = this.getUnitFacade().getAllUnitIdsForUsername(userName);
            ArrayList<RoleLocal> newRoles = new ArrayList<RoleLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long roleId : roleIds) {
                roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
                newRoles.add(roleLocal);
                newAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collection actRoles = account.getRoles();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : actRoles) {
                roleLocal = (RoleLocal)obj;
                oldAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setRoles(newRoles);
            ArrayList<String> newRolesList = new ArrayList<String>(Arrays.asList(this.getAllSectionRolesForUser(userName)));
            HashSet<Long> newUnitIDs = this.getUnitFacade().getAllUnitIdsForUsername(userName);
            if (sendJMSMessage) {
                ArrayList<AccountValue> accounts;
                if (this.permissionUpdateToolsLocal.getDiffOfCollection(currentRolesList, newRolesList).toString().contains("section.airportmap")) {
                    accounts = new ArrayList<AccountValue>();
                    accounts.add(account.getAccountValue());
                    this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
                }
                if (this.permissionUpdateToolsLocal.getDiffOfCollection(currentUnitIDs, newUnitIDs).size() != 0) {
                    accounts = new ArrayList();
                    accounts.add(account.getAccountValue());
                    this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessage(accounts);
                }
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserToRole", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRoleIdsByGroupId(long userGroupId, long[] roleIds) {
        boolean success = false;
        try {
            HashMap<String, String[]> oldAccountPermissions = new HashMap();
            HashMap<String, String[]> newAccountPermissions = new HashMap();
            HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap();
            HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
            List<AccountValue> accounts = this.userGroupAdminFacade.getAccountsByGroupID(userGroupId);
            String[] affectedUserNames = this.permissionUpdateToolsLocal.getUserNames(accounts);
            oldAccountPermissions = this.getAllSectionRolesForUsers(affectedUserNames);
            oldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            RoleLocal roleLocal = null;
            GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(userGroupId));
            ArrayList<RoleLocal> newRoles = new ArrayList<RoleLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long roleId : roleIds) {
                roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
                newRoles.add(roleLocal);
                newAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collection actRoles = account.getRoles();
            ArrayList<RoleLocal> oldRoles = new ArrayList<RoleLocal>();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : actRoles) {
                roleLocal = (RoleLocal)obj;
                oldRoles.add(roleLocal);
                oldAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setRoles(newRoles);
            newAccountPermissions = this.getAllSectionRolesForUsers(affectedUserNames);
            newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
            List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
            if (affectedUsersByAirportmapRoleChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
            }
            if (affectedUsersByVisibleUnitChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getGroupname();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserGroupToRole", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByUserId(long accountId, ArrayList<RoleValue> roles) {
        boolean success = false;
        ArrayList<RoleLocal> coll = new ArrayList<RoleLocal>();
        try {
            AccountLocal account = this.accountLocalHome.findByPrimaryKey(new AccountPK(accountId));
            String newRoles = "";
            for (RoleValue role : roles) {
                RoleLocal roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(role.getId()));
                coll.add(roleLocal);
                String newSectionRole = roleLocal.getRoleValue().getRolename();
                if (!newSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                newRoles = newRoles + newSectionRole + ",";
            }
            Collection actRoles = account.getRoles();
            String oldRoles = "";
            for (Object obj : actRoles) {
                RoleLocal local = (RoleLocal)obj;
                String oldSectionRole = local.getRoleValue().getRolename();
                if (!oldSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                oldRoles = oldRoles + oldSectionRole + ",";
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserToAccess", oldRoles, newRoles);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            account.setRoles(coll);
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByGroupId(long userGroupId, ArrayList<RoleValue> roles) {
        boolean success = false;
        ArrayList<RoleLocal> coll = new ArrayList<RoleLocal>();
        try {
            GroupIdentLocal groupIdentLocal = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(userGroupId));
            String newRoles = "";
            for (RoleValue role : roles) {
                RoleLocal roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(role.getId()));
                coll.add(roleLocal);
                String newSectionRole = roleLocal.getRoleValue().getRolename();
                if (!newSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                newRoles = newRoles + newSectionRole + ",";
            }
            Collection actRoles = groupIdentLocal.getRoles();
            String oldRoles = "";
            for (Object obj : actRoles) {
                RoleLocal local = (RoleLocal)obj;
                String oldSectionRole = local.getRoleValue().getRolename();
                if (!oldSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                oldRoles = oldRoles + oldSectionRole + ",";
            }
            try {
                String pk = groupIdentLocal.getPrimaryKey().toString() + " " + groupIdentLocal.getGroupname();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationUserGroupToAccess", oldRoles, newRoles);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            groupIdentLocal.setRoles(coll);
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByRoleId(long parentRoleId, long[] roles) {
        boolean success = false;
        try {
            RoleLocal roleLocal2 = null;
            RoleLocal parentRole = this.roleLocalHome.findByPrimaryKey(new RolePK(parentRoleId));
            ArrayList<RoleLocal> newRoleCollection = new ArrayList<RoleLocal>(roles.length);
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (int i = 0; i != roles.length; ++i) {
                roleLocal2 = this.roleLocalHome.findByPrimaryKey(new RolePK(roles[i]));
                newRoleCollection.add(roleLocal2);
                newAssignment.add(roleLocal2.getRoleValue().getRolename());
            }
            ArrayList<String> oldAssignment = new ArrayList<String>();
            Collection oldRolesCollection = parentRole.getSectionRoles();
            ArrayList<RoleLocal> oldRoles = new ArrayList<RoleLocal>();
            for (RoleLocal roleLocal2 : oldRolesCollection) {
                oldRoles.add(roleLocal2);
                oldAssignment.add(roleLocal2.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            parentRole.setSectionRoles(newRoleCollection);
            if (this.isAirportMapRoleAffected(newRoleCollection, oldRoles)) {
                List<AccountValue> accounts = this.getAccountsInRoleAndGroupsByRoleID(parentRoleId);
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
            }
            try {
                String pk = parentRole.getPrimaryKey().toString() + " " + parentRole.getRoleValue().getRolename();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationRoleToAccess", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public List<RoleValue> getRolesByUsername(String username) {
        ArrayList<RoleValue> list = null;
        try {
            Collection accountRecords = this.accountLocalHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            AccountLocal account = null;
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                Collection roles = account.getRoles();
                list = new ArrayList<RoleValue>();
                for (Object obj : roles) {
                    RoleLocal local = (RoleLocal)obj;
                    RoleValue value = local.getRoleValue();
                    list.add(value);
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<AccountValue> getAccountsInRoleAndGroupsByRoleID(long roleID) {
        ArrayList<AccountValue> accounts = new ArrayList<AccountValue>();
        try {
            RoleLocal roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(roleID));
            ArrayList groupsIdentsList = new ArrayList();
            for (GroupIdentLocal groupIdent : roleLocal.getUserGroups()) {
                Long groupId = ((GroupIdentPK)groupIdent.getPrimaryKey()).getID();
                List<AccountValue> accountList = this.userGroupAdminFacade.getAccountsByGroupID(groupId);
                accounts.addAll(accountList);
            }
            accounts.addAll(this.getAccountsbyRoleID(roleID));
        }
        catch (FinderException e) {
            log.error((Object)"getUserbyRole runs into : ", (Throwable)e);
        }
        return accounts;
    }

    public List<RoleValue> getRolesByGroupId(long groupId) {
        ArrayList<RoleValue> list = new ArrayList<RoleValue>();
        try {
            GroupIdentLocal group = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            Collection roles = group.getRoles();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByRoleId(long roleId) {
        ArrayList<RoleValue> list = null;
        try {
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            Collection roles = role.getSectionRoles();
            list = new ArrayList<RoleValue>();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setUsernamesByRoleId(long roleId, String[] usernames) {
        boolean success = false;
        try {
            HashMap<String, String[]> oldAccounts = new HashMap();
            HashMap<String, String[]> newAccounts = new HashMap();
            HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap();
            HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
            String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsers(this.userAdminFacadeLocal.getUsernamesByRoleId(roleId), usernames);
            oldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            oldAccounts = this.getAllSectionRolesForUsers(affectedUserNames);
            AccountLocal account = null;
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            ArrayList<AccountLocal> newUsers = new ArrayList<AccountLocal>();
            ArrayList<AccountValue> newUsersList = new ArrayList<AccountValue>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (String username : usernames) {
                Collection accountRecords = this.accountLocalHome.findByUsername(username);
                Iterator it = accountRecords.iterator();
                if (!it.hasNext()) continue;
                account = (AccountLocal)it.next();
                newUsers.add(account);
                newAssignment.add(account.getAccountValue().getUsername());
                newUsersList.add(account.getAccountValue());
            }
            Collection users = role.getUser();
            ArrayList<AccountValue> oldUsersList = new ArrayList<AccountValue>();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : users) {
                account = (AccountLocal)obj;
                oldAssignment.add(account.getAccountValue().getUsername());
                oldUsersList.add(account.getAccountValue());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            role.setUser(newUsers);
            newAccounts = this.getAllSectionRolesForUsers(affectedUserNames);
            newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccounts, newAccounts, affectedUserNames);
            List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
            if (affectedUsersByAirportmapRoleChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
            }
            if (affectedUsersByVisibleUnitChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
            }
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationRoleToUser", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    private boolean isAirportMapRoleAffected(Collection<RoleLocal> col1, Collection<RoleLocal> col2) {
        Collection diffCollection = this.permissionUpdateToolsLocal.getDiffOfCollection(col1, col2);
        for (RoleLocal roleLocal : diffCollection) {
            if (!roleLocal.getRoleValue().getRolename().contains("section.airportmap")) continue;
            return true;
        }
        return false;
    }

    public boolean setGroupsByRoleId(long roleId, long[] groupIds) {
        boolean success = false;
        try {
            HashMap<String, String[]> oldAccountPermissions = new HashMap();
            HashMap<String, String[]> newAccountPermissions = new HashMap();
            HashMap<String, HashSet<Long>> oldUnitPermissions = new HashMap();
            HashMap<String, HashSet<Long>> newUnitPermissions = new HashMap();
            List<AccountValue> newAccounts = this.userGroupAdminFacade.getAccountsByGroupIDs(groupIds);
            List<AccountValue> currentAccounts = this.getAccountsInRoleAndGroupsByRoleID(roleId);
            String[] affectedUserNames = this.permissionUpdateToolsLocal.getDifferentUsersByAccountValueList(currentAccounts, newAccounts);
            oldAccountPermissions = this.getAllSectionRolesForUsers(affectedUserNames);
            oldUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            GroupIdentLocal groupIdent = null;
            ArrayList<Long> newGroupIDs = new ArrayList<Long>();
            RoleLocal role = this.roleLocalHome.findByPrimaryKey(new RolePK(roleId));
            ArrayList<GroupIdentLocal> newGroups = new ArrayList<GroupIdentLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long groupId : groupIds) {
                groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
                newGroups.add(groupIdent);
                newGroupIDs.add(groupId);
                newAssignment.add(groupIdent.getGroupname());
            }
            Collection oldGroups = role.getUserGroups();
            ArrayList<Long> oldGroupIDs = new ArrayList<Long>();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldGroups) {
                groupIdent = (GroupIdentLocal)obj;
                oldAssignment.add(groupIdent.getGroupname());
                oldGroupIDs.add(((GroupIdentPK)groupIdent.getPrimaryKey()).getID());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            role.setUserGroups(newGroups);
            newAccountPermissions = this.getAllSectionRolesForUsers(affectedUserNames);
            newUnitPermissions = this.getUnitFacade().getAllUnitIdsForUsernames(affectedUserNames);
            List<String> affectedUsersByAirportmapRoleChanges = this.permissionUpdateToolsLocal.getAffectedUsersByRolesChanges(oldAccountPermissions, newAccountPermissions, affectedUserNames);
            List<String> affectedUsersByVisibleUnitChanges = this.permissionUpdateToolsLocal.getAffectedUsersByVisibleUnitChanges(oldUnitPermissions, newUnitPermissions, affectedUserNames);
            if (affectedUsersByAirportmapRoleChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessageByUserNames(affectedUsersByAirportmapRoleChanges);
            }
            if (affectedUsersByVisibleUnitChanges.size() != 0) {
                this.permissionUpdateNotifyLocal.sendPermissionChangedJMSMessageByUserNames(affectedUsersByVisibleUnitChanges);
            }
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.auditFacadeLocal.createAuditData(auditAppl, pk, "RelationRoleToUserGroup", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public SectionRoleNode getSectionRolesTreeByGroupId(long groupId, String sectionIdentifier) {
        if (groupId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        List<RoleValue> userRoles = this.getRolesByGroupId(groupId);
        ArrayList<RoleValue> directRoles = new ArrayList<RoleValue>();
        ArrayList<RoleValue> roleRoles = new ArrayList<RoleValue>();
        this.splitRoles(userRoles, directRoles, roleRoles, sectionIdentifier);
        return this.getSectionRolesTreeByRoles(sectionIdentifier, directRoles, null, roleRoles);
    }

    public SectionRoleNode getSectionRolesTreeByUserId(long userId, String sectionIdentifier) {
        if (userId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        ArrayList<RoleValue> groupRoles = new ArrayList<RoleValue>();
        List<GroupIdentValue> memberGroups = this.userGroupAdminFacade.getGroupsByUserId(userId);
        for (int i = 0; i != memberGroups.size(); ++i) {
            List<RoleValue> currentRoles = this.getRolesByGroupId(memberGroups.get(i).getID());
            for (int j = 0; j != currentRoles.size(); ++j) {
                groupRoles.addAll(this.getRolesByRoleId(currentRoles.get(j).getId()));
            }
            groupRoles.addAll(currentRoles);
        }
        List<RoleValue> userRoles = this.getRolesByUserId(userId);
        ArrayList<RoleValue> directRoles = new ArrayList<RoleValue>();
        ArrayList<RoleValue> roleRoles = new ArrayList<RoleValue>();
        this.splitRoles(userRoles, directRoles, roleRoles, sectionIdentifier);
        return this.getSectionRolesTreeByRoles(sectionIdentifier, directRoles, groupRoles, roleRoles);
    }

    private void splitRoles(List<RoleValue> allRoles, List<RoleValue> directRoles, List<RoleValue> roleRoles, String sectionIdentifier) {
        directRoles.clear();
        roleRoles.clear();
        for (int i = 0; i != allRoles.size(); ++i) {
            RoleValue currentRole = allRoles.get(i);
            if (currentRole.getRolename().startsWith(sectionIdentifier)) {
                directRoles.add(currentRole);
                continue;
            }
            List<RoleValue> sectionRoles = this.getRolesByRoleId(currentRole.getId());
            for (int j = 0; j != sectionRoles.size(); ++j) {
                roleRoles.add(sectionRoles.get(j));
            }
        }
    }

    public SectionRoleNode getSectionRolesTreeByRoleId(long roleId, String sectionIdentifier) {
        if (roleId == 0L) {
            return this.getSectionRoleNodeTree(sectionIdentifier);
        }
        return this.getSectionRolesTreeByRoles(sectionIdentifier, this.getRolesByRoleId(roleId), null, null);
    }

    public SectionRoleNode getSectionRolesTreeByRoles(String sectionIdentifier, List<RoleValue> userRoles, List<RoleValue> groupRoles, List<RoleValue> roleRoles) {
        SectionRoleNode root = this.getSectionRoleNodeTree(sectionIdentifier);
        if (groupRoles != null) {
            root.setGroupSelectionsByRole(groupRoles, false, true);
        }
        if (roleRoles != null) {
            root.setRoleSelectionsByRole(roleRoles, false, true);
        }
        if (userRoles != null) {
            root.setUserSelectionsByRole(userRoles, false, true);
        }
        return root;
    }

    public List<AccountValue> getAccountsbyRoleID(long roleID) {
        try {
            RoleLocal roleLocal = this.roleLocalHome.findByPrimaryKey(new RolePK(roleID));
            Collection accounts = roleLocal.getUser();
            ArrayList<AccountValue> list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
            return list;
        }
        catch (FinderException e) {
            log.error((Object)"getUserbyRole runs into : ", (Throwable)e);
            return null;
        }
    }

    public List<RoleValue> getAllRolesForUser(String username) {
        MasterDataFastLaneReader masterDataFastLaneReader = new MasterDataFastLaneReader();
        List<RoleValue> roles = masterDataFastLaneReader.getAllRolesForUser(username);
        return roles;
    }

    private UnitFacadeLocal getUnitFacade() {
        if (this.unitFacadeLocal == null) {
            try {
                this.unitFacadeLocal = UnitFacadeUtil.getLocalHome().create();
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return this.unitFacadeLocal;
    }

    public void sendRoleChangedJMSMessageDueToRoleDeleted(RoleLocal role) {
        boolean apInvolved = false;
        Collection sectionRoles = role.getSectionRoles();
        for (RoleLocal roleLocal : sectionRoles) {
            if (roleLocal == null || !roleLocal.getRoleValue().getRolename().contains("section.airportmap")) continue;
            apInvolved = true;
            break;
        }
        if (apInvolved) {
            ArrayList<AccountValue> accounts = new ArrayList<AccountValue>();
            Collection groupIdents = role.getUserGroups();
            GroupIdentLocal groupIdentLocal2 = null;
            Collection accountsGroup = new ArrayList();
            for (GroupIdentLocal groupIdentLocal2 : groupIdents) {
                if (groupIdentLocal2 == null || (accountsGroup = groupIdentLocal2.getUser()).size() <= 0) continue;
                for (AccountLocal accountLocal : accountsGroup) {
                    if (accountLocal == null) continue;
                    accounts.add(accountLocal.getAccountValue());
                }
            }
            Collection allAccounts = role.getUser();
            for (AccountLocal accountLocal : allAccounts) {
                if (accountLocal == null) continue;
                accounts.add(accountLocal.getAccountValue());
            }
            if (accounts.size() > 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
            }
        }
    }

    public void sendRoleChangedJMSMessageDueToUserGroupDeleted(GroupIdentLocal userGroup) {
        Collection userGroupRoles = userGroup.getRoles();
        boolean apInvolved = false;
        block0: for (RoleLocal roleLocal2 : userGroupRoles) {
            if (roleLocal2 == null) continue;
            if (roleLocal2.getRoleValue().getRolename().contains("section.airportmap")) {
                apInvolved = true;
                break;
            }
            Collection sectionRoles = roleLocal2.getSectionRoles();
            for (RoleLocal roleLocal2 : sectionRoles) {
                if (roleLocal2 == null || !roleLocal2.getRoleValue().getRolename().contains("section.airportmap")) continue;
                apInvolved = true;
                continue block0;
            }
        }
        if (apInvolved) {
            Collection accountLocals = userGroup.getUser();
            ArrayList<AccountValue> accounts = new ArrayList<AccountValue>();
            for (AccountLocal accountLocal : accountLocals) {
                if (accountLocal == null) continue;
                accounts.add(accountLocal.getAccountValue());
            }
            if (accounts.size() > 0) {
                this.permissionUpdateNotifyLocal.sendRoleChangedJMSMessage(accounts);
            }
        }
    }
}

