/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.monitoring;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeUtil;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocalHome;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeUtil;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveStamp;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocalHome;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.state.exception.StatesForUnitNotFoundException;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocalHome;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoringFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(MonitoringFacadeBean.class);
    private CurrentStateFacadeLocalHome currentStateFacadeHome;
    private CurrentNotifyCacheLocalHome currentNotifyCacheHome;
    private NotifyHistoryLocalHome notifyHistoryHome;
    private UnitTreeFacadeLocalHome unitTreeFacadeHome;
    private KeepAliveOutFacadeLocalHome keepAliveOutFacadeHome;
    private NotificationAdministrationFacadeLocal notificationAdminFacade;

    public void ejbCreate() throws CreateException {
        log.debug((Object)"ejbCreate()");
        this.init();
    }

    private void init() throws CreateException {
        log.debug((Object)"init()");
        try {
            this.currentStateFacadeHome = CurrentStateFacadeUtil.getLocalHome();
            this.currentNotifyCacheHome = CurrentNotifyCacheUtil.getLocalHome();
            this.notifyHistoryHome = NotifyHistoryUtil.getLocalHome();
            this.keepAliveOutFacadeHome = KeepAliveOutFacadeUtil.getLocalHome();
            this.unitTreeFacadeHome = UnitTreeFacadeUtil.getLocalHome();
            this.notificationAdminFacade = NotificationAdministrationFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public void doVoid() {
        log.debug((Object)"doVoid()");
    }

    public Map<Long, CurrentStateFacadeStruct> getCurrentUnitStates(long unitId) {
        Map<Long, CurrentStateFacadeStruct> stateMap = null;
        try {
            stateMap = this.currentStateFacadeHome.create().getCurrentState(unitId);
        }
        catch (StatesForUnitNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateMap;
    }

    public int getNotifyCount(long unitId, long messageId, long since, long until) {
        int count = 0;
        try {
            count = this.notifyHistoryHome.findByUnitIdNotifyId(unitId, messageId, since, until, true).size();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return count;
    }

    public CurrentNotifyCacheValue getLastNotifyEntryFromCache(long unitId) {
        CurrentNotifyCacheValue currentNotifyCacheValue = null;
        try {
            Collection currentNotifyCaches = this.currentNotifyCacheHome.findLastByUnitId(unitId);
            Iterator iter = currentNotifyCaches.iterator();
            if (iter.hasNext()) {
                CurrentNotifyCacheLocal currentNotifyCache = (CurrentNotifyCacheLocal)iter.next();
                currentNotifyCacheValue = currentNotifyCache.getCurrentNotifyCacheValue();
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return currentNotifyCacheValue;
    }

    public long getLastKeepAliveTimestamp(long unitId) {
        long timestamp = 0L;
        try {
            KeepAliveOutFacadeLocal keepAliveOutFacade = this.keepAliveOutFacadeHome.create();
            long currentTime = System.currentTimeMillis();
            Set messages = keepAliveOutFacade.getKeepAliveMessages(unitId, currentTime, currentTime);
            if (messages.size() > 1) {
                log.warn((Object)"more than one keep alive messages when asking for online data?");
            } else if (messages.size() < 1) {
                log.warn((Object)"no keep alive message for unit?");
            }
            Iterator iter = messages.iterator();
            if (iter.hasNext()) {
                KeepAliveStamp stamp = (KeepAliveStamp)iter.next();
                timestamp = stamp.getTimeStamp();
            }
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return timestamp;
    }

    public long getAggregatedStateDuration(long unitId, long stateId, long beginTime, long endTime, int periodType) {
        long duration = 0L;
        return duration;
    }

    public UnitTreeNode getUnitTreeDTO() {
        UnitTreeNode unitTreeDTO = null;
        try {
            unitTreeDTO = this.unitTreeFacadeHome.create().getTreeViewData(false, false, true);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitTreeDTO;
    }

    public String getNotifyRuleParameterValue(String key, String parameter) {
        return this.notificationAdminFacade.getNotifyRuleParameterValue(key, parameter);
    }
}

