/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.mapclient;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.exceptions.NoAirportMapUnitException;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacade;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationAdministrationFacadeUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapClientFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(MapClientFacadeBean.class);
    private NotificationAdministrationFacadeLocal notificationAdminFacade;
    private AreaLocalHome areaHome;
    private CurrentGdataCacheLocalHome currentGdataCacheHome;
    private KeepAliveCacheLocalHome keepAliveCacheHome;
    private CurrentStateCacheLocalHome currentStateCacheHome;
    private UnitFacadeLocal unitFacade;
    private UnitIdentityLocalHome unitIdentityHome;
    private ScanmanMsgFacadeLocal scanmanMsgFacade;
    private NotifyHistoryLocalHome notifyHistoryLocalHome;
    private UseCacheLocalHome useCacheLocalHome;
    private long infomanKeepaliveTimeout = 0L;
    private PermissionCheckerLocal permissionCheckerLocal;
    private UseFacade useFacade;
    private UnitTreeFacadeLocal unitTreeFacade;
    private InfomanConfigurationClientFacadeLocal infomanConfigurationClientFacade;
    private LoginContextUtil lcu;
    private boolean oldMap = false;
    private ConfigurationLocal configurationLocal;
    private int maxOfNotifyEvents = 500;
    private NotifyComparator comparator;

    public void ejbCreate() throws CreateException {
        try {
            this.notificationAdminFacade = NotificationAdministrationFacadeUtil.getLocalHome().create();
            this.currentGdataCacheHome = CurrentGdataCacheUtil.getLocalHome();
            this.keepAliveCacheHome = KeepAliveCacheUtil.getLocalHome();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            this.unitFacade = UnitFacadeUtil.getLocalHome().create();
            this.unitIdentityHome = UnitIdentityUtil.getLocalHome();
            this.scanmanMsgFacade = ScanmanMsgFacadeUtil.getLocalHome().create();
            this.notifyHistoryLocalHome = NotifyHistoryUtil.getLocalHome();
            this.permissionCheckerLocal = PermissionCheckerUtil.getLocalHome().create();
            this.useCacheLocalHome = UseCacheUtil.getLocalHome();
            this.useFacade = UseFacadeUtil.getHome().create();
            this.unitTreeFacade = UnitTreeFacadeUtil.getLocalHome().create();
            this.infomanConfigurationClientFacade = InfomanConfigurationClientFacadeUtil.getLocalHome().create();
            this.configurationLocal = ConfigurationUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
        long DEFAULT = 300L;
        long value = 300L;
        String key = "infoman.keepalive.timeout";
        String para = this.configurationLocal.getParameter(key, Long.toString(300L));
        value = Long.parseLong(para);
        this.infomanKeepaliveTimeout = value * 60L * 1000L;
        this.comparator = new NotifyComparator();
    }

    public HashSet<Long> getUnitPermissions(long unitGroupId) {
        HashSet<Long> unitPermissions = this.permissionCheckerLocal.getUnitPermissions();
        UnitTreeNode rootUnitNode = null;
        try {
            UnitTreeNode unitTree;
            if (unitGroupId != -1L && (unitTree = this.unitTreeFacade.getAirportMapTreeModel()) != null) {
                rootUnitNode = (UnitTreeNode)unitTree.getRoot();
                UnitTreeNode unitGroupNode = this.findUnitGroupNode(rootUnitNode, unitGroupId);
                if (unitGroupNode != null) {
                    rootUnitNode = unitGroupNode;
                }
                HashSet<Long> tmpUnitPermissions = new HashSet<Long>(unitPermissions);
                for (Long unitId : unitPermissions) {
                    if (this.isUnitIdInGroup(rootUnitNode, unitId)) continue;
                    tmpUnitPermissions.remove(unitId);
                }
                unitPermissions = tmpUnitPermissions;
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAirportMapTreeModel() runs into", (Throwable)ex);
        }
        return unitPermissions;
    }

    public Set getOnlineMapData(boolean scanmanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded, String username, String password, long unitGroupId) {
        String sMethodName = "getOnlineMapData(): ";
        HashSet<Map> allStamps = new HashSet<Map>();
        Map currentGdatas = this.getAllCurrentGdataCache();
        Map areas = this.getAllAreas(unitGroupId);
        Map<Long, UnitIdentityValue> unitIdentities = this.getAllUnitIdentities();
        if (username == null && password == null) {
            this.oldMap = true;
        } else {
            try {
                this.lcu = new LoginContextUtil(username, password);
            }
            catch (Exception ex) {
                log.error((Object)"LoginContextUtil runs into: ", (Throwable)ex);
            }
        }
        HashSet<Long> unitPermissions = this.getUnitPermissions(unitGroupId);
        Map<Object, Object> notifyEvents = new HashMap();
        if (notifyMessagesNeeded) {
            notifyEvents = this.getAllNotifyEvents(unitPermissions);
        }
        Map currentKeepAlives = this.getAllKeepAliveCache();
        Map currentUseEvents = new HashMap();
        if (useMessagesNeeded) {
            currentUseEvents = this.getAllUseCache();
        }
        Collection col = this.getCurrentStates();
        Iterator it = col.iterator();
        int i = 0;
        long lastUnitId = -1L;
        Map mapClientStamp = null;
        long currentTime = System.currentTimeMillis();
        while (it.hasNext()) {
            CurrentStateCacheLocal remote = (CurrentStateCacheLocal)it.next();
            CurrentStateCacheValue state = remote.getCurrentStateCacheValue();
            long unitId = state.getUnitId();
            if (!this.oldMap && !unitPermissions.contains(unitId)) continue;
            try {
                if (unitId != lastUnitId) {
                    if (mapClientStamp != null) {
                        allStamps.add(mapClientStamp);
                    }
                    mapClientStamp = this.getNewMapClientStamp(unitId, unitIdentities, notifyEvents, currentUseEvents, areas, currentGdatas, currentKeepAlives, currentTime, scanmanMessagesNeeded, notifyMessagesNeeded, useMessagesNeeded);
                    lastUnitId = unitId;
                }
                if (mapClientStamp != null) {
                    this.addState(mapClientStamp, state);
                }
            }
            catch (NoAirportMapUnitException e) {
                log.trace((Object)"AirportMap data cannot be retrieved for this unit. Please check data! Missing A/P map flag?");
            }
            ++i;
        }
        if (mapClientStamp != null) {
            allStamps.add(mapClientStamp);
        }
        return allStamps;
    }

    private UnitTreeNode findUnitGroupNode(UnitTreeNode unitNode, long unitGroupId) {
        List children;
        if (unitNode == null) {
            return null;
        }
        UnitTreeNode ret = null;
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        long unitId = unitModelValue.getUnitId();
        if (unitId == unitGroupId) {
            return unitNode;
        }
        if (unitNode.hasChildren() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.findUnitGroupNode(childUnitNode, unitGroupId);
                if (ret == null) continue;
                return ret;
            }
        }
        return ret;
    }

    private boolean isUnitIdInGroup(UnitTreeNode unitNode, long unitId) {
        List children;
        boolean ret = false;
        if (unitNode == null) {
            return ret;
        }
        UnitModelValue unitModelValue = ((UnitDTO)unitNode.getData()).getUnitModelValue();
        long thisUnitId = unitModelValue.getUnitId();
        if (thisUnitId == unitId) {
            ret = true;
            return ret;
        }
        if (!unitModelValue.getBasic() && (children = unitNode.getChildren()) != null) {
            for (UnitTreeNode childUnitNode : children) {
                ret = this.isUnitIdInGroup(childUnitNode, unitId);
                if (!ret) continue;
                return ret;
            }
        }
        return ret;
    }

    public Set checkPermissionsAndRequest(Set gseData, String username, String password, long unitGroupId, boolean infomanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded) {
        this.permissionCheckerLocal.updateUserPermissions(username);
        HashSet<Long> permissions = this.getUnitPermissions(unitGroupId);
        HashSet gseDataClone = null;
        if (gseData instanceof HashSet) {
            gseDataClone = (HashSet)((HashSet)gseData).clone();
        }
        if (gseDataClone != null) {
            for (HashMap stamp : gseDataClone) {
                if (!permissions.contains(stamp.get("UnitId")) || !((Boolean)stamp.get("UnitAirportMapFlag")).booleanValue() || stamp.get("GeoBegin") == null) {
                    gseData.remove(stamp);
                    continue;
                }
                if (!useMessagesNeeded && stamp.remove("UseEventUserKey") != null) {
                    stamp.remove("UseEventTimestamp");
                    stamp.remove("UseEventUserGroupId");
                    stamp.remove("UseEventLogin");
                    stamp.remove("UseEventReceiveTime");
                    stamp.remove("UseEventDriverName");
                    stamp.remove("UseEventPersonalNumber");
                }
                if (!infomanMessagesNeeded) {
                    stamp.remove("SmBootTimestamp");
                    stamp.remove("SmBootMessage");
                    stamp.remove("SmIpTimestamp");
                    stamp.remove("SmIpMessage");
                    stamp.remove("SmErrorTimestamp");
                    stamp.remove("SmErrorMessage");
                }
                if (notifyMessagesNeeded) continue;
                stamp.remove("NotifyEvents");
            }
        }
        return gseData;
    }

    protected Collection getCurrentStates() {
        Collection states = new HashSet();
        try {
            states = this.currentStateCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)"getCurrentStates() Finder Problem", (Throwable)ex);
        }
        return states;
    }

    protected Map getAllCurrentGdataCache() {
        Collection col = new HashSet();
        try {
            col = this.currentGdataCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)"getAllCurrentGdataCache() Finder Problem", (Throwable)ex);
        }
        HashMap<Long, CurrentGdataCacheValue> gdatas = new HashMap<Long, CurrentGdataCacheValue>();
        for (CurrentGdataCacheLocal remote : col) {
            CurrentGdataCacheValue value = remote.getCurrentGdataCacheValue();
            gdatas.put(value.getUnitId(), value);
        }
        return gdatas;
    }

    protected Map getAllUseCache() {
        Collection allUseCacheCol = new HashSet();
        try {
            allUseCacheCol = this.useCacheLocalHome.findAll();
        }
        catch (FinderException e) {
            log.error((Object)"getAllUseCache runs into FinderException: ", (Throwable)e);
        }
        HashMap<Long, UseCacheValue> useEvents = new HashMap<Long, UseCacheValue>();
        Iterator it = allUseCacheCol.iterator();
        while (it.hasNext()) {
            UseCacheValue value = ((UseCacheLocal)it.next()).getUseCacheValue();
            Long unitId = value.getUnitId();
            useEvents.put(unitId, value);
        }
        return useEvents;
    }

    protected Map getAllKeepAliveCache() {
        String method = "getAllKeepAliveCache(): ";
        Collection col = new HashSet();
        try {
            col = this.keepAliveCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Long, KeepAliveCacheValue> alives = new HashMap<Long, KeepAliveCacheValue>();
        for (KeepAliveCacheLocal remote : col) {
            KeepAliveCacheValue value = remote.getKeepAliveCacheValue();
            alives.put(value.getUnitId(), value);
        }
        return alives;
    }

    protected Map getAllAreas(long unitGroupId) {
        String method = "getAllAreas(): ";
        Collection col = new HashSet();
        try {
            if (unitGroupId != -1L) {
                col = this.areaHome.findOrderedByPriorityByAirport(unitGroupId);
            }
            if (col == null || col.size() <= 0) {
                col = this.areaHome.findOrderedByPriority();
            }
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Integer, AreaValue> areas = new HashMap<Integer, AreaValue>();
        for (AreaLocal remote : col) {
            AreaValue value = remote.getAreaValue();
            areas.put(value.getAreaId(), value);
        }
        return areas;
    }

    public Map<Long, UnitIdentityValue> getAllUnitIdentities() {
        String method = "getAllUnitIdentities(): ";
        Collection col = new HashSet();
        try {
            col = this.unitIdentityHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Long, UnitIdentityValue> identities = new HashMap<Long, UnitIdentityValue>();
        for (UnitIdentityLocal remote : col) {
            UnitIdentityValue value = remote.getUnitIdentityValue();
            identities.put(value.getUnitId(), value);
        }
        return identities;
    }

    protected ScanmanMsgHistoryValue getLastScanmanMessage(long unitId, int type) {
        String method = "getLastScanmanMessage(unitId=" + unitId + ", type=" + type + "): ";
        ScanmanMsgHistoryValue value = this.scanmanMsgFacade.getLastMessage(type, unitId);
        return value;
    }

    protected Map<Long, List<NotifyHistoryValue>> getAllNotifyEvents(HashSet<Long> unitPermissions) {
        String method = "getAllNotifyEvents(): ";
        Collection col = new HashSet();
        long startTime = System.currentTimeMillis() - 86400000L;
        try {
            col = this.notifyHistoryLocalHome.findAllOlderThanGivenTimestamp(startTime);
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Long, List<NotifyHistoryValue>> notifies = new HashMap<Long, List<NotifyHistoryValue>>();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            NotifyHistoryValue value = ((NotifyHistoryLocal)it.next()).getNotifyHistoryValue();
            Long unitId = value.getUnitId();
            ArrayList<NotifyHistoryValue> notifyList = null;
            if (this.notifyEventAndUnitHasPermission(unitId, unitPermissions)) {
                notifyList = (ArrayList<NotifyHistoryValue>)notifies.get(unitId);
            }
            if (notifyList == null) {
                notifyList = new ArrayList<NotifyHistoryValue>();
            }
            notifyList.add(value);
            notifies.put(unitId, notifyList);
        }
        this.limitAmountOfNotifies(notifies);
        return notifies;
    }

    private void limitAmountOfNotifies(Map<Long, List<NotifyHistoryValue>> notifies) {
        if (this.configurationLocal.isConfigured("observable.notifies.maximumPerUnitPerDay")) {
            try {
                this.maxOfNotifyEvents = this.configurationLocal.getInteger("observable.notifies.maximumPerUnitPerDay");
            }
            catch (Throwable ex) {
                log.error((Object)"Could not get property \"observable.notifies.maximumPerUnitPerDay\"", ex);
            }
        }
        for (List<NotifyHistoryValue> tmp : notifies.values()) {
            if (tmp.size() <= this.maxOfNotifyEvents) continue;
            Collections.sort(tmp, this.comparator);
            if (tmp.size() < 1) continue;
            tmp.subList(this.maxOfNotifyEvents, tmp.size()).clear();
        }
    }

    private boolean notifyEventAndUnitHasPermission(Long unitId, HashSet<Long> unitPermissions) {
        if (this.oldMap) {
            return true;
        }
        if (this.lcu == null) {
            return false;
        }
        if (this.lcu.isSuperAdmin()) {
            return true;
        }
        if (!this.lcu.isUserInRole("section.airportmap.notification")) {
            return false;
        }
        return unitPermissions != null && unitPermissions.contains(unitId);
    }

    private void addUnitIdentityBasicData(Map unitIdentities, Map<String, Object> mapClientStamp, Long unitID) throws NoAirportMapUnitException {
        UnitIdentityValue unitIdentity = (UnitIdentityValue)unitIdentities.get(unitID);
        this.addBasicGSEData(mapClientStamp, unitID, unitIdentity);
    }

    public Map addUnitIdentityBasicData(Map mapClientStamp, Long unitID) throws NoAirportMapUnitException {
        try {
            UnitIdentityValue unitIdentity = this.unitIdentityHome.findByPrimaryKey(new UnitIdentityPK(unitID)).getUnitIdentityValue();
            this.addBasicGSEData(mapClientStamp, unitID, unitIdentity);
        }
        catch (FinderException e) {
            log.error((Object)"Unit cannot be find in the db!", (Throwable)e);
        }
        return mapClientStamp;
    }

    private void addBasicGSEData(Map<String, Object> mapClientStamp, Long unitID, UnitIdentityValue unitIdentity) throws NoAirportMapUnitException {
        if (unitIdentity == null) {
            throw new NoAirportMapUnitException();
        }
        UnitDTO unitDTO = this.unitFacade.getUnit(unitID);
        String unitType = null;
        try {
            String tmp = unitDTO.getUnitTypeIdentityValue().getName();
            if (tmp.trim().length() > 0) {
                unitType = tmp;
            }
        }
        catch (Throwable ex) {
            log.error((Object)("No unitType for unit with unitId '" + unitID + "' defined!"));
        }
        mapClientStamp.put("UnitId", unitID);
        mapClientStamp.put("UnitKind", unitType);
        mapClientStamp.put("UnitType", unitType);
        mapClientStamp.put("UnitName", unitIdentity.getName());
        mapClientStamp.put("UnitAirportMapFlag", unitDTO.getUnitModelValue().getAirportMapVisible());
    }

    private Map getNewMapClientStamp(long uid, Map unitIdentities, Map notifyEvents, Map currentUseEvents, Map areas, Map currentGdatas, Map currentKeepAlives, long now, boolean infomanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded) throws NoAirportMapUnitException {
        String method = "getNewMapClientStamp(): ";
        Long unitID = uid;
        CurrentGdataCacheValue currentGdata = (CurrentGdataCacheValue)currentGdatas.get(unitID);
        AreaValue areaValue = null;
        if (currentGdata != null) {
            areaValue = this.addArea(uid, areas, currentGdata);
        }
        KeepAliveCacheValue currentKeepAlive = (KeepAliveCacheValue)currentKeepAlives.get(unitID);
        boolean currentKeepAliveTimeout = false;
        if (currentKeepAlive == null) {
            currentKeepAlive = new KeepAliveCacheValue();
            currentKeepAlive.setUnitId(uid);
            currentKeepAlive.setReceiveTimeStamp(0L);
            currentKeepAliveTimeout = false;
        } else if (now - currentKeepAlive.getReceiveTimeStamp() > this.infomanKeepaliveTimeout) {
            currentKeepAliveTimeout = true;
        }
        String configName = "";
        boolean configUpToDate = false;
        String hardware = "";
        String hardwareSN = "";
        String infomanSN = "";
        String javaVMVersion = "";
        String kernelVersion = "";
        String pmVersion = "";
        String rootFSVersion = "";
        String swVersion = "";
        if (this.lcu != null && this.lcu.isSuperAdmin()) {
            try {
                CurrentInfomanSetupValue infomanSetupValue = this.infomanConfigurationClientFacade.getCurrentInfomanSetup(unitID);
                configName = infomanSetupValue.getConfigurationName();
                configUpToDate = infomanSetupValue.getConfigurationUpToDate();
                hardware = infomanSetupValue.getHardware();
                hardwareSN = infomanSetupValue.getHardwareSN();
                infomanSN = infomanSetupValue.getInfomanSN();
                javaVMVersion = infomanSetupValue.getJavaVMVersion();
                kernelVersion = infomanSetupValue.getKernelVersion();
                pmVersion = infomanSetupValue.getPowerManagementVersion();
                rootFSVersion = infomanSetupValue.getRootfsVersion();
                swVersion = infomanSetupValue.getSoftwareVersion();
            }
            catch (Throwable ex) {
                log.warn((Object)(method + "Could not get current infoman setup for unitId \"" + unitID + "\": " + ex.getMessage()));
            }
        }
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        this.addUnitIdentityBasicData(unitIdentities, mapClientStamp, unitID);
        if (currentGdata != null) {
            mapClientStamp.put("GeoBegin", currentGdata.getCreateTime());
            mapClientStamp.put("GpsGga", currentGdata.getGgaRec());
            mapClientStamp.put("GpsRmc", currentGdata.getRmcRec());
            mapClientStamp.put("GpsTrusted", currentGdata.getTrusted());
            mapClientStamp.put("GpsLatMsec", currentGdata.getLatMSEC());
            mapClientStamp.put("GpsLongMsec", currentGdata.getLongMSEC());
            mapClientStamp.put("Area", areaValue.getArea());
            mapClientStamp.put("AreaName", areaValue.getDescription());
        }
        mapClientStamp.put("KeepaliveTimestamp", currentKeepAlive.getReceiveTimeStamp());
        mapClientStamp.put("KeepaliveTimeout", currentKeepAliveTimeout);
        mapClientStamp.put("infomanConfigurationName", configName);
        mapClientStamp.put("infomanConfigurationUpToDate", configUpToDate);
        mapClientStamp.put("infomanHardware", hardware);
        mapClientStamp.put("infomanHardwareSN", hardwareSN);
        mapClientStamp.put("infomanInfomanSN", infomanSN);
        mapClientStamp.put("infomanJavaVMVersion", javaVMVersion);
        mapClientStamp.put("infomanKernelVersion", kernelVersion);
        mapClientStamp.put("infomanPMVersion", pmVersion);
        mapClientStamp.put("infomanRootFSVersion", rootFSVersion);
        mapClientStamp.put("infomanSoftwareVersion", swVersion);
        if (infomanMessagesNeeded) {
            this.addInfomanMessages(unitID, mapClientStamp);
        }
        if (notifyMessagesNeeded) {
            TreeMap<String, Map> notifyMap = this.addNotifyMessages(uid, notifyEvents, unitID);
            mapClientStamp.put("NotifyEvents", notifyMap);
        }
        if (useMessagesNeeded) {
            UseCacheValue useEvent = (UseCacheValue)currentUseEvents.get(unitID);
            if (useEvent == null) {
                log.debug((Object)(method + "no useEvents found for unitId " + uid));
            } else {
                this.addUseEvent(mapClientStamp, useEvent);
            }
        }
        return mapClientStamp;
    }

    private AreaValue addArea(long uid, Map areas, CurrentGdataCacheValue currentGdata) {
        AreaValue areaValue = null;
        AreaLocal area = null;
        try {
            CurrentGdataCacheLocal cache = this.currentGdataCacheHome.findByPrimaryKey(currentGdata.getPrimaryKey());
            area = cache.getAreaLocal();
            if (area == null) {
                log.debug((Object)("empty area in CURRENT_GDATA_CACHE for unitId " + uid + ", seems like GSE is out of airport"));
            } else {
                areaValue = (AreaValue)areas.get(area.getAreaId());
            }
        }
        catch (FinderException ex) {
            log.error((Object)"getNewMapClientStamp() unable to related area", (Throwable)ex);
        }
        if (areaValue == null) {
            if (area != null) {
                log.error((Object)("no AREA record found for area '" + area.getAreaId() + "' in CURRENT_GDATA_CACHE"));
            }
            areaValue = new AreaValue();
            areaValue.setArea("-");
            areaValue.setDescription("(not defined)");
            areaValue.setPriority(0);
        }
        return areaValue;
    }

    private void addInfomanMessages(Long unitID, Map<String, Object> mapClientStamp) {
        ScanmanMsgHistoryValue lastIPMessage = null;
        ScanmanMsgHistoryValue lastBootMessage = null;
        ScanmanMsgHistoryValue lastErrorMessage = null;
        lastErrorMessage = this.getLastScanmanMessage(unitID, 9);
        lastIPMessage = this.getLastScanmanMessage(unitID, 10);
        lastBootMessage = this.getLastScanmanMessage(unitID, 25);
        if (lastBootMessage != null) {
            mapClientStamp.put("SmBootTimestamp", lastBootMessage.getCreateTime());
            mapClientStamp.put("SmBootMessage", lastBootMessage.getMsgToString());
        }
        if (lastIPMessage != null) {
            mapClientStamp.put("SmIpTimestamp", lastIPMessage.getCreateTime());
            mapClientStamp.put("SmIpMessage", lastIPMessage.getMsgToString());
        }
        if (lastErrorMessage != null) {
            mapClientStamp.put("SmErrorTimestamp", lastErrorMessage.getCreateTime());
            mapClientStamp.put("SmErrorMessage", lastErrorMessage.getMsgToString());
        }
    }

    private void addUseEvent(Map mapClientStamp, UseCacheValue useEvent) {
        long userId = useEvent.getUserId();
        try {
            UseUserValue useUserValue = this.useFacade.getUser(userId);
            mapClientStamp.put("UseEventTimestamp", useEvent.getBeginTime());
            mapClientStamp.put("UseEventUserGroupId", useEvent.getGroupId());
            mapClientStamp.put("UseEventLogin", true);
            mapClientStamp.put("UseEventReceiveTime", useEvent.getBeginReceiveTime());
            mapClientStamp.put("UseEventUserKey", useUserValue.getKey());
            mapClientStamp.put("UseEventDriverName", useUserValue.getName());
            mapClientStamp.put("UseEventPersonalNumber", useUserValue.getPersonalNumber());
        }
        catch (RemoteException e) {
            log.error((Object)"getNewMapClientStamp runs into RemoteException: ", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            log.error((Object)"getNewMapClientStamp runs into UserNotFoundException: ", (Throwable)e);
        }
    }

    private TreeMap<String, Map> addNotifyMessages(long uid, Map notifyEvents, Long unitID) {
        TreeMap<String, Map> notifyMap = null;
        Collection notifys = (Collection)notifyEvents.get(unitID);
        if (notifys == null) {
            log.debug((Object)("no notifyEvents found for unitId " + uid));
        } else {
            notifyMap = new TreeMap<String, Map>();
            for (NotifyHistoryValue nhv : notifys) {
                long timestamp = nhv.getCreateTime();
                long messageId = nhv.getMessageId();
                NotificationValue value = this.notificationAdminFacade.getNotificationById(messageId);
                String message = "";
                if (value != null) {
                    message = value.getDefaultName();
                }
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                valueMap.put("UnitId", nhv.getUnitId());
                valueMap.put("NotifyMessageID", messageId);
                valueMap.put("NotifyMessage", message);
                valueMap.put("NotifyEntry", nhv.getEntry());
                valueMap.put("NotifyTimestamp", timestamp);
                valueMap.put("NotifyReceiveTime", nhv.getReceiveTime());
                notifyMap.put(timestamp + "_" + messageId, valueMap);
            }
        }
        return notifyMap;
    }

    private void addState(Map mapClientStamp, CurrentStateCacheValue state) {
        String methodName = "addState(): ";
        long stateModel = state.getStateModelId();
        if (stateModel == 2010L) {
            mapClientStamp.put("MotorState", state.getState());
            mapClientStamp.put("MotorStateBegin", state.getBeginTime());
        } else if (stateModel == 2050L) {
            mapClientStamp.put("OperationState", state.getState());
            mapClientStamp.put("OperationStateBegin", state.getBeginTime());
        } else if (stateModel == 2090L) {
            mapClientStamp.put("ServiceState", state.getState());
            mapClientStamp.put("ServiceStateBegin", state.getBeginTime());
            mapClientStamp.put("ServiceStateRemark", state.getRemark());
        } else if (stateModel == 2100L) {
            mapClientStamp.put("AssignedState", state.getState());
            mapClientStamp.put("AssignedStateBegin", state.getBeginTime());
            mapClientStamp.put("AssignedStateRemark", state.getRemark());
        } else if (stateModel == 2110L) {
            mapClientStamp.put("InfomanOnlineState", state.getState());
            mapClientStamp.put("InfomanOnlineStateBegin", state.getBeginTime());
        } else if (stateModel == 2030L) {
            mapClientStamp.put("FuelState", state.getState());
            mapClientStamp.put("FuelStateBegin", state.getBeginTime());
        } else if (stateModel == 2020L) {
            mapClientStamp.put("ConnectorState", state.getState());
            mapClientStamp.put("ConnectorStateBegin", state.getBeginTime());
        } else if (stateModel == 2910L) {
            mapClientStamp.put("Flag1State", state.getState());
            mapClientStamp.put("Flag1StateBegin", state.getBeginTime());
        } else if (stateModel == 2920L) {
            mapClientStamp.put("Flag2State", state.getState());
            mapClientStamp.put("Flag2StateBegin", state.getBeginTime());
        } else if (stateModel == 2930L) {
            mapClientStamp.put("Flag3State", state.getState());
            mapClientStamp.put("Flag3StateBegin", state.getBeginTime());
        } else if (stateModel == 2120L) {
            mapClientStamp.put("GseAssignmentState", state.getState());
            mapClientStamp.put("GseAssignmentStateBegin", state.getBeginTime());
        } else {
            log.warn((Object)(methodName + "state model '" + stateModel + "' not implemented!"));
        }
    }

    class NotifyComparator
    implements Comparator {
        NotifyComparator() {
        }

        public int compare(Object o1, Object o2) {
            int value = 0;
            value = ((NotifyHistoryValue)o1).getCreateTime() == ((NotifyHistoryValue)o2).getCreateTime() ? 0 : (((NotifyHistoryValue)o1).getCreateTime() < ((NotifyHistoryValue)o2).getCreateTime() ? 1 : -1);
            return value;
        }
    }
}

