/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.audit;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataUtil;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.common.ApplicationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(AuditFacadeBean.class);
    private static final String CONFIG_PARAM_AUDIT_TRAIL = "auditdata.activated";
    private static final String FILTER_OUT_SUPERADMIN = "filterOutSuperadmin";
    private boolean auditTrail = false;
    private boolean filterOutSuperadmin = false;
    private AuditdataLocalHome auditdataHome = null;
    private ConfigurationLocalHome configurationHome = null;
    private ConfigurationLocal configuration;

    public void ejbCreate() throws CreateException {
        try {
            this.auditdataHome = AuditdataUtil.getLocalHome();
            this.configurationHome = ConfigurationUtil.getLocalHome();
            this.configuration = this.configurationHome.create();
            try {
                String param = this.configuration.getParameter(CONFIG_PARAM_AUDIT_TRAIL);
                if (param.length() > 0) {
                    this.auditTrail = Boolean.parseBoolean(param);
                }
                if ((param = this.configuration.getParameter(FILTER_OUT_SUPERADMIN)).length() > 0) {
                    this.filterOutSuperadmin = Boolean.parseBoolean(param);
                }
            }
            catch (ConfigurationParameterNotFoundException e) {
                logger.error((Object)"parameter for auditdata missed, changes wont be logged into auditdata");
            }
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public boolean isAuditTrail() {
        return this.auditTrail;
    }

    public Long createAuditData(String application, String primaryKey, String entity, Object oldValue, Object newValue) throws CreateException {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String oldString = "";
        String newString = "";
        if (oldValue != null) {
            oldString = oldValue.toString();
            if (entity == null || entity.length() == 0) {
                entity = oldValue.getClass().getSimpleName();
            }
        }
        if (newValue != null) {
            newString = newValue.toString();
            if (entity == null || entity.length() == 0) {
                entity = newValue.getClass().getSimpleName();
            }
        }
        try {
            value.setOldValue(oldString.getBytes());
            value.setNewValue(newString.getBytes());
            String action = "Update";
            if (oldString.length() == 0) {
                action = "Insert";
            } else if (newString.length() == 0 || newString.equals("Marked as deleted")) {
                action = "Delete";
            } else if (oldValue instanceof CurrentGdataCacheValue || newValue instanceof CurrentGdataCacheValue) {
                action = "Area Adjustment";
            }
            value.setAction(action);
            value.setModifiedEntity(entity);
            value.setPkModifiedRecord(primaryKey);
            value.setTimestamp(System.currentTimeMillis());
            value.setUsername(this.getCallerName());
            value.setApplicationName(application);
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            this.auditdataHome.reorganizeSequence();
            try {
                local = this.auditdataHome.create(value);
            }
            catch (CreateException e) {
                String msg = "auditData runs into error ";
                logger.error((Object)msg, (Throwable)e);
                throw new ImplicitRollbackException(msg);
            }
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public List<AuditdataValue> getAuditdata(long begin, long end) {
        ArrayList<AuditdataValue> list = null;
        try {
            Collection collection = this.auditdataHome.findByTimeframe(begin, end, "AccessToSystem");
            AuditdataLocal[] arr = collection.toArray(new AuditdataLocal[collection.size()]);
            list = new ArrayList<AuditdataValue>();
            for (int i = 0; i != arr.length; ++i) {
                AuditdataValue value = arr[i].getAuditdataValue();
                if (this.filterOutSuperadmin && !this.sessionContext.isCallerInRole("superadmin") && value.getUsername().equals("proveoadmin")) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long createAuditDataLoginLogout(ApplicationType application, boolean login, String username) {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String string = "";
        try {
            String action = "Login";
            if (!login) {
                action = "Logout";
            }
            value.setOldValue(string.getBytes());
            value.setNewValue(action.getBytes());
            value.setAction(action);
            value.setModifiedEntity("AccessToSystem");
            value.setPkModifiedRecord("");
            value.setTimestamp(System.currentTimeMillis());
            if (username == null) {
                value.setUsername(this.getCallerName());
            } else {
                value.setUsername(username);
            }
            value.setApplicationName(application.toString());
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            logger.error((Object)"createAuditDataLoginLogout runs into error ", (Throwable)ex);
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public Long createAuditDataFailedLogin(ApplicationType application, String username, String password) {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String string = "";
        try {
            String action = "Failed Login";
            value.setOldValue(string.getBytes());
            value.setNewValue(string.getBytes());
            value.setAction(action);
            value.setModifiedEntity("AccessToSystem");
            value.setPkModifiedRecord(password);
            value.setTimestamp(System.currentTimeMillis());
            value.setApplicationName(application.toString());
            if (username == null) {
                value.setUsername(this.getCallerName());
            } else {
                value.setUsername(username);
            }
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            logger.error((Object)"createAuditDataFailedLogin runs into error ", (Throwable)ex);
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public List<AuditdataValue> getAuditdataLoginLogout(long begin, long end) {
        ArrayList<AuditdataValue> list = null;
        try {
            Collection collection = this.auditdataHome.findFailedLoginByTimeframe(begin, end, "AccessToSystem");
            AuditdataLocal[] arr = collection.toArray(new AuditdataLocal[collection.size()]);
            list = new ArrayList<AuditdataValue>();
            for (int i = 0; i != arr.length; ++i) {
                AuditdataValue value = arr[i].getAuditdataValue();
                if (value.getUsername() == null || value.getUsername().equals("nobody") || this.filterOutSuperadmin && !this.sessionContext.isCallerInRole("superadmin") && value.getUsername().equals("proveoadmin")) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }
}

