/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.observable;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableJMSSender;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(ObservableFacadeBean.class);
    private static long lastPkGdataHistory;
    private ObservableJMSSender observableJMSSender;

    public void ejbCreate() throws CreateException {
        try {
            this.observableJMSSender = new ObservableJMSSender();
            this.observableJMSSender.initialize();
        }
        catch (Exception e) {
            throw new CreateException();
        }
    }

    public void ejbRemove() {
        try {
            if (this.observableJMSSender != null) {
                this.observableJMSSender.closeConnection();
                this.observableJMSSender = null;
            }
        }
        catch (Exception ex) {
            log.error((Object)("runs into " + ex));
        }
    }

    public void notifyClients(String msg, String kindOfEvent) {
        if (msg != null) {
            this.observableJMSSender.sendMessage(msg, kindOfEvent);
        } else {
            log.warn((Object)"msg is null, nothing to send!!!");
        }
    }

    public void notifyClients(SerializableEventWrapper wrapper, String kindOfEvent) {
        if (wrapper != null) {
            if (wrapper.get_typeOfEvent().equals("GeoStructHistoryAndCache")) {
                long pkGdataHistoryPre = wrapper.get_PkGdataHistoryPre();
                if (pkGdataHistoryPre < lastPkGdataHistory) {
                    log.warn((Object)("new pk (" + pkGdataHistoryPre + ") is less than last pk (" + lastPkGdataHistory + ")"));
                }
                lastPkGdataHistory = pkGdataHistoryPre;
            }
            this.observableJMSSender.sendMessage(wrapper, kindOfEvent);
        } else {
            log.warn((Object)"wrapper is null, nothing to send!!!");
        }
    }
}

