/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisFlight.plausibility;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlausibilityCheckerBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(PlausibilityCheckerBean.class);
    final long MIN = 60000L;

    public void ejbCreate() throws CreateException {
    }

    public boolean isTurnaroundPlausible(FisFlightCacheValue arrivalFlight, FisFlightCacheValue departureFlight) {
        if (!this.isArrivalPlausible(arrivalFlight)) {
            return false;
        }
        if (!this.isDeparturePlausible(departureFlight)) {
            return false;
        }
        long startTime = arrivalFlight.getScheduledTimeOfArrival();
        if (arrivalFlight.getEstimatedTimeOfArrival() != 0L) {
            startTime = arrivalFlight.getEstimatedTimeOfArrival();
        }
        if (arrivalFlight.getOnBlockTime() != 0L) {
            startTime = arrivalFlight.getOnBlockTime();
        }
        long endTime = departureFlight.getScheduledTimeOfDeparture();
        if (departureFlight.getEstimatedTimeOfDeparture() != 0L) {
            endTime = departureFlight.getEstimatedTimeOfDeparture();
        }
        if (departureFlight.getOffBlockTime() != 0L) {
            endTime = departureFlight.getOffBlockTime();
        }
        if (endTime < startTime) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("End time ");
            strBuilder.append(endTime);
            strBuilder.append("is before start time ");
            strBuilder.append(startTime);
            strBuilder.append(". Arrival flight is ");
            strBuilder.append(arrivalFlight.getUniqueFlightNumber());
            strBuilder.append(". Departure flight is ");
            strBuilder.append(departureFlight.getUniqueFlightNumber());
            log.warn((Object)strBuilder.toString());
        }
        return true;
    }

    public boolean isArrivalPlausible(FisFlightCacheValue arrivalFlight) {
        long now = System.currentTimeMillis();
        long onbl = arrivalFlight.getOnBlockTime();
        if (onbl - now > 300000L) {
            log.warn((Object)("On-block time of flight " + arrivalFlight.getUniqueFlightNumber() + " is more than 5 min in the future."));
            return false;
        }
        return true;
    }

    public boolean isDeparturePlausible(FisFlightCacheValue departureFlight) {
        long now = System.currentTimeMillis();
        long ofbl = departureFlight.getOffBlockTime();
        if (ofbl - now > 300000L) {
            log.warn((Object)("Off-block time of flight " + departureFlight.getUniqueFlightNumber() + " is more than 5 min in the future."));
            return false;
        }
        return true;
    }
}

