/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stopwatch
implements Serializable {
    private static final long serialVersionUID = -3799285388926331724L;
    String stopwatchName;
    public static final String OVERALL = "overall";
    public static final String BUILD_DTOs = "building DTO";
    public static final String DATABASE_ACCESS = "dataBase access";
    public static final String CHARTING = "charting";
    public static final String CLIENT_PROCESSING = "client Processing";
    HashMap<String, Watch> watches = new HashMap();
    private static final Log log = LogFactory.getLog(Stopwatch.class);
    private Class<?> c;

    public Stopwatch(Class<?> c, String name) {
        this.c = c;
        this.stopwatchName = name;
    }

    public void start(String watchname) {
        Watch watch = new Watch(watchname);
        watch.start();
        this.watches.put(watchname, watch);
    }

    public Watch stop(String watchname, boolean logNow) {
        Watch watch = this.watches.get(watchname);
        if (watch != null) {
            watch.stop();
            if (logNow) {
                watch.logDuration();
            }
        }
        return watch;
    }

    public void stop(String watchname, boolean logNow, int dataSize) {
        Watch watch = this.stop(watchname, false);
        if (watch != null) {
            watch.dataSize = dataSize;
            if (logNow) {
                watch.logDuration();
            }
        }
    }

    public void remove(String watchname) {
        this.watches.remove(watchname);
    }

    public void logAll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Perfomance Log Summary for: " + this.stopwatchName + ""));
            ArrayList<Watch> list = new ArrayList<Watch>();
            for (Map.Entry<String, Watch> e : this.watches.entrySet()) {
                list.add(e.getValue());
            }
            Collections.sort(list, new WatchComparator());
            for (Watch watch : list) {
                watch.logDuration();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WatchComparator
    implements Comparator<Watch> {
        WatchComparator() {
        }

        @Override
        public int compare(Watch o1, Watch o2) {
            return o1.end.compareTo(o2.end);
        }
    }

    class Watch
    implements Serializable {
        private static final long serialVersionUID = -3463103918494770036L;
        String name;
        Integer dataSize;
        Long start;
        Long end;
        Long duration;

        public Watch(String name) {
            this.name = name;
        }

        private void logDuration() {
            if (log.isDebugEnabled()) {
                long minutes = this.duration / 60000L;
                long seconds = this.duration % 60000L / 1000L;
                long millis = this.duration % 1000L;
                StringBuilder sb = new StringBuilder();
                sb.append("Time: ");
                sb.append(String.format("%02d:%02d.%03d", minutes, seconds, millis));
                sb.append(" (class: ");
                sb.append(Stopwatch.this.c.getSimpleName());
                sb.append("; watchName: ");
                sb.append(this.name);
                if (this.dataSize != null) {
                    sb.append("; dataSize: ");
                    sb.append(this.dataSize);
                }
                sb.append(")");
                log.debug((Object)sb.toString());
            }
        }

        public void start() {
            this.start = System.currentTimeMillis();
        }

        public void stop() {
            this.end = System.currentTimeMillis();
            this.duration = this.end - this.start;
        }

        public void stop(int size) {
            this.stop();
            this.dataSize = size;
        }
    }
}

