/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.security;

import de.proveo.wwt.logic.app.security.LoginCallbackHandler;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacade;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditFacadeHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacade;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.web.common.ApplicationType;
import java.rmi.RemoteException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginContextUtil {
    private static final Log log = LogFactory.getLog(LoginContextUtil.class);
    private UserAdminFacade userAdminFacade;
    private AuditFacade auditFacade;
    String username;
    boolean accessPermitted = false;
    String accessReasonCode = "";
    CallbackHandler loginCallbackHandler;
    TreeSet<String> permissions = new TreeSet();
    TreeSet<String> roles = new TreeSet();
    public static final String ROLE_SUPERADMIN = "superadmin";
    public static final String ROLE_AIRPORTMAP = "section.airportmap";
    public static final String ROLE_AIRPORTMAP_ADMIN = "section.airportmap_admin";
    public static final String ROLE_AIRPORTMAP_NOTIFICATION = "section.airportmap.notification";

    public LoginContextUtil(String user, String pw) throws Exception {
        this.username = user;
        this.loginCallbackHandler = new LoginCallbackHandler(this.username, pw);
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("AuditFacade");
            this.auditFacade = ((AuditFacadeHome)PortableRemoteObject.narrow((Object)ref, AuditFacadeHome.class)).create();
            ref = ctx.lookup("UserAdminFacade");
            UserAdminFacadeHome userAdminFacadeHome = (UserAdminFacadeHome)PortableRemoteObject.narrow((Object)ref, UserAdminFacadeHome.class);
            this.userAdminFacade = userAdminFacadeHome.create();
        }
        catch (NamingException ex) {
            log.error((Object)"naming problem", (Throwable)ex);
            throw new Exception("naming problem", ex);
        }
        catch (CreateException ex) {
            log.error((Object)"create problem", (Throwable)ex);
            throw new Exception("create problem", ex);
        }
        catch (RemoteException ex) {
            log.error((Object)"remote problem", (Throwable)ex);
            throw new Exception("remote problem", ex);
        }
        this.fetchPermissions();
    }

    public LoginContextUtil(String user, char[] pw) throws Exception {
        this.username = user;
        this.loginCallbackHandler = new LoginCallbackHandler(this.username, pw);
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup("AuditFacade");
            this.auditFacade = ((AuditFacadeHome)PortableRemoteObject.narrow((Object)ref, AuditFacadeHome.class)).create();
            ref = ctx.lookup("UserAdminFacade");
            UserAdminFacadeHome userAdminFacadeHome = (UserAdminFacadeHome)PortableRemoteObject.narrow((Object)ref, UserAdminFacadeHome.class);
            this.userAdminFacade = userAdminFacadeHome.create();
        }
        catch (NamingException ex) {
            log.error((Object)"naming problem", (Throwable)ex);
            throw new Exception("naming problem", ex);
        }
        catch (CreateException ex) {
            log.error((Object)"create problem", (Throwable)ex);
            throw new Exception("create problem", ex);
        }
        catch (RemoteException ex) {
            log.error((Object)"remote problem", (Throwable)ex);
            throw new Exception("remote problem", ex);
        }
        this.fetchPermissions();
    }

    private void fetchPermissions() throws LoginException {
        String method = "fetchPermissions(): ";
        try {
            LoginContext lc = new LoginContext("rts", this.loginCallbackHandler);
            lc.login();
            Set<Principal> principals = lc.getSubject().getPrincipals();
            for (Principal principal : principals) {
                if (principal == null || principal.getName() == null) {
                    log.warn((Object)(method + "found a principal==null or principal's name is null"));
                    continue;
                }
                if (!(principal instanceof Group)) continue;
                Group group = (Group)principal;
                Enumeration e = group.members();
                while (e.hasMoreElements()) {
                    Principal rolePrincipal = (Principal)e.nextElement();
                    String role = rolePrincipal.getName();
                    this.roles.add(role);
                }
                String permission = principal.getName();
                this.permissions.add(permission);
            }
            this.accessPermitted = true;
        }
        catch (LoginException lex) {
            try {
                AccountValue accountValue = this.getAccountValue();
                if (accountValue == null) {
                    this.accessReasonCode = "incorrectUsernameOrPassword";
                    this.userAdminFacade.incrementFailedLogins(this.username);
                    log.debug((Object)(method + "login failed, user '" + this.username + "' unknown"));
                } else if (accountValue.getDeleted()) {
                    this.accessReasonCode = "incorrectUsernameOrPassword";
                    log.debug((Object)(method + "user is deleted"));
                } else if (accountValue.getBlockOut()) {
                    this.accessReasonCode = "userBlocked";
                    log.debug((Object)(method + "user is blocked"));
                } else {
                    this.accessReasonCode = "incorrectUsernameOrPassword";
                    this.userAdminFacade.incrementFailedLogins(this.username);
                    log.debug((Object)(method + "login failed, but user '" + this.username + "' is not blocked: incorrect username or password"));
                }
            }
            catch (RemoteException e1) {
                log.error((Object)(method + "runs into"), (Throwable)e1);
                this.accessReasonCode = "LogoutApplicationError";
            }
            this.accessPermitted = false;
            throw lex;
        }
    }

    public HashMap login4AirportMap() {
        String method = "login4AirportMap(): ";
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (this.accessPermitted) {
            responseMap.put("Permissions", this.permissions);
            responseMap.put("Roles", this.roles);
            if (this.isSuperAdmin()) {
                responseMap.put("AccessPermitted", true);
                try {
                    this.auditFacade.createAuditDataLoginLogout(ApplicationType.AIRPORTMAP, true, this.username);
                }
                catch (RemoteException re) {
                    log.error((Object)("AdminFacade.createAuditDataLoginLogout() runs into " + re.getMessage()));
                }
            } else {
                AccountValue accountValue = this.getAccountValue();
                if (accountValue == null) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "incorrectUsernameOrPassword");
                    log.error((Object)("account value null for user '" + this.username + "'"));
                } else if (accountValue.getDeleted()) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "incorrectUsernameOrPassword");
                    log.debug((Object)"user is deleted");
                } else if (accountValue.getBlockOut()) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "userBlocked");
                    log.debug((Object)"user is blocked");
                } else if (!this.isUserInRole(ROLE_AIRPORTMAP)) {
                    responseMap.put("AccessPermitted", false);
                    responseMap.put("ReasonCode", "UserNotInRoleAirportmap");
                    log.debug((Object)"user is not in role 'section.airportmap'");
                } else {
                    responseMap.put("AccessPermitted", true);
                    log.debug((Object)(method + "login access granted for user '" + this.username + "'"));
                    try {
                        this.userAdminFacade.setLoginSuccessful(this.username);
                        this.auditFacade.createAuditDataLoginLogout(ApplicationType.AIRPORTMAP, true, this.username);
                        log.debug((Object)(method + "login logged (audit data) for user '" + this.username + "'"));
                    }
                    catch (RemoteException re) {
                        log.error((Object)("AdminFacade.createAuditDataLoginLogout() runs into " + re.getMessage()));
                    }
                }
            }
        } else {
            responseMap.put("AccessPermitted", false);
            responseMap.put("ReasonCode", this.accessReasonCode);
        }
        return responseMap;
    }

    public HashMap logout4AirportMap() {
        String method = "logout4AirportMap(): ";
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (this.accessPermitted) {
            try {
                this.auditFacade.createAuditDataLoginLogout(ApplicationType.AIRPORTMAP, false, this.username);
                if (!this.isSuperAdmin()) {
                    log.debug((Object)(method + "logout logged (audit data) for user '" + this.username + "'"));
                }
                responseMap.put("LogoutSuccessful", true);
            }
            catch (RemoteException re) {
                log.error((Object)(method + "AdminFacade.createAuditDataLoginLogout() runs into " + re.getMessage()));
                responseMap.put("LogoutSuccessful", false);
                responseMap.put("LogoutReasonCode", "LogoutApplicationError");
            }
        } else {
            log.error((Object)(method + "could not perform logout and audit log because of refused access."));
            responseMap.put("LogoutSuccessful", false);
            responseMap.put("LogoutReasonCode", this.accessReasonCode);
        }
        return responseMap;
    }

    public TreeSet getPermissions() {
        return this.permissions;
    }

    public TreeSet getRoles() {
        return this.roles;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public boolean isSuperAdmin() {
        return this.roles.contains(ROLE_SUPERADMIN);
    }

    private AccountValue getAccountValue() {
        AccountValue accountValue = null;
        try {
            accountValue = this.userAdminFacade.getAccount(this.username);
        }
        catch (RemoteException e1) {
            log.error((Object)"getAccountValue() runs into", (Throwable)e1);
        }
        return accountValue;
    }
}

