/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.security;

import de.proveo.util.ByteUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginCallbackHandler
implements CallbackHandler {
    private static final Log log = LogFactory.getLog(LoginCallbackHandler.class);
    private String name;
    private char[] pass;

    public LoginCallbackHandler(String wwtUser, String password) {
        if (wwtUser == null || password == null) {
            log.warn((Object)"username or password is not set!");
        } else {
            this.name = wwtUser;
            this.pass = this.plainStringToSHA1(password).toCharArray();
        }
    }

    public LoginCallbackHandler(String wwtUser, char[] passwordHashSha1) {
        if (wwtUser == null || passwordHashSha1 == null) {
            log.warn((Object)"username or password is not set!");
        } else {
            this.name = wwtUser;
            this.pass = passwordHashSha1;
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.name);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.pass);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Callback not known");
        }
    }

    private String plainStringToSHA1(String input) {
        MessageDigest md = null;
        byte[] byteHash = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("NoSuchAlgorithmException caught! " + e.getMessage()));
        }
        md.reset();
        md.update(input.getBytes());
        byteHash = md.digest();
        String resultString = ByteUtil.toHexString((byte[])byteHash);
        return resultString;
    }
}

