/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.ReposNotifyInformation;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.callback.ReposNotifyCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.InputInterface;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.OutputInterface;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.Version;

public class SVNAdmin {
    private SVNRepos aSVNAdmin = new SVNRepos();
    protected long cppAddr = this.aSVNAdmin.getCppAddr();
    public static final String BDB = "bdb";
    public static final String FSFS = "fsfs";

    public void dispose() {
        this.aSVNAdmin.dispose();
    }

    protected void finalize() {
    }

    public Version getVersion() {
        return new Version(NativeResources.getVersion());
    }

    public void create(String string, boolean bl, boolean bl2, String string2, String string3) throws ClientException {
        try {
            this.aSVNAdmin.create(new File(string), bl, bl2, string2 == null ? null : new File(string2), string3);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void deltify(String string, Revision revision, Revision revision2) throws ClientException {
        try {
            this.aSVNAdmin.deltify(new File(string), revision == null ? null : revision.toApache(), revision2 == null ? null : revision2.toApache());
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void dump(String string, OutputInterface outputInterface, OutputInterface outputInterface2, Revision revision, Revision revision2, boolean bl) throws ClientException {
        this.dump(string, outputInterface, outputInterface2, revision, revision2, bl, false);
    }

    public void dump(String string, OutputInterface outputInterface, OutputInterface outputInterface2, Revision revision, Revision revision2, boolean bl, boolean bl2) throws ClientException {
        try {
            this.aSVNAdmin.dump(new File(string), new OutputWrapper(outputInterface), revision == null ? null : revision.toApache(), revision2 == null ? null : revision2.toApache(), bl, bl2, new ReposNotifyHandler(outputInterface2));
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void hotcopy(String string, String string2, boolean bl) throws ClientException {
        try {
            this.aSVNAdmin.hotcopy(new File(string), new File(string2), bl);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void listDBLogs(String string, MessageReceiver messageReceiver) throws ClientException {
        try {
            this.aSVNAdmin.listDBLogs(new File(string), messageReceiver);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void listUnusedDBLogs(String string, MessageReceiver messageReceiver) throws ClientException {
        try {
            this.aSVNAdmin.listUnusedDBLogs(new File(string), messageReceiver);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void load(String string, InputInterface inputInterface, OutputInterface outputInterface, boolean bl, boolean bl2, String string2) throws ClientException {
        this.load(string, inputInterface, outputInterface, bl, bl2, false, false, string2);
    }

    public void load(String string, InputInterface inputInterface, OutputInterface outputInterface, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) throws ClientException {
        try {
            this.aSVNAdmin.load(new File(string), new InputWrapper(inputInterface), bl, bl2, bl3, bl4, string2, new ReposNotifyHandler(outputInterface));
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void lstxns(String string, MessageReceiver messageReceiver) throws ClientException {
        try {
            this.aSVNAdmin.lstxns(new File(string), messageReceiver);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public long recover(String string) throws ClientException {
        try {
            return this.aSVNAdmin.recover(new File(string), null);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void rmtxns(String string, String[] stringArray) throws ClientException {
        try {
            this.aSVNAdmin.rmtxns(new File(string), stringArray);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void setLog(String string, Revision revision, String string2, boolean bl) throws ClientException {
        try {
            this.aSVNAdmin.setRevProp(new File(string), revision == null ? null : revision.toApache(), "svn:log", string2, !bl, !bl);
        }
        catch (org.apache.subversion.javahl.SubversionException subversionException) {
            throw ClientException.fromException(subversionException);
        }
    }

    public void setRevProp(String string, Revision revision, String string2, String string3, boolean bl, boolean bl2) throws SubversionException {
        try {
            this.aSVNAdmin.setRevProp(new File(string), revision == null ? null : revision.toApache(), string2, string3, bl, bl2);
        }
        catch (org.apache.subversion.javahl.SubversionException subversionException) {
            throw new SubversionException(subversionException);
        }
    }

    public void verify(String string, OutputInterface outputInterface, Revision revision, Revision revision2) throws ClientException {
        try {
            this.aSVNAdmin.verify(new File(string), revision == null ? null : revision.toApache(), revision2 == null ? null : revision2.toApache(), new ReposNotifyHandler(outputInterface));
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public Lock[] lslocks(String string) throws ClientException {
        try {
            Set<org.apache.subversion.javahl.types.Lock> set = this.aSVNAdmin.lslocks(new File(string), Depth.toADepth(3));
            Lock[] lockArray = new Lock[set.size()];
            int n = 0;
            for (org.apache.subversion.javahl.types.Lock lock : set) {
                lockArray[n] = new Lock(lock);
                ++n;
            }
            return lockArray;
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    public void rmlocks(String string, String[] stringArray) throws ClientException {
        try {
            this.aSVNAdmin.rmlocks(new File(string), stringArray);
        }
        catch (org.apache.subversion.javahl.ClientException clientException) {
            throw new ClientException(clientException);
        }
    }

    private class InputWrapper
    extends InputStream {
        private InputInterface inputer;

        InputWrapper(InputInterface inputInterface) {
            this.inputer = inputInterface;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            if (this.inputer.read(byArray) > 0) {
                return byArray[0];
            }
            return -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.inputer.read(byArray);
        }

        public void close() throws IOException {
            this.inputer.close();
        }
    }

    public static interface MessageReceiver
    extends ISVNRepos.MessageReceiver {
    }

    private class OutputWrapper
    extends OutputStream {
        private OutputInterface outputer;

        OutputWrapper(OutputInterface outputInterface) {
            this.outputer = outputInterface;
        }

        public void write(int n) throws IOException {
            this.outputer.write(new byte[]{(byte)(n & 0xFF)});
        }

        public void write(byte[] byArray) throws IOException {
            this.outputer.write(byArray);
        }

        public void close() throws IOException {
            this.outputer.close();
        }
    }

    private class ReposNotifyHandler
    implements ReposNotifyCallback {
        private OutputInterface outputer;

        public ReposNotifyHandler(OutputInterface outputInterface) {
            this.outputer = outputInterface;
        }

        public void onNotify(ReposNotifyInformation reposNotifyInformation) {
            String string;
            block1 : switch (reposNotifyInformation.getAction()) {
                case warning: {
                    string = reposNotifyInformation.getWarning();
                    break;
                }
                case dump_rev_end: {
                    string = "* Dumped revision " + reposNotifyInformation.getRevision() + ".\n";
                    break;
                }
                case verify_rev_end: {
                    string = "* Verified revision " + reposNotifyInformation.getRevision() + ".\n";
                    break;
                }
                case load_txn_committed: {
                    if (reposNotifyInformation.getOldRevision() == -1L) {
                        string = "\n------- Committed revision " + reposNotifyInformation.getNewRevision() + " >>>\n\n";
                        break;
                    }
                    string = "\n------- Committed new rev " + reposNotifyInformation.getNewRevision() + " (loaded from original rev " + reposNotifyInformation.getOldRevision() + ") >>>\n\n";
                    break;
                }
                case load_node_start: {
                    switch (reposNotifyInformation.getNodeAction()) {
                        case change: {
                            string = "     * editing path : " + reposNotifyInformation.getPath() + " ...";
                            break block1;
                        }
                        case deleted: {
                            string = "     * deleting path : " + reposNotifyInformation.getPath() + " ...";
                            break block1;
                        }
                        case add: {
                            string = "     * adding path : " + reposNotifyInformation.getPath() + " ...";
                            break block1;
                        }
                        case replace: {
                            string = "     * replacing path : " + reposNotifyInformation.getPath() + " ...";
                            break block1;
                        }
                    }
                    string = null;
                    break;
                }
                case load_node_done: {
                    string = " done.\n";
                    break;
                }
                case load_copied_node: {
                    string = "COPIED...";
                    break;
                }
                case load_txn_start: {
                    string = "<<< Started new transaction, based on original revision " + reposNotifyInformation.getOldRevision() + "\n";
                    break;
                }
                case load_normalized_mergeinfo: {
                    string = " removing '\\r' from svn:mergeinfo ...";
                    break;
                }
                default: {
                    string = null;
                }
            }
            if (string != null) {
                try {
                    this.outputer.write(string.getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

