/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Info
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private String wcroot;
    private String url;
    private long rev;
    private NodeKind kind;
    private String reposRootUrl;
    private String reposUUID;
    private long lastChangedRev;
    private long lastChangedDate;
    private String lastChangedAuthor;
    private Lock lock;
    private boolean hasWcInfo;
    private ScheduleKind schedule;
    private String copyFromUrl;
    private long copyFromRev;
    private long textTime;
    private Checksum checksum;
    private String changelistName;
    private long workingSize;
    private long reposSize;
    private Depth depth;
    private Set<ConflictDescriptor> conflict;

    public Info(String string, String string2, String string3, long l, NodeKind nodeKind, String string4, String string5, long l2, long l3, String string6, Lock lock, boolean bl, ScheduleKind scheduleKind, String string7, long l4, long l5, Checksum checksum, String string8, long l6, long l7, Depth depth, Set<ConflictDescriptor> set) {
        this.path = string;
        this.wcroot = string2;
        this.url = string3;
        this.rev = l;
        this.kind = nodeKind;
        this.reposRootUrl = string4;
        this.reposUUID = string5;
        this.lastChangedRev = l2;
        this.lastChangedDate = l3;
        this.lastChangedAuthor = string6;
        this.lock = lock;
        this.hasWcInfo = bl;
        this.schedule = scheduleKind;
        this.copyFromUrl = string7;
        this.copyFromRev = l4;
        this.textTime = l5;
        this.checksum = checksum;
        this.changelistName = string8;
        this.workingSize = l6;
        this.reposSize = l7;
        this.depth = depth;
        this.conflict = set;
    }

    public String getPath() {
        return this.path;
    }

    public String getWcroot() {
        return this.wcroot;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRev() {
        return this.rev;
    }

    public NodeKind getKind() {
        return this.kind;
    }

    public String getReposRootUrl() {
        return this.reposRootUrl;
    }

    public String getReposUUID() {
        return this.reposUUID;
    }

    public long getLastChangedRev() {
        return this.lastChangedRev;
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == 0L) {
            return null;
        }
        return new Date(this.lastChangedDate / 1000L);
    }

    public String getLastChangedAuthor() {
        return this.lastChangedAuthor;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isHasWcInfo() {
        return this.hasWcInfo;
    }

    public ScheduleKind getSchedule() {
        return this.schedule;
    }

    public String getCopyFromUrl() {
        return this.copyFromUrl;
    }

    public long getCopyFromRev() {
        return this.copyFromRev;
    }

    public Date getTextTime() {
        if (this.textTime == 0L) {
            return null;
        }
        return new Date(this.textTime / 1000L);
    }

    public Checksum getChecksum() {
        return this.checksum;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public long getReposSize() {
        return this.reposSize;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public Set<ConflictDescriptor> getConflicts() {
        return this.conflict;
    }

    public String toString() {
        return this.getUrl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScheduleKind {
        normal,
        add,
        delete,
        replace;

    }
}

