/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.properties;

import java.awt.Color;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyHandler
extends Properties {
    private static final Log log = LogFactory.getLog(PropertyHandler.class);
    String propertyFileName = "";
    boolean warn = false;

    public PropertyHandler() {
    }

    public PropertyHandler(String fileName) {
        this.loadPropertyFile(fileName);
    }

    public boolean getBoolean(String pName, boolean pDefault) {
        String sMethodName = "getBoolean";
        boolean pRet = false;
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        if (!(prop = prop.trim()).equalsIgnoreCase("true") && !prop.equalsIgnoreCase("false")) {
            log.error((Object)(sMethodName + ": property '" + pName + "' must be 'true' or 'false' and not '" + prop + "' ! Return default value."));
            return pDefault;
        }
        pRet = Boolean.valueOf(prop);
        return pRet;
    }

    public Color getColor(String pName, Color pDefault) {
        String sMethodName = "getColor()";
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault.toString() + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        StringTokenizer st = new StringTokenizer(prop = prop.trim(), ",");
        if (st.countTokens() != 3) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' doesn't contain 3 color values !! Use given default '" + pDefault.toString() + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        int[] cols = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            int intVal;
            String token = st.nextToken().trim();
            try {
                intVal = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                log.error((Object)(sMethodName + ": token '" + token + "' is not an integer value ! Use '0'. "));
                intVal = 0;
            }
            cols[i] = intVal;
            ++i;
        }
        Color pRet = new Color(cols[0], cols[1], cols[2]);
        return pRet;
    }

    public double getDouble(String pName, double pDefault) {
        String sMethodName = "getDouble";
        double pRet = 0.0;
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        try {
            pRet = Double.parseDouble(prop);
        }
        catch (NumberFormatException e) {
            log.error((Object)(sMethodName + ": property '" + pName + "' is not a double value: '" + prop + "' ! Return default value"));
            pRet = pDefault;
        }
        return pRet;
    }

    public double[] getDoubleArray(String pName, double[] pDefault) {
        String sMethodName = "getDoubleArray";
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        StringTokenizer st = new StringTokenizer(prop, ",");
        double[] pRet = new double[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            double val;
            String token = st.nextToken().trim();
            try {
                val = Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                log.error((Object)(sMethodName + ": token '" + token + "' is not an double value ! Use '0'. "));
                val = 0.0;
            }
            pRet[i] = val;
            ++i;
        }
        return pRet;
    }

    public float getFloat(String pName, float pDefault) {
        String sMethodName = "getFloat";
        float pRet = 0.0f;
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        try {
            pRet = Float.parseFloat(prop);
        }
        catch (NumberFormatException e) {
            log.error((Object)(sMethodName + ": property '" + pName + "' is not a float value: '" + prop + "' ! Return default value"));
            pRet = pDefault;
        }
        return pRet;
    }

    public int getInt(String pName, int pDefault) {
        String sMethodName = "getInt";
        int pRet = 0;
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        try {
            pRet = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            log.error((Object)(sMethodName + ": property '" + pName + "' is not an integer value: '" + prop + "' ! Return default value"));
            pRet = pDefault;
        }
        return pRet;
    }

    public int[] getIntArray(String pName, int[] pDefault) {
        String sMethodName = "getIntArray";
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        StringTokenizer st = new StringTokenizer(prop, ",");
        int[] pRet = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            int intVal;
            String token = st.nextToken().trim();
            try {
                intVal = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                log.error((Object)(sMethodName + ": token '" + token + "' is not an integer value ! Use '0'. "));
                intVal = 0;
            }
            pRet[i] = intVal;
            ++i;
        }
        return pRet;
    }

    public long getLong(String pName, long pDefault) {
        String sMethodName = "getLong";
        long pRet = 0L;
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        try {
            pRet = Long.parseLong(prop);
        }
        catch (NumberFormatException e) {
            log.error((Object)(sMethodName + ": property '" + pName + "' is not a long value: '" + prop + "' ! Return default value"));
            pRet = pDefault;
        }
        return pRet;
    }

    public String[] getStrArray(String pName, String[] pDefault) {
        String sMethodName = "getStrArray()";
        String prop = super.getProperty(pName);
        if (prop == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        prop = prop.trim();
        StringTokenizer st = new StringTokenizer(prop, ",");
        String[] pRet = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            pRet[i] = st.nextToken().trim();
            ++i;
        }
        return pRet;
    }

    public String getString(String pName, String pDefault) {
        String sMethodName = "getString()";
        String pRet = super.getProperty(pName);
        if (pRet == null) {
            if (this.warn) {
                log.warn((Object)(sMethodName + ": property '" + pName + "' not found !! Use given default '" + pDefault + "' (" + this.propertyFileName + ")"));
            }
            return pDefault;
        }
        return pRet.trim();
    }

    public int loadPropertyFile(String fileName) {
        String sMethodName = "loadPropertyFile()";
        this.propertyFileName = fileName;
        int rc = -1;
        try {
            FileInputStream propIS = new FileInputStream(this.propertyFileName);
            super.load(propIS);
            propIS.close();
            rc = 0;
        }
        catch (Exception e) {
            rc = -1;
            log.debug((Object)(sMethodName + ": property file '" + this.propertyFileName + "' not found !!"));
        }
        return rc;
    }

    public static void main(String[] args) {
        String propertyFileName = "";
        String propertyName = "";
        PropertyHandler ph = new PropertyHandler(propertyFileName);
        String[] propertyValue = ph.getStrArray(propertyName, null);
        System.out.println("'" + propertyName + "'=" + propertyValue);
    }

    public void setWarning(boolean wrn) {
        this.warn = wrn;
    }
}

