/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.geo;

import de.proveo.util.date.DateUtil;
import de.proveo.util.math.angle.AngleFormat;
import de.proveo.util.math.angle.AngleParser;
import de.proveo.util.math.angle.impl.PatternAngleFormat;
import de.proveo.util.math.angle.impl.UnversalAngleParser;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSPosition
implements Serializable {
    private static final Log log = LogFactory.getLog(GPSPosition.class);
    private static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT+00:00");
    public static float MSEC_TO_METER_LONGITUDE = 0.0208f;
    public static final float MSEC_TO_METER_LATITUDE = 0.03087f;
    public static final String LATITUDE_INDICATOR_NORTH = "N";
    public static final String LATITUDE_INDICATOR_SOUTH = "S";
    public static final String LONGITUDE_INDICATOR_EAST = "E";
    public static final String LONGITUDE_INDICATOR_WEST = "W";
    public static final String WITHOUT_DIFFERENTIAL_GPS = "1";
    public static final String WITH_DIFFERENTIAL_GPS = "2";
    private static final AngleParser angleParser = new UnversalAngleParser();
    private static final AngleFormat angleFormat = new PatternAngleFormat();
    private final String DATA_INVALID = "V";
    private final String DATA_VALID = "A";
    private final String DEGREE_SIGN = "\u00b0";
    private String latitudeIndicator = "";
    private String longitudeIndicator = "";
    private char[] aGGA;
    private char[] aRMC;
    private boolean differentialGPSused = false;
    private boolean trusted = true;
    private boolean valid = false;
    private float altitude = 0.0f;
    private float course = 0.0f;
    private float latitudeArcSecond = 0.0f;
    private float longitudeArcSecond = 0.0f;
    private float speed = 0.0f;
    private float tolerance = 0.0f;
    private int latitudeArcDegree = 0;
    private int latitudeArcMinute = 0;
    private int latitudeMSec = 0;
    private int longitudeArcDegree = 0;
    private int longitudeArcMinute = 0;
    private int longitudeMSec = 0;
    private int numberOfSatellites = 0;
    private long timestamp = 0L;
    private long unitId = 0L;
    private boolean fullFeaturedData = true;

    public GPSPosition(int longMSec, int latMSec) {
        this(longMSec, latMSec, true);
    }

    public GPSPosition(int longMSec, int latMSec, boolean isTrusted) {
        this(longMSec, latMSec, true, 0L);
    }

    public GPSPosition(int longMSec, int latMSec, boolean isTrusted, long uid) {
        this.longitudeMSec = longMSec;
        this.latitudeMSec = latMSec;
        this.trusted = isTrusted;
        this.unitId = uid;
        this.computeArcValues();
        this.fullFeaturedData = false;
    }

    public GPSPosition(String rmc, String gga) {
        this(rmc, gga, true);
    }

    public GPSPosition(String rmc, String gga, boolean isTrusted) {
        this(rmc, gga, isTrusted, 0L);
    }

    public GPSPosition(String rmc, String gga, boolean isTrusted, long uid) {
        this.trusted = isTrusted;
        this.unitId = uid;
        this.fullFeaturedData = true;
        if (rmc == null) {
            rmc = "";
        }
        if (gga == null) {
            gga = "";
        }
        this.aRMC = rmc.toCharArray();
        this.aGGA = gga.toCharArray();
        if (this.aRMC.length > 0) {
            try {
                this.parseRMC();
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing RMC :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
            }
        } else {
            log.debug((Object)("RMC not available" + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
        if (this.aGGA.length > 0) {
            try {
                this.parseGGA();
            }
            catch (Exception e) {
                log.error((Object)("Error while parsing GGA :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
            }
        } else {
            log.debug((Object)("GGA not available" + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
        if (this.aRMC.length > 0) {
            try {
                this.computeMSecValues();
            }
            catch (Exception e) {
                log.error((Object)("Error while compute values for milli arc seconds :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
            }
        }
    }

    public GPSPosition(int longArcDegree, int longArcMinute, float longArcSecond, String longIndicator, int latArcDegree, int latArcMinute, float latArcSecond, String latIndicator) {
        this.longitudeArcDegree = longArcDegree;
        this.longitudeArcMinute = longArcMinute;
        this.longitudeArcSecond = longArcSecond;
        this.longitudeIndicator = longIndicator;
        this.latitudeArcDegree = latArcDegree;
        this.latitudeArcMinute = latArcMinute;
        this.latitudeArcSecond = latArcSecond;
        this.latitudeIndicator = latIndicator;
        try {
            this.computeMSecValues();
        }
        catch (Exception e) {
            log.error((Object)("Error while compute values for milli arc seconds :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
        }
    }

    public static String createNMEArecord(String type, Map<String, String> parameters) {
        if (type.equalsIgnoreCase("rmc")) {
            return GPSPosition.createRMCrecord(parameters);
        }
        if (type.equalsIgnoreCase("gga")) {
            return GPSPosition.createGGArecord(parameters);
        }
        throw new IllegalArgumentException("unkown record type '" + type + "'");
    }

    protected static String createGGArecord(Map<String, String> parameters) {
        StringBuffer buffer = new StringBuffer("$GPGGA,");
        Date time = new Date(Long.parseLong(parameters.get("time")));
        buffer.append(new SimpleDateFormat("HHmmss.SS").format(time));
        buffer.append(',');
        int latitudeMsec = 0;
        if (parameters.containsKey("latitude")) {
            latitudeMsec = Integer.parseInt(parameters.get("latitude"));
            int degree = Math.abs(latitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)latitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("0000.0000");
        }
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        int longitudeMsec = 0;
        if (parameters.containsKey("longitude")) {
            longitudeMsec = Integer.parseInt(parameters.get("longitude"));
            int degree = Math.abs(longitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("00");
            } else if (degree < 100) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)longitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("00000.0000");
        }
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        if (parameters.containsKey("quality")) {
            buffer.append(Integer.parseInt(parameters.get("quality")));
        } else {
            buffer.append("0");
        }
        buffer.append(",");
        if (parameters.containsKey("sats")) {
            int sats = Integer.parseInt(parameters.get("sats"));
            if (sats < 10) {
                buffer.append("0");
            }
            buffer.append(sats);
        } else {
            buffer.append("00");
        }
        buffer.append(",");
        if (parameters.containsKey("hdop")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("hdop"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("altitude")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("altitude"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("altitudeUnit")) {
            buffer.append(parameters.get("altitudeUnit"));
        } else {
            buffer.append("M");
        }
        buffer.append(',');
        if (parameters.containsKey("geoidalSeperation")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("geoidalSeperation"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("seperationUnit")) {
            buffer.append(parameters.get("seperationUnit"));
        } else {
            buffer.append("M");
        }
        buffer.append(',');
        if (parameters.containsKey("dgpsAge")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("dgpsAge"))));
        }
        buffer.append(',');
        if (parameters.containsKey("dgpsRef")) {
            buffer.append(parameters.get("dgpsRef"));
        } else {
            buffer.append("0000");
        }
        buffer.append("*00");
        return buffer.toString();
    }

    protected static String createRMCrecord(Map<String, String> parameters) {
        StringBuffer buffer = new StringBuffer("$GPRMC,");
        Date time = new Date(Long.parseLong(parameters.get("time")));
        buffer.append(new SimpleDateFormat("HHmmss.SS").format(time));
        buffer.append(',');
        if (parameters.containsKey("status")) {
            String status = parameters.get("status");
            if (status.length() != 1) {
                throw new IllegalArgumentException("parameter status must have a length of 1");
            }
            buffer.append(status);
        } else {
            buffer.append('A');
        }
        buffer.append(',');
        int latitudeMsec = 0;
        if (parameters.containsKey("latitude")) {
            latitudeMsec = Integer.parseInt(parameters.get("latitude"));
            int degree = Math.abs(latitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)latitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("0000.0000");
        }
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        int longitudeMsec = 0;
        if (parameters.containsKey("longitude")) {
            longitudeMsec = Integer.parseInt(parameters.get("longitude"));
            int degree = Math.abs(longitudeMsec / 60 / 60 / 1000);
            if (degree < 10) {
                buffer.append("00");
            } else if (degree < 100) {
                buffer.append("0");
            }
            buffer.append(degree);
            double minute = Math.abs((double)longitudeMsec / 60.0 / 1000.0) - (double)degree * 60.0;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumIntegerDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            numberFormat.setMaximumFractionDigits(4);
            numberFormat.setMinimumFractionDigits(4);
            buffer.append(numberFormat.format(minute));
        } else {
            buffer.append("00000.0000");
        }
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        if (parameters.containsKey("speed")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("speed"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        if (parameters.containsKey("trackMadeGood")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("trackMadeGood"))));
        } else {
            buffer.append("0.0");
        }
        buffer.append(',');
        buffer.append(new SimpleDateFormat("ddMMyy").format(time));
        buffer.append(',');
        float magVar = 0.0f;
        if (parameters.containsKey("magneticVariation")) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(1);
            buffer.append(numberFormat.format(Float.parseFloat(parameters.get("magneticVariation"))));
        }
        buffer.append(',');
        if (parameters.containsKey("magneticVariation")) {
            if ((double)magVar >= 0.0) {
                buffer.append(LONGITUDE_INDICATOR_EAST);
            } else {
                buffer.append(LONGITUDE_INDICATOR_WEST);
            }
        } else {
            buffer.append("A");
        }
        buffer.append('*');
        buffer.append("00");
        return buffer.toString();
    }

    public static String createGGA(int latitudeMsec, int longitudeMsec, String time) {
        StringBuffer buffer = new StringBuffer("$GPGGA,");
        buffer.append(time);
        buffer.append(',');
        PatternAngleFormat gpsFormat = new PatternAngleFormat("ddm");
        buffer.append(gpsFormat.format(Math.abs(latitudeMsec)));
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        gpsFormat.setPattern("dddm");
        buffer.append(gpsFormat.format(Math.abs(longitudeMsec)));
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(",1,10,0.9,256.8,M,48.0,M,,0000*52");
        return buffer.toString();
    }

    public static String createRMC(int latitudeMsec, int longitudeMsec, String speed, String trackMadeGood, String time, String date) {
        StringBuffer buffer = new StringBuffer("$GPRMC,");
        buffer.append(time);
        buffer.append(",A,");
        PatternAngleFormat gpsFormat = new PatternAngleFormat("ddm");
        buffer.append(gpsFormat.format(Math.abs(latitudeMsec)));
        buffer.append(',');
        if (latitudeMsec >= 0) {
            buffer.append('N');
        } else {
            buffer.append('S');
        }
        buffer.append(',');
        gpsFormat.setPattern("dddm");
        buffer.append(gpsFormat.format(Math.abs(longitudeMsec)));
        buffer.append(',');
        if (longitudeMsec >= 0) {
            buffer.append('E');
        } else {
            buffer.append('W');
        }
        buffer.append(',');
        buffer.append(speed);
        buffer.append(',');
        buffer.append(trackMadeGood);
        buffer.append(',');
        buffer.append(date);
        buffer.append(",,,A*5F");
        return buffer.toString();
    }

    public static String formatLatitude(int latittude) {
        StringBuffer str = new StringBuffer(angleFormat.format(Math.abs(latittude)));
        str.append(" ");
        if (latittude >= 0) {
            str.append(LATITUDE_INDICATOR_NORTH);
        } else {
            str.append(LATITUDE_INDICATOR_SOUTH);
        }
        return str.toString();
    }

    public static String formatLongitude(int longitude) {
        StringBuffer str = new StringBuffer(angleFormat.format(Math.abs(longitude)));
        str.append(" ");
        if (longitude >= 0) {
            str.append(LONGITUDE_INDICATOR_EAST);
        } else {
            str.append(LONGITUDE_INDICATOR_WEST);
        }
        return str.toString();
    }

    public float getAltitude() {
        return this.altitude;
    }

    public float getCourse() {
        return this.course;
    }

    public int getCourseIntValue() {
        return Math.round(this.course);
    }

    public String getGGA() {
        return new String(this.aGGA);
    }

    public int getLatitudeArcDegree() {
        return this.latitudeArcDegree;
    }

    public int getLatitudeArcMinute() {
        return this.latitudeArcMinute;
    }

    public float getLatitudeArcSecond() {
        return this.latitudeArcSecond;
    }

    public String getLatitudeIndicator() {
        return this.latitudeIndicator;
    }

    public int getLatitudeMSec() {
        return this.latitudeMSec;
    }

    public int getLongitudeArcDegree() {
        return this.longitudeArcDegree;
    }

    public int getLongitudeArcMinute() {
        return this.longitudeArcMinute;
    }

    public float getLongitudeArcSecond() {
        return this.longitudeArcSecond;
    }

    public String getLongitudeIndicator() {
        return this.longitudeIndicator;
    }

    public int getLongitudeMSec() {
        return this.longitudeMSec;
    }

    public int getNumberOfSatellites() {
        return this.numberOfSatellites;
    }

    public String getPositionString() {
        return "" + this.longitudeArcDegree + "\u00b0" + " " + (0.0f + (float)this.longitudeArcMinute + this.longitudeArcSecond / 60.0f) + "' " + this.longitudeIndicator + ", " + this.latitudeArcDegree + "\u00b0" + " " + (0.0f + (float)this.latitudeArcMinute + this.latitudeArcSecond / 60.0f) + "' " + this.latitudeIndicator;
    }

    public String getRMC() {
        return new String(this.aRMC);
    }

    public float getSpeedKmh() {
        return this.speed * 1.852f;
    }

    public int getSpeedKmhIntValue() {
        return Math.round(this.getSpeedKmh());
    }

    public float getSpeedMph() {
        return this.speed * 1.151f;
    }

    public int getSpeedMphIntValue() {
        return Math.round(this.getSpeedMph());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return DateUtil.getDatestring4Timestamp(this.timestamp);
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public boolean isDifferentialGPSused() {
        return this.differentialGPSused;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isFullFeaturedData() {
        return this.fullFeaturedData;
    }

    public static GPSPosition parse(String latitude, String longitude) {
        int latitudeMS = angleParser.parseIntoMS(latitude);
        int longitudeMS = angleParser.parseIntoMS(longitude);
        int longitudeDegree = longitudeMS / 3600 / 1000;
        int longitudeMinute = (longitudeMS - longitudeDegree * 3600 * 1000) / 60 / 1000;
        float longitudeSecond = (float)(longitudeMS - longitudeDegree * 3600 * 1000 - longitudeMinute * 60 * 1000) / 1000.0f;
        String longitudeIndicator = longitude.indexOf(LONGITUDE_INDICATOR_EAST) > -1 ? LONGITUDE_INDICATOR_EAST : LONGITUDE_INDICATOR_WEST;
        int latitudeDegree = latitudeMS / 3600 / 1000;
        int latitudeMinute = (latitudeMS - latitudeDegree * 3600 * 1000) / 60 / 1000;
        float latitudeSecond = (float)(latitudeMS - latitudeDegree * 3600 * 1000 - latitudeMinute * 60 * 1000) / 1000.0f;
        String latitudeIndicator = latitude.indexOf(LATITUDE_INDICATOR_NORTH) > -1 ? LATITUDE_INDICATOR_NORTH : LATITUDE_INDICATOR_SOUTH;
        GPSPosition position = new GPSPosition(longitudeDegree, longitudeMinute, longitudeSecond, longitudeIndicator, latitudeDegree, latitudeMinute, latitudeSecond, latitudeIndicator);
        return position;
    }

    public static int parseLatitudeMS(String latitude) {
        int latitudeMS = angleParser.parseIntoMS(latitude);
        if (latitude.indexOf(LATITUDE_INDICATOR_SOUTH) > -1) {
            latitudeMS *= -1;
        }
        return latitudeMS;
    }

    public static int parseLongitudeMS(String longitude) {
        int longitudeMS = angleParser.parseIntoMS(longitude);
        if (longitude.indexOf(LONGITUDE_INDICATOR_WEST) > -1) {
            longitudeMS *= -1;
        }
        return longitudeMS;
    }

    public String getLatitudeToString() {
        StringBuffer str = new StringBuffer(angleFormat.format(Math.abs(this.latitudeMSec)));
        str.append(" ");
        str.append(this.latitudeIndicator);
        return str.toString();
    }

    public String getLongtitudeToString() {
        StringBuffer str = new StringBuffer(angleFormat.format(Math.abs(this.longitudeMSec)));
        str.append(" ");
        str.append(this.longitudeIndicator);
        return str.toString();
    }

    private void computeArcValues() {
        float fl;
        String sMethodName = "computeArcValues()";
        if (this.longitudeMSec < 0) {
            this.longitudeIndicator = LONGITUDE_INDICATOR_WEST;
            fl = this.longitudeMSec * -1;
        } else {
            this.longitudeIndicator = LONGITUDE_INDICATOR_EAST;
            fl = this.longitudeMSec;
        }
        this.longitudeArcDegree = (int)Math.floor(fl /= 3600000.0f);
        fl -= (float)this.longitudeArcDegree;
        this.longitudeArcMinute = (int)Math.floor(fl *= 60.0f);
        this.longitudeArcSecond = (float)(Math.rint((double)((fl -= (float)this.longitudeArcMinute) * 60.0f) * 100.0) / 100.0);
        if (this.latitudeMSec < 0) {
            this.latitudeIndicator = LATITUDE_INDICATOR_SOUTH;
            fl = this.latitudeMSec * -1;
        } else {
            this.latitudeIndicator = LATITUDE_INDICATOR_NORTH;
            fl = this.latitudeMSec;
        }
        this.latitudeArcDegree = (int)Math.floor(fl /= 3600000.0f);
        fl -= (float)this.latitudeArcDegree;
        this.latitudeArcMinute = (int)Math.floor(fl *= 60.0f);
        this.latitudeArcSecond = (float)(Math.rint((double)((fl -= (float)this.latitudeArcMinute) * 60.0f) * 100.0) / 100.0);
        double cosinus = Math.cos(Math.toRadians(0.0 + (double)this.latitudeArcDegree));
        MSEC_TO_METER_LONGITUDE = new Double(cosinus).floatValue() * 111325.0f / 3600000.0f;
    }

    private void computeMSecValues() {
        String sMethodName = "computeMSecValues()";
        float sec = (float)(this.longitudeArcDegree * 3600 + this.longitudeArcMinute * 60) + this.longitudeArcSecond;
        this.longitudeMSec = (int)(sec * 1000.0f);
        if (this.longitudeIndicator.equals(LONGITUDE_INDICATOR_WEST)) {
            this.longitudeMSec *= -1;
        }
        sec = (float)(this.latitudeArcDegree * 3600 + this.latitudeArcMinute * 60) + this.latitudeArcSecond;
        this.latitudeMSec = (int)(sec * 1000.0f);
        if (this.latitudeIndicator.equals(LATITUDE_INDICATOR_SOUTH)) {
            this.latitudeMSec *= -1;
        }
        double cosinus = Math.cos(Math.toRadians(0.0 + (double)this.latitudeArcDegree));
        MSEC_TO_METER_LONGITUDE = new Double(cosinus).floatValue() * 111325.0f / 3600000.0f;
    }

    private String getAttribute(char[] rec, int pos) {
        String sMethodName = "getAttribute()";
        String val = "";
        int curPos = 0;
        for (int i = 0; i < rec.length; ++i) {
            if (rec[i] == ',') {
                ++curPos;
            }
            if (curPos != pos) continue;
            for (int e = i + 1; e < rec.length && rec[e] != ',' && rec[e] != '*'; ++e) {
                val = val + rec[e];
            }
            break;
        }
        return val;
    }

    private void parseGGA() {
        String sMethodName = "parseGGA()";
        String tmp = "";
        tmp = this.getAttribute(this.aGGA, 6);
        this.differentialGPSused = tmp.equals(WITH_DIFFERENTIAL_GPS);
        tmp = this.getAttribute(this.aGGA, 7);
        this.numberOfSatellites = tmp.length() < 1 ? 0 : Integer.parseInt(tmp);
        tmp = this.getAttribute(this.aGGA, 8);
        this.tolerance = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        tmp = this.getAttribute(this.aGGA, 9);
        this.altitude = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
    }

    private void parseRMC() {
        String sMethodName = "parseRMC()";
        String tmp = "";
        tmp = this.getAttribute(this.aRMC, 9);
        if (tmp.length() > 0) {
            try {
                String pattern = "ddMMyy HHmmss";
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                sdf.setTimeZone(gmtTimeZone);
                tmp = tmp + " " + this.getAttribute(this.aRMC, 1);
                Date date = sdf.parse(tmp);
                this.timestamp = date.getTime();
            }
            catch (Exception e) {
                log.error((Object)(sMethodName + ": Error while parsing date and time :" + e.getMessage() + (this.unitId > 0L ? " (unitId=" + this.unitId + ")" : "")));
            }
        } else {
            this.timestamp = 0L;
        }
        this.valid = (tmp = this.getAttribute(this.aRMC, 2)).length() > 0 && tmp.equals(this.DATA_VALID);
        tmp = this.getAttribute(this.aRMC, 3);
        if (tmp.length() > 0) {
            this.latitudeArcDegree = Integer.parseInt(tmp.substring(0, 2));
            this.latitudeArcMinute = Integer.parseInt(tmp.substring(2, tmp.indexOf(".")));
            this.latitudeArcSecond = Float.parseFloat(tmp.substring(tmp.indexOf(".")));
            this.latitudeArcSecond *= 60.0f;
        } else {
            this.latitudeArcDegree = 0;
            this.latitudeArcMinute = 0;
            this.latitudeArcSecond = 0.0f;
        }
        this.latitudeIndicator = this.getAttribute(this.aRMC, 4);
        tmp = this.getAttribute(this.aRMC, 5);
        if (tmp.length() > 0) {
            this.longitudeArcDegree = Integer.parseInt(tmp.substring(0, 3));
            this.longitudeArcMinute = Integer.parseInt(tmp.substring(3, tmp.indexOf(".")));
            this.longitudeArcSecond = Float.parseFloat(tmp.substring(tmp.indexOf(".")));
            this.longitudeArcSecond *= 60.0f;
        } else {
            this.longitudeArcDegree = 0;
            this.longitudeArcMinute = 0;
            this.longitudeArcSecond = 0.0f;
        }
        this.longitudeIndicator = this.getAttribute(this.aRMC, 6);
        tmp = this.getAttribute(this.aRMC, 7);
        this.speed = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
        tmp = this.getAttribute(this.aRMC, 8);
        this.course = tmp.length() < 1 ? 0.0f : Float.parseFloat(tmp);
    }
}

