/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.connection.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EasyX509TrustManager
implements X509TrustManager {
    private static final Log LOG = LogFactory.getLog(EasyX509TrustManager.class);
    private X509TrustManager standardTrustManager = null;

    public EasyX509TrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance("SunX509");
        factory.init(keystore);
        TrustManager[] trustmanagers = factory.getTrustManagers();
        if (trustmanagers.length == 0) {
            throw new NoSuchAlgorithmException("SunX509 trust manager not supported");
        }
        this.standardTrustManager = (X509TrustManager)trustmanagers[0];
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.standardTrustManager.getAcceptedIssuers();
    }

    public boolean isClientTrusted(X509Certificate[] chain) {
        return true;
    }

    public boolean isServerTrusted(X509Certificate[] certificates) {
        if (certificates != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)"Server certificate chain:");
            for (int i = 0; i < certificates.length; ++i) {
                LOG.debug((Object)("X509Certificate[" + i + "]=" + certificates[i]));
            }
        }
        if (certificates != null && certificates.length == 1) {
            X509Certificate certificate = certificates[0];
            try {
                certificate.checkValidity();
            }
            catch (CertificateException e) {
                LOG.error((Object)e.toString());
                return false;
            }
            return true;
        }
        return true;
    }
}

