/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.connection;

import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.connection.ssl.EasySSLProtocolSocketFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletConnection {
    private static final Log log = LogFactory.getLog(ServletConnection.class);
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    HttpClient client;
    String host;
    String lastStatusText = "";
    String protocol;
    String proxyDomain;
    String proxyName;
    String proxyPass;
    String proxyUser;
    boolean useProxy = false;
    boolean useProxyAuthentication = false;
    final int SOCKET_TIMEOUT = 3600000;
    int lastState = 0;
    int port;
    int proxyPort;
    final long HTTP_CONNECTION_TIMEOUT = 30000L;
    final String PARA_PASSWORD = "password";

    public ServletConnection(String host, int port) {
        this.host = host;
        this.port = port;
        this.protocol = PROTOCOL_HTTP;
    }

    public ServletConnection(String host, int port, String prot) {
        this.host = host;
        this.port = port;
        this.protocol = prot;
        if (!prot.equals(PROTOCOL_HTTP) && !prot.equals(PROTOCOL_HTTPS)) {
            log.warn((Object)("Unknown protocol '" + prot + "'"));
        }
    }

    public void close() {
        try {
            HostConfiguration hostConfiguration = this.client.getHostConfiguration();
            if (hostConfiguration != null) {
                log.debug((Object)("try to close connection with hostConfiguration=" + hostConfiguration.toString()));
                HttpConnection httpConnection = this.client.getHttpConnectionManager().getConnection(hostConfiguration);
                httpConnection.close();
                log.debug((Object)"Servlet connection closed.");
            } else {
                log.debug((Object)"hostConfiguration already null");
            }
        }
        catch (Throwable ex) {
            log.debug((Object)("Could not close servlet connection regulary because of: '" + ex.getMessage() + "'"));
        }
    }

    public void connect() {
        String method = "connect(): ";
        this.client = new HttpClient();
        HttpClientParams params = this.client.getParams();
        params.setConnectionManagerTimeout(30000L);
        params.setSoTimeout(3600000);
        if (this.protocol.equals(PROTOCOL_HTTPS)) {
            EasySSLProtocolSocketFactory psf = new EasySSLProtocolSocketFactory();
            Protocol easyhttps = new Protocol(PROTOCOL_HTTPS, (ProtocolSocketFactory)psf, this.port);
            Protocol.registerProtocol((String)PROTOCOL_HTTPS, (Protocol)easyhttps);
            log.debug((Object)(method + "https protocol registered."));
        } else {
            log.debug((Object)(method + "use '" + this.protocol + "' protocol"));
        }
        if (this.useProxy) {
            log.debug((Object)(method + "setup proxy..."));
            if (this.useProxyAuthentication) {
                params.setParameter("http.authentication.credential-provider", (Object)new AuthenticationProvider(this.proxyUser, this.proxyPass, this.proxyDomain));
                params.setAuthenticationPreemptive(true);
                log.debug((Object)(method + "proxy authentication configured."));
            } else {
                log.debug((Object)(method + "proxy without authentication."));
            }
            this.client.getHostConfiguration().setProxy(this.proxyName, this.proxyPort);
            log.debug((Object)(method + "proxy configuration set."));
        } else {
            log.debug((Object)(method + "don't use a proxy"));
        }
        this.client.setParams(params);
    }

    public int executeMethod(String url) throws HttpException, IOException, ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.executeMethod(url, passwd);
    }

    public int executeMethod(String url, String passwd) throws HttpException, IOException, ServletConnectionException {
        String method = "executeMethod(): ";
        PostMethod httpMethod = new PostMethod(url);
        if (passwd != null && passwd.length() > 0) {
            httpMethod.addParameter("password", passwd);
        }
        this.lastState = this.client.executeMethod((HttpMethod)httpMethod);
        this.lastStatusText = httpMethod.getStatusText();
        httpMethod.releaseConnection();
        if (this.lastState != 200) {
            log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
            throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
        }
        return this.lastState;
    }

    public int getLastState() {
        return this.lastState;
    }

    public String getLastStatusText() {
        return this.lastStatusText;
    }

    public ObjectInputStream getObjectInputStreamX(String url) throws ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.getObjectInputStream(url, passwd);
    }

    public ObjectInputStream getObjectInputStream(String url, String passwd) throws ServletConnectionException {
        ObjectInputStream ois;
        String method = "getObjectInputStream(url, passwd): ";
        PostMethod httpMethod = new PostMethod(url);
        if (passwd != null && passwd.length() > 0) {
            httpMethod.addParameter("password", passwd);
        }
        try {
            HttpClientParams httpClientParams = this.client.getParams();
            httpClientParams.setSoTimeout(60000);
            httpClientParams.setConnectionManagerTimeout(60000L);
            this.lastState = this.client.executeMethod((HttpMethod)httpMethod);
            this.lastStatusText = httpMethod.getStatusText();
            if (this.lastState != 200) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            InputStream is = httpMethod.getResponseBodyAsStream();
            ois = new ObjectInputStream(new BufferedInputStream(is));
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (ConnectException ce) {
            log.error((Object)(method + ce.toString() + ", Servlet can not connect"));
            throw new ServletConnectionException("ConnectError", ce);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        return ois;
    }

    public String getSafeUrl(String servletAlias, String parameters) {
        return this.removePwFromtUrl(this.getUrl(servletAlias, parameters));
    }

    public String getUrl(String servletAlias, String parameters) {
        String url = this.protocol + "://" + this.host + ":" + this.port + "/" + servletAlias;
        if (parameters != null && parameters.length() > 1) {
            url = url + "?" + parameters;
        }
        return url;
    }

    private String removePwFromtUrl(String url) {
        int ind = url.indexOf("password=");
        if (ind < 0) {
            return url;
        }
        String part1 = url.substring(0, ind);
        String rest = url.substring(ind, url.length());
        ind = rest.indexOf("&");
        String part2 = "";
        if (ind >= 0) {
            part2 = rest.substring(ind + 1, rest.length());
        }
        String ret = part1 + part2;
        return ret;
    }

    private String getParaFromUrl(String url, String para) {
        String method = "getParaFromtUrl(): ";
        String ret = "";
        int ind = url.indexOf(para + "=");
        if (ind < 0) {
            log.debug((Object)(method + "parameter '" + para + "' not found in URL '" + url + "'"));
            return ret;
        }
        String rest = url.substring(ind + para.length() + 1, url.length());
        ret = (ind = rest.indexOf("&")) >= 0 ? rest.substring(0, ind) : rest;
        return ret;
    }

    public Object readObject(String url, String passwd) throws ServletConnectionException {
        ObjectInputStream ois;
        String method = "readObject(): ";
        PostMethod httpMethod = new PostMethod(url);
        if (passwd != null && passwd.length() > 0) {
            httpMethod.addParameter("password", passwd);
        }
        try {
            this.lastState = this.client.executeMethod((HttpMethod)httpMethod);
            this.lastStatusText = httpMethod.getStatusText();
            if (this.lastState != 200) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            InputStream is = httpMethod.getResponseBodyAsStream();
            ois = new ObjectInputStream(new BufferedInputStream(is));
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (ConnectException ce) {
            log.error((Object)(method + ce.toString() + ", Servlet can not connect"));
            throw new ServletConnectionException("ConnectError", ce);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        Object obj = null;
        try {
            obj = ois.readObject();
            ois.close();
        }
        catch (IOException ioe) {
            log.error((Object)(method + "Error : " + ioe.toString()));
            throw new ServletConnectionException("ObjectResponseError");
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)(method + "Error : " + ce.toString()));
            throw new ServletConnectionException("ObjectClassError");
        }
        httpMethod.releaseConnection();
        return obj;
    }

    public String readString(String url) throws ServletConnectionException {
        String passwd = this.getParaFromUrl(url, "password");
        url = this.removePwFromtUrl(url);
        return this.readString(url, passwd);
    }

    public String readString(String url, String passwd) throws ServletConnectionException {
        String response;
        String method = "readString(): ";
        PostMethod httpMethod = new PostMethod(url);
        if (passwd != null && passwd.length() > 0) {
            httpMethod.addParameter("password", passwd);
        }
        try {
            this.lastState = this.client.executeMethod((HttpMethod)httpMethod);
            this.lastStatusText = httpMethod.getStatusText();
            if (this.lastState != 200) {
                log.error((Object)(method + "status not ok (" + this.lastState + ", " + this.lastStatusText + "), break"));
                throw new ServletConnectionException("BadStatusCode", "" + this.lastState, this.lastStatusText);
            }
            response = httpMethod.getResponseBodyAsString();
        }
        catch (SocketTimeoutException ste) {
            log.error((Object)(method + ste.toString() + ", Servlet time out"));
            throw new ServletConnectionException("TimeOut", ste);
        }
        catch (HttpException e) {
            log.error((Object)(method + e.toString()));
            throw new ServletConnectionException("HttpError", e);
        }
        catch (SSLHandshakeException ssle) {
            log.error((Object)(method + ssle.toString()));
            throw new ServletConnectionException("SslHandshakeError", ssle);
        }
        catch (IOException ioe) {
            log.error((Object)(method + ioe.toString() + ", Network not available ? Servlet not accessible ? Server not running ?"));
            throw new ServletConnectionException("NoServerFound");
        }
        catch (Exception ex) {
            log.error((Object)(method + "uncatched exception '" + ex.getClass().getName() + "' : " + ex.toString()));
            throw new ServletConnectionException("UnknownException", ex.getClass().getName(), ex.toString());
        }
        httpMethod.releaseConnection();
        return response;
    }

    public void setupProxy(String name, int port) {
        this.setupProxy(name, port, "", "", "");
    }

    public void setupProxy(String name, int port, String user, String pass, String dom) {
        this.useProxy = true;
        this.proxyName = name;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPass = pass;
        this.proxyDomain = dom;
        if (this.proxyUser.length() > 0) {
            this.useProxyAuthentication = true;
        }
    }

    public int writeObject(String url, Object object) throws ServletConnectionException {
        String method = "writeObject(): ";
        ByteArrayOutputStream barrOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(barrOut);
            oos.writeObject(object);
            oos.close();
        }
        catch (Exception ex) {
            log.error((Object)(method + "runs into"), (Throwable)ex);
        }
        ByteArrayRequestEntity re = new ByteArrayRequestEntity(barrOut.toByteArray());
        PostMethod httppost = new PostMethod(url);
        httppost.setRequestEntity((RequestEntity)re);
        int response = -1;
        try {
            response = this.client.executeMethod((HttpMethod)httppost);
        }
        catch (Exception ex) {
            log.error((Object)(method + "runs into"), (Throwable)ex);
        }
        return response;
    }

    public class AuthenticationProvider
    implements CredentialsProvider {
        String domain;
        String password;
        String user;

        public AuthenticationProvider(String user, String password, String domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
            String method = "getCredentials(): ";
            if (authscheme == null) {
                return null;
            }
            try {
                if (authscheme instanceof NTLMScheme) {
                    log.debug((Object)(host + ":" + port + " requires Windows authentication, return NTLM credentials"));
                    return new NTCredentials(this.user, this.password, host, this.domain);
                }
                if (authscheme instanceof RFC2617Scheme) {
                    log.debug((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "', return USER/PASS credentials"));
                    return new UsernamePasswordCredentials(this.user, this.password);
                }
                log.error((Object)(method + "Unsupported authentication scheme: " + authscheme.getSchemeName()));
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

