/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionUtil
extends Properties {
    private static final Log log = LogFactory.getLog(VersionUtil.class);
    protected static final String REPO_PROPS = "/repository-version.properties";
    public static final String REPO_BUILD_DATE_PROP = "repository.builddate";
    public static final String REPO_VERSION_PROP = "repository.version";
    public static final String IMPL_VERSION_PROP = "implVersion";
    protected static final String REPO_INFO_PROP = "repository.info";
    public static final String DEF_DATE_PATTERN = "dd.MM.yyyy HH:mm:ss zzz";
    private Properties svnInfo;

    public Date getBuildDate() {
        return this.getBuildDate(DEF_DATE_PATTERN);
    }

    public Date getBuildDate(String dateFormatPattern) {
        Date buildDate = null;
        try {
            buildDate = new SimpleDateFormat(dateFormatPattern, Locale.ENGLISH).parse(this.getProperty(REPO_BUILD_DATE_PROP));
        }
        catch (ParseException ex) {
            log.error((Object)"getBuildDate() runs into: ", (Throwable)ex);
        }
        return buildDate;
    }

    public String getImplVersion() {
        return this.getProperty(IMPL_VERSION_PROP);
    }

    public String getRepositoryInfo(String key) {
        if (this.svnInfo != null) {
            return this.svnInfo.getProperty(key);
        }
        return "[no svn info]";
    }

    public String getRepositoryVersion() {
        return this.getProperty(REPO_VERSION_PROP);
    }

    public void load(Class clazz) throws IOException {
        this.load(clazz, REPO_PROPS);
    }

    public void load(Class clazz, String resname) throws IOException {
        InputStream is = clazz.getResourceAsStream(resname);
        if (is == null) {
            throw new IOException("Version Ressource not found");
        }
        this.load(is);
        String svnInfoResName = this.getProperty(REPO_INFO_PROP);
        if (svnInfoResName != null) {
            is = clazz.getResourceAsStream(svnInfoResName = svnInfoResName.trim());
            if (is != null) {
                this.svnInfo = new Properties();
                this.svnInfo.load(is);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("load() snvinfo: " + this.svnInfo));
                }
            } else {
                log.error((Object)("load() cannot load svninfo resource. res not found: '" + svnInfoResName + "'"));
            }
        } else {
            log.debug((Object)"load() no svninfo resource found");
            this.svnInfo = null;
        }
    }
}

